SET FOREIGN_KEY_CHECKS=0;

ALTER TABLE `72crm_admin_field` MODIFY COLUMN `type`  int(2) NOT NULL DEFAULT 1 COMMENT '字段类型 1 单行文本 2 多行文本 3 单选 4日期 5 数字 6 小数 7 手机  8 文件 9 多选 10 人员 11 附件 12 部门 13 日期时间 14 邮箱 15客户 16 商机 17 联系人 18 地图 19 产品类型 20 合同 21 回款计划' AFTER `name`;
ALTER TABLE `72crm_admin_field` ADD COLUMN `field_type`  int(2) NOT NULL DEFAULT 0 COMMENT '是否是自定义字段  0.自定义 1.固定' AFTER `examine_category_id`;

DROP TABLE IF EXISTS `72crm_admin_fieldv`;
CREATE TABLE `72crm_admin_fieldv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '字段名称',
  `value` longtext,
  `create_time` datetime DEFAULT NULL,
  `batch_id` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

INSERT INTO `72crm_admin_fieldv` (`field_id`,`name`, `value`, `create_time`, `batch_id`) SELECT f.parent_id,f.name,f.`value`,f.update_time,f.batch_id FROM 72crm_admin_field as f WHERE f.batch_id is not NULL and f.batch_id !='';

DELETE FROM 72crm_admin_field WHERE (batch_id IS NOT NULL OR batch_id = '');

ALTER TABLE `72crm_admin_field` DROP COLUMN `parent_id`;
ALTER TABLE `72crm_admin_field` DROP COLUMN `value`;
ALTER TABLE `72crm_admin_field` DROP COLUMN `batch_id`;

UPDATE `72crm_admin_field` SET `field_type`='0';

INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('leads_name', '线索名称', '1', '1', NULL, NULL, '255', '', '1', '1', '0', NULL, '1', '2019-07-02 09:10:19', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('telephone', '电话', '1', '1', NULL, NULL, '255', '', '0', '0', '2', NULL, '1', '2019-07-02 09:10:19', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('mobile', '手机', '7', '1', NULL, NULL, '255', '', '0', '0', '3', NULL, '1', '2019-07-02 09:10:19', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('address', '地址', '1', '1', NULL, NULL, '255', '', '0', '0', '6', NULL, '1', '2019-07-02 09:10:19', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('next_time', '下次联系时间', '13', '1', NULL, NULL, NULL, '', '0', '0', '7', NULL, '1', '2019-07-02 09:10:19', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '1', '1', NULL, NULL, '255', '', '0', '0', '8', NULL, '1', '2019-07-02 09:10:19', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('customer_name', '客户名称', '1', '2', NULL, NULL, '255', '', '1', '1', '0', NULL, '1', '2019-07-02 09:10:41', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('mobile', '手机', '7', '2', NULL, NULL, '255', '', '0', '0', '1', NULL, '1', '2019-07-02 09:10:41', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('telephone', '电话', '1', '2', NULL, NULL, '255', '', '0', '0', '2', NULL, '1', '2019-07-02 09:10:41', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('website', '网址', '1', '2', NULL, NULL, '255', '', '0', '0', '6', NULL, '1', '2019-07-02 09:10:41', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('deal_status', '成交状态', '3', '2', NULL, NULL, NULL, '', '0', '1', '7', '未成交,已成交', '3', '2019-07-02 09:10:41', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('next_time', '下次联系时间', '13', '2', NULL, NULL, NULL, '', '0', '0', '8', NULL, '1', '2019-07-02 09:10:41', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '1', '2', NULL, NULL, '255', '', '0', '0', '9', NULL, '1', '2019-07-02 09:10:41', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('name', '姓名', '1', '3', NULL, NULL, '255', '', '0', '1', '0', NULL, '1', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('customer_id', '客户名称', '15', '3', NULL, NULL, NULL, '', '0', '0', '1', NULL, '3', '2019-07-01 17:13:28', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('mobile', '手机', '7', '3', NULL, NULL, '255', '', '0', '0', '2', NULL, '1', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('telephone', '电话', '1', '3', NULL, NULL, '255', '', '0', '0', '3', NULL, '1', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('email', '电子邮箱', '14', '3', NULL, NULL, '255', '', '0', '0', '4', NULL, '1', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('post', '职务', '1', '3', NULL, NULL, '255', '', '0', '0', '5', NULL, '1', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('address', '地址', '1', '3', NULL, NULL, '255', '', '0', '0', '6', NULL, '1', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('next_time', '下次联系时间', '13', '3', NULL, NULL, NULL, '', '0', '0', '7', NULL, '1', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('性别', '性别', '3', '3', NULL, NULL, NULL, '', '0', '0', '10', '男,女', '3', '2019-07-01 17:10:21', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('name', '产品名称', '1', '4', NULL, NULL, '255', '', '0', '0', '0', NULL, '1', '2019-07-01 17:22:28', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('category_id', '产品类型', '19', '4', NULL, NULL, NULL, '', '0', '1', '1', NULL, '3', '2019-07-01 17:55:24', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('num', '产品编码', '5', '4', NULL, NULL, '255', '', '1', '1', '2', NULL, '1', '2019-07-01 17:22:28', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('price', '价格', '6', '4', NULL, NULL, '255', '', '0', '1', '3', NULL, '1', '2019-07-01 17:57:01', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('description', '产品描述', '1', '4', NULL, NULL, '255', '', '0', '0', '4', NULL, '1', '2019-07-01 17:22:28', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('business_name', '商机名称', '1', '5', NULL, NULL, '255', '', '0', '0', '0', NULL, '3', '2019-07-01 17:10:31', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('customer_id', '客户名称', '15', '5', NULL, NULL, NULL, '', '0', '1', '1', NULL, '3', '2019-07-01 17:13:25', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('money', '商机金额', '6', '5', NULL, NULL, '255', '', '0', '0', '2', NULL, '1', '2019-07-01 17:10:31', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('deal_date', '预计成交日期', '13', '5', NULL, NULL, NULL, '', '0', '0', '3', NULL, '1', '2019-07-01 17:10:31', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '1', '5', NULL, NULL, '255', '', '0', '0', '4', NULL, '1', '2019-07-01 17:10:31', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('num', '合同编号', '5', '6', NULL, NULL, '255', '', '1', '1', '0', NULL, '1', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('name', '合同名称', '1', '6', NULL, NULL, '255', '', '0', '1', '1', NULL, '1', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('customer_id', '客户名称', '15', '6', NULL, NULL, NULL, '', '0', '1', '2', NULL, '3', '2019-07-01 17:22:49', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('business_id', '商机名称', '16', '6', NULL, NULL, NULL, '', '0', '0', '3', NULL, '3', '2019-07-01 17:22:57', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('order_date', '下单时间', '4', '6', NULL, NULL, NULL, '', '0', '0', '4', NULL, '1', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('money', '合同金额', '6', '6', NULL, NULL, '255', '', '0', '0', '5', NULL, '1', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('start_time', '合同开始时间', '4', '6', NULL, NULL, NULL, '', '0', '0', '6', NULL, '1', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('end_tme', '合同结束时间', '4', '6', NULL, NULL, NULL, '', '0', '0', '7', NULL, '1', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('contacts_id', '客户签约人', '17', '6', NULL, NULL, NULL, '', '0', '0', '8', NULL, '3', '2019-07-01 17:23:11', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('company_user_id', '公司签约人', '10', '6', NULL, NULL, NULL, '', '0', '0', '9', NULL, '3', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '1', '6', NULL, NULL, '255', '', '0', '0', '10', NULL, '1', '2019-07-01 17:10:34', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('number', '回款编号', '5', '7', NULL, NULL, '255', '', '0', '1', '0', NULL, '1', '2019-07-01 17:10:36', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('customer_id', '客户名称', '15', '7', NULL, NULL, NULL, '', '0', '1', '1', NULL, '3', '2019-07-01 17:23:15', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('contract_id', '合同编号', '20', '7', NULL, NULL, NULL, '', '0', '1', '2', NULL, '3', '2019-07-01 17:23:24', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('return_time', '回款日期', '4', '7', NULL, NULL, NULL, '', '0', '0', '3', NULL, '1', '2019-07-01 17:10:36', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('money', '回款金额', '6', '7', NULL, NULL, '255', '', '0', '0', '4', NULL, '1', '2019-07-01 17:10:36', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('plan_id', '期数', '21', '7', NULL, NULL, NULL, '', '0', '0', '5', NULL, '3', '2019-07-01 17:23:35', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '1', '7', NULL, NULL, '255', '', '0', '0', '6', NULL, '1', '2019-07-01 17:10:36', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('content', '审批事由', '2', '10', NULL, NULL, '0', '', '0', '1', '0', NULL, '1', '2019-06-27 14:00:42', '7', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '10', NULL, NULL, '0', '', '0', '1', '1', NULL, '1', '2019-06-27 14:01:13', '7', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('customer_id', '客户名称', '15', '8', NULL, NULL, NULL, '', '0', '0', '1', NULL, '3', '2019-06-28 16:52:13', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('contract_id', '合同编号', '20', '8', NULL, NULL, '11', '', '0', '0', '2', NULL, '3', '2019-06-28 16:55:17', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('money', '计划回款金额', '6', '8', NULL, NULL, NULL, '', '0', '0', '3', NULL, '3', '2019-06-28 16:53:04', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('return_date', '计划回款日期', '4', '8', NULL, NULL, NULL, '', '0', '0', '4', NULL, '3', '2019-06-28 16:54:01', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remind', '提前几天提醒', '5', '8', NULL, NULL, '11', '', '0', '0', '5', NULL, '3', '2019-06-28 16:55:13', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '8', NULL, NULL, '1000', '', '0', '0', '6', NULL, '3', '2019-06-28 16:55:07', NULL, '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('content', '审批内容', '1', '10', NULL, '', NULL, '', '0', '1', '0', NULL, '3', NULL, '1', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '10', NULL, '', '1000', '', '0', '0', '1', NULL, '3', NULL, '1', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('type_id', '请假类型', '3', '10', NULL, '', NULL, '年假', '0', '1', '0', '年假,事假,病假,产假,调休,婚假,丧假,其他', '3', NULL, '2', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('content', '审批内容', '1', '10', NULL, '', NULL, '', '0', '1', '1', NULL, '3', NULL, '2', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('start_time', '开始时间', '13', '10', NULL, '', NULL, '', '0', '1', '2', NULL, '3', NULL, '2', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('end_time', '结束时间', '13', '10', NULL, '', NULL, '', '0', '1', '3', NULL, '3', NULL, '2', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('duration', '时长', '6', '10', NULL, '', NULL, '', '0', '1', '4', NULL, '3', NULL, '2', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '10', NULL, '', '1000', '', '0', '0', '5', NULL, '3', NULL, '2', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('content', '出差事由', '1', '10', NULL, '', NULL, '', '0', '1', '0', NULL, '3', '2019-06-30 18:13:08', '3', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '10', NULL, '', '1000', '', '0', '0', '1', NULL, '3', '2019-06-30 18:13:08', '3', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('duration', '出差总天数', '6', '10', NULL, '', NULL, '', '0', '1', '2', NULL, '3', '2019-06-30 18:13:08', '3', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('cause', '行程明细', '22', '10', NULL, '', NULL, '', '0', '1', '2', NULL, '3', '2019-06-30 18:13:08', '3', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('content', '加班原因', '1', '10', NULL, '', NULL, '', '0', '1', '0', NULL, '3', '2019-06-30 18:13:08', '4', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('start_time', '开始时间', '13', '10', NULL, '', NULL, '', '0', '1', '1', NULL, '3', '2019-06-30 18:13:08', '4', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('end_time', '结束时间', '13', '10', NULL, '', NULL, '', '0', '1', '2', NULL, '3', '2019-06-30 18:13:08', '4', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('duration', '加班总天数', '6', '10', NULL, '', NULL, '', '0', '1', '3', NULL, '3', '2019-06-30 18:13:08', '4', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '10', NULL, '', '1000', '', '0', '0', '4', NULL, '3', '2019-06-30 18:13:08', '4', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('content', '差旅事由', '1', '10', NULL, '', NULL, '', '0', '1', '0', NULL, '3', '2019-06-30 18:13:08', '5', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('money', '报销总金额', '6', '10', NULL, '', '0', '', '0', '1', '1', NULL, '3', '2019-06-30 18:13:08', '5', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '10', NULL, '', '1000', '', '0', '0', '2', NULL, '3', '2019-06-30 18:13:08', '5', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('cause', '费用明细', '23', '10', NULL, '', '1000', '', '0', '0', '2', NULL, '3', '2019-06-30 18:13:08', '5', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('content', '借款事由', '1', '10', NULL, '', NULL, '', '0', '1', '0', NULL, '3', '2019-06-30 18:13:08', '6', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('money', '借款金额（元）', '6', '10', NULL, '', '0', '', '0', '1', '1', NULL, '3', '2019-06-30 18:13:08', '6', '1');
INSERT INTO `72crm_admin_field` (`field_name`, `name`, `type`, `label`, `remark`, `input_tips`, `max_length`, `default_value`, `is_unique`, `is_null`, `sorting`, `options`, `operating`, `update_time`, `examine_category_id`, `field_type`) VALUES ('remark', '备注', '2', '10', NULL, '', '1000', '', '0', '0', '2', NULL, '3', '2019-06-30 18:13:08', '6', '1');



ALTER TABLE `72crm_crm_customer` MODIFY COLUMN `followup`  int(11) NULL DEFAULT NULL COMMENT '跟进状态 0未跟进1已跟进' AFTER `customer_name`;
ALTER TABLE `72crm_crm_leads` MODIFY COLUMN `followup`  int(11) NULL DEFAULT NULL COMMENT '跟进状态 0未跟进1已跟进' AFTER `is_transform`;

INSERT INTO `72crm_admin_menu` VALUES ('127', '1', '公海管理', 'pool', '1', '4', '1', null);
INSERT INTO `72crm_admin_menu` VALUES ('128', '127', '查看列表', 'index', '3', '1', '1', null);
INSERT INTO `72crm_admin_menu` VALUES ('129', '127', '分配', 'distribute', '3', '1', '1', null);
INSERT INTO `72crm_admin_menu` VALUES ('130', '127', '领取', 'receive', '3', '1', '1', null);
INSERT INTO `72crm_admin_menu` VALUES ('131', '127', '导出', 'excelexport', '3', '1', '1', null);


ALTER TABLE `72crm_oa_examine_category` ADD COLUMN `type`  int(1) NULL DEFAULT 0 COMMENT '1 普通审批 2 请假审批 3 出差审批 4 加班审批 5 差旅报销 6 借款申请 0 自定义审批' AFTER `remarks`;

UPDATE `72crm_oa_examine_category` SET `type`='1' WHERE (`category_id`='1');
UPDATE `72crm_oa_examine_category` SET `type`='2' WHERE (`category_id`='2');
UPDATE `72crm_oa_examine_category` SET `type`='3' WHERE (`category_id`='3');
UPDATE `72crm_oa_examine_category` SET `type`='4' WHERE (`category_id`='4');
UPDATE `72crm_oa_examine_category` SET `type`='5' WHERE (`category_id`='5');
UPDATE `72crm_oa_examine_category` SET `type`='6' WHERE (`category_id`='6');