using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
namespace FileComminuteUnite
{
    public partial class frmSplit : Form
    {
        public frmSplit()
        {
            InitializeComponent();
        }

        #region ָļ
        /// <summary>
        /// ָļ
        /// </summary>
        /// <param name="strFlag">ָλ</param>
        /// <param name="intFlag">ָС</param>
        /// <param name="strPath">ָļ·</param>
        /// <param name="strFile">Ҫָļ</param>
        /// <param name="PBar">ʾ</param>
        public void SplitFile(string strFlag, int intFlag, string strPath, string strFile, ProgressBar PBar)
        {
            int iFileSize = 0;
            //ѡ趨ָСļĴС
            switch (strFlag)
            {
                case "Byte":
                    iFileSize = intFlag;
                    break;
                case "KB":
                    iFileSize = intFlag * 1024;
                    break;
                case "MB":
                    iFileSize = intFlag * 1024 * 1024;
                    break;
                case "GB":
                    iFileSize = intFlag * 1024 * 1024 * 1024;
                    break;
            }
            //ļȫ·ӦַļģʽʼFileStreamļʵ
            FileStream SplitFileStream = new FileStream(strFile, FileMode.Open);
            //FileStreamļʼBinaryReaderļĶ
            BinaryReader SplitFileReader = new BinaryReader(SplitFileStream);
            //ÿηָȡ
            byte[] TempBytes;
            //Сļ
            int iFileCount = (int)(SplitFileStream.Length / iFileSize);
            PBar.Maximum = iFileCount;
            if (SplitFileStream.Length % iFileSize != 0) iFileCount++;
            string[] TempExtra = strFile.Split('.');
            //ѭļָɶСļ
            for (int i = 1; i <= iFileCount; i++)
            {
                //ȷСļļ
                string sTempFileName = strPath + @"\" + i.ToString().PadLeft(4, '0') + "." + TempExtra[TempExtra.Length - 1]; //Сļ
                //ļƺļģʽʼFileStreamļʵ
                FileStream TempStream = new FileStream(sTempFileName, FileMode.OpenOrCreate);
                //FileStreamʵʼBinaryWriterдʵ
                BinaryWriter TempWriter = new BinaryWriter(TempStream);
                //ӴļжȡָС
                TempBytes = SplitFileReader.ReadBytes(iFileSize);
                //ѴдСļ
                TempWriter.Write(TempBytes);
                //رдγСļ
                TempWriter.Close();
                //رļ
                TempStream.Close();
                PBar.Value = i - 1;
            }
            //رմļĶ
            SplitFileReader.Close();
            SplitFileStream.Close();
            MessageBox.Show("ļָɹ!");
        }
        #endregion

        #region ϲļ
        /// <summary>
        /// ϲļ
        /// </summary>
        /// <param name="list">Ҫϲļ</param>
        /// <param name="strPath">ϲļ</param>
        /// <param name="PBar">ʾ</param>
        public void CombinFile(string[] strFile, string strPath, ProgressBar PBar)
        {
            PBar.Maximum = strFile.Length;
            FileStream AddStream = null;
            //Ժϲļƺʹ򿪷ʽʼFileStreamļ
            AddStream = new FileStream(strPath, FileMode.Append);
            //FileStreamļʼBinaryWriterдԺϲָļ
            BinaryWriter AddWriter = new BinaryWriter(AddStream);
            FileStream TempStream = null;
            BinaryReader TempReader = null;
            //ѭϲСļɺϲļ
            for (int i = 0; i < strFile.Length; i++)
            {
                //СļӦļƺʹģʽʼFileStreamļȡָ
                TempStream = new FileStream(strFile[i].ToString(), FileMode.Open);
                TempReader = new BinaryReader(TempStream);
                //ȡָļеݣɺϲļ
                AddWriter.Write(TempReader.ReadBytes((int)TempStream.Length));
                //رBinaryReaderļĶ
                TempReader.Close();
                //رFileStreamļ
                TempStream.Close();
                PBar.Value = i + 1;
            }
            //رBinaryWriterļд
            AddWriter.Close();
            //رFileStreamļ
            AddStream.Close();
            MessageBox.Show("ļϲɹ");
        }
        #endregion

        private void frmSplit_Load(object sender, EventArgs e)
        {
            timer1.Start();//ʱ
        }

        //ѡҪָļ
        private void btnSFile_Click(object sender, EventArgs e)
        {
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                txtFile.Text = openFileDialog.FileName;
            }
        }

        //ִļָ
        private void btnSplit_Click(object sender, EventArgs e)
        {
            try
            {
                if (txtLength.Text == ""||txtFile.Text.Trim()==""||txtPath.Text.Trim()=="")
                {
                    MessageBox.Show("뽫Ϣд", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    txtLength.Focus();
                }
                else if (cboxUnit.Text == "")
                {
                    MessageBox.Show("ѡҪָļλ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    cboxUnit.Focus();
                }
                else
                {
                    SplitFile(cboxUnit.Text, Convert.ToInt32(txtLength.Text.Trim()), txtPath.Text, txtFile.Text, progressBar);
                }
            }
            catch { }
        }

        //ѡָļ·
        private void btnSPath_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                txtPath.Text = folderBrowserDialog.SelectedPath;
            }
        }

        //ѡҪϳɵļ
        private void btnCFile_Click(object sender, EventArgs e)
        {
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                string Selectfile = "";
                string[] files = openFileDialog.FileNames;
                for (int i = 0; i < files.Length; i++)
                {
                    Selectfile += "," + files[i].ToString();
                }
                if (Selectfile.StartsWith(","))
                {
                    Selectfile = Selectfile.Substring(1);
                }
                if (Selectfile.EndsWith(","))
                {
                    Selectfile.Remove(Selectfile.LastIndexOf(","),1);
                }
                txtCFile.Text = Selectfile;
            }
        }

        //ѡϳɺļ·
        private void btnCPath_Click(object sender, EventArgs e)
        {
            if (saveFileDialog.ShowDialog() == DialogResult.OK)
            {
                txtCPath.Text = saveFileDialog.FileName;
            }
        }

        //ִкϳļ
        private void btnCombin_Click(object sender, EventArgs e)
        {
            try
            {
                if (txtCFile.Text.Trim() == "" || txtCPath.Text.Trim() == "")
                {
                    MessageBox.Show("뽫Ϣ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                else
                {
                    if (txtCFile.Text.IndexOf(",") == -1)
                        MessageBox.Show("ѡҪϳɵļΪ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    else
                    {
                        string[] strFiles = txtCFile.Text.Split(',');
                        CombinFile(strFiles, txtCPath.Text, progressBar);
                    }
                }
            }
            catch { }
        }

        //ӡָ/ϲťĿ״̬
        private void timer1_Tick(object sender, EventArgs e)
        {
            if (txtFile.Text != "" && txtPath.Text != "")
                btnSplit.Enabled = true;
            else
                btnSplit.Enabled = false;
            if (txtCFile.Text != "" && txtCPath.Text != "")
                btnCombin.Enabled = true;
            else
                btnCombin.Enabled = false;
        }
    }
}