using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace VideoMonitor.CommonClass
{
    class VideoOperate
    {
        #region  Ƶɼеö

        public enum DISPLAYTRANSTYPE
        {
            NOT_DISPLAY = 0,
            PCI_VIEDOMEMORY = 1,
            PCI_MEMORY_VIDEOMEMORY = 2
        }

        //ƵԤƵ׽ʽĿǰ汾ֻ֧UUY2ʽ
        public enum COLORFORMAT
        {
            RGB32 = 0x0,
            RGB24 = 0x1,
            RGB16 = 0x2,
            RGB15 = 0x3,
            YUY2 = 0x4,
            BTYUV = 0x5,
            Y8 = 0x6,
            RGB8 = 0x7,
            PL422 = 0x8,
            PL411 = 0x9,
            YUV12 = 0xA,
            YUV9 = 0xB,
            RAW = 0xE
        }

        /*ƵԤƵʾԣУ
            BRIGHTNESSΪȣvalueΧ0~255ѣ80
            CONTRASTΪԱȶȣvalueΧ-128~127ѣ0x44
            SATURATIONΪͶȣvalueΧ-128~127ѣ0x40
            HUEΪɫȣvalueΧ-128~127ѣ0x0
                ֻеCOLORDEVICETYPECOLOR_DECODERʱЧ
            SHARPNESSΪȣvalueΧ-8~7ѣ0x0
                ֻеCOLORDEVICETYPECOLOR_DECODERʱЧ
        */
        public enum COLORCONTROL
        {
            BRIGHTNESS = 0,
            CONTRAST = 1,
            SATURATION = 2,
            HUE = 3,
            SHARPNESS = 4
        }

        /*ʾ豸ʾԣУ
            COLOR_DECODERΪʾԣӰƵԤƵʾ
            COLOR_PREVIEWΪƵԤʾ
            COLOR_CAPTUREΪƵʾ
        */
        public enum COLORDEVICETYPE
        {
            COLOR_DECODER = 0,
            COLOR_PREVIEW = 1,
            COLOR_CAPTURE = 2,
        }

        /*ƵʽУ
            CAP_NULL_STREAM Ч
            CAP_ORIGIN_STREAM Ϊԭʼص
            CAP_MPEG4_STREAM ΪMPEG4
        */
        public enum CAPMODEL
        {
            CAP_NULL_STREAM = 0,
            CAP_ORIGIN_STREAM = 1,
            CAP_MPEG4_STREAM = 2,
        }

        /*ƵMPEG4ʽֻCAPMODELCAP_MPEG4_STREAMʱЧУ
           MPEG4_AVIFILE_ONLY ΪMPEG4ļ
           MPEG4_CALLBACK_ONLY MPEGݻص
           MPEG4_AVIFILE_CALLBACK ΪMPEGļص
       */
        public enum MP4MODEL
        {
            MPEG4_AVIFILE_ONLY = 0,
            MPEG4_CALLBACK_ONLY = 1,
            MPEG4_AVIFILE_CALLBACK = 2,
        }

        /*MPEG4_XVIDѹģʽУ
           XVID_CBR_MODE 
           XVID_VBR_MODE 
       */
        public enum COMPRESSMODE
        {
            XVID_CBR_MODE = 0,
            XVID_VBR_MODE = 1,
        }

        /*ƵԴƵʣУ
           FIELD_FREQ_50HZ 50HZ,ԶΪPALʽ
           FIELD_FREQ_60HZ 60HZ,ԶΪNTSCʽ
           FIELD_FREQ_0HZ ź
       */
        public enum eFieldFrequency
        {
            FIELD_FREQ_50HZ = 0,
            FIELD_FREQ_60HZ = 1,
            FIELD_FREQ_0HZ = 2,
        }

        /*ƽ״̬У
           HIGH_VOLTAGE ߵƽ
           LOW_VOLTAGE ͵ƽ
       */
        public enum eVOLTAGELEVEL
        {
            HIGH_VOLTAGE = 0,
            LOW_VOLTAGE = 1,
        }

        #endregion

        #region  ƵɼеAPI

        //ʼϵͳԴ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAInitSdk")]
        public extern static bool VCAInitSdk(IntPtr hWndMain, DISPLAYTRANSTYPE eDispTransType, bool bLnitAuDev);

        //ͷϵͳԴ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAUnInitSdk")]
        public extern static void VCAUnInitSdk();

        //ָŵ豸ӦϵͳԴ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAOpenDevice")]
        public extern static bool VCAOpenDevice(Int32 dwCard, IntPtr hPreviewWnd);

        //رָŵ豸ͷӦϵͳԴ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCACloseDevice")]
        public extern static bool VCACloseDevice(Int32 dwCard);

        //ϵͳпΪSAA7134ӲĿΪ0ʱʾû豸
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAGetDevNum")]
        public extern static int VCAGetDevNum();

        //ʼƵԤ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAStartVideoPreview")]
        public extern static bool VCAStartVideoPreview(Int32 dwCard);

        //ֹͣƵԤ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAStopVideoPreview")]
        public extern static bool VCAStopVideoPreview(Int32 dwCard);

        //ƵԤ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAUpdateVideoPreview")]
        public extern static bool VCAUpdateVideoPreview(Int32 dwCard, IntPtr hPreviewWnd);

        //overlayڣoverlayھıߴ硢λøıʱãoverlayھǰ
        //·ʾСڵĴ󴰿ڣoverlayڱһ·ʾСڱڲ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAUpdateOverlayWnd")]
        public extern static bool VCAUpdateOverlayWnd(IntPtr hOverlayWnd);

        //ΪJPEGļ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASaveAsJpegFile")]
        public extern static bool VCASaveAsJpegFile(Int32 dwCard, string lpFileName, Int32 dwQuality);

        //ΪBMPļ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASaveAsBmpFile")]
        public extern static bool VCASaveAsBmpFile(Int32 dwCard, string lpFileName);

        //ʼƵ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAStartVideoCapture")]
        public extern static bool VCAStartVideoCapture(Int32 dwCard, CAPMODEL enCapMode, MP4MODEL enMp4Mode, string lpFileName);

        //ֹͣƵ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAStopVideoCapture")]
        public extern static bool VCAStopVideoCapture(Int32 dwCard);

        //Ƶߴ磬dwWidthdwHeightΪ16ı򣬶̬Ϊ16*16һС飬⽫᲻׼ȷ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASetVidCapSize")]
        public extern static bool VCASetVidCapSize(Int32 dwCard, Int32 dwWidth, Int32 dwHeight);

        //õƵߴ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAGetVidCapSize")]
        public extern static bool VCAGetVidCapSize(Int32 dwCard, Int32 dwWidth, Int32 dwHeight);

        //ƵƵ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASetVidCapFrameRate")]
        public extern static bool VCASetVidCapFrameRate(Int32 dwCard, Int32 dwFrameRate, bool bFrameRateReduction);

        //MPEGѹλ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASetBitRate")]
        public extern static bool VCASetBitRate(Int32 dwCard, Int32 dwBitRate);

        //MPEGѹĹؼ֡ڵ֡
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASetKeyFrmInterval")]
        public extern static bool VCASetKeyFrmInterval(Int32 dwCard, Int32 dwKeyFrmInterval);

        //MPEG4_XVIDѹ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASetXVIDQuality")]
        public extern static bool VCASetXVIDQuality(Int32 dwCard, Int32 dwQuantizer, Int32 dwMotionPrecision);

        //MPEG4_XVIDѹģʽ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASetXVIDCompressMode")]
        public extern static bool VCASetXVIDCompressMode(Int32 dwCard, COMPRESSMODE enCompessMode);

        //ƵɫԣӰƵԤƵʾ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCASetVidDeviceColor")]
        public extern static bool VCASetVidDeviceColor(Int32 dwCard, COLORCONTROL enCtlType, Int32 dwValue);

        //õƵԴƵʣɵõƵԴʽ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAGetVidFieldFrq")]
        public extern static bool VCAGetVidFieldFrq(Int32 dwCard, eFieldFrequency eVidSourceFieldRate);

        //ʼƵ豸ƵʾֻƵ¼ƵʱͨVCAInitSdk()ѾʼɣԲʼ
        [DllImport("Sa7134Capture.dll", EntryPoint = "VCAInitVidDev")]
        public extern static bool VCAInitVidDev();

        #endregion
    }
}
