// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/lib/application.d.ts
declare module '~express/lib/application' {

import {Server} from 'http';
import {ListenOptions} from 'net';
import {EventEmitter} from 'events';
import {Router, ParamHandler, HandlerArgument, PathArgument} from '~express/lib/router/index';

namespace app {
    export interface Application extends EventEmitter, Router {

        /**
         * Contains one or more path patterns on which a sub-app was mounted.
         */
        mountpath: string | string[];

        /**
         * Has properties that are local variables within the application.
         * Once set, the value of app.locals properties persist throughout the life of the application,
         * in contrast with res.locals properties that are valid only for the lifetime of the request.
         * You can access local variables in templates rendered within the application.
         * This is useful for providing helper functions to templates, as well as application-level data.
         * Local variables are available in middleware via req.app.locals (see req.app)
         */
        locals: any;

        /**
         * Initialize the server.
         *
         *   - setup default configuration
         *   - setup default middleware
         *   - setup route reflection methods
         */
        init(): void;

        /**
         * Initialize application configuration.
         */
        defaultConfiguration(): void;

        /**
         * Register the given template engine callback `fn`
         * as `ext`.
         *
         * By default will `require()` the engine based on the
         * file extension. For example if you try to render
         * a "foo.jade" file Express will invoke the following internally:
         *
         *     app.engine('jade', require('jade').__express);
         *
         * For engines that do not provide `.__express` out of the box,
         * or if you wish to "map" a different extension to the template engine
         * you may use this method. For example mapping the EJS template engine to
         * ".html" files:
         *
         *     app.engine('html', require('ejs').renderFile);
         *
         * In this case EJS provides a `.renderFile()` method with
         * the same signature that Express expects: `(path, options, callback)`,
         * though note that it aliases this method as `ejs.__express` internally
         * so if you're using ".ejs" extensions you dont need to do anything.
         *
         * Some template engines do not follow this convention, the
         * [Consolidate.js](https://github.com/visionmedia/consolidate.js)
         * library was created to map all of node's popular template
         * engines to follow this convention, thus allowing them to
         * work seamlessly within Express.
         */
        engine(ext: string, fn: Function): Application;

        /**
         * Assign `setting` to `val`, or return `setting`'s value.
         *
         *    app.set('foo', 'bar');
         *    app.get('foo');
         *    // => "bar"
         *    app.set('foo', ['bar', 'baz']);
         *    app.get('foo');
         *    // => ["bar", "baz"]
         *
         * Mounted servers inherit their parent server's settings.
         */
        set(setting: string, val: any): this;
        get(name: string): any;
        // need to duplicate this here from the Router because of the overload
        get(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * Add callback triggers to route parameters, where name is the name of the parameter or an array of them,
         * and callback is the callback function. The parameters of the callback function are the request object,
         * the response object, the next middleware, the value of the parameter and the name of the parameter,
         * in that order.
         * If name is an array, the callback trigger is registered for each parameter declared in it,
         * in the order in which they are declared. Furthermore, for each declared parameter except the last one,
         * a call to next inside the callback will call the callback for the next declared parameter.
         * For the last parameter, a call to next will call the next middleware in place for the route currently
         * being processed, just like it would if name were just a string.
         * For example, when :user is present in a route path, you may map user loading logic to automatically
         * provide req.user to the route, or perform validations on the parameter input.
         */
        param(name: string | string[], handler: ParamHandler): this;

        /**
         * @deprecated
         */
        param(callback: (name: string, matcher: RegExp) => ParamHandler): this;

        /**
         * Return the app's absolute pathname
         * based on the parent(s) that have
         * mounted it.
         *
         * For example if the application was
         * mounted as "/admin", which itself
         * was mounted as "/blog" then the
         * return value would be "/blog/admin".
         */
        path(): string;

        /**
         * Check if `setting` is enabled (truthy).
         *
         *    app.enabled('foo')
         *    // => false
         *
         *    app.enable('foo')
         *    app.enabled('foo')
         *    // => true
         */
        enabled(setting: string): boolean;

        /**
         * Check if `setting` is disabled.
         *
         *    app.disabled('foo')
         *    // => true
         *
         *    app.enable('foo')
         *    app.disabled('foo')
         *    // => false
         */
        disabled(setting: string): boolean;

        /**
         * Enable `setting`.
         */
        enable(setting: string): this;

        /**
         * Disable `setting`.
         */
        disable(setting: string): this;

        /**
         * Render the given view `name` name with `options`
         * and a callback accepting an error and the
         * rendered template string.
         *
         * Example:
         *
         *    app.render('email', { name: 'Tobi' }, function(err, html){
         *      // ...
         *    })
         */
        render(name: string, locals?: { [local: string]: any }, callback?: (err: Error, html: string) => void): void;
        render(name: string, callback: (err: Error, html: string) => void): void;

        /**
         * Listen for connections.
         *
         * A node `http.Server` is returned, with this
         * application (which is a `Function`) as its
         * callback. If you wish to create both an HTTP
         * and HTTPS server you may do so with the "http"
         * and "https" modules as shown here:
         *
         *    var http = require('http')
         *      , https = require('https')
         *      , express = require('express')
         *      , app = express();
         *
         *    http.createServer(app).listen(80);
         *    https.createServer({ ... }, app).listen(443);
         */
        listen(port: number, hostname?: string, backlog?: number, listeningListener?: Function): Server;
        listen(port: number, hostname?: string, listeningListener?: Function): Server;
        listen(port: number, backlog?: number, listeningListener?: Function): Server;
        listen(port: number, listeningListener?: Function): Server;
        listen(path: string, backlog?: number, listeningListener?: Function): Server;
        listen(path: string, listeningListener?: Function): Server;
        listen(handle: any, backlog?: number, listeningListener?: Function): Server;
        listen(handle: any, listeningListener?: Function): Server;
        listen(options: ListenOptions, listeningListener?: Function): Server;
    }
}

const app: app.Application;
export = app;
}
declare module 'express/lib/application' {
import main = require('~express/lib/application');
export = main;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/lib/request.d.ts
declare module '~express/lib/request' {

import {IncomingMessage} from 'http';
import {Application} from '~express/lib/application';
import Route = require('~express/lib/router/route');

namespace req {

    export interface RangeOptions {
        /**
         * Specifies if overlapping & adjacent ranges should be combined, defaults to `false`.
         * When `true`, ranges will be combined and returned as if they were specified that
         * way in the header.
         *
         * ```js
         * parseRange(100, 'bytes=50-55,0-10,5-10,56-60', { combine: true })
         * // => [
         * //      { start: 0,  end: 10 },
         * //      { start: 50, end: 60 }
         * //    ]
         * ```
         */
        combined?: boolean;
    }

    export interface Range {
        start: number;
        end: number;
    }

    export interface Request extends IncomingMessage {

        /**
         * Return the protocol string "http" or "https"
         * when requested with TLS. When the "trust proxy"
         * setting is enabled the "X-Forwarded-Proto" header
         * field will be trusted. If you're running behind
         * a reverse proxy that supplies https for you this
         * may be enabled.
         */
        protocol: string;

        /**
         * Short-hand for:
         *
         *    req.protocol == 'https'
         */
        secure: boolean;

        /**
         * Return the remote address, or when
         * "trust proxy" is `true` return
         * the upstream addr.
         */
        ip: string;

        /**
         * When "trust proxy" is `true`, parse
         * the "X-Forwarded-For" ip address list.
         *
         * For example if the value were "client, proxy1, proxy2"
         * you would receive the array `["client", "proxy1", "proxy2"]`
         * where "proxy2" is the furthest down-stream.
         */
        ips: string[];

        /**
         * Return subdomains as an array.
         *
         * Subdomains are the dot-separated parts of the host before the main domain of
         * the app. By default, the domain of the app is assumed to be the last two
         * parts of the host. This can be changed by setting "subdomain offset".
         *
         * For example, if the domain is "tobi.ferrets.example.com":
         * If "subdomain offset" is not set, req.subdomains is `["ferrets", "tobi"]`.
         * If "subdomain offset" is 3, req.subdomains is `["tobi"]`.
         */
        subdomains: string[];

        /**
         * Short-hand for `url.parse(req.url).pathname`.
         */
        path: string;

        /**
         * Parse the "Host" header field hostname.
         */
        hostname: string;

        /**
         * @deprecated Use hostname instead.
         */
        host: string;

        /**
         * Check if the request is fresh, aka
         * Last-Modified and/or the ETag
         * still match.
         */
        fresh: boolean;

        /**
         * Check if the request is stale, aka
         * "Last-Modified" and / or the "ETag" for the
         * resource has changed.
         */
        stale: boolean;

        /**
         * Check if the request was an _XMLHttpRequest_.
         */
        xhr: boolean;

        /**
         * Contains a string corresponding to the HTTP method of the request: GET, POST, PUT, and so on.
         */
        method: string;

        /**
         * req.url is not a native Express property, it is inherited from Node's http
         * module. In opposite to req.originalUrl, req.url is rewritten for internal
         * routing purposes. For example, the "mounting"" feature of app.use() will
         * rewrite req.url to strip the mount point.
         */
        url: string; // needs to be redefined because IncomingMessage.url is optional

        /**
         * This property is an object containing a property for each query string parameter in the
         * route. If there is no query string, it is the empty object, {}.
         */
        query: {
            [queryParam: string]: string;
        };

        /**
         * Contains the currently-matched route
         */
        route: Route;

        /**
         * This property is much like req.url; however, it retains the original request URL, allowing you to rewrite
         * req.url freely for internal routing purposes. For example, the “mounting” feature of app.use() will
         * rewrite req.url to strip the mount point.
         *
         *     // GET /search?q=something
         *     req.originalUrl
         *     // => "/search?q=something"
         *
         * In a middleware function, req.originalUrl is a combination of req.baseUrl and req.path, as shown in the following example.
         *
         *     app.use('/admin', function(req, res, next) {  // GET 'http://www.example.com/admin/new'
         *       console.log(req.originalUrl); // '/admin/new'
         *       console.log(req.baseUrl); // '/admin'
         *       console.log(req.path); // '/new'
         *       next();
         *     });
         *
         */
        originalUrl: string;

        /**
         * The URL path on which a router instance was mounted. The req.baseUrl property is similar
         * to the mountpath property of the app object, except app.mountpath returns the matched
         * path pattern(s).
         */
        baseUrl: string;

        /**
         * This property holds a reference to the instance of the Express application that is using
         * the middleware. If you follow the pattern in which you create a module that just exports
         * a middleware function and require() it in your main file, then the middleware can access
         * the Express instance via req.app
         */
        app: Application;

        /**
         * This property is an object containing properties mapped to the named route "parameters".
         * For example, if you have the route `/user/:name`, then the "name" property is available as `req.params.name`.
         * This object defaults to `{}`.
         * When you use a regular expression for the route definition, capture groups are provided in the array using
         * `req.params[n]`, where n is the nth capture group.
         * This rule is applied to unnamed wild card matches with string routes such as `/file/*`.
         */
        params: {
            [param: string]: string,
            [captureGroup: number]: string
        };

        /**
         * Return request header.
         *
         * The `Referrer` header field is special-cased,
         * both `Referrer` and `Referer` are interchangeable.
         *
         * Examples:
         *
         *     req.get('Content-Type');
         *     // => "text/plain"
         *
         *     req.get('content-type');
         *     // => "text/plain"
         *
         *     req.get('Something');
         *     // => undefined
         *
         * Aliased as `req.header()`.
         */
        get(name: string): string;

        header(name: string): string;

        /**
         * Check if the given `type(s)` is acceptable, returning
         * the best match when true, otherwise `undefined`, in which
         * case you should respond with 406 "Not Acceptable".
         *
         * The `type` value may be a single mime type string
         * such as "application/json", the extension name
         * such as "json", a comma-delimted list such as "json, html, text/plain",
         * or an array `["json", "html", "text/plain"]`. When a list
         * or array is given the _best_ match, if any is returned.
         *
         * Examples:
         *
         *     // Accept: text/html
         *     req.accepts('html');
         *     // => "html"
         *
         *     // Accept: text/*, application/json
         *     req.accepts('html');
         *     // => "html"
         *     req.accepts('text/html');
         *     // => "text/html"
         *     req.accepts('json, text');
         *     // => "json"
         *     req.accepts('application/json');
         *     // => "application/json"
         *
         *     // Accept: text/*, application/json
         *     req.accepts('image/png');
         *     req.accepts('png');
         *     // => undefined
         *
         *     // Accept: text/*;q=.5, application/json
         *     req.accepts(['html', 'json']);
         *     req.accepts('html, json');
         *     // => "json"
         */
        accepts(type: string | string[]): string | void;

        /**
         * Returns the first accepted charset of the specified character sets,
         * based on the request's Accept-Charset HTTP header field.
         * If none of the specified charsets is accepted, returns false.
         *
         * For more information, or if you have issues or concerns, see accepts.
         */
        acceptsCharsets(charset?: string | string[]): string | boolean;

        /**
         * Returns the first accepted encoding of the specified encodings,
         * based on the request’s Accept-Encoding HTTP header field.
         * If none of the specified encodings is accepted, returns false.
         *
         * For more information, or if you have issues or concerns, see accepts.
         */
        acceptsEncodings(encoding?: string | string[]): string | boolean;

        /**
         * Returns the first accepted language of the specified languages,
         * based on the request’s Accept-Language HTTP header field.
         * If none of the specified languages is accepted, returns false.
         *
         * For more information, or if you have issues or concerns, see accepts.
         */
        acceptsLanguages(lang?: string | string[]): string | boolean;

        /**
         * Parse Range header field,
         * capping to the given `size`.
         *
         * Unspecified ranges such as "0-" require
         * knowledge of your resource length. In
         * the case of a byte range this is of course
         * the total number of bytes. If the Range
         * header field is not given `null` is returned,
         * `-1` when unsatisfiable, `-2` when syntactically invalid.
         *
         * NOTE: remember that ranges are inclusive, so
         * for example "Range: users=0-3" should respond
         * with 4 users when available, not 3.
         */
        range(size: number, options?: RangeOptions): number | Range[];

        /**
         * @deprecated Use either req.params, req.body or req.query, as applicable.
         *
         * Return the value of param `name` when present or `defaultValue`.
         *
         *  - Checks route placeholders, ex: _/user/:id_
         *  - Checks body params, ex: id=12, {"id":12}
         *  - Checks query string params, ex: ?id=12
         *
         * To utilize request bodies, `req.body`
         * should be an object. This can be done by using
         * the `connect.bodyParser()` middleware.
         */
        param(name: string, defaultValue?: any): string;

        /**
         * Check if the incoming request contains the "Content-Type"
         * header field, and it contains the give mime `type`.
         *
         * Examples:
         *
         *      // With Content-Type: text/html; charset=utf-8
         *      req.is('html');
         *      req.is('text/html');
         *      req.is('text/*');
         *      // => true
         *
         *      // When Content-Type is application/json
         *      req.is('json');
         *      req.is('application/json');
         *      req.is('application/*');
         *      // => true
         *
         *      req.is('html');
         *      // => false
         */
        is(type: string | string[]): boolean;
    }
}

const req: req.Request;
export = req;
}
declare module 'express/lib/request' {
import main = require('~express/lib/request');
export = main;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/lib/response.d.ts
declare module '~express/lib/response' {

import {ServerResponse} from 'http';
import {Application} from '~express/lib/application';

namespace res {

    export interface CookieOptions {
        maxAge?: number;
        signed?: boolean;
        expires?: Date;
        httpOnly?: boolean;
        path?: string;
        domain?: string;
        secure?: boolean;
    }

    export interface Response extends ServerResponse {

        app: Application;

        locals: any;

        charset: string;

        /** Property indicating if HTTP headers has been sent for the response. */
        headersSent: boolean;

        /**
         * Set status `code`.
         */
        status(code: number): this;

        /**
         * Set the response HTTP status code to `statusCode` and send its string representation as the response body.
         *
         * Examples:
         *
         *    res.sendStatus(200); // equivalent to res.status(200).send('OK')
         *    res.sendStatus(403); // equivalent to res.status(403).send('Forbidden')
         *    res.sendStatus(404); // equivalent to res.status(404).send('Not Found')
         *    res.sendStatus(500); // equivalent to res.status(500).send('Internal Server Error')
         */
        sendStatus(code: number): this;

        /**
         * Set Link header field with the given `links`.
         *
         * Examples:
         *
         *    res.links({
         *      next: 'http://api.example.com/users?page=2',
         *      last: 'http://api.example.com/users?page=5'
         *    });
         */
        links(links: any): this;

        /**
         * Send a response.
         *
         * Examples:
         *
         *     res.send(new Buffer('wahoo'));
         *     res.send({ some: 'json' });
         *     res.send('<p>some html</p>');
         *     res.send(404, 'Sorry, cant find that');
         *     res.send(404);
         */
        send(body: string | Buffer): this;

        /**
         * Send JSON response.
         *
         * Examples:
         *
         *     res.json(null);
         *     res.json({ user: 'tj' });
         *     res.json(500, 'oh noes!');
         *     res.json(404, 'I dont have that');
         */
        json(obj: any): this;

        /**
         * Send JSON response with JSONP callback support.
         *
         * Examples:
         *
         *     res.jsonp(null);
         *     res.jsonp({ user: 'tj' });
         *     res.jsonp(500, 'oh noes!');
         *     res.jsonp(404, 'I dont have that');
         */
        jsonp(obj: any): this;

        /**
         * Transfer the file at the given `path`.
         *
         * Automatically sets the _Content-Type_ response header field.
         * The callback `fn(err)` is invoked when the transfer is complete
         * or when an error occurs. Be sure to check `res.sentHeader`
         * if you wish to attempt responding, as the header and some data
         * may have already been transferred.
         *
         * Options:
         *
         *   - `maxAge`   defaulting to 0 (can be string converted by `ms`)
         *   - `root`     root directory for relative filenames
         *   - `headers`  object of headers to serve with file
         *   - `dotfiles` serve dotfiles, defaulting to false; can be `"allow"` to send them
         *
         * Other options are passed along to `send`.
         *
         * Examples:
         *
         *  The following example illustrates how `res.sendFile()` may
         *  be used as an alternative for the `static()` middleware for
         *  dynamic situations. The code backing `res.sendFile()` is actually
         *  the same code, so HTTP cache support etc is identical.
         *
         *     app.get('/user/:uid/photos/:file', function(req, res){
         *       var uid = req.params.uid
         *         , file = req.params.file;
         *
         *       req.user.mayViewFilesFrom(uid, function(yes){
         *         if (yes) {
         *           res.sendFile('/uploads/' + uid + '/' + file);
         *         } else {
         *           res.send(403, 'Sorry! you cant see that.');
         *         }
         *       });
         *     });
         *
         * @api public
         */
        sendFile(path: string): void;
        sendFile(path: string, options: any): void;
        sendFile(path: string, fn: (err?: Error) => any): void;
        sendFile(path: string, options: any, fn: (err?: Error) => any): void;

        /**
         * @deprecated Use sendFile instead.
         */
        sendfile(path: string): void;
        sendfile(path: string, options: any): void;
        sendfile(path: string, fn: (err?: Error) => any): void;
        sendfile(path: string, options: any, fn: (err?: Error) => any): void;

        /**
         * Transfer the file at the given `path` as an attachment.
         *
         * Optionally providing an alternate attachment `filename`,
         * and optional callback `fn(err)`. The callback is invoked
         * when the data transfer is complete, or when an error has
         * ocurred. Be sure to check `res.headerSent` if you plan to respond.
         *
         * This method uses `res.sendFile()`.
         */
        download(path: string): void;
        download(path: string, filename: string): void;
        download(path: string, fn: (err?: Error) => any): void;
        download(path: string, filename: string, fn: (err?: Error) => any): void;

        /**
         * Set _Content-Type_ response header with `type` through `mime.lookup()`
         * when it does not contain "/", or set the Content-Type to `type` otherwise.
         *
         * Examples:
         *
         *     res.type('.html');
         *     res.type('html');
         *     res.type('json');
         *     res.type('application/json');
         *     res.type('png');
         */
        contentType(type: string): this;

        /**
         * Set _Content-Type_ response header with `type` through `mime.lookup()`
         * when it does not contain "/", or set the Content-Type to `type` otherwise.
         *
         * Examples:
         *
         *     res.type('.html');
         *     res.type('html');
         *     res.type('json');
         *     res.type('application/json');
         *     res.type('png');
         */
        type(type: string): this;

        /**
         * Respond to the Acceptable formats using an `obj`
         * of mime-type callbacks.
         *
         * This method uses `req.accepted`, an array of
         * acceptable types ordered by their quality values.
         * When "Accept" is not present the _first_ callback
         * is invoked, otherwise the first match is used. When
         * no match is performed the server responds with
         * 406 "Not Acceptable".
         *
         * Content-Type is set for you, however if you choose
         * you may alter this within the callback using `res.type()`
         * or `res.set('Content-Type', ...)`.
         *
         *    res.format({
         *      'text/plain': function(){
         *        res.send('hey');
         *      },
         *
         *      'text/html': function(){
         *        res.send('<p>hey</p>');
         *      },
         *
         *      'appliation/json': function(){
         *        res.send({ message: 'hey' });
         *      }
         *    });
         *
         * In addition to canonicalized MIME types you may
         * also use extnames mapped to these types:
         *
         *    res.format({
         *      text: function(){
         *        res.send('hey');
         *      },
         *
         *      html: function(){
         *        res.send('<p>hey</p>');
         *      },
         *
         *      json: function(){
         *        res.send({ message: 'hey' });
         *      }
         *    });
         *
         * By default Express passes an `Error`
         * with a `.status` of 406 to `next(err)`
         * if a match is not made. If you provide
         * a `.default` callback it will be invoked
         * instead.
         */
        format(obj: any): this;

        /**
         * Set _Content-Disposition_ header to _attachment_ with optional `filename`.
         */
        attachment(filename?: string): this;

        /**
         * Set header `field` to `val`, or pass
         * an object of header fields.
         *
         * Examples:
         *
         *    res.set('Foo', ['bar', 'baz']);
         *    res.set('Accept', 'application/json');
         *    res.set({ Accept: 'text/plain', 'X-API-Key': 'tobi' });
         *
         * Aliased as `res.header()`.
         */
        set(fields: { [field: string]: string }): this;
        set(field: string, value: string): this;
        header(fields: { [field: string]: string }): this;
        header(field: string, value: string): this;

        /**
         * Get value for header `field`.
         */
        get(field: string): string;

        /**
         * Clear cookie `name`.
         */
        clearCookie(name: string, options?: CookieOptions): this;

        /**
         * Set cookie `name` to `val`, with the given `options`.
         *
         * Options:
         *
         *    - `maxAge`   max-age in milliseconds, converted to `expires`
         *    - `signed`   sign the cookie
         *    - `path`     defaults to "/"
         *
         * Examples:
         *
         *    // "Remember Me" for 15 minutes
         *    res.cookie('rememberme', '1', { expires: new Date(Date.now() + 900000), httpOnly: true });
         *
         *    // save as above
         *    res.cookie('rememberme', '1', { maxAge: 900000, httpOnly: true })
         */
        cookie(name: string, val: string | Object, options?: CookieOptions): this;

        /**
         * Set the location header to `url`.
         *
         * The given `url` can also be the name of a mapped url, for
         * example by default express supports "back" which redirects
         * to the _Referrer_ or _Referer_ headers or "/".
         *
         * Examples:
         *
         *    res.location('/foo/bar').;
         *    res.location('http://example.com');
         *    res.location('../login'); // /blog/post/1 -> /blog/login
         *
         * Mounting:
         *
         *   When an application is mounted and `res.location()`
         *   is given a path that does _not_ lead with "/" it becomes
         *   relative to the mount-point. For example if the application
         *   is mounted at "/blog", the following would become "/blog/login".
         *
         *      res.location('login');
         *
         *   While the leading slash would result in a location of "/login":
         *
         *      res.location('/login');
         */
        location(url: string): this;

        /**
         * Redirect to the given `url` with optional response `status`
         * defaulting to 302.
         *
         * The resulting `url` is determined by `res.location()`, so
         * it will play nicely with mounted apps, relative paths,
         * `"back"` etc.
         *
         * Examples:
         *
         *    res.redirect('/foo/bar');
         *    res.redirect('http://example.com');
         *    res.redirect(301, 'http://example.com');
         *    res.redirect('http://example.com', 301);
         *    res.redirect('../login'); // /blog/post/1 -> /blog/login
         */
        redirect(url: string): void;
        redirect(status: number, url: string): void;
        redirect(url: string, status: number): void;

        /**
         * Render `view` with the given `options` and optional callback `fn`.
         * When a callback function is given a response will _not_ be made
         * automatically, otherwise a response of _200_ and _text/html_ is given.
         *
         * Options:
         *
         *  - `cache`     boolean hinting to the engine it should cache
         *  - `filename`  filename of the view being rendered
         */
        render(view: string, locals?: { [local: string]: any }, callback?: (err: Error | void, html?: string) => void): void;
        render(view: string, callback?: (err: Error, html: string) => void): void;

        /**
         * Adds the field to the Vary response header, if it is not there already.
         * Examples:
         *
         *     res.vary('User-Agent').render('docs');
         *
         */
        vary(field: string): this;
    }
}

const res: res.Response;
export = res;
}
declare module 'express/lib/response' {
import main = require('~express/lib/response');
export = main;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/lib/router/index.d.ts
declare module '~express/lib/router/index' {

import {Request} from '~express/lib/request';
import {Response} from '~express/lib/response';
import Route = require('~express/lib/router/route');

namespace createRouter {

    export type PathArgument = string | RegExp | (string | RegExp)[];

    export interface NextFunction {
        (err?: any): void;
    }

    export interface RequestHandler {
        (req: Request, res: Response, next: NextFunction): any;
    }

    export interface ErrorHandler {
        (err: any, req: Request, res: Response, next: NextFunction): any;
    }

    export type Handler = RequestHandler | ErrorHandler;

    /** Can be passed to all methods like `use`, `get`, `all` etc */
    export type HandlerArgument = Handler | Handler[];

    export interface ParamHandler {
        (req: Request, res: Response, next: NextFunction, value: any, name: string): any;
    }

    export interface Router extends RequestHandler {

        /**
         * Map the given param placeholder `name`(s) to the given callback(s).
         *
         * Parameter mapping is used to provide pre-conditions to routes
         * which use normalized placeholders. For example a _:user_id_ parameter
         * could automatically load a user's information from the database without
         * any additional code,
         *
         * The callback uses the samesignature as middleware, the only differencing
         * being that the value of the placeholder is passed, in this case the _id_
         * of the user. Once the `next()` function is invoked, just like middleware
         * it will continue on to execute the route, or subsequent parameter functions.
         *
         *      app.param('user_id', function(req, res, next, id){
         *        User.find(id, function(err, user){
         *          if (err) {
         *            next(err);
         *          } else if (user) {
         *            req.user = user;
         *            next();
         *          } else {
         *            next(new Error('failed to load user'));
         *          }
         *        });
         *      });
         */
        param(name: string, handler: ParamHandler): this;

        /**
         * @deprecated
         */
        param(callback: (name: string, matcher: RegExp) => ParamHandler): this;

        all(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The GET method means retrieve whatever information (in the form of an entity)
         * is identified by the Request-URI. If the Request-URI refers to a data-producing
         * process, it is the produced data which shall be returned as the entity in the
         * response and not the source text of the process, unless that text happens to be
         * the output of the process.
         */
        get(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The POST method is used to request that the origin server accept the entity
         * enclosed in the request as a new subordinate of the resource identified by the
         * Request-URI in the Request-Line. POST is designed to allow a uniform method to
         * cover the following functions:
         *  - Annotation of existing resources;
         *  - Posting a message to a bulletin board, newsgroup, mailing list,
         *      or similar group of articles;
         *  - Providing a block of data, such as the result of submitting a
         *      form, to a data-handling process;
         *  - Extending a database through an append operation.
         */
        post(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The PUT method requests that the enclosed entity be stored under the supplied
         * Request-URI. If the Request-URI refers to an already existing resource, the
         * enclosed entity SHOULD be considered as a modified version of the one residing
         * on the origin server. If the Request-URI does not point to an existing
         * resource, and that URI is capable of being defined as a new resource by the
         * requesting user agent, the origin server can create the resource with that URI
         */
        put(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The HEAD method is identical to GET except that the server MUST NOT send a
         * message body in the response (i.e., the response terminates at the end of the
         * header section).
         */
        head(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The DELETE method requests that the origin server remove the association
         * between the target resource and its current functionality.  In effect, this
         * method is similar to the rm command in UNIX: it expresses a deletion operation
         * on the URI mapping of the origin server rather than an expectation that the
         * previously associated information be deleted.
         */
        delete(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The OPTIONS method requests information about the communication options
         * available for the target resource, at either the origin server or an
         * intervening intermediary.  This method allows a client to determine the options
         * and/or requirements associated with a resource, or the capabilities of a
         * server, without implying a resource action.
         *
         */
        options(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The final recipient of the request SHOULD reflect the message received,
         * excluding some fields described below, back to the client as the message body
         * of a 200 (OK) response with a Content-Type of "message/http" (Section 8.3.1 of
         * RFC7230).
         */
        trace(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAV COPY Method creates a duplicate of the source resource identified by
         * the Request-Uniform Resource Identifier (URI), in the destination resource
         * identified by the Destination Header. The COPY Method can be used to duplicate
         * collection and property resources.
         */
        copy(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAV LOCK method is used to take out a lock of any access type on a
         * resource so that another principal will not modify the resource while it is
         * being edited. The LOCK method may also be used to initiate transactions, which
         * allow clients to define groups of operations that are performed atomically.
         */
        lock(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAV MKCOL method creates a new collection at the location specified by
         * the Request-Uniform Resource Identifier (URI). When invoked without a request
         * body, the collection will be created without member resources. When used with a
         * request body, you can create members and properties on the collections or
         * members.
         */
        mkcol(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAV MOVE Method is used to move a resource to the location specified by
         * a request Uniform Resource Identifier (URI).
         */
        move(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * A purge is what happens when you pick out an object from the cache and discard
         * it along with its variants. Usually a purge is invoked through HTTP with the
         * method PURGE. An HTTP purge is similar to an HTTP GET request, except that the
         * method is PURGE. Actually you can call the method whatever you'd like, but most
         * people refer to this as purging.
         */
        purge(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAV PROPFIND Method retrieves properties for a resource identified by
         * the request Uniform Resource Identifier (URI). The PROPFIND Method can be used
         * on collection and property resources.
         */
        propfind(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAVPROPPATCH method sets properties for the resource at the specified
         * destination Uniform Resource Identifier (URI). All property names must be
         * scoped in the XML body using namespace URI references.
         */
        proppatch(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAVUNLOCK Method is used to remove the lock on the resource at the
         * request Uniform Resource Identifier (URI). The UNLOCK Method may also be used
         * to end a transaction that was initiated by the LOCK Method.
         */
        unlock(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * A REPORT request is an extensible mechanism for obtaining information about a
         * resource. Unlike a resource property, which has a single value, the value of a
         * report can depend on additional information specified in the REPORT request
         * body and in the REPORT request headers.
         */
        report(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * A MKACTIVITY request creates a new activity resource. A server MAY restrict
         * activity creation to particular collections, but a client can determine the
         * location of these collections from a DAV:activity-collection-set OPTIONS
         * request.
         */
        mkactivity(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * A CHECKOUT request can be applied to a checked-in version-controlled resource
         * to allow modifications to the content and dead properties of that
         * version-controlled resource.
         */
        checkout(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The MERGE method performs the logical merge of a specified version (the "merge
         * source") into a specified version-controlled resource (the "merge target").  If
         * the merge source is neither an ancestor nor a descendant of the DAV:checked-in
         * or DAV:checked-out version of the merge target, the MERGE checks out the merge
         * target (if it is not already checked out) and adds the URL of the merge source
         * to the DAV:merge-set of the merge target.
         */
        merge(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * a HTTP SEARCH method enhanced with the ssdp:discover functionality will be
         * referred to as a ssdp:discover request.
         */
        'm-search'(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         *  The WebDAV NOTIFY method is called by the server whenever an event that the
         *  client has subscribed to fires. The NOTIFY method will send User Datagram
         *  Protocol (UDP) packets to the client until the subscription has timed out. The
         *  subscription to the resource will persist after the notification is sent by
         *  the server.
         */
        notify(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAV SUBSCRIBE method is used to create a subscription to a resource.
         * This method is used to specify the details about the event to be monitored:
         * where to look for it; how long the event should be monitored; what the
         * notification mechanism is; and how long to delay before generating a
         * notification of the event.
         */
        subscribe(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The WebDAV UNSUBSCRIBE method is used to end a subscription to a resource.
         */
        unsubscribe(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The PATCH method requests that a set of changes described in the request entity
         * be applied to the resource identified by the Request- URI. The set of changes
         * is represented in a format called a "patch document" identified by a media
         * type.
         */
        patch(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * The client invokes the SEARCH method to initiate a server-side search. The body
         * of the request defines the query. The server MUST emit an entity matching the
         * RFC2518 PROPFIND response.
         */
        search(path: PathArgument, ...handlers: HandlerArgument[]): this;

        /**
         * This specification reserves the method name CONNECT for use with a proxy that
         * can dynamically switch to being a tunnel (e.g. SSL tunneling).
         */
        connect(path: PathArgument, ...handlers: HandlerArgument[]): this;

        use(...handlers: HandlerArgument[]): this;
        use(mountPoint: string | RegExp | (string | RegExp)[], ...handlers: HandlerArgument[]): this;

        route(prefix: PathArgument): Route;
    }
}

function createRouter(): createRouter.Router;
export = createRouter;
}
declare module 'express/lib/router/index' {
import main = require('~express/lib/router/index');
export = main;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/pillarjs/path-to-regexp/ec285ed3500aed455df59e3b8b07f473412918a4/index.d.ts
declare module '~express~path-to-regexp' {
function pathToRegexp (path: pathToRegexp.Path, options?: pathToRegexp.Options): pathToRegexp.PathRegExp;
function pathToRegexp (path: pathToRegexp.Path, keys: pathToRegexp.Token[], options?: pathToRegexp.Options): pathToRegexp.PathRegExp;

namespace pathToRegexp {
  export interface PathRegExp extends RegExp {
    // An array to be populated with the keys found in the path.
    keys: Key[];
  }

  export interface Options {
    // When `true` the route will be case sensitive. (default: `false`)
    sensitive?: boolean;
    // When `false` the trailing slash is optional. (default: `false`)
    strict?: boolean;
    // When `false` the path will match at the beginning. (default: `true`)
    end?: boolean;
  }

  /**
   * Parse an Express-style path into an array of tokens.
   */
  export function parse (path: string): Token[];

  /**
   * Transforming an Express-style path into a valid path.
   */
  export function compile (path: string): PathFunction;

  /**
   * Transform an array of tokens into a path generator function.
   */
  export function tokensToFunction (tokens: Token[]): PathFunction;

  /**
   * Transform an array of tokens into a matching regular expression.
   */
  export function tokensToRegExp (tokens: Token[], options?: Options): PathRegExp;

  export interface Key {
    name: string | number;
    prefix: string;
    delimiter: string;
    optional: boolean;
    repeat: boolean;
    pattern: string;
    partial: boolean;
    asterisk: boolean;
  }

  interface PathFunctionOptions {
    pretty?: boolean;
  }

  export type Token = string | Key;
  export type Path = string | RegExp | Array<string | RegExp>;
  export type PathFunction = (data?: Object, options?: PathFunctionOptions) => string;
}

export = pathToRegexp;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/lib/router/layer.d.ts
declare module '~express/lib/router/layer' {

import {Options, Token} from '~express~path-to-regexp';

interface Layer {
    handle?: Function;
    name: string;
    params?: any;
    path?: string;
    keys: Token[];
    regexp: RegExp;
    method: string;
}

const Layer: {
    (path: string, options?: Options, fn?: Function): Layer;
    new (path: string, options?: Options, fn?: Function): Layer;
};

export = Layer;
}
declare module 'express/lib/router/layer' {
import main = require('~express/lib/router/layer');
export = main;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/lib/router/route.d.ts
declare module '~express/lib/router/route' {

import {HandlerArgument} from '~express/lib/router/index';
import Layer = require('~express/lib/router/layer');

class Route {

    path: string;
    stack: Layer[];

    /**
     * route handlers for various http methods
     */
    methods: {
        [method: string]: boolean;
    };

    constructor(path: string);

    all(...handlers: HandlerArgument[]): this;

    /**
     * The GET method means retrieve whatever information (in the form of an entity)
     * is identified by the Request-URI. If the Request-URI refers to a data-producing
     * process, it is the produced data which shall be returned as the entity in the
     * response and not the source text of the process, unless that text happens to be
     * the output of the process.
     */
    get(...handlers: HandlerArgument[]): this;

    /**
     * The POST method is used to request that the origin server accept the entity
     * enclosed in the request as a new subordinate of the resource identified by the
     * Request-URI in the Request-Line. POST is designed to allow a uniform method to
     * cover the following functions:
     *  - Annotation of existing resources;
     *  - Posting a message to a bulletin board, newsgroup, mailing list,
     *      or similar group of articles;
     *  - Providing a block of data, such as the result of submitting a
     *      form, to a data-handling process;
     *  - Extending a database through an append operation.
     */
    post(...handlers: HandlerArgument[]): this;

    /**
     * The PUT method requests that the enclosed entity be stored under the supplied
     * Request-URI. If the Request-URI refers to an already existing resource, the
     * enclosed entity SHOULD be considered as a modified version of the one residing
     * on the origin server. If the Request-URI does not point to an existing
     * resource, and that URI is capable of being defined as a new resource by the
     * requesting user agent, the origin server can create the resource with that URI
     */
    put(...handlers: HandlerArgument[]): this;

    /**
     * The HEAD method is identical to GET except that the server MUST NOT send a
     * message body in the response (i.e., the response terminates at the end of the
     * header section).
     */
    head(...handlers: HandlerArgument[]): this;

    /**
     * The DELETE method requests that the origin server remove the association
     * between the target resource and its current functionality.  In effect, this
     * method is similar to the rm command in UNIX: it expresses a deletion operation
     * on the URI mapping of the origin server rather than an expectation that the
     * previously associated information be deleted.
     */
    delete(...handlers: HandlerArgument[]): this;

    /**
     * The OPTIONS method requests information about the communication options
     * available for the target resource, at either the origin server or an
     * intervening intermediary.  This method allows a client to determine the options
     * and/or requirements associated with a resource, or the capabilities of a
     * server, without implying a resource action.
     *
     */
    options(...handlers: HandlerArgument[]): this;

    /**
     * The final recipient of the request SHOULD reflect the message received,
     * excluding some fields described below, back to the client as the message body
     * of a 200 (OK) response with a Content-Type of "message/http" (Section 8.3.1 of
     * RFC7230).
     */
    trace(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAV COPY Method creates a duplicate of the source resource identified by
     * the Request-Uniform Resource Identifier (URI), in the destination resource
     * identified by the Destination Header. The COPY Method can be used to duplicate
     * collection and property resources.
     */
    copy(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAV LOCK method is used to take out a lock of any access type on a
     * resource so that another principal will not modify the resource while it is
     * being edited. The LOCK method may also be used to initiate transactions, which
     * allow clients to define groups of operations that are performed atomically.
     */
    lock(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAV MKCOL method creates a new collection at the location specified by
     * the Request-Uniform Resource Identifier (URI). When invoked without a request
     * body, the collection will be created without member resources. When used with a
     * request body, you can create members and properties on the collections or
     * members.
     */
    mkcol(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAV MOVE Method is used to move a resource to the location specified by
     * a request Uniform Resource Identifier (URI).
     */
    move(...handlers: HandlerArgument[]): this;

    /**
     * A purge is what happens when you pick out an object from the cache and discard
     * it along with its variants. Usually a purge is invoked through HTTP with the
     * method PURGE. An HTTP purge is similar to an HTTP GET request, except that the
     * method is PURGE. Actually you can call the method whatever you'd like, but most
     * people refer to this as purging.
     */
    purge(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAV PROPFIND Method retrieves properties for a resource identified by
     * the request Uniform Resource Identifier (URI). The PROPFIND Method can be used
     * on collection and property resources.
     */
    propfind(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAVPROPPATCH method sets properties for the resource at the specified
     * destination Uniform Resource Identifier (URI). All property names must be
     * scoped in the XML body using namespace URI references.
     */
    proppatch(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAVUNLOCK Method is used to remove the lock on the resource at the
     * request Uniform Resource Identifier (URI). The UNLOCK Method may also be used
     * to end a transaction that was initiated by the LOCK Method.
     */
    unlock(...handlers: HandlerArgument[]): this;

    /**
     * A REPORT request is an extensible mechanism for obtaining information about a
     * resource. Unlike a resource property, which has a single value, the value of a
     * report can depend on additional information specified in the REPORT request
     * body and in the REPORT request headers.
     */
    report(...handlers: HandlerArgument[]): this;

    /**
     * A MKACTIVITY request creates a new activity resource. A server MAY restrict
     * activity creation to particular collections, but a client can determine the
     * location of these collections from a DAV:activity-collection-set OPTIONS
     * request.
     */
    mkactivity(...handlers: HandlerArgument[]): this;

    /**
     * A CHECKOUT request can be applied to a checked-in version-controlled resource
     * to allow modifications to the content and dead properties of that
     * version-controlled resource.
     */
    checkout(...handlers: HandlerArgument[]): this;

    /**
     * The MERGE method performs the logical merge of a specified version (the "merge
     * source") into a specified version-controlled resource (the "merge target").  If
     * the merge source is neither an ancestor nor a descendant of the DAV:checked-in
     * or DAV:checked-out version of the merge target, the MERGE checks out the merge
     * target (if it is not already checked out) and adds the URL of the merge source
     * to the DAV:merge-set of the merge target.
     */
    merge(...handlers: HandlerArgument[]): this;

    /**
     * a HTTP SEARCH method enhanced with the ssdp:discover functionality will be
     * referred to as a ssdp:discover request.
     */
    'm-search'(...handlers: HandlerArgument[]): this;

    /**
     *  The WebDAV NOTIFY method is called by the server whenever an event that the
     *  client has subscribed to fires. The NOTIFY method will send User Datagram
     *  Protocol (UDP) packets to the client until the subscription has timed out. The
     *  subscription to the resource will persist after the notification is sent by
     *  the server.
     */
    notify(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAV SUBSCRIBE method is used to create a subscription to a resource.
     * This method is used to specify the details about the event to be monitored:
     * where to look for it; how long the event should be monitored; what the
     * notification mechanism is; and how long to delay before generating a
     * notification of the event.
     */
    subscribe(...handlers: HandlerArgument[]): this;

    /**
     * The WebDAV UNSUBSCRIBE method is used to end a subscription to a resource.
     */
    unsubscribe(...handlers: HandlerArgument[]): this;

    /**
     * The PATCH method requests that a set of changes described in the request entity
     * be applied to the resource identified by the Request- URI. The set of changes
     * is represented in a format called a "patch document" identified by a media
     * type.
     */
    patch(...handlers: HandlerArgument[]): this;

    /**
     * The client invokes the SEARCH method to initiate a server-side search. The body
     * of the request defines the query. The server MUST emit an entity matching the
     * RFC2518 PROPFIND response.
     */
    search(...handlers: HandlerArgument[]): this;

    /**
     * This specification reserves the method name CONNECT for use with a proxy that
     * can dynamically switch to being a tunnel (e.g. SSL tunneling).
     */
    connect(...handlers: HandlerArgument[]): this;
}

export = Route;
}
declare module 'express/lib/router/route' {
import main = require('~express/lib/router/route');
export = main;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/felixfbecker/typed-serve-static/fe2b0ca8e5f2bd696242c57fef96e85715b4c516/index.d.ts
declare module '~express~serve-static' {

import {IncomingMessage, ServerResponse} from 'http';
import {Stats} from 'fs';

/**
 * Create a new middleware function to serve files from within a given root directory.
 * The file to serve will be determined by combining req.url with the provided root directory.
 * When a file is not found, instead of sending a 404 response, this module will instead call next() to move on to the next middleware, allowing for stacking and fall-backs.
 */
function serveStatic(root: string, options?: serveStatic.ServeStaticOptions): (req: IncomingMessage, res: ServerResponse, next: (err?: any) => any) => void;

namespace serveStatic {
    export interface ServeStaticOptions {
        /**
         * Set how "dotfiles" are treated when encountered. A dotfile is a file or directory that begins with a dot (".").
         * Note this check is done on the path itself without checking if the path actually exists on the disk.
         * If root is specified, only the dotfiles above the root are checked (i.e. the root itself can be within a dotfile when when set to "deny").
         * The default value is 'ignore'.
         * 'allow' No special treatment for dotfiles
         * 'deny' Send a 403 for any request for a dotfile
         * 'ignore' Pretend like the dotfile does not exist and call next()
         */
        dotfiles?: string;

        /**
         * Enable or disable etag generation, defaults to true.
         */
        etag?: boolean;

        /**
         * Set file extension fallbacks. When set, if a file is not found, the given extensions will be added to the file name and search for.
         * The first that exists will be served. Example: ['html', 'htm'].
         * The default value is false.
         */
        extensions?: string[];

        /**
         * Let client errors fall-through as unhandled requests, otherwise forward a client error.
         * The default value is false.
         */
        fallthrough?: boolean;

        /**
         * By default this module will send "index.html" files in response to a request on a directory.
         * To disable this set false or to supply a new index pass a string or an array in preferred order.
         */
        index?: boolean | string | string[];

        /**
         * Enable or disable Last-Modified header, defaults to true. Uses the file system's last modified value.
         */
        lastModified?: boolean;

        /**
         * Provide a max-age in milliseconds for http caching, defaults to 0. This can also be a string accepted by the ms module.
         */
        maxAge?: number | string;

        /**
         * Redirect to trailing "/" when the pathname is a dir. Defaults to true.
         */
        redirect?: boolean;

        /**
         * Function to set custom headers on response. Alterations to the headers need to occur synchronously.
         * The function is called as fn(res, path, stat), where the arguments are:
         * res the response object
         * path the file path that is being sent
         * stat the stat object of the file that is being sent
         */
        setHeaders?: (res: ServerResponse, path: string, stat: Stats) => any;
    }
}

export = serveStatic;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/lib/express.d.ts
declare module '~express/lib/express' {

import {Application as _Application} from '~express/lib/application';
import {Request as _Request} from '~express/lib/request';
import {Response as _Response, CookieOptions as _CookieOptions} from '~express/lib/response';
import createRouter = require('~express/lib/router/index');
import RouteClass = require('~express/lib/router/route');
import serveStatic = require('~express~serve-static');

namespace createApplication {

    // workaround to reexport the interfaces
    export type Request = _Request
    export type Response = _Response
    export type CookieOptions = _CookieOptions
    export type Application = _Application
    export type Router = createRouter.Router
    export type RequestHandler = createRouter.RequestHandler
    export type ErrorHandler = createRouter.ErrorHandler
    export type ParamHandler = createRouter.ParamHandler
    export type Handler = createRouter.Handler
    export type NextFunction = createRouter.NextFunction

    // need to use an interface for this because `static` is a reserved word
    // and cannot be used as a variable identifier
    export interface Express {

        /** Create an express application. */
        (): Application;

        /** The Application prototype */
        application: Application;

        /** The Request prototype */
        request: Request;

        /** The Response prototype */
        response: Response;

        /** The Route constructor */
        Route: typeof RouteClass;

        /** The Router constructor */
        Router: typeof createRouter;

        /** The serve-static middleware */
        static: typeof serveStatic;

        // TODO query
    }
}

const createApplication: createApplication.Express;
export = createApplication;
}
declare module 'express/lib/express' {
import main = require('~express/lib/express');
export = main;
}

// Generated by typings
// Source: https://raw.githubusercontent.com/types/npm-express/48ccd5cae75385b37d6b0c03f0e957112f108b04/index.d.ts
declare module 'express' {

import express = require('~express/lib/express');
export = express;
}
