// Generated by typings
// Source: https://raw.githubusercontent.com/DefinitelyTyped/DefinitelyTyped/d09fbd46a893294f5fe7d53dc206dd41661e7ee2/fast-json-patch/fast-json-patch.d.ts
declare namespace fastjsonpatch {
    

    interface JsonPatch {
        /**
         * Applies an array of patch instructions to an object
         */
        apply(object:any, patches:Patch[], validate?:boolean):boolean
        
        /**
         * Observes changes made to an object, which can then be retieved using generate
         */
        observe<T>(object:T, callback?:()=>void):Observer<T>
        
        /**
         * Detach an observer from an object
         */
        unobserve<T>(object:T, observer:Observer<T>):void

        /**
         * Generate an array of patches from an observer
         */
        generate<T>(observer:Observer<T>):Patch[]

        /**
         * Create an array of patches from the differences in two objects
         */
        compare(object1:any, object2:any):Patch[]

        /**
         * Ensure a set of patch instructions is valid
         */
        validate(patches:Patch[], tree?:any):JsonPatchError[]
    }
    
    interface Observer<T> {
        object:T
        patches:Patch[]
        unobserve():void
    }

    interface Patch {
        op:string
        path:string
        value?:any
        from?:string
    }

    interface JsonPatchError {
        name:string
        message:string
        index:number
        operation:any
        tree:any
    }
}

declare  var jsonpatch: fastjsonpatch.JsonPatch;

declare module "fast-json-patch" {
    export = jsonpatch
}
