return {
-- covers Lua 5.1, Lua 5.2, and Lua 5.3;
-- Lua 5.2 and Lua 5.3 specific items are marked with
-- FUNCTION/ARGUMENT/ARGS/VALUE ADDED/DEPRECATED IN Lua 5.2 or Lua 5.3.
-- 感谢 lu9523@qq.com 汉化

-- Keywords
["and"] = {type = "keyword"},
["break"] = {type = "keyword"},
["do"] = {type = "keyword"},
["else"] = {type = "keyword"},
["elseif"] = {type = "keyword"},
["end"] = {type = "keyword"},
["for"] = {type = "keyword"},
["function"] = {type = "keyword"},
["goto"] = {type = "keyword"},
["if"] = {type = "keyword"},
["in"] = {type = "keyword"},
["local"] = {type = "keyword"},
["not"] = {type = "keyword"},
["or"] = {type = "keyword"},
["repeat"] = {type = "keyword"},
["return"] = {type = "keyword"},
["then"] = {type = "keyword"},
["until"] = {type = "keyword"},
["while"] = {type = "keyword"},

-- Boolean values
["false"] = {type = "value"},
["nil"] = {type = "value"},
["true"] = {type = "value"},

-- TouchSprite library
init = {
type = "function",
description = "脚本使用触摸函数前必须调用，以指定应用程序以及坐标系。\n参数 rotate: 0 - 竖屏; 1 - Home键在右边; 2 - Home键在左边",
args = "(bid: string, rotate: number)",
returns = "()",
},
touchDown = {
type = "function",
description = "发送触摸事件: 触摸按下。",
args = "(index: number, x: number, y: number)",
returns = "()",
},
touchMove = {
type = "function",
description = "发送触摸事件: 触摸移动。",
args = "(index: number, x: number, y: number)",
returns = "()",
},
touchUp = {
type = "function",
description = "发送触摸事件: 触摸抬起。",
args = "(index: number, x: number, y: number)",
returns = "()",
},
inputText = {
type = "function",
description = "输入字符串。",
args = "(str: string)",
returns = "()",
},
getColor = {
type = "function",
description = "获取某一点的颜色值（BGR）。",
args = "(x: number, y: number)",
returns = "(color: number)",
},
getColorRGB = {
type = "function",
description = "获取某一点的颜色 R,G,B 值。",
args = "(x: number, y: number)",
returns = "(color_r: number, color_g: number, color_b: number)",
},
mSleep = {
type = "function",
description = "等待延迟,延时。",
args = "(interval: number)",
returns = "()",
},
findColorInRegionFuzzy = {
type = "function",
description = "区域找色、模糊找色、模糊区域找色。",
args = "(color: number, degree: number, x1: number, y1: number, x2: number, y2: number)",
returns = "(x: number, y: number)",
},
findImageInRegionFuzzy = {
type = "function",
description = "区域找图、模糊找图、模糊区域找图。",
args = "(picpath: string, degree: number, x1: number, y1: number, x2: number, y2: number, alpha: number)",
returns = "(x: number, y: number)",
},
findMultiColorInRegionFuzzy = {
type = "function",
description = "多点找色，区域多点找色。",
args = "(color: number,posandcolor: string, degree: number, x1: number,y1: number,x2: number,y2: number)",
returns = "(x: number, y: number)",
},
snapshot = {
type = "function",
description = "截取屏幕中指定区域的图像并?生成指定格式的图片文件。",
args = "(picpath: string, x1: number,y1: number, x2: number, y2: number, quality: number)",
returns = "()",
},
dialog = {
type = "function",
description = "弹出提示信息。",
args = "(text: string, time: number)",
returns = "()",
},
dialogRet = {
type = "function",
description = "弹出提示信息，并提供 1 ~ 3 个按钮给用户选择。\n返回值: cbtn == 0；btn1 == 1；btn2 == 2",
args = "(text: string, cbtn: string, btn1: string, btn2: string, time: number)",
returns = "(choice: number)",
},
dialogInput = {
type = "function",
description = "弹出提示信息，并提供 1 ~ 2 个编辑框给用户输入。",
args = "(title: string, format: string, btn: string)",
returns = "(text_a: string, text_b: string)",
},
showUI = {
type = "function",
description = "显示一个自定义的界面，用来接收用户相关的自定义配置。\n返回值: 1 == 确认输入；0 == 取消输入",
args = "(ui_json: string)",
returns = "(ret: number)",
},
openURL = {
type = "function",
description = "调用系统浏览器，打开一个指定网址。",
args = "(url: string)",
returns = "()",
},
initLog = {
type = "function",
description = "初始化日志。\n参数 flag : 0 == 输出到文件名; 1 == 输出到带时间戳的文件名; 2 == 异步发送到服务器; 3 == 同步发送到服务器",
args = "(name: string, flag: number)",
returns = "()",
},
wLog = {
type = "function",
description = "写日志、发送日志。",
args = "(name: string, contents: string)",
returns = "()",
},
closeLog = {
type = "function",
description = "关闭日志输出连接。",
args = "(name: string, contents: string)",
returns = "()",
},
syslog = {
type = "function",
description = "输出系统日志 NSLog。",
args = "(contents: string)",
returns = "()",
},
nLog = {
type = "function",
description = "输出日志到TS Studio 或是 触动抓色器, 需配合TS Studio使用 或 使用触动抓色器远程运行脚本。",
args = "(contents: string)",
returns = "()",
},
playAudio = {
type = "function",
description = "在后台播放指定的声音文件。",
args = "(filename: string)",
returns = "()",
},
keepScreen = {
type = "function",
description = "在脚本中保持当前屏幕内容不变，多次调用取色、找色、截图、找图等函数时，直接调用保持的内容。该函数为优化类函数，能够为大量的静态图像处理函数提供性能优化。",
args = "(flag: bool)",
returns = "()",
},
runApp = {
type = "function",
description = "通过指定BID打开一个应用程序。\n返回值: 0 == 应用启动成功；非0 == 应用启动失败",
args = "(bid: string)",
returns = "(flag: number)",
},
closeApp = {
type = "function",
description = "通过指定BID关闭一个应用程序。",
args = "(bid: string)",
returns = "()",
},
getScreenSize = {
type = "function",
description = "获取设备屏幕的分辨率，用来判断坐标系的使用。",
args = "()",
returns = "(width: number,height: number)",
},
getDeviceType = {
type = "function",
description = "获取设备的类型，可使用获取屏幕分辨率代替。\n返回值: 0 == iPod Touch；1 == iPhone；2 == iPad",
args = "()",
returns = "(type: number)",
},
getDeviceID = {
type = "function",
description = "获取设备标识，每台设备的标识都是唯一的。",
args = "()",
returns = "(id: string)",
},
lua_exit = {
type = "function",
description = "直接终止脚本。",
args = "()",
returns = "()",
},
pressHomeKey = {
type = "function",
description = "模拟用户按下或抬起主屏幕按键的操作。参数: IOS6及其以下系统 0 ==按下；1 ==抬起；IOS7 只能填0",
args = "(flag: number)",
returns = "()",
},
doublePressHomeKey = {
type = "function",
description = "模拟用户双击HOME键的操作。",
args = "() \n此函数需触动精灵 2.x 以上版本支持,且IOS版本高于7.0",
returns = "()",
},
isFrontApp = {
type = "function",
description = "根据应用的 Bundle ID 判断应用是否处于前台。\n返回值: 0 == 不在前台运行；1 == 在前台运行",
args = "(bid: string)",
returns = "(flag: number)",
},
resetIDLETimer = {
type = "function",
description = "重置系统空闲时间，阻止自动锁屏，保持屏幕常亮。",
args = "()",
returns = "()",
},
vibrator = {
type = "function",
description = "使手机振动一次。",
args = "()",
returns = "()",
},
lockDevice = {
type = "function",
description = "锁定设备并关闭屏幕。",
args = "()",
returns = "()",
},
deviceIsLock = {
type = "function",
description = "判断当前设备的屏幕锁定状态。\n返回值: 0 == 表示设备未锁定；非0 == 表示设备已锁定",
args = "()",
returns = "(flag: number)",
},
unlockDevice = {
type = "function",
description = "解除屏幕锁定状态。",
args = "()",
returns = "()",
},
getNetTime = {
type = "function",
description = "从互联网上获取时间信息，返回从1970年1月1日到当前状态的秒数。",
args = "()",
returns = "(time: number)",
},
writePasteboard = {
type = "function",
description = "写剪贴板。",
args = "(str: string)",
returns = "()",
},
readPasteboard = {
type = "function",
description = "读剪贴板。",
args = "()",
returns = "(str: string)",
},
getTSVer = {
type = "function",
description = "获取触动精灵版本号。",
args = "()",
returns = "(version: string)",
},
getOSVer = {
type = "function",
description = "获取系统版本号。",
args = "()",
returns = "(version: string)",
},
frontAppBid = {
type = "function",
description = "获取前台应用的 Bundle ID。",
args = "()",
returns = "(bid: string)",
},
luaExitIfCall = {
type = "function",
description = "设置电话拨入时停止脚本运行的标识。",
args = "()",
returns = "()",
},
clearKeyChain = {
type = "function",
description = "清除指定应用储存在系统钥匙串中的信息。",
args = "(bid: string)",
returns = "()",
},
setWifiEnable = {
type = "function",
description = "设置无线局域网开关。\n参数: 打开WIFI - true;关闭WIFI - false",
args = "(flag: bool)",
returns = "()",
},
catchTouchPoint = {
type = "function",
description = "调用该函数后，触动精灵将等待用户完成一次屏幕点击，并返回此次点击的坐标。",
args = "()",
returns = "(x: number, y: number)",
},
fakeGPS = {
type = "function",
description = "调用该函数以欺骗当前应用获取到的位置信息。",
args = "(x: float, y: float)",
returns = "()",
},
appBundlePath = {
type = "function",
description = "调用该函数将返回应用程序的安装路径。",
args = "(bid: string) \n此函数需触动精灵 iOS v2.0.7 及以上版本支持",
returns = "(path: string)",
},
appDataPath = {
type = "function",
description = "调用该函数将返回应用程序的数据路径。",
args = "(bid: string) \n此函数需触动精灵 iOS v2.0.8 及以上版本支持",
returns = "(path: string)",
},
loadPlugin = {
type = "function",
description = "载入插件。",
args = "(plugin_name: string)",
returns = "()",
},
callPlugin = {
type = "function",
description = "执行插件函数。",
args = "(plugin_name: string,func_name: string, params: string)",
returns = "(return: string)",
},
unloadPlugin = {
type = "function",
description = "释放插件。",
args = "()",
returns = "()",
},
appIsRunning = {
type = "function",
description = "根据应用的 Bundle ID 判断应用是否在运行。\n返回值: 0 == 应用未运行；1 == 应用运行中",
args = "(bid: string) \n此函数需触动精灵 iOS v2.2.0 及以上版本支持",
returns = "(flag: number)",
},
isColor = {
	type = "function",
	description = "抓色器默认格式中提到的一个自定义函数",
	args = "() \n此函数需用户自定定义，可以在编辑器中输入 \"isColor定义\" 自动补全",
	returns = "(return: boolean)",
},
touchMoveTo = {
	type = "function",
	description = "从一点触摸滑动到另一点",
	args = "(p1: pos, p2: pos) \n此函数需引用触动扩展库 sz.pos ，参考手册 [POS 模块]",
	returns = "()",
},
pos = {
	type = "function",
	description = "构建一个点",
	args = "(x: number, y: number, color: number) \n此函数需引用触动扩展库 sz.pos ，参考手册 [POS 模块]",
	returns = "(return: pos)",
},
plist = {
	type = "lib",
	description = [[]],
	childs = {
		read = {
			type = "function",
			description = "读取一个 plist 文件",
			args = "(filename: string) \n此函数需引用触动扩展库 sz.plist ，参考手册 [PLIST 模块]",
			returns = "(return: table)",
		},
		write = {
			type = "function",
			description = "将一个表写入 plist 文件",
			args = "(filename: string, tab: table, isbinary: boolean) \n此函数需引用触动扩展库 sz.plist ，参考手册 [PLIST 模块]",
			returns = "()",
		},
	},
},

json = {
	type = "lib",
	description = [[]],
	childs = {
		decode = {
			type = "function",
			description = "解码 json 串为表",
			args = "(json: string) \n此函数需引用触动扩展库 sz.json ，参考手册 [JSON 模块]",
			returns = "(return: table)",
		},
		encode = {
			type = "function",
			description = "将表编码成 json 串",
			args = "(tab: table) \n此函数需引用触动扩展库 sz.json ，参考手册 [JSON 模块]",
			returns = "(return: string)",
		},
		totable = {
			type = "function",
			description = "解码 json 串为表",
			args = "(json: string) \n此函数需引用触动扩展库 sz.json ，参考手册 [JSON 模块]",
			returns = "(return: table)",
		},
		fromtable = {
			type = "function",
			description = "将表编码成 json 串",
			args = "(tab: table) \n此函数需引用触动扩展库 sz.json ，参考手册 [JSON 模块]",
			returns = "(return: string)",
		},
	},
},

cjson = {
	type = "lib",
	description = [[]],
	childs = {
		decode = {
			type = "function",
			description = "解码 json 串为表",
			args = "(json: string) \n此函数需引用触动扩展库 sz.cjson ，参考手册 [JSON 模块]",
			returns = "(return: table)",
		},
		encode = {
			type = "function",
			description = "将表编码成 json 串",
			args = "(tab: table) \n此函数需引用触动扩展库 sz.cjson ，参考手册 [JSON 模块]",
			returns = "(return: string)",
		},
		totable = {
			type = "function",
			description = "解码 json 串为表",
			args = "(json: string) \n此函数需引用触动扩展库 sz.cjson ，参考手册 [JSON 模块]",
			returns = "(return: table)",
		},
		fromtable = {
			type = "function",
			description = "将表编码成 json 串",
			args = "(tab: table) \n此函数需引用触动扩展库 sz.cjson ，参考手册 [JSON 模块]",
			returns = "(return: string)",
		},
	},
},

ftp = {
	type = "lib",
	description = [[]],
	childs = {
		download = {
			type = "function",
			description = "从 FTP 服务器下载一个文件到本地",
			args = "(remote_url: string, local_path: string) \n此函数需引用触动扩展库 sz.ftp ，参考手册 [FTP 模块]",
			returns = "(msg: string, err: string)",
		},
		upload = {
			type = "function",
			description = "从本地上传一个文件到 FTP 服务器",
			args = "(local_path: string, remote_url: string) \n此函数需引用触动扩展库 sz.ftp ，参考手册 [FTP 模块]",
			returns = "(msg: string, err: string)",
		},
		cmd = {
			type = "function",
			description = "远程执行一条 FTP 命令",
			args = "(remote_url: string, command: string) \n此函数需引用触动扩展库 sz.ftp ，参考手册 [FTP 模块]",
			returns = "(msg: string, err: string)",
		},
	},
},

http = {
	type = "lib",
	description = [[]],
	childs = {
		get = {
			type = "function",
			description = "使用 HTTP 协议发送 GET 请求",
			args = "(url: string[, timeout: number, headers: string]) \n此函数需引用触动扩展库 sz.ftp ，参考手册 [FTP 模块]",
			returns = "(status: string, headers: string, body: string)",
		},
		post = {
			type = "function",
			description = "使用 HTTP 协议发送 POST 请求",
			args = "(url: string, timeout: number, headers: string, data: string) \n此函数需引用触动扩展库 sz.ftp ，参考手册 [FTP 模块]",
			returns = "(status: string, headers: string, body: string)",
		},
		header = {
			type = "function",
			description = "解析一个 HTTP 请求返回的头信息",
			args = "(headers: table) \n此函数需引用触动扩展库 sz.ftp ，参考手册 [FTP 模块]",
			returns = "(return: string)",
		},
	},
},

system = {
	type = "lib",
	description = [[]],
	childs = {
		udid = {
			type = "function",
			description = "获取设备 UDID 信息",
			args = "() \n此函数需引用触动扩展库 sz.system ，参考手册 [设备信息模块]",
			returns = "(return: string)",
		},
		serialnumber = {
			type = "function",
			description = "获取设备序列号信息",
			args = "() \n此函数需引用触动扩展库 sz.system ，参考手册 [设备信息模块]",
			returns = "(return: string)",
		},
		wifimac = {
			type = "function",
			description = "获取设备的 WiFi MAC 地址",
			args = "() \n此函数需引用触动扩展库 sz.system ，参考手册 [设备信息模块]",
			returns = "(return: string)",
		},
		btmac = {
			type = "function",
			description = "获取设备的蓝牙 MAC 地址",
			args = "() \n此函数需引用触动扩展库 sz.system ，参考手册 [设备信息模块]",
			returns = "(return: string)",
		},
		osversion = {
			type = "function",
			description = "获取设备的系统版本号",
			args = "() \n此函数需引用触动扩展库 sz.system ，参考手册 [设备信息模块]",
			returns = "(return: string)",
		},
		localwifiaddr = {
			type = "function",
			description = "获取设备本地所有的网络地址",
			args = "() \n此函数需引用触动扩展库 sz.system ，参考手册 [设备信息模块]",
			returns = "(return: table)",
		},
	},
},

-- Basic library
--[[
_ENV = {
type = "value",
description = "VALUE ADDED IN Lua 5.2.",
},
--]]
_G = {
type = "value",
description = "一个保存了全局环境的全局变量（不是一个函数）,但Lua虚拟机自己并不使用这个变量,脚本中可以任意改变这个变量_G的值，不会影响任何环境或出现副作用.",
},
_VERSION = {
type = "value",
description = "一个保存当前解释器版本名字的全局变量（不是一个函数）,此变量当前的值为 Lua 5.2.",
},
assert = {
type = "function",
description = [[当参数v为假（比如nil或false）时发出一个错误，否则返回函数的所有参数。参数message是一个错误消息，它的缺省值为 assertion failed!]],
args = "(v: any [, message: string])",
returns = "(...)",
},
collectgarbage = {
type = "function",
description =[[这个函数是垃圾回收器的接口。根据函数的第一个参数opt，它实现了不同的功能：\ncollect:执行一次完整的垃圾回收循环。这个是函数的默认选择。\nstop:停止垃圾回收器的自动执行。只有显式调用“重启”时，回收器才会再次进行自动的回收工作。\nrestart:重启垃圾回收器的自动执行。\ncount:返回Lua使用的内存的总大小（单位为千字节）及内存大小（以字节为单位）模1024 的值。第一个返回值带有小数部分，因此下面的等式永远为真：k,b=collectgarbage(count)assert(k*1024==math.floor(k)*1024 + b)(当 Lua的数字类型不是浮点型时，第二个返回值就很有用了。)\nstep:执行一次分步垃圾回收操作。步长由参数arg控制（值越大意味着回收步骤更多）。如果你想控制好步长，你必须通过实验的方法来调整 arg 的大小。如果这次分步执行完后，整个垃圾回收的循环也结束了，函数返回 true。\nsetpause:将参数 arg 的值设为回收器的“暂停”值。返回之前的“暂停”值。\nsetstepmul:将参数 arg 的值设为回收器的“步长”值。返回之前的“步长”值。\nisrunning:返回一个布尔值。如果垃圾回收器正在工作（没有 stop）就返回 true，否则返回false。\ngenerational:将回收器的工作模式改为世代式。这是一个实验性质的特点。\nincremental:将回收器的工作模式改为增量式。这是默认的模式。]],
args = "([opt: string [, arg: number]])",
returns = "(...)",
},
dofile = {
type = "function",
description = "打开指定名字的文件并将它的内容作为 Lua 的代码块来执行。如果不传参数，dofile 会执行标准输入（stdin）的内容。函数返回代码块的所有返回值。如果发生了错误，dofile 会将错误传给它的调用者（也就是说，dofile 不是在保护模式下运行的）。",
args = "([filename: string])",
returns = "(...)",
},
error = {
type = "function",
description = "终止最后一个保护的函数的调用并返回参数 message 作为错误消息。函数 error 从不会返回。通常错误消息的开头都会带有错误发生位置的信息。参数 level 指定如果获得出错的位置信息。当 level 为 1 时（默认值），出错位置就是调用 error 函数的地方。当 level 为 2 时，出错位置就是调用 error 函数的函数被调用的地方，以此类推（调用栈上一级级往上）。如果不想将出错的位置信息加到错误消息中，将 0 传给 level 就可以了。",
args = "(message: string [, level: number])",
returns = "()",
},
--[[
getfenv = {
type = "function",
description = "Returns the current environment in use by the function.\n\nf can be a Lua function or a number that specifies the function at that stack level: Level 1 is the function calling getfenv. If the given function is not a Lua function, or if f is 0, getfenv returns the global environment. The default for f is 1.\n\nFUNCTION DEPRECATED IN Lua 5.2.",
args = "([f: function|number])",
returns = "(table)",
},
--]]
getmetatable = {
type = "function",
description = "返回object的元表。如果对象没有元表就返回nil。如果对象的元表中有“__metatable”这个域则返回该域所关联的值。",
args = "(object: any)",
returns = "(table|nil)",
valuetype = "m",
},
ipairs = {
type = "function",
description = "如果t有__ipairs这个元方法，则将t作为参数去调用它并返回它的前三个返回值。否则的话，ipairs返回三个值：迭代函数，表t和0，所以语句：\nfor i, v in ipairs(t) do body end\n会从表t中的第一对键值对(1,t[1])开始迭代，一直到出现第一个不连续的整型键时结束。",
args = "(t: table)",
returns = "(function, table, number)",
},
load = {
type = "function",
description = "加载一个代码块。\n如果ld是一个字符串，则代码块就是这个字符串。如果ld是一个函数，load会不断地调用它来获得代码块的片断。每次调用ld都必须返回一个和之前结果连接起来的字符串。如果返回空字符串，nil或没有返回都表示已到达代码块的尾部。\n如果没有出现语法错误，那么load会将代码块作为一个函数返回，否则返回nil及错误消息。\n如果返回的结果函数有upvalues，那么它的第一个upvalue会被设为参数env（如果有此参数）的值或全局环境的值。（当你加载主代码块的时候，结果函数一定且只有一个upvalue，那就是_ENV。当你加载一个由函数（参考string.dump）生成的二进制代码块时，结果函数可以有任意的upvalues。）\n参数source用来标识代码源的来源，它会用于显示错误消息和调试信息。当参数的缺省时，如果ld是字符串，那缺省值就是ld，否则就是字符串“=(load)”。\n字符串参数mode限制了代码块的是文本形式还是二进制形式（也就是预编译的代码块）。它可能是字符串“b”（只能是二进制形式的代码块），“t”（只能是文本形式的代码块）或“bt”。默认值是“bt”。",
args = "(ld: string|function [, source: string [, mode: string [, env: table]]])",
returns = "(function|nil [, string])",
},
loadfile = {
type = "function",
description = "与load类似，它从filename文件加载一个代码块，当filename参数缺省时，以标准输入方式加载代码块。",
args = "([filename: string [, mode: string [, env: table]]])",
returns = "(function|nil [, string])",
},

--[[
loadstring = {
type = "function",
description = "Loads a chunk from the given string.\nIf there are no errors, returns the compiled chunk as a function; otherwise, returns nil plus the error message. The environment of the returned function is the global environment.\nTo load and run a given string, use the idiom\nassert(loadstring(s))()\nWhen absent, chunkname defaults to the given string.\nFUNCTION DEPRECATED IN Lua 5.2.",
args = "(string: string [, chunkname: string])",
returns = "(function|nil [, string])",
},
--]]
next = {
type = "function",
description = [[（当filename参数为缺省值时）遍历table时对元素的访问顺序是不定的，就算是数字的索引，也不是按数字顺序遍历的。（如果想按数字顺序遍历，可以使用数值形的for循环。）如果在遍历的过程中对不存在的域进行赋值，next的行为是未定义的。但是你可以在遍历的过程中修改已存在的那些域。特别地，你还可以删除已存在的域。]],
args = "(table: table [, index: any])",
returns = "(any [, any])",
},
pairs = {
type = "function",
description = [[如果t有__pairs这个元方法，则将t作为参数去调用它并返回它的前三个返回值。否则的话，pairs返回三个值：next函数，表t和nil，所以语句：for i, v in pairs(t) do body end会遍历表t中的所有键值对。参考next以了解遍历过程中对table进行修改的警告说明。]],
args = "(t: table)",
returns = "(function, table, nil)",
},
pcall = {
type = "function",
description = [[在保护模式下用指定的参数调用函数f。这意味着在f中发生的任何错误都不会被传递，相反，pcall捕获错误并返回一个状态码。它的第一个返回值是一个状态码（一个布尔值），如果为true则表示没有错误发生，调用成功。这种情况下，pcall还会返回f函数的所有返回值，这些返回值在状态码之后被返回。如果发生了错误，pcall返回false及错识消息。]],
args = "(f: function [, arg1: any, ...])",
returns = "(boolean, ...)",
},
print = {
type = "function",
description = [[收任意数量的参数并使用函数tostring将每一个参数转为字符串来输出到标准输出（stdout）。print并不打算做格式化输出，它只是一种快速显示一个值的方法，比如在调试Lua代码的时候。如果想完全地控制输出，请使用string.format和io.write。]],
args = "(...)",
returns = "()",
},
rawequal = {
type = "function",
description = "在不触发任何元方法的情况下比较v1和v2是否相等。返回一个布尔值。",
args = "(v1: any, v2: any)",
returns = "(boolean)",
},
rawget = {
type = "function",
description = "在不触发任何元方法的情况下获得table[index]的值。参数table必须是一个表，参数index可以是任何值。",
args = "(table: table, index: any)",
returns = "(any)",
},
rawlen = {
type = "function",
description = "在不触发任何元方法的情况下获得对象v的长度，v必须是个表或字符串。返回一个整型数字。",
args = "(v: table|string)",
returns = "(number)",
},
rawset = {
type = "function",
description = "在不触发任何元方法的情况下设置table[index]的值。参数table必须是一个表，参数index不能为nil和NaN，参数value可以是任意的Lua值。",
args = "(table: table, index: any, value: any)",
returns = "(table)",
},
select = {
type = "function",
description = "如果index是个正数，那么函数从第index个不定参数开始返回，如果index是个负数，则函数从倒数第index个（-1表示最后一个参数）不定参数开始返回。否则，index一定得是字符串“#”，这时select返回不定参数的个数。",
args = "(index: number|string, ...)",
returns = "(...)",
},
setfenv = {
type = "function",
description = "Sets the environment to be used by the given function.\nf can be a Lua function or a number that specifies the function at that stack level: Level 1 is the function calling setfenv. setfenv returns the given function.\nAs a special case, when f is 0 setfenv changes the environment of the running thread. In this case, setfenv returns no values.\nFUNCTION DEPRECATED IN Lua 5.2.",
args = "(f: function|number, table: table)",
returns = "([function])",
},
setmetatable = {
type = "function",
description = "设置指定table的元表。（你不能在Lua中修改其它数据类型的元表，只有在C中才可以。）如果参数metatable为nil则表示删除指定table的元表。如果之前的元表中有“__metatable”这个域，调用setmetatable会报错。\n函数返回table。",
args = "(table: table, metatable: table|nil)",
returns = "(table)",
valuetype = "m",
},
tonumber = {
type = "function",
description = "如果没有参数base，tonumber尝试将参数e转为一个数字。如果参数e是一个数字或一个可转为数字的字符串，那么tonumber返回这个数字，否则返回nil。\n当填了base（基数，如十进制的10，二进制的2）这个参数时，字符串参数e应根据这个基数来解释为一个整数。基数可以为2至36之间的任意整型，包括2和36。当base大于10时，字母“A”（不管大小写）表示10，“B”表示11，依此类推，“Z”表示35。如果字符串e中有不符合基数的字符，函数返回nil。",
args = "(e: any [, base: number])",
returns = "(number|nil)",
},
tostring = {
type = "function",
description = "接受任意类型的值并将它转为一个合理的字符串。（想要完全地控制数字的转换，使用string.format。）\n如果v的元表中有“__tostring”这个域，那么tostring会以v作为参数调用对应值并将调用的返回值作为tostring的返回值。",
args = "(v: any)",
returns = "(string)",
valuetype = "string",
},
type = {
type = "function",
description = "返回唯一参数v的类型名。可能的返回值有：“nil”（是一个字符串，不是值nil），“number”，“string”，“boolean”，“table”，“function”，“thread”和“userdata”。",
args = "(v: any)",
returns = "(string)",
},

--unpack = {
--type = "function",
--description = "Returns the elements from the given table.\nThis function is equivalent to\nreturn list[i], list[i+1], ···, list[j]\nexcept that the above code can be written only for a fixed number of elements. By default, i is 1 and j is the length of the list, as defined by the length operator.\nFUNCTION DEPRECATED IN Lua 5.2.",
--args = "(list: table [, i: number [, j: number]])",
--returns = "(...)",
--},

xpcall = {
type = "function",
description = "除了需要设置一个新的消息处理句柄msgh外，此函数和pcall一样。",
args = "(f: function, msgh: function [, arg1: any, ...])",
returns = "(boolean, ...)",
},

-- Coroutine library
coroutine = {
type = "lib",
description = "与协程相关的一些操作，它们作为基础库的一个子库封装在coroutine这个table中。",
childs = {
create = {
type = "function",
description = "用函数体f来创建一个新的协程。f必须是一个Lua函数。返回这个新的协程，它是一个类型为“thread”的对象。",
args = "(f: function)",
returns = "(thread)",
},
resume = {
type = "function",
description = [[开始或继续协程 co 的执行。当你第一次 resume 某个协程时，它就开始执行它的协程函数体。值 val1，……作为参数传给函数体。如果当前协程已经 yield 了，那么 resume 会使协程恢复执行，传递给 resume 的 val1，……会作为 yield 函数的返回结果。\n如果执行协程的时候没有发生任何错误，那么 resume 会返回 true 和 yield 函数的参数（如果协程 yield 了）或函数体的返回值（如果协程执行完毕）。如果协程发生了错误，resume返回 false 和错误消息。]],
args = "(co: thread [, val1: any, ...])",
returns = "(boolean, ...)",
},
running = {
type = "function",
description = [[返回当前运行的协程及一个布尔值，如果布尔值为 true 则表示当前运行的协程为主协程。]],
args = "()",
returns = "(thread, boolean)",
},
status = {
type = "function",
description = [[返回协程 co 的状态。 “running”表示协程正在执行（也就是说调用 status 的正是该协程）；“suspended”表示因调用了 yield 而暂停或还没开始；“normal”表示协程是激活的但并没有运行（也就是说，它 resume 了另一个协程）；“dead”表示协程已经执行完毕它的函数体或者因为某个错误而停止了。]],
returns = "(string)",
},
wrap = {
type = "function",
description = [[用函数体 f 来创建一个新的协程。f 必须是一个 Lua 函数。返回一个封装函数，每次调用该封装函数时都会 resume 协程。传递给封装函数的所有参数都将作为 resume 函数的额外参数。除了没有第一个布尔值的返回值，封装函数的其它返回值和 resume 一样。如果协程发生了错误，那么错误将会被传递（propagate）。]],
args = "(f: function)",
returns = "(function)",
},
yield = {
type = "function",
description = [[暂停当前协程的执行。传递给 yield 的所有参数都会作为 resume 的额外返回结果。]],
args = "(...)",
returns = "()",
},
},
},

-- Module/Package library
require = {
type = "function",
description = [[加载指定的模块。首先函数会在package.loaded这个表中查看是否已经加载了modname
这个模块。如果是，那么 require 会返回保存在 package.loaded[modname]的值。否则它将尝
试去查找一个加载该模块的加载器。
require 是由 package.searchers 引导来查找加载器的。修改 package.searchers 可以修改
require 查找模块的方式。下面的解释是基于默认配置的 package.searchers。
require 首先查询 package.preload[modname]是否有值，是则该值（应该是个函数）为加
载器，否则 require 根据保存在 package.path 的路径去查找 Lua 加载器。如果找不到，那就
根据保存在 package.cpath 的路径去查找，如果还是找不到，那么会尝试使用一个“集成”
（all-in-one）的加载器（参考 package.searchers）。
一旦找到了加载器，require 会以两个参数去调用它，这两个参数为模块名及一个用来
表示如何找到加载器的额外参数。（如果加载器来自某个文件，那额外参数就是该文件名）
如果加载器返回一个非空的值，require 将该返回值赋值给 package.loaded[modname]，否则
将 true 赋 值 给 package.loaded[modname] 。 不 管 哪 种 情 况 ， require 都 会 返 回
package.loaded[modname]的值。
如果在加载或执行模块时发生了错误，或者无法找到任何该模块的加载器，require 会
唤起一个错误。]],
args = "(modname: string)",
returns = "(any)",
},
package = {
type = "lib",
description =[[包库提供了一些基本的工具用来在 Lua 中加载模块。库中的 require 函数在全局环境中，其它的函数都封装在 package 这个 table 中。]],
childs = {
config = {
type = "value",
description = [[一个描述编译时包相关配置的字符串。此字符串是用行来分割的：
第一行配置目录分割符。Windows 系统下的默认值为“\”，其它系统的默认值为“/”。
第二行配置路径字符串中模板的分割符。默认值为“;”。
第三行配置模板中的替换符。默认值为“?”。
第四行是一个替换符，在 Windows 的路径中，它会被可执行目录（executable'sdirectory）所替换。默认为“!”。
第五行是一个标记符。在构建 lua_open_函数名时，该标记符前面的字符都会被忽略。默认值为“-”。]],
},
cpath = {
type = "value",
description = [[require 查找 C 加载器的路径。
Lua 初始化 C 路径 package.cpath 的方式和初始化 Lua 路径 package.path 的方式是一样的，都是使用环境变量 LUA_CPATH_5_2 或环境变量 LUA_CPATH 或 luaconf.h 中定义的默
认路径。]],
},
loaded = {
type = "value",
description = [[require 用来判断某个模块是否已经加载过的一个 table。当你加载一个名为 modname的 模 块 时 且 package.loaded[modname] 不 为 假 ， require 仅 简 单 地 返 回 保 存 在package.loaded[modname]的值。\n
该值仅仅是一个引用，对该值进行赋值并不会改变 require 使用的那个表。]],
},
loadlib = {
type = "function",
description = [[动态加载 libname 这个 C 库。
如果 funcname 是“*”，则只链接该库，使其它动态链接的库可以使用该库导出的符号。
否则它在库中查找名为 funcname 的函数并返回这个函数。因此 funcname 这个函数必须遵守
lua_CFunction 的原型（参考 lua_CFunction）。
这是一个底层函数。它完全绕开了包和模块系统。和 require 不一样，它不会搜索路径，
也不会自动做一些扩展操作。libname 必须是 C 库的完整路径，包括路径与扩展名。funcname
必须是 C 库导出的函数名（这个由所使用的编译器与链接器决定）。
此函数并不被标准 C 所支持。它只在一些平台（Windows，Linux，Mac OS X，Solaris，
BSD 及其它支持 dlfcn 标准的 unix 平台）上有效果。]],
args = "(libname: string, funcname: string)",
returns = "([function])",
},
path = {
type = "value",
description = [[require 查找 Lua 加载器的路径。\n
在程序开始的时候，Lua 使用环境变量 LUA_PATH_5_2 或环境变量 LUA_PATH 或luaconf.h 中定义的默认路径来初始化这个变量（如果前面两个环境变量没定义的话）。
环境变量中的任何“;;”字符串都会被默认路径替换。]],
},
preload = {
type = "value",
description = [[一个保存指定模块加载器的 table（类似于 require）。
该值仅仅是一个引用，对该值进行赋值并不会改变 require 使用的那个表。]],
},
searchers = {
type = "value",
description = [[一个给 require 控制如何加载模块的 table。
表中的每一个元素都是一个查找函数。当查找一个模块时，require 会按表索引的升序来调用这些查找函数，模块名（传给 require 的参数）是这些函数的唯一参数。函数会返回另一个函数（模块加载器）及一个会传给加载器的额外参数，函数也有可能返回一个解释为何找不到模块的字符串（如果无法解释则返回 nil）。\n
Lua 会用四个函数来初始化这个 table。\n
第一个查找函数只是简单地在 package.preload 中查找加载器。
第二个查找函数用保存在 package.path 中的路径去查找一个加载 Lua 库的加载器。查找方式在 package.searchpath 中说明。
第三个查找函数用保存在 package.cpath中的路径去查找一个加载C库的加载器。同样，查找方式在 package.searchpath 中说明。举个例子，如果 C 路径是下面的字符串："./?.so;./?.dll;/usr/local/?/init.so"对模块 foo 的查找会按顺序尝试打开这些文件：./foo.so，./foo.dll 和/usr/local/foo/init.so。一旦找到一个 C 库，搜索函数首先会用动态链接工具将其与应用程序链接，然后它尝试在库中找到一个作为加载器的 C 函数。C 函数的名字为“lua_open_”与模块名组成的字符串，如果模块名有点号的话，所有的点号都会被替换为下划线。此外，如果模块名有连号（“-”），那么连号及连号之前的字符都会被移除。比如某个模块的名字为 a.v1-b.c，那么对应的函数名应该为 luaopen_b_c。\n
第四个查找函数尝试使用一个“集成”（all-in-one）的加载器。它使用模块名的根名字在 C 路径中查找库。比如 require(“a.b.c”)时，它会先查找名为“a”的 C 库，如果找到了就查找库中有没有对应的子模块的加载器函数，在我们这个例子中，加载器函数名为lua_open_a_b_c。利用这个功能，我们可以将多个 C 的子模块打包进一个库文件，每个子模块只需定义自己的加载器函数就好。\n
除了第一个查找函数没有返回值外，其它的查找函数都会返回一个文件名（和package.searchpath 返回的一样）以指示它在哪找到模块的。
]],
searchpath = {
type = "function",
description = [[在指定路径中查找指定的模块名字。\n
路径是指一个包含多个由分号隔开的模板的字符串。对于每一个模板，函数会将其中的每一个问号（如果有的话）替换为参数 name，而参数 name 中的每一个 sep（默认是一个点）字符串也会被 rep（默认是操作系统的目录分割符）所替换。最后，函数尝试使用根据这个模板生成的文件名来打开这个文件。\n
举个例子，如果 path 是以下字符串："./?.lua;./?.lc;/usr/local/?/init.lua"查 找 模 块 foo.a 时 会 按 顺 序 尝 试 打 开 这 些 文 件 ： ./foo/a.lua ， ./foo/a.lc 和/usr/local/foo/a/init.lua。
函数返回第一个可以用读模式打开的结果文件名（在关闭文件后），或者在查找都不成功时返回 nil 及一个附加的错误消息。（错误消息会列出所有尝试去打开的文件名。）
]],
args = "(name: string, path: string [, sep: string [, rep: string]])",
returns = "(string|nil [, string])",
},

--[[]
seeall = {
type = "function",
description = "Sets a metatable for module with its __index field referring to the global environment, so that this module inherits values from the global environment.\nTo be used as an option to function module.\nFUNCTION DEPRECATED IN Lua 5.2.",
args = "(module: table)",
returns = "()",
},
--]]
},
},
},

-- String library
string = {
type = "lib",
description = [[此库提供了字符串相关操作的函数，比如查找和截取子串，模式匹配。索引 Lua 中的字
符串时，第一个字符的位置是 1（不像 C 那样是 0）。索引可以是负数，表示从字符串后面
往前的位置。因此，最后一个字符的位置为-1，其它的以此类推。
字符串库中的所有函数都封装在 string 这个 table 中。另外，每个字符串对象都有一个
元表，元表中的__index 域指向 string 这个 table。因此，你可以用面向对象的方式来使用字
符串库中的函数。比如 string.byte(s,i)也可以写成 s:byte(i)。
字符串库假设字符都是一字节编码的。]],
childs = {
byte = {
type = "function",
description = [[返回字符 s[i]，s[i+1]，……，s[j]的内码。i 的默认值为 1，j 的默认值为 i。这些索引的
规则和函数 string.sub 的是一样的。
字符的内码并不需要支持不同平台之间的移植。]],
args = "(s: string [, i: number [, j: number]])",
returns = "(number [, ...])",
},
char = {
type = "function",
description = [[接受 0 或多个非负整数。返回一个长度为参数个数的字符串，字符串中每个字符的内码
等于对应位置的参数值。
字符的内码并不需要支持不同平台之间的移植。]],
args = "(...)",
returns = "(string)",
valuetype = "string",
},
dump = {
type = "function",
description = [[返回一个字符串，该字符串是给定函数的二进制表示，因此将此字符串传给 load 函数
会返回该函数的副本（但函数的 upvalue 是新的）。]],
args = "(function: function)",
returns = "(string)",
valuetype = "string",
},
find = {
type = "function",
description = [[在字符串 s 中查找第一个与模式 pattern 相匹配的字符串。如果匹配成功则返回匹配字
符串在字符串 s 的开始位置与结尾位置，否则返回 nil。第三个参数是一个可选的数字参数
init，它指定从字符串 s 的哪个位置开始查找，它的默认值为 1，可以为负数。第四个参数
plain 也是个可选的参数，如果为 true 则关闭模式匹配，此时函数是一个“查找子串”的操
作，pattern 中没有字符会被看作为魔法字符。如果给定了 plain 参数，那么 init 也必须给定。
如果模式中有捕获，那么在匹配成功时，捕获的值会在返回的两个索引之后被返回。]],
args = "(s: string, pattern: string [, init: number [, plain: boolean]])",
returns = "(number|nil [, number [, ...]])",
},
format = {
type = "function",
description = [[根据第一个参数（必须是个字符串）指定的格式，将可变数量的参数格式化为一个字符
串并返回。格式化字符串遵守与标准 C 函数 sprintf 一样的规则。唯一的区别是不支持*，h，
L，l，n 和 p 这些选项/修改符，另外增加了一个新的选项 q。选项 q 格式化双引号之间的字
符串，在必要的时候使用转义符以保证 Lua 解释器可以安全地读回该字符串。举个例子，下
面的调用：
string.format('%q', 'a string with "quotes" and \n new line')
会返回以下字符串：
"a string with \"quotes\" and \new line"
选项 A 和 a（当可用时），E，e，f，G 和 g 期望参数是一个数字。选项 c，d，i，o，u，
X 和 x 同样期望参数是一个字符，但数字的范围由 C 的实现所限制。选项 o，u，X 和 x，
对应的数字可以为负数。选项 q 期望参数是一个字符串。选项 s 期望参数是一个不包含嵌入
式 0 的字符串。如果选项 s 对应的参数不是一个字符串，那么它的转换规则与 tostring 的一
样。]],
args = "(formatstring, ...)",
returns = "(string)",
valuetype = "string",
},
gmatch = {
type = "function",
description = [[返回一个迭代函数，每次调用迭代函数的时候都会返回接下来根据模式 pattern 在字符
串 s 中捕获的所有内容。如果 pattern 中没有指定捕获，则返回匹配的整个字符串。
作为一个例子，下面的循环会迭代字符串 s 中的所有单词，每行打印一个：
[=[
s = "hello world from Lua"
for w in string.gmatch(s, "%a+") do
	print(w)
end
]=]
下一个例子将在给定的字符串中收集所有的键值对 key=value，并将它们放入一个 table：
[=[
t = {}
s = "from=world, to=Lua"
for k, v in string.gmatch(s, "(%w+)=(%w+)") do
	t[k] = v
end
]=]
对于此函数，补字符“^”无法作为模式的开始符，因为这会阻止迭代的执行。]],
args = "(s: string, pattern: string)",
returns = "(function)",
},
pack = {
type = "function",
description = "Returns a binary string containing the values v1, v2, etc. packed (that is, serialized in binary form) according to the format string fmt.\nFUNCTION ADDED IN Lua 5.3.",
args = "(fmt: string, v1, v2, ...)",
returns = "(string)",
valuetype = "string",
},
unpack = {
type = "function",
description = "Returns the values packed in string s (see string.pack) according to the format string fmt. An optional pos marks where to start reading in s (default is 1). After the read values, this function also returns the index of the first unread byte in s.\nFUNCTION ADDED IN Lua 5.3.",
args = "(fmt: string, s: string [, pos: number])",
returns = "(values)",
},
packsize = {
type = "function",
description = "Returns the size of a string resulting from string.pack with the given format. The format string cannot have the variable-length options 's' or 'z'.\nFUNCTION ADDED IN Lua 5.3.",
args = "(fmt: string)",
returns = "(number)",
},
gsub = {
type = "function",
description = [[
返回字符串 s 的拷贝，其中 s 中出现的所有（或者前 n 个，如果给定了参数 n 的话）pattern
都将被 repl（或以是字符串，table 或函数）所指定的字符串所替换。gsub 还会返回匹配成
功的次数作为它的第二个返回值。gsub 这个名字来源于 Global SUBstitution。
如果 repl 是个字符串，那么它的值会被用于替换。字符%是一种转换符：repl 中%d（d
在 1 至 9 之间）表示捕获的第 d 个子串。%0 表示完整的匹配字符串。%%表示字符%。
如果 repl 是一个 table，那么每次成功匹配的时候都会用第一个捕获的值作为键去查询
repl 中的值，然后替换 pattern。
如果 repl 是一个函数，那么每次成功匹配的时候都会按顺序将捕获的所有子串传递给这
个函数来调用它。
如果 pattern 中没有指定捕获，那么整个 pattern 将作为一个捕获。
如果查询 table 得到的值或函数返回的值是一个字符串或数字，那么该值就会用作替换
字符串，否则如果是 false 或 nil 则不作替换。
]],
args = "(s: string, pattern: string, repl: string|table|function [, n: number])",
returns = "(string, number)",
valuetype = "string",
},
len = {
type = "function",
description = [[接受一个字符串作为参数并返回该字符串的长度。空字符串””的长度为 0。嵌入式 0 也
会被计算，因此”a\000bc\000”的长度为 5（注：这里\000 被当作为一个嵌入式 0，与\0 或
\00 是一样的，但和\0000 却不一样）。]],
args = "(s: string)",
returns = "(number)",
},
lower = {
type = "function",
description = [[接受一个字符串作为参数并返回该字符串的一个拷贝，该拷贝中的所有大写字符都会转
为小写字符，其它字符则保持不变。大写字符的定义与本地设置有关。]],
args = "(s: string)",
returns = "(string)",
valuetype = "string",
},
match = {
type = "function",
description =[[在字符串 s 中查找第一个与 pattern 匹配的字符串。如果匹配成功则返回捕获的所有字
符串，否则返回 nil。第三个参数 init 是一个可选参数，它指定从字符串 s 的哪个位置开始
查找，它的默认值为 1，可以为负数。]],
args = "(s: string, pattern: string [, init: number])",
returns = "(string|nil [,...])",
valuetype = "string",
},
rep = {
type = "function",
description = [[返回一个由 n 个 s 连接起来的字符串，s 与 s 之间由字符串 sep 隔开。sep 的默认值为空
字符串（也就是没有分割符）。]],
args = "(s: string, n: number [, sep: string])",
returns = "(string)",
valuetype = "string",
},
reverse = {
type = "function",
description = [[返回 s 的反转字符串]],
args = "(s: string)",
returns = "(string)",
valuetype = "string",
},
sub = {
type = "function",
description = [[
返回字符串 s 中位置 i 与位置 j 之间的子串。i 和 j 可以为负数。j 的缺省值可以认为是-1 （和字符串的长度一致）。string.sub(s,1,j)返回字符串 s 的长度为 j 的前缀字符串。string.sub(s,-i)返回字符串 s 的长度为 i 的后缀字符串。\n
如果负的索引 i 转换过后小于 1，那么它会纠正为 1；如果 j 大于字符串的长度，那么它会纠正为字符串的长度。如果转换及纠正过后的 i 大于 j，那么函数返回空字符串。
]],
args = "(s: string, i: number [, j: number])",
returns = "(string)",
valuetype = "string",
},
upper = {
type = "function",
description = [[接受一个字符串作为参数并返回该字符串的一个拷贝，该拷贝中的所有小写字符都会转为大写字符，其它字符则保持不变。小写字符的定义与本地设置有关。]],
args = "(s: string)",
returns = "(string)",
valuetype = "string",
},
	split = {
		type = "function",
		description = "分割字符串",
		args = "(str: string, sep: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: table)",
	},
	rtrim = {
		type = "function",
		description = "删除字符串尾部的空白字符(空白字符包括 \\r、\\n、\\t)",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	ltrim = {
		type = "function",
		description = "删除字符串首部的空白字符(空白字符包括 \\r、\\n、\\t)",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	trim = {
		type = "function",
		description = "删除字符串首尾的空白字符(空白字符包括 \\r、\\n、\\t)",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	atrim = {
		type = "function",
		description = "删除字符串所有的空白字符(空白字符包括 \\r、\\n、\\t)",
		args = "(str: string)\n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	tohex = {
		type = "function",
		description = "数据串转换成 16 进制编码",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	fromhex = {
		type = "function",
		description = " 16 进制编码转换成数据串",
		args = "(hex: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	md5 = {
		type = "function",
		description = "计算数据串的 md5 校验值",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	sha1 = {
		type = "function",
		description = "计算数据串的 sha1 校验值",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	aes128_encrypt = {
		type = "function",
		description = "使用 aes 算法 ecb 模式加密数据串",
		args = "(str: string, key: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	aes128_decrypt = {
		type = "function",
		description = "使用 aes 算法 ecb 模式解密数据串",
		args = "(str: string, key: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	base64_encode = {
		type = "function",
		description = "数据串编码成 base64 串",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
	base64_decode = {
		type = "function",
		description = " base64 串解码成数据串",
		args = "(str: string) \n此函数需引用触动扩展库 sz ，参考手册 [字符串处理模块]",
		returns = "(return: string)",
	},
},
},

-- Table library
table = {
type = "lib",
description = [[此库提供了操作 table 的相关函数。所有的函数都封装在 table 这个表中。\n
			记住，当一个操作需要用到 table 的长度时，该 table 必须是一个数列（sequence）或有__len 元方法（参考 3.4.6）。如果 table 作为函数的参数，那么非数值型键都会被库中的函数忽略掉。\n
			基于性能的原因，函数对 table 的访问（获取/设置）都是原始的操作。]],
childs = {
concat = {
type = "function",
description = [[返回字符串 list[i]..sep..list[i+1] ··· sep..list[j]，其中 list 的全部元素为字符串或数字。sep的默认值为空字符串。i 的默认值为 1，j 的默认值为#list。如果 i 大于 j 则返回空字符串。]],
args = "(list: table [, sep: string [, i: number [, j: number]]])",
returns = "(string)",
valuetype = "string",
},
insert = {
type = "function",
description = [[将元素 value 插入到 list 的 pos 位置，元素 list[pos], list[pos+1], ···, list[#list]都向上移一个位置。pos 的默认值为#list+1，因此 table.insert(t, x)将 x 插入到 t 的最后面。]],
args = "(list: table, [pos: number,] value: any)",
returns = "()",
},
pack = {
type = "function",
description = [[返回一个新的 table，其中 table[1]保存第一个参数，table[2]保存第二个参数，以此类推。同时 table 中还有一个键 n，它的值是函数参数的个数。注意，返回的 table 并不是一个数列。]],
args = "(...)",
returns = "(table)",
},
move = {
type = "function",
description = "Moves elements from table a1 to table a2. This function performs the equivalent to the following multiple assignment: a2[t],··· = a1[f],···,a1[e]. The default for a2 is a1. The destination range can overlap with the source range. Index f must be positive.\nFUNCTION ADDED IN Lua 5.3.",
args = "(a1: table, f, e, t [,a2: table])",
returns = "()",
},
remove = {
type = "function",
description = [[
			删除 list 中位置为 pos 的元素并返回该元素。当 pos 是一个 1 至#list 之间的整数时，元素 list[pos+1], list[pos+2], ···, list[#list]都向下移一个位置并删除掉元素 list[#list]。当#list 为 0时，pos 可以为 0，pos 也可以为#list+1，这种情况下，函数删除元素 list[pos].\n
			pos 的默认值为#list，因此 table.remove(t)删除 list 的最后一个元素.
			]],
args = "(list: table [, pos: number])",
returns = "(any)",
},
sort = {
type = "function",
description =[[
				将 list 中的元素排序。如果给定了参数 comp，那么它必须是一个函数，该函数接受两个 list 中的元素，如果第一个元素在排序过后位置在第二个元素的后面则返回 true（排序后not comp(list[i+1],list[i])为 true）。如果 comp 没给定，那么就会使用 Lua 的标准比较符“<”来代替。\n
				排序算法是不稳定的，也就是说，被认为是相同的元素在经过排序后，在 list 中的位置
				有可能会发生改变。
			]],
args = "(list: table [, comp: function])",
returns = "()",
},
unpack = {
type = "function",
description = [[
				返回 list 中的元素。此函数等价于下面的语句：\n
					return list[i], list[i+1], ···, list[j]
				i 的默认值为 1，j 的默认值为#list。
			]],
args = "(list: table [, i: number [, j: number]])",
returns = "(...)",
},
},
},

-- Math library
math = {
type = "lib",
description = "此库是标准 C 数学库的接口。库的所有函数都封装在 math 这个 table 中。",
childs = {
abs = {
type = "function",
description = "返回 x 的绝对值。",
args = "(x: number)",
returns = "(number)",
},
acos = {
type = "function",
description = "返回 x（单位为弧度）的反余弦值。",
args = "(x: number)",
returns = "(number)",
},
asin = {
type = "function",
description = "返回 x（单位为弧度）的反正弦值。",
args = "(x: number)",
returns = "(number)",
},
atan = {
type = "function",
description = "返回 x（单位为弧度）的反正切值",
args = "(x: number)",
returns = "(number)",
},
atan2 = {
type = "function",
description = "利用两个参数的正负符号在对应象限中找到 y/x（单位都为弧度）的反正切值。（当 x为 0 时也可以正确处理。）",
args = "(y: number, x: number)",
returns = "(number)",
},
ceil = {
type = "function",
description = "返回大于或等于 x 的最小整数。",
args = "(x: number)",
returns = "(number)",
},
cos = {
type = "function",
description = "返回 x（单位为弧度）的余弦值。",
args = "(x: number)",
returns = "(number)",
},
cosh = {
type = "function",
description = "返回 x 的双曲线余弦值。",
args = "(x: number)",
returns = "(number)",
},
deg = {
type = "function",
description = "返回弧度 x 对应的角度。",
args = "(x: number)",
returns = "(number)",
},
exp = {
type = "function",
description = "返回 e 的 x 次方。",
args = "(x: number)",
returns = "(number)",
},
floor = {
type = "function",
description = "返回小于或等于 x 的最大整数。",
args = "(x: number)",
returns = "(number)",
},
fmod = {
type = "function",
description = "返回 x 除以 y 的余数。",
args = "(x: number, y: number)",
returns = "(number)",
},
frexp = {
type = "function",
description = "返回两个值 m 与 e，这两个值使 x = m2^e 成立, e 为整数，m 的绝对值在[0.5,1)之间（当 x 为 0 时，m 为 0）。.",
args = "(x: number)",
returns = "(number, number)",
},
huge = {
type = "value",
description = "一个大于或等于任意数字的值，即最大值。",
},
ldexp = {
type = "function",
description = "返回 m2^e 的值(e应为整数).",
args = "(m: number, e: number)",
returns = "(number)",
},
log = {
type = "function",
description = [[返回以 base 为底数的 x 的对数。base 的默认值为 e（此时函数返回 x 的自然对数）。]],
args = "(x: number [, base: number])",
returns = "(number)",
},
log10 = {
type = "function",
description = "Returns the base-10 logarithm of x.\nFUNCTION DEPRECATED IN Lua 5.2.",
args = "(x: number)",
returns = "(number)",
},
max = {
type = "function",
description = [[返回参数列表中最大值。]],
args = "(x: number, ...)",
returns = "(number)",
},
min = {
type = "function",
description = "返回参数列表中最小值。",
args = "(x: number, ...)",
returns = "(number)",
},
modf = {
type = "function",
description = "返回 x 的整数部分与小数部分。",
args = "(x: number)",
returns = "(number, number)",
},
pi = {
type = "value",
description = "The value of pi.",
},
pow = {
type = "function",
description = [[
			返回 x 的 y 次方。\n
			（你也可以用表达式 x^y 来计算该值。）
			]],
args = "(x: number, y: number)",
returns = "(number)",
},
rad = {
type = "function",
description = "返回 x（单位为角度）对应的弧度。",
args = "(x: number)",
returns = "(number)",
},
random = {
type = "function",
description = [[此函数是标准 C 提供的简单伪随机函数 rand 的一个接口。 （无法保证该函数的稳定值。）
不传递任何参数去调用此函数时，返回一个范围为(0,1)的实数。当只传递了参数 m 时，
math.random 返回范围为(1,m)的整数。当 m，n 参数都传递时，math.random 返回范围为(m,n) 的整数。]],
args = "([m: number [, n: number]])",
returns = "(number)",
},
randomseed = {
type = "function",
description = "将 x 设为伪随机产生器的“种子”。相同的种子产生相同的数字序列。",
args = "(x: number)",
returns = "()",
},
sin = {
type = "function",
description = "返回 x（单位为弧度）的正弦值。",
args = "(x: number)",
returns = "(number)",
},
sinh = {
type = "function",
description = "返回 x 的双曲线正弦值。",
args = "(x: number)",
returns = "(number)",
},
sqrt = {
type = "function",
description = "返回 x 的开方值。（你也可以使用表达式 x^0.5 来计算该值。）",
args = "(x: number)",
returns = "(number)",
},
tan = {
type = "function",
description = "返回 x（单位为弧度）的正切值。",
args = "(x: number)",
returns = "(number)",
},
tanh = {
type = "function",
description = "返回 x 的双曲线正切值。",
args = "(x: number)",
returns = "(number)",
},
},
},

-- Bitwise library
bit32 = {
type = "lib",
description = [[此库提供了位相关的操作。库中所有函数都封装在 bit32 这个 table 中。
除非另有说明，此库的所有函数接受一个范围在(-2 51 ，+2 51 )的数字参数。每个参数都会
规格化为被 2 32 除的余数。因此最后值一定在[0，2 32 -1]这个区间。同样地，所有的结果也都
在[0，2 32 -1]这个区间。注意：bit32.bnot(0)的结果是 0xFFFFFFFF，并不等于-1。]],
childs = {
arshift = {
type = "function",
description = [[返回 x 右移 disp 位后的结果。disp 可以是任意可描述的整型。diap 为负数表示向左位移。
这种位移叫算术位移。左边新进的位为 x 的最高位，右边新进的位为 0。当 disp 的绝对值大于 31 时，结果一定为 0 或 0xFFFFFFFF（所有的位都移出去了）。]],
args = "(x: number, disp: number)",
returns = "(number)",
},
band = {
type = "function",
description = "将所有参数按位做与操作并返回最终的结果。",
args = "(...)",
returns = "(number)",
},
bnot = {
type = "function",
description = [[对 x 按位取反并返回最终的结果。对于任何一个 x，下面都是一个恒等式：\n
				assert(bit32.bnot(x) == (-1 - x) % 2^32)
			]],
args = "(x: number)",
returns = "(number)",
},
bor = {
type = "function",
description = "将所有参数按位做或操作并返回最终的结果。",
args = "(...)",
returns = "(number)",
},
btest = {
type = "function",
description = "将所有参数按位做与操作，如果最终的结果不为 0 则返回 true，否则返回 false。",
args = "(...)",
returns = "(boolean)",
},
bxor = {
type = "function",
description = "将所有参数按位做异或操作并返回最终的结果。",
args = "(...)",
returns = "(number)",
},
extract = {
type = "function",
description =[[以无符号数字的形式返回数字 n 的第 field 位至第 field + width - 1 位所表示的值。位的编号为 0（最小标记）至 31（最大标记）。可读取的位的编号必须在范围[0,31]内。
			width 的默认值为 1。]],
args = "(n: number, field: number [, width: number])",
returns = "(number)",
},
replace = {
type = "function",
description = [[将数字 n 的第 filed 位至第 field + width - 1 位的数据替换为数字 v 的二进制数据。field
和 width 的说明请参考 bit32.extract。]],
args = "(n: number, v: number, field: number [, width: number])",
returns = "(number)",
},
lrotate = {
type = "function",
description = [[返回 x 循环左位移（最高位会进入最低位）disp 位后的结果。disp 可以是任意可描述的整型。
			对于任意的位移，下面都是一个恒等式：
				assert(bit32.lrotate(x, disp) == bit32.lrotate(x, disp % 32))
			如果 disp 为负数则表示向右位移。]],
args = "(x: number, disp: number)",
returns = "(number)",
},
lshift = {
type = "function",
description = [[返回 x 左移 disp 位后的结果。disp 可以是任意可描述的整型。diap 为负数表示向右位移。不管向哪个方向移动，新进的位都为 0。当 disp 的绝对值大于 31 时，结果一定为 0（所有的位都移出去了）。
				当 disp 为正数时，下面是一个恒等式：
					assert(bit32.lshift(b, disp) == (b * 2^disp) % 2^32)
			]],
args = "(x: number, disp: number)",
returns = "(number)",
},
rrotate = {
type = "function",
description = [[
			返回 x 循环右位移（最低位会进入最高位）disp 位后的结果。disp 可以是任意可描述的整型。
			对于任意的位移，下面都是一个恒等式：
				assert(bit32.rrotate(x, disp) == bit32.rrotate(x, disp % 32)) 
			如果 disp 为负数则表示向左位移。
			]],
args = "(x: number, disp: number)",
returns = "(number)",
},
rshift = {
type = "function",
description = [[
			返回 x 右移 disp 位后的结果。disp 可以是任意可描述的整型。diap 为负数表示向左位移。不管向哪个方向移动，新进的位都为 0。当 disp 的绝对值大于 31 时，结果一定为 0（所有的位都移出去了）。
			当 disp 为正数时，下面是一个恒等式：
				assert(bit32.rshift(b, disp) == math.floor(b % 2^32 / 2^disp)) 
			这种位移叫做逻辑位移
			]],
args = "(x: number, disp: number)",
returns = "(number)",
},
},
},

-- I/O library
io = {
type = "lib",
description = 
[[
I/O 库为文件操作提供了两种不同的方式。第一种方式使用隐式文件描述符，也就是说
有些操作可以设置默认的输入文件和输出文件，所有的输入/输出操作都在这些默认文件上。
第二种方式使用明确的文件描述符。
当使用隐式文件描述符时，所有的操作都有 io 这个 table 提供。当使用明确的文件描述
符时，先使用 io.open 返回一个文件描述符，然后通过该文件描述符的元方法来操作文件。
io 这个 table 中也提供了三个预定义的文件描述符：io.stdin，io.stdout 和 io.stderr，它们
的含义和 C 的一样。I/O 库永远不会关闭这三个文件。
除非另有说明，所有的 I/O 函数在失败的时候都返回 nil（第二个返回值为错误消息，
第三个返回值是一个取决于系统的错误码），成功的时候都返回一个不同于 nil 的值。在非
Posix 的系统上，在发生错误时对错误消息和错误码的计算并不是线程安全的，因为它们依
赖于 C 的全局变量 errno。
]],
childs = {
stdin = { type = "value" },
stdout = { type = "value" },
stderr = { type = "value" },
close = {
type = "function",
description = "等同于 file:close()。如果不传 file 参数则关闭当前的默认输出文件。",
args = "([file: file])",
returns = "(boolean|nil [, string, number])",
},
flush = {
type = "function",
description = "等同于 io.output():flush()。",
args = "()",
returns = "()",
},
input = {
type = "function",
description = 
[[
当 file 是一个文件名时，它打开（以文本模式）file 这个文件并将它的句柄设为当前的
默认输入文件。当 file 是一个文件句柄时，它只是简单地将这个句柄设为当前的默认输入文
件。当不传递 file 参数时，函数返回当前的默认输入文件。
此函数在发生错误时会唤起一个错误而不是返回一个错误码。
]],
args = "([file: string|file])",
returns = "([file])",
valuetype = "f",
},
lines = {
type = "function",
description = 
[[
以只读模式打开给定文件名的文件并返回一个迭代函数，这个迭代函数的功能像基于该
打开文件调用 file:lines(...)。当迭代函数检测到文件尾时会返回 nil（译者看代码后发现是没
有返回值）（以结束循环）并自动关闭该文件。
io.lines()（没有参数）等同于 io.input():lines()。即迭代默认输入文件的每一行。这种情
况下，当到达文件尾时并不会关闭文件。
此函数在发生错误时会唤起一个错误而不是返回一个错误码。
]],
args = "([filename: string, ...])",
returns = "(function)",
},
open = {
type = "function",
description =
[[
此函数以参数 mode 指定的方式打开一个文件。它返回一个新的文件句柄。如果发生了
错误则返回 nil 及错误信息。
mode 可以为下面的任意字符串：
 "r":读模式（默认值）。
 "w":写模式。
 "a":追加模式。
 "r+":更新模式，文件之前的内容会被保留。
 "w+":更新模式，文件之前的内容会被删除。
 "a+":追加更新模式，文件之前的内容会被保留，只允许在文件的尾部写入数据。
mode 字符串的后面也可以加上“b”，在某些系统上需要用它来表示以二进制模式打开
文件。
]] ,
args = "(filename: string [, mode: string])",
returns = "(file|nil [, string])",
valuetype = "f",
},
output = {
type = "function",
description = [[说明请参考 io.input ，此函数是对默认输出文件的操作。]],
args = "([file: string|file])",
returns = "([file])",
valuetype = "f",
},
popen = {
type = "function",
description = [[
此函数是依赖于系统的，并不是所有平台都可用。
在另一个进程中启动程序 prog 并返回一个文件句柄，你可以使用这个句柄来读取来自
prog 的数据（如果模式为“r”）或向 prog 写数据（如果模式为“w”）。
]],
args = "(prog: string [, mode: string])",
returns = "(file|nil [, string])",
valuetype = "f",
},
read = {
type = "function",
description = "等同 io.input():read(...)。",
args = "(...)",
returns = "(...)",
},
tmpfile = {
type = "function",
description = "返回一个临时文件的句柄。该文件以更新模式打开，在程序结束的时候自动关闭。",
args = "()",
returns = "(file)",
valuetype = "f",
},
type = {
type = "function",
description = [[
检查 obj 是否是一个合法的文件句柄。如果 obj 是一个打开的文件句柄则返回字符串
“file”，如果 obj 是一个已关闭的文件句柄则返回“closed”，如果 obj 不是一个文件句柄则
返回 nil。
]],
args = "(obj: file)",
returns = "(string|nil)",
},
write = {
type = "function",
description = "等同于 io.output():write(...)。",
args = "(...)",
returns = "(file|nil [, string])",
},
},
},

f = {
type = "class",
description = "Pseudoclass for operations on file handles.",
childs = {
close = {
type = "method",
description = [[
关闭文件。注意：当文件的句柄被垃圾回收器回收时，文件会自动关闭，但它的发生时间是不可预知的。
当关闭由 io.popen 打开的文件时，file:close 的返回值与 os.execute 的一样。
]],
args = "(file: file)",
returns = "(boolean|nil [, string, number])",
},
flush = {
type = "method",
description = "将缓冲区的所有内容写入文件。",
args = "(file: file)",
returns = "(boolean|nil [, string])",
},
lines = {
type = "method",
description = 
[[
返回一个迭代函数，每次调用迭代函数时会根据给定的参数来读取文件的内容。当没有参数时全使用“*l”作默认值。下面的语句会从文件的当前位置开始遍历文件中的所有字符：
	for c in file:lines(1) do body end 
与 io.lines 不一样，当迭代结束时不会关闭文件。
此函数在发生错误时会唤起一个错误而不是返回一个错误码。
]],
args = "(file: file, ...)",
returns = "(function)",
},
read = {
type = "method",
description = 
[[
根据给定的格式参数来读取文件的数据。对于每种格式，函数返回它读取到的字符串（或
一个数字），如果无法按照给定的格式读取数据则返回 nil。当没有参数时，它的默认格式为
“*l”。
有效的格式如下：
 "*n":读一个数字。这是唯一一个返回一个数字的格式。
 "*a":从当前位置开始，读取文件剩下的所有数据。如果当前位置为文件尾则返回
空字符串。
 "*l":读取下一行的数据，会忽略行尾（回车和换行符）。如果已达文件尾则返回 nil。
这是函数默认使用的格式。
 "*L":读取下一行的数据，包括行尾。如果已达文件尾则返回 nil。
 数字:如果数字为 n，则从当前位置开始读取 n 个字节的数据，如果已达文件尾则返
回 nil。如果数字为 0 则不读任何数据并返回空字符串或 nil（如果已达文件尾）。
]],
args = "(file: file, ...)",
returns = "(...)",
},
seek = {
type = "method",
description = 
[[
以文件的开头作为计算基准，根据参数 whence（基于哪个位置）和 offset（偏移量）设
置和获取文件的读写位置，whence 的值及含义如下：
 "set":基于位置 0（文件的开头）。
 "cur":基于当前位置。
 "end":基于文件尾。
如果函数调用成功，seek 返回当前文件的读写位置（相对于文件开头），单位为字节。
否则 seek 返回 nil 及一个描述错误的字符串。
whence 的默认值为“cur”，offset 的默认值为 0。因此 file:seek()在不改变文件当前读写
位置的情况下返回它的读写位置。file:seek(“set”)将当前读写位置设为文件头并返回 0。\n
file:seek(“end”)将当前读写位置设为文件尾并返回文件的大小。
]],
args = "(file: file, [whence: string [, offset: number]])",
returns = "(number|nil [, string])",
},
setvbuf = {
type = "method",
description = [[
设置输出文件的缓冲模式。有三种可用的模式：\n
 "no":没有缓冲。任何输出都是即时写入文件的。\n
 "full":全缓冲。只有当缓冲区满了或调用 flush（参考 io.flush）的时候才将缓冲区
的内容写入文件。
 "line":行缓冲。只有当新的一行数据写入缓冲区或有来自别的文件（比如终端设备）
的输入时才将缓冲区的内容写入文件。
对于最后两种模式，参数 size 以字节为单位指定了缓冲区的大小。默认值是一个合
适的大小。
]],
args = "(file: file, mode: string [, size: number])",
returns = "(boolean|nil [, string])",
},
write = {
type = "method",
description = [[
将每个参数的值写入文件。参数必须是字符串或数字。
成功的话函数返回文件句柄，否则返回 nil 及一个描述错误的字符串。]],
args = "(file: file, ...)",
returns = "(file|nil [, string])",
},
},
},

m = {
type = "class",
description = "类的元方法",
childs = {
__add = {
type = "function",
description = [[add": + （加法操作）]],
args = "(op1, op2)",
returns = "(value)",
},
__sub = {
type = "function",
description = [["sub": - （减法操作）行为和加法操作类似。]],
args = "(op1, op2)",
returns = "(value)",
},
__mul = {
type = "function",
description = [["mul": * （乘法操作）行为和加法操作类似。]],
args = "(op1, op2)",
returns = "(value)",
},
__div = {
type = "function",
description = [["div": / （除法操作）行为和加法操作类似。]],
args = "(op1, op2)",
returns = "(value)",
},
__mod = {
type = "function",
description = [["mod": % （求余操作）行为和加法操作类似。它的原始操作是 o1 - floor(o1/o2)*o2。]],
args = "(op1, op2)",
returns = "(value)",
},
__pow = {
type = "function",
description = [["pow": ^ （求幂操作）行为和加法操作类似。 它的原始操作是 pow 函数（来自 C 的数学库）。]],
	args = "(op1, op2)",
	returns = "(value)",
	},
	__concat = {
	type = "function",
	description = [["concat": .. （连接操作符）]],
	args = "(op1, op2)",
	returns = "(value)",
	},
	__unm = {
	type = "function",
	description = [["unm": - （一元操作符-）]],
	args = "(op)",
	returns = "(value)",
	},
	__len = {
	type = "function",
	description = [["len": # （取长度操作符）]],
	args = "(op)",
	returns = "(value)",
	},
	__eq = {
	type = "function",
	description = 
	[["eq": == （关系运算符：等于） 函数 getequalhandler 模拟了 Lua 是怎么选择比较
	操作符的元方法的。只有当两个待比较的数值它们的类型相同，且类型为 table 或 full
	userdata，且__eq 元方法也相同时，getequalhandler 才返回__eq 的值作为比较操作符
	的元方法。]],
	args = "(op1, op2)",
	returns = "(boolean)",
	},
	__lt = {
	type = "function",
	description = [[lt": < （关系运算符：小于）]],
	args = "(op1, op2)",
	returns = "(boolean)",
	},
	__le = {
	type = "function",
	description = [["le": < =（关系运算符：小于等于）]],
	args = "(op1, op2)",
	returns = "(boolean)",
	},
	__index = {
	type = "function",
	description = 
	[["index":索引操作。当使用一个不存于 table 中的键去索引 table 中的内容时会尝
	试调用此元方法。（当索引操作作用于的对象不是一个 table 时，那么所有键都是不存
	在的，所以元方法一定会被尝试调用。）]],
	args = "(table, key)",
	returns = "(value)",
	},
	__newindex = {
	type = "function",
	description = 
	[["newindex": table 赋值操作 table[key] = value。使用一个不存在于 table 中的
	键来给 table 中的域赋值时会尝试调用此元方法。]],
	args = "(table, key, value)",
	returns = "(value)",
	},
	__call = {
	type = "function",
	description = [["call":当 Lua 调用一个值的时候被调用。]],
	args = "(func, ...)",
	returns = "(values)",
	},
	__tostring = {
	type = "function",
	description = "Control string representation. When the builtin 'tostring(table)' function is called, if the metatable for myTable has a __tostring property set to a function, that function is invoked (passing table to it) and the return value is used as the string representation.",
	args = "(op)",
	returns = "(value)",
	},
	__pairs = {
	type = "function",
	description = "This method is called when pairs() is called and returns the first three results from the call (Lua 5.2+).",
	args = "(table)",
	returns = "(iterator, table, key)",
	},
	__ipairs = {
	type = "function",
	description = "This method is called when ipairs() is called and returns the first three results from the call (Lua 5.2+).",
	args = "(table)",
	returns = "(iterator, table, index)",
	},
	__gc = {
	type = "function",
	description = "Finalizer method. When userdata/table is set to be garbage collected, if the metatable has a __gc field pointing to a function, that function is first invoked, passing the userdata to it. Starting from Lua 5.2 this method is also called for tables.",
	args = "(func, ...)",
	returns = "(values)",
	},
	__mode = {
	type = "value",
	description = "Value that controls 'weakness' of the table. If the __mode field is a string containing the character 'k', the keys in the table are weak. If __mode contains 'v', the values in the table are weak.",
	},
	__metatable = {
	type = "value",
	description = "Value to hide the metatable. This value is returned as the result of getmetatable() call.",
	},
	},
	},
	
	-- OS library
	os = {
	type = "lib",
	description = "操作系统库，此库通过 os 这个 table 实现。",
	childs = {
	clock = {
	type = "function",
	description = "返回程序占用 CPU 时间的近似值，单位为秒。",
	args = "()",
	returns = "(number)",
	},
	date = {
	type = "function",
	description = 
[[返回一个包含日期和时间信息的字符串或 table，格式由参数 format 指定。
如果传递了参数 time，则格式化 time 的时间（参考 os.time 以了解该值的说明）。否则，
函数格式化当前的时间。
如果 format 参数以“!”开始，那么格式化后的时间为协调世界时。在“!”这个可选字
符之后，如果格式字符串是“*t”，那么 date 函数返回一个 table，该 table 有下面这些域：
year（4 位数），month（1-12），day（1-31），hour（0-23），min（0-59），sec（0-61），wday
（星期几，1 为星期天），yday（一年当中第几天）以及 isdst（日光节省的标记，一个布尔
值）。如果无法获得日光节省的相关信息的话就没有最后一个域。
如果 format 不是“*t”，那么 date 会根据标准 C 函数 strftime 的规则返回一个日期字符
串。
当函数没有参数时，date 会根据主机系统及本地设置返回一个合理的日期与时间的字符
串（也就是预，os.date()等同于 os.date(“%c”)）。
在非 Posix 的系统上，此函数并不是线程安全的，因为它依赖于 gmtime 和 localtime 这
两个 C 函数。]],
args = "([format: string [, time: number]])",
	returns = "(string|table)",
	},
	difftime = {
	type = "function",
	description = [[返回时间 t1 至时间 t2 的秒数差。在 POSIX、Windows 及其它一些系统上，返回值就是t2-t1]],
	args = "(t2: number, t1: number)",
	returns = "(number)",
	},
	execute = {
	type = "function",
	description = 
	[[
	此函数等同于标准 C 函数 system。它将 command 参数的值传给操作系统的壳（比如Windows 的 DOS，linux 的 bash）。如果命令成功执行完毕，则函数的第一个返回值为 true，否则为 nil。在第一个返回值之后，函数还会返回一个字符串和一个数字，看下面说明：\n
 		"exit":命令正常结束。后面的数字表示命令的退出状态码。\n
 		"signal":命令被某个信号结束。后面的数字表示结束命令的信号。\n
		不传递参数时，os.execute 返回一个布尔值，如果为 true 表示系统的壳是可用的\n
	]],
	args = "([command: string])",
	returns = "(boolean|nil [, string, number])",
	},
	exit = {
	type = "function",
	description =[[调用标准C函数exit来结束主程序。如果code为true，返回的状态码为EXIT_SUCCESS。如果 code 为 false，返回的状态码为 EXIT_FAILURE。如果 code 是一个数字，则返回的状态码为该数字。参数 code 的默认值为 true。\n
				如果第二个可选参数 close 为 true，则在退出主程序前先关闭 Lua 状态机。]],
	args = "([code: boolean|number [, close: boolean]])",
	returns = "()",
	},
	getenv = {
	type = "function",
	description = "返回名为 varname 的进程环境变量，如果该变量没有定义则返回 nil。",
	args = "(varname: string)",
	returns = "(string|nil)",
	},
	remove = {
	type = "function",
	description = [[删除名为 filename 的文件（或者是 POSIX 系统上的空文件夹）。如果失败则返回 nil，错误描述和错误码。]],
	args = "(filename: string)",
	returns = "(boolean|nil [, string, number])",
	},
	rename = {
	type = "function",
	description = "将名为 oldname 的文件或文件夹改名为 newname。如果失败则返回 nil，错误描述和错误码。",
	args = "(oldname: string, newname: string)",
	returns = "(boolean|nil [, string, number])",
	},
	setlocale = {
	type = "function",
	description = 
	[[
	设置程序的本地化信息。参数locale是一个系统相关的字符串，用于指定地域，比如“chs”表示简体中文的地区。参数 category 是一个可选的字符串，用于指定需要改变哪些类别： “all”（全部）， “collate” （排序规则）， “ctype” （字符类别及转换）， “monetary” （货币格式）， “numeric”（数字格式），或者“time”，默认值为“all”。函数返回新的本地化名字，如果请求不能满足则返回 nil。\n
	如果 locale 是一个空字符串则将当前本地化信息设为当前机器的本地化信息。如果locale 是“C”，则当前本地化信息会被设为标准 C 的本地化信息。
	当第一个参数为 nil 时，函数返回指定类别当前的本地化信息。
	此函数并不是线程安全的，因为它依赖于 setlocale 这个 C 函数。
	]],
	args = "(locale: string [, category: string])",
	returns = "(string|nil)",
	},
	time = {
	type = "function",
	description = 
	[[
	如果没有参数，函数返回当前时间，如果有参数，则返回参数 table 指定的时间。参数table 必须要有 year，month，day 这三个域，可选的域有 hour（默认值为 12），min（默认值为 0），sec（默认值为 0）和 isdst（默认值为 nil）。这些域的说明可以参考 os.date 函数。\n
	函数的返回值是一个数字，它的含义取决于你的系统。在 POSIX，Windows 和其它一些系统上，该数字为从“epoch”（1970 年 1 月 1 日的 0 时 0 分 0 秒）到当前的秒数。在其它的一些系统上，该数字的含义是不确定的，它只能用作 os.date 和 os.difftime 的参数。
	]],
	args = "([table: table])",
	returns = "(number)",
	},
	tmpname = {
	type = "function",
	description =
	[[
	返回一个可以用作临时文件名的字符串。该文件在使用前必须先明确地打开，并且在不
需要时要明确地关闭。在 POSIX 系统上，此函数还会创建该名字的文件以避免安全性的风
险。（有可能有人凭借错误的权限在生成名字与创建文件之间创建一个同名文件。）但你仍需
要在使用它前打开它，同时要记得关闭它（就算你没有使用它）。
如果可能，你最好还是选择使用 io.tmpfile 这个函数，因此它会在程序结束时自动删除。
	]],
	args = "()",
	returns = "(string)",
	},
	},
	},
	
	-- Debug library
	debug = {
	type = "lib",
	description = 
	[[
	此库提供了调试 Lua 程序的接口。你应该谨慎地使用这些接口。库中有好几
个函数会破坏 Lua 代码的基本假设（比如无法从外部访问函数的局部变量；Lua 代码无法修
改 userdata 的元表；Lua 程序不会崩溃等），因此会破坏 Lua 代码的安全性。此外，库中有
些函数的执行速度可能会很慢。\n
库中的所有函数都封装在 debug 这个 table 中。那些基于线程的函数的第一个参数是一
个可选的参数，该参数表示函数要操作的目标线程，它的默认值为当前线程。
	]],
	childs = {
	debug = {
	type = "function",
	description =
	[[进入与用户进行交互的模式，执行用户输入的每个字符串。用户可以使用简单的命令和
	其它调试工具观察和修改全局变量和局部变量的值，对表达式进行计算等等。输入单词
	“cont”可以结束此函数，从而继续原来执行。
	注意，debug.debug 这个命令并不是语法嵌套在函数中的，因此它不能直接访问局部变
	量。]],
	args = "()",
	returns = "()",
	},
	getfenv = {
	type = "function",
	description = "Returns the environment of object o.\nFUNCTION DEPRECATED IN Lua 5.2.",
	args = "(o: any)",
	returns = "(table)",
	},
	gethook = {
	type = "function",
	description = [[返回给定线程的当前钩子信息，有三个返回值：钩子函数，钩子掩码及钩子的计数（使
用 debug.sethook 函数设置的）。]],
	args = "([thread: thread])",
	returns = "(function, string, number)",
	},
	getinfo = {
	type = "function",
	description =
	[[
		以 table 的形式返回指定线程中某个函数的信息。参数 f 可以是函数也可以是个数字，
	为函数时，则该函数为目标函数，为数字时表示运行在调用栈第 f 层的函数。0 层表示当前
	函数（即 getinfo 自身），1 层为调用 getinfo 的函数（除了尾调用，因为尾调用不在调用栈上），
	以此类推。如果层数大于活动函数的数量，getinfo 返回 nil。
	返回的 table 可以包含 lua_getinfo 返回的所有域，参数 what 用来指定哪些域会被填上
	值。如果没有 what 参数则返回除了合法行号表外的所有的信息。
	举个例子，如果能找到一个合理的名字，debug.getinfo(1, “n”).name 返回一个包含当前
	函数名字信息的 table。debug.getinfo(print)则返回一个包含 print 函数所有可得到的信息的
	table。
		]],
		args = "([thread: thread,] f: function|number [, what: string])",
		returns = "(table|nil)",
		},
		getlocal = {
		type = "function",
		description = 
		[[
			此函数返回在调用栈 f 层的函数的第 local 个局部变量的名字和值。此函数不仅可以访
		问那些显式定义的局部变量，还可以访问函数参数临时变量等。
			第一个参数或局部变量的索引为 1，以此类推直到最后一个活动的变量。负的索引表示
		变参，-1 表示变参中的第一个变量。当指定索引处没有局部变量时，函数返回 nil。当指定
		的层超出范围时，函数唤起一个错误。（你可以调用 debug.getinfo 来检查某层是否有效。）
		以“(”（开圆括号）开头的变量名表示内部变量（循环的控制变量，临时变量，变参和
		C function locals）。
			参数 f 也可以是个函数。这种情况下，getlocal 只返回函数参数的名字（第一个参数的
		索引为 1）。
		]],
		args = "([thread: thread,] f: number|function, local: number)",
		returns = "(string|nil, any)",
		},
		getmetatable = {
		type = "function",
		description = "返回给定 value 的元表。如果 value 没有元表则返回 nil。",
		args = "(value: any)",
		returns = "(table|nil)",
		},
		getregistry = {
		type = "function",
		description = "返回 Lua 的注册表",
		args = "()",
		returns = "()",
		},
		getupvalue = {
		type = "function",
		description = 
		[[返回指定函数 f 的第 up 个 upvalue 的名字和值。如果指定的索引处没有 upvalue 则返回
		nil。]],
		args = "(f: function, up: number)",
		returns = "(string|nil, any)",
		},
		getuservalue = {
		type = "function",
		description = "返回与 u 关联的 Lua 变量的值。如果 u 不是 userdata 则返回 nil",
		args = "(u: userdata)",
		returns = "(table|nil)",
		},
		setfenv = {
		type = "function",
		description = "Sets the environment of the given object to the given table. Returns object.\nFUNCTION DEPRECATED IN Lua 5.2.",
		args = "(object: any, table: table)",
		returns = "(any)",
		},
		sethook = {
		type = "function",
		description = [[
		将指定的函数设为一个钩子。字符串参数 mask 与数字参数 count 描述了钩子函数什么时候会被调用。mask 可以包含下面这些字符：
 			'c':每当 Lua 调用一个函数的时候会调用钩子函数。
 			'r':每当 Lua 从函数返回时会调用钩子函数。
			'l':每当 Lua 执行新的一行代码时会调用钩子函数。
		如果参数 count 的值不为 0，则每执行完 count 条指令时调用一次钩子函数。当函数没有参数时，debug.sethook 关闭钩子。
		当钩子函数被调用时，它的第一个参数是一个描述触发事件的字符串：“call”（或“tailcall”），“return”，“line”和“count”。对于 line 事件，钩子函数的第二个参数是新行的行号。在钩子函数里面，你可以调用 debug.getinfo(2)来获取更多的关于正在执行的函数的信息（0层是 getinfo 函数，1 层是钩子函数）。
]],
		args = "([thread: thread,] hook: function, mask: string [, count: number])",
		returns = "()",
		},
		setlocal = {
		type = "function",
		description =
		[[
			此函数将参数 value 的值赋值给调用栈第 level 层的函数的第 local 个局部变量。当指定
		索引处没有局部变量时，函数返回 nil。当指定的层超出范围时，函数唤起一个错误。（你可
		以调用 debug.getinfo 来检查某层是否有效。）否则它返回局部变量的名字。
		参考 debug.getlocal 以了解更多关于局部变量索引与名字的信息。
		]],
		args = "([thread: thread,] level: number, local: number, value: any)",
		returns = "(string|nil)",
		},
		setmetatable = {
		type = "function",
		description = "将指定的参数 table（可以为 nil）设为指定参数 value 的元表。返回 value 的值。",
		args = "(value: any, table: table|nil)",
		returns = "(any)",
		},
		setupvalue = {
		type = "function",
		description = 
			[[
			此函数将参数 value 的值赋值给函数 f 的第 up 个 upvalue。当指定索引处没有 upvalue
		时，函数返回 nil，否则函数返回 upvalue 的名字。
			]],
		args = "(f: function, up: number, value: any)",
		returns = "(string|nil)",
		},
		setuservalue = {
		type = "function",
		description = 
		[[
			将参数 value 设为与参数 udata 关联的 Lua 值。value 必须是一个 table 或 nil。udata 必须
		是 full userdata。\n
		返回 udata。
		]],
		args = "(udata: userdata, value: table|nil)",
		returns = "(userdata)",
		},
		traceback = {
		type = "function",
		description = 
		[[
			如果 mesage 既不是字符串也不是 nil，那么此函数只返回 message，不做其它处理。否
		则返回调用栈的一个栈回溯信息。可选字符串参数 message 会被加到栈回溯信息的前面。可
		选参数 level 指定了从栈的哪一层开始回溯（默认是 1，即从调用 traceback 的那个函数开始）。
		]],
		args = "([thread: thread,] [message: any [, level: number]])",
		returns = "(string)",
		},
			upvalueid = {
			type = "function",
			description = 
			[[
				返回函数 f 的第 n 个 upvalue 的唯一标识（是一个 light userdata）。
				程序可以利用这个唯一标记来判断是否有不同的闭包共享了 upvalue。被不同闭包共享（即它们访问同一个外部局部变量）的 upvalue 它们的唯一标记是一样的。
			]],
			args = "(f: function, n: number)",
			returns = "(userdata)",
			},
			upvaluejoin = {
			type = "function",
			description = "将 Lua 闭包 f1 的第 n1 个 upvalue 引用为 Lua 闭包 f2 的第 n2 个 upvalue。",
			args = "(f1: function, n1: number, f2: function, n2: number)",
			returns = "()",
			},
			},
			},
			}
			
			
--[[
语言的变化:
 环境的概念变了。只有 Lua 的函数才有环境。使用变量_ENV 或函数 load 来设置
Lua 函数的环境。
 C 函数不再有环境。如果你想在不同的 C 函数中共享状态，可以使用一个 table 来
作为 C 函数的共享 upvalue。（你可以使用 luaL_setfuncs 在开启 C 库时让所有函数
都共享一个公共的 upvalue。
 想要操作 userdata（现在叫 user value）的“环境”，你可以使用新的函数：
lua_getuservalue 和 lua_setuservalue。
 Lua 的标识符不能使用依赖于地域（locale-dependent）的字母了。
 执行分步回收或全回收时不会重新启动已停止工作的回收器。
 拥有弱键的弱表现在表示得像短命（ephemeron）table。
 调试钩子中的尾返回事件（tail return）被删除了，同时增加了尾调用事件（tail call）。
因此，调试器可以知道该种调用没有对应的返回事件。
 函数的相等比较规则改变了。现在定义一个函数时不一定会创建一个新的值，如果
它和之前的定义的一个函数没有任何区别，那么就会重用之前函数的值。

标准库的变化:
 不推荐使用函数 module。用常规的 Lua 代码可以很容易创建一个模块。 模块不需
要设为全局变量了。
 因为环境的改变，函数 setfenv 和 getfenv 已被删除了。
 不推荐使用函数 math.log10。将 10 作为第 2 个参数来调用 math.log 可以代替
math.log10 这个函数。
 不推荐使用函数 loadstring。可以使用函数 load 来代替。现在 load 可以接受一个字
符串参数了，它的效果与 loadstring 完全一样。
 不推荐使用函数 table.maxn。如果真需要，你可以自己用 Lua 实现一个。
 当命令成功结束时，函数 os.execute 返回 true。否则返回 nil 和错误信息。
 函数 unpack 被移到 table 库中了，因此必须用 table.unpack 这种形式调用。
 不推荐使用模式中的字符类型%z，因为现在模式可以把’\0’当作常规字符包含进
来。
 表 package.loaders 改名为 package.searchers。
 Lua 不再有字节码的验证机制。因此，所有与加载代码有关的函数（load 和 loadfile）
在加载不受信任的二进制数据时都有潜在的安全问题。（实际上，由于验证算法的
漏洞，那些函数早就不安全了。）当你对某些代码有顾虑的时候，你可以使用那些
函数的 mode 参数来限制它们只能加载文本形式的代码块。
 不同版本的官方发行包之间，标准路径有可能会改变。

API  的变化:
 伪索引 LUA_GLOBALSINDEX 被删除了。你必须从注册表中获得全局环境表。
 伪索引 LUA_ENVIRONINDEX 和函数 lua_getfenv/lua_setfenv 被删除了，因为 C 函
数不再有环境。
 不推荐使用函数 luaL_register。使用 luaL_setfuncs 可以让你的模块不在全局中创建
（不要求模块是一个全局变量）。
 当创建一个新块时（也就是 ptr 为 NULL 时），分配函数的参数 osize 可以不为 0 了。
只能通过 ptr == NULL 来判断分配的块是否是新的。
 userdata按照它们被标记的反序而不是它们被创建的顺序来调用它们的__gc元方法。
（大部分 userdata 都是在它们被创建的时候就被标记了）同时，如
果设置元表时元表中没有__gc 域，那么即使在之后设置了该域也不会被调用了。
 luaL_typerror 已被移除。有需要的话你可以自己实现一个。
 不推荐使用函数 lua_cpcall。 你可以先用 lua_pushcfunction 将函数压栈再用
lua_pcall 执行函数。
 不再推荐使用 lua_equal 和 lua_lessthan。可以使用新函数 lua_compare 来代替。
 函数 lua_objlen 改名为 lua_rawlen。
 函数 lua_load 多了一个额外的参数 mode。将 NULL 传给这个参数就可以实现旧的
行为。
 函数 lua_resume 多了一个额外的参数 from。可以传 NULL 或调用此函数的线程给
这个参数。



















--]]