﻿--[[

	文件名:
		scripts/config/colorpicker/default_keymap.lua
	说明:
		抓色器默认快捷键生成文件

--]]


local table = table
local ipairs = ipairs
local pairs = pairs

function posToRegA()
	setRegA(getCurrentXY())
end

function posToRegS()
	setRegS(getCurrentXY())
end

function posToRegX()
	setRegX(getCurrentXY())
end

function posToRegC()
	setRegC(getCurrentXY())
end

function moveMouseToPosOfRegA()
	moveMouseToXY(getRegA())
end

function moveMouseToPosOfRegS()
	moveMouseToXY(getRegS())
end

function moveMouseToPosOfRegX()
	moveMouseToXY(getRegX())
end

function moveMouseToPosOfRegC()
	moveMouseToXY(getRegC())
end

function moveMouseUp()
	local x, y = getCurrentXY()
	y = y - 1
	moveMouseToXY(x, y)
end

function moveMouseDown()
	local x, y = getCurrentXY()
	y = y + 1
	moveMouseToXY(x, y)
end

function moveMouseLeft()
	local x, y = getCurrentXY()
	x = x - 1
	moveMouseToXY(x, y)
end

function moveMouseRight()
	local x, y = getCurrentXY()
	x = x + 1
	moveMouseToXY(x, y)
end

function moveMouseUp10()
	local x, y = getCurrentXY()
	y = y - 10
	moveMouseToXY(x, y)
end

function moveMouseDown10()
	local x, y = getCurrentXY()
	y = y + 10
	moveMouseToXY(x, y)
end

function moveMouseLeft10()
	local x, y = getCurrentXY()
	x = x - 10
	moveMouseToXY(x, y)
end

function moveMouseRight10()
	local x, y = getCurrentXY()
	x = x + 10
	moveMouseToXY(x, y)
end

function moveMouseUp100()
	local x, y = getCurrentXY()
	y = y - 100
	moveMouseToXY(x, y)
end

function moveMouseDown100()
	local x, y = getCurrentXY()
	y = y + 100
	moveMouseToXY(x, y)
end

function moveMouseLeft100()
	local x, y = getCurrentXY()
	x = x - 100
	moveMouseToXY(x, y)
end

function moveMouseRight100()
	local x, y = getCurrentXY()
	x = x + 100
	moveMouseToXY(x, y)
end

function copyRect()
	local ax, ay = getRegA()
	local text = table.concat({ax, ay, getRegS()}, ", ")
	setTempRectText(text)
	writePasteboard(text)
end

function clearRect()
	setTempRectText("")
end

local poslist = {}

local function getCurrentConfig()
	local config = customFormatsTable()
	local current_config_index = currentFormatIndex()
	local current_config_name = config[current_config_index][1]
	local current_config = config[current_config_index][2]
	return current_config, current_config_name
end

local function getCurrentPos()
	local p = {getCurrentXY()}
	p.x = p[1]
	p.y = p[2]
	p.c = p[3]
	p.r, p.g, p.b = getColorRGB(p.x, p.y)
	return p
end

local function getPosASXC()
	local a = {getRegA()}
	local s = {getRegS()}
	local x = {getRegX()}
	local c = {getRegC()}
	a.x = a[1]
	a.y = a[2]
	s.x = s[1]
	s.y = s[2]
	x.x = x[1]
	x.y = x[2]
	c.x = c[1]
	c.y = c[2]
	return a, s, x, c
end

local function getPosList()
	local ret = {}
	for i=1,9 do
		if poslist[i] then
			ret[#ret + 1] = poslist[i]
		end
	end
	if poslist[0] then
		ret[#ret + 1] = poslist[0]
	end
	ret.a, ret.s, ret.x, ret.c = getPosASXC()
	return ret
end

function reloadPasteboard()
	local ret = ""
	for i=1,9 do
		if poslist[i] then
			ret = ret..getTextWithRegister(i)
		end
	end
	if poslist[0] then
		ret = ret..getTextWithRegister(0)
	end
	writePasteboard(ret)
end

local function repickColorRegister(reg_idx) -- [+ 1.7.4]
	local current_config = getCurrentConfig()
	local p, a, s, x, c = poslist[reg_idx], getPosASXC()
	p.c = getColor(p.x, p.y)
	p.r, p.g, p.b = getColorRGB(p.x, p.y)
	local ret = current_config.multiPosFormatRule(p, a, s, x, c, getSettingRuleSet())
	setTextToRegister(reg_idx, ret)
	setColorToRegister(reg_idx, p.c)
	reloadPasteboard()
	if getMarkState(reg_idx)==1 then
		local wnums = {
			"①",
			"②",
			"③",
			"④",
			"⑤",
			"⑥",
			"⑦",
			"⑧",
			"⑨",
		}
		wnums[0] = "〇"
		textOut(p.x, p.y, string.format("◤%s", wnums[reg_idx]), "黑体", 120, p.c, (255 - p.r) * 256^2 + (255 - p.g) * 256 + (255 - p.b), 2)
	end
end

function repickColor() -- [+ 1.7.4]
	for i=0,9 do
		if poslist[i] then
			repickColorRegister(i)
		end
	end
end

local function colorToColorRegister(reg_idx)
	local current_config = getCurrentConfig()
	local p, a, s, x, c = getCurrentPos(), getPosASXC()
	p.num = reg_idx
	p.idx = reg_idx
	if reg_idx == 0 then
		p.num = 10
	end
	poslist[reg_idx] = p
	local ret = current_config.multiPosFormatRule(p, a, s, x, c, getSettingRuleSet())
	setTextToRegister(reg_idx, ret)
	setColorToRegister(reg_idx, p.c)
	reloadPasteboard()
end

function colorToPasteboard()
	local current_config = getCurrentConfig()
	local p, a, s, x, c = getCurrentPos(), getPosASXC()
	local ret = current_config.singlePosFormatRule(p, a, s, x, c, getSettingRuleSet())
	if ret then
		writePasteboard(ret)
	end
end

local cachedScripts = {}

function makeScripts()
	local current_config = getCurrentConfig()
	local poslist = getPosList()
	for i=1,3 do
		local ret = current_config.makeScriptRule[i](poslist, getSettingRuleSet())
		cachedScripts[i] = ret
		setTextToScriptRegister(i, ret)
		if i == 1 then
			writePasteboard(ret)
		end
	end
end

local function clearColorRegister(reg_idx)
	setColorToRegister(reg_idx, 0xf0f0f0)
	setTextToRegister(reg_idx, "")
	poslist[reg_idx] = nil
end

function clearAllColorRegisters()
	for i=0,9 do
		clearColorRegister(i)
	end
	writePasteboard("")
end

function colorToNextColorRegister()
	for i=1,9 do
		if not poslist[i] then
			colorToColorRegister(i)
			return
		end
	end
	if not poslist[0] then
		colorToColorRegister(0)
	end
end

setRemoteCmdCallback(function(cmd, arg)		    -- [+ 1.7.10] 设置远程指令接口
	local current_config = getCurrentConfig()
	local remoteCmd = (type(current_config.remoteCmd)=="table" and current_config.remoteCmd) or {}
	if type(remoteCmd[cmd])=="function" then
		local poslist = getPosList()
		local noerr, ret = pcall(remoteCmd[cmd], arg, poslist, getSettingRuleSet())
		if noerr then
			return ret
		end
	else
		if cmd == "/nLog" then
			print(arg)
			return "ok"
		elseif cmd == "/openImageFile" then
			openImageFile(arg)
			return "ok"
		else
			print("未能识别的指令", cmd, arg)
		end
	end
end)

setClearButtonCallback(function(idx)		-- 设置清除按钮点击回调函数，参数为按钮索引（-1、0~9）
	if idx == -1 then						-- 索引为 -1 是 清除所有(Z) 按钮
		clearAllColorRegisters()
	elseif idx >= 0 and idx <= 9 then
		clearColorRegister(idx)
		reloadPasteboard()
	end
end)

-- 测试代码功能灵感来自 翟人抓抓
setTestButtonCallback(function(idx)		    -- [+ 1.7.7] 设置三个 “<-测试” 按钮的回调函数，参数为按钮索引（1~3）
	local current_config = getCurrentConfig()
	current_config.makeScriptRule = current_config.makeScriptRule or {}
	local tr = current_config.makeScriptRule.testRule
	if  (type(tr)=="table") and 
		(type(tr[idx])=="function") then
		if cachedScripts[idx] then
			local ret = tr[idx](cachedScripts[idx])
			if type(ret)=="string" then
				local noerr, errmsg = load(ret)
				if noerr then
					if not device_uploadScriptAndRun(ret) then -- [f 1.7.8]
						print("连接或传输失败，无法进行代码测试")
					end
				else
					print("代码不完整或有语法错误无法测试")
				end
			else
				print("自定义测试定义不正确")
			end
		else
			print("请先点击 “生成脚本(F)” 以生成自定义代码")
		end
	else
		print("左侧代码并没有合适的测试定义")
	end
end)

setASXCButtonCallback(function(idx)			-- 设置 A、S、X、C 四个按钮的回调函数，参数为按钮索引（分别是字符串 "A"、"S"、"X"、"C"）
	if idx == "A" then
		writePasteboard(table.concat({getRegA()}, ", "))
	elseif idx == "S" then
		writePasteboard(table.concat({getRegS()}, ", "))
	elseif idx == "X" then
		writePasteboard(table.concat({getRegX()}, ", "))
	elseif idx == "C" then
		writePasteboard(table.concat({getRegC()}, ", "))
	end
end)

setMakeScriptButtonCallback(makeScripts)	-- 设置 生成脚本(F) 按钮回调函数，没有参数

setCtrlMouseLeftCallback(colorToNextColorRegister)

for i=0,9 do
	_G["colorToColorRegister"..(i)] = function()
		colorToColorRegister(i)
	end
end

for i=0,9 do
	_G["clearColorRegister"..(i)] = function()
		clearColorRegister(i)
		reloadPasteboard()
	end
end

local default_keymap = [=[
--[[
	文件名:
		scripts/config/colorpicker/keymap.lua
	说明:
		抓色器快捷键映射配置文件


	可以使用的自定义全局函数列表:

		msgbox(text)
			弹出一个显示有文本 @text 提示窗

		writePasteboard(text)
			将文本 @text 写入系统剪贴板

		text|nil = readPasteboard()
			当系统剪贴板中有文本之时，返回文本 @text ，否则返回 nil

		text = inputBox([default, title])
			弹出一个输入提示窗，阻塞并返回
			@default 为文本框中默认存在的文本
			@title 为弹出窗口的标题
			返回最终的文本框中的文本内容 @text

		sel = actionSheet([list])
			弹出一个选择表，阻塞并返回
			@list 为一个顺序表，表中值类型为文本
			@sel 返回被用户选择的那个项的顺序编号

		x,y,color = getCurrentXY()
			获取鼠标最后指向的图片上那个点的相对坐标值及该点颜色值
			@x 横坐标    @y 纵坐标    @color 该点颜色值

		setColorToRegister(reg_idx, color)
			设置某寄存位旁的颜色值
			@reg_idx 寄存位编号(范围 0~9)
			@color 目标颜色值

		setTextToRegister(reg_idx, text) [f 1.7.3]
			设置某寄存位的文本
			@reg_idx 寄存位编号(范围 0~9)
			@text 文本

		text = getTextWithRegister(reg_idx)
			获取某寄存位的文本
			@reg_idx 寄存位编号(范围 0~9)
			@text 寄存位中的文本

		setTextToScriptRegister(reg_idx, text) [f 1.7.3]
			设置某脚本代码寄存位的文本
			@reg_idx 寄存位编号(范围 1~3)
			@text 文本

		text = getTextWithScriptRegister(reg_idx)
			获取某脚本代码寄存位的文本
			@reg_idx 寄存位编号(范围 1~3)
			@text 寄存位中的文本

		setRegA(x, y) [+ 1.7.3]
			设置取色面板上 A 点的坐标记录
			@x 横坐标    @y 纵坐标

		setRegS(x, y) [+ 1.7.3]
			设置取色面板上 S 点的坐标记录
			@x 横坐标    @y 纵坐标

		setRegX(x, y) [+ 1.7.3]
			设置取色面板上 X 点的坐标记录
			@x 横坐标    @y 纵坐标

		setRegC(x, y) [+ 1.7.3]
			设置取色面板上 C 点的坐标记录
			@x 横坐标    @y 纵坐标

		x,y = getRegA() [+ 1.7.3]
			获取取色面板上 A 点的坐标记录
			@x 横坐标    @y 纵坐标

		x,y = getRegS() [+ 1.7.3]
			获取取色面板上 S 点的坐标记录
			@x 横坐标    @y 纵坐标

		x,y = getRegX() [+ 1.7.3]
			获取取色面板上 X 点的坐标记录
			@x 横坐标    @y 纵坐标

		x,y = getRegC() [+ 1.7.3]
			获取取色面板上 C 点的坐标记录
			@x 横坐标    @y 纵坐标

		setTempRectText(text) [+ 1.7.3]
			设置取色面板上临时区域文本
			@text 需要设置的文本

		setClearButtonCallback(clear_callback) [+ 1.7.3]
			设置取色面板清除按钮被点击的回调函数
			@clear_callback
				回调函数，当按钮点击事件触发时，会调用这个函数，并传递被点击的按钮的索引作为唯一的参数
				按钮 全部清除(Z) 的索引为 -1

		setASXCButtonCallback(asxc_callback) [+ 1.7.3]
			设置取色面板 A、S、X、C 四个按钮被点击的回调函数
			@asxc_callback
				回调函数，当按钮点击事件触发时，会调用这个函数，并传递被点击的按钮的索引作为唯一的参数
				四个按钮的索引分别为字符串 "A"，"S"，"X"，"C"

		setMakeScriptButtonCallback(makescript_callback) [+ 1.7.3]
			设置取色面板 生成脚本(F) 按钮被点击的回调函数
			@makescript_callback
				回调函数，当按钮点击事件触发时，会调用这个函数，这个没有参数

		setCtrlMouseLeftCallback(ctrlmouse_callback) [+ 1.7.3]
			设置 Ctrl + 鼠标左键点击 回调函数
			@ctrlmouse_callback
				回调函数，当该事件触发时，会调用这个函数，这个没有参数

		setRemoteCmdCallback(remotecmd_callback) [+ 1.7.10]
			设置 远程指令 回调函数
			@remotecmd_callback
				回调函数，当接收到远程指令的时候，会调用这个函数，并将指令附带的字符串参数当作唯一参数

		port = getRemoteCmdPort() [+ 1.7.10]
			获取接收远程指令的端口，每个抓色器实例的端口都是本机唯一
			@port 将此端口传递给外部程序，然后外部程序可以使用此端口给抓色器传递消息

		table = customFormatsTable()
			获取当前自定义格式配置表
			@table 返回总表

		index = currentFormatIndex()
			获取当前用户所选择的自定义格式的编号
			@index 当前自定义格式在顺序选择中的编号

		w,h = getImageSize() [+ 1.7.4]
			获取当前图片的尺寸
			@w 宽度    @h 高度

		color = getColor(x, y)
			获取图片上某坐标的颜色值
			@x 横坐标    @y 纵坐标
			@color 图片上其坐标点上的颜色值

		r,g,b = getColorRGB(x, y)
			获取图片上某坐标的 R/G/B 值
			@x 横坐标    @y 纵坐标
			@r,@g,@b 图片上其坐标点上的 R/G/B 值

		moveMouseToXY(x, y)
			将鼠标指针移动到图片上的坐标上
			@x 图片上的横坐标
			@y 图片上的纵坐标

		set = getSettingRuleSet()
			获取抓色用户对当前自定义格式的配置设置
			@set 一个对应格式的设置数组(顺序表)

		viewZoomIn()
			放大当前图片

		viewZoomOut()
			缩小当前图片

		viewRotateLeft()
			左旋当前图片

		viewRotateRight()
			右边旋当前图片

--]]

local VK = require("scripts.config.virtual_keycodes")

-- 直接按键
local SK_PRESS_ = {
	[ VK["{A}"		] ] = posToRegA, -- 直接按 A
	[ VK["{S}"		] ] = posToRegS,
	[ VK["{X}"		] ] = posToRegX,
	[ VK["{C}"		] ] = posToRegC,
	[ VK["{D}"		] ] = copyRect,
	[ VK["{Z}"		] ] = clearAllColorRegisters,
	[ VK["{F}"		] ] = makeScripts,
	[ VK["{W}"		] ] = reloadPasteboard,
	[ VK["{`~}"		] ] = colorToPasteboard,
	[ VK["{=+}"		] ] = viewZoomIn,
	[ VK["{-_}"		] ] = viewZoomOut,
	[ VK["{J}"		] ] = viewRotateLeft,
	[ VK["{K}"		] ] = viewRotateRight,
	[ VK["{UP}"		] ] = moveMouseUp,
	[ VK["{DOWN}"	] ] = moveMouseDown,
	[ VK["{LEFT}"	] ] = moveMouseLeft,
	[ VK["{RIGHT}"	] ] = moveMouseRight,
	[ VK["{RETURN}"	] ] = colorToNextColorRegister,
	[ VK["{E}"		] ] = function() -- [+ 1.7.4]
		local x, y = getRegA()
		setRegA(getRegX())
		setRegX(x, y)
		x, y = getRegS()
		setRegS(getRegC())
		setRegC(x, y)
	end,
	[ VK["{R}"		] ] = repickColor, -- [+ 1.7.4]
}

for i=0,9 do
	SK_PRESS_[ VK["{"..(i).."}"] ] = _G["colorToColorRegister"..(i)]
end


-- Shift + 按键
local SK_SHIFT_ = {
	[ VK["{A}"		] ] = moveMouseToPosOfRegA, -- 按住 Shift 键再按 A
	[ VK["{S}"		] ] = moveMouseToPosOfRegS,
	[ VK["{X}"		] ] = moveMouseToPosOfRegX,
	[ VK["{C}"		] ] = moveMouseToPosOfRegC,
	[ VK["{D}"		] ] = clearRect,
	[ VK["{UP}"		] ] = moveMouseUp10,
	[ VK["{DOWN}"	] ] = moveMouseDown10,
	[ VK["{LEFT}"	] ] = moveMouseLeft10,
	[ VK["{RIGHT}"	] ] = moveMouseRight10,
	[ VK["{E}"		] ] = function() -- [+ 1.7.4]
		setRegA(0, 0)
		setRegS(0, 0)
	end,
}

for i=0,9 do
	SK_SHIFT_[ VK["{"..(i).."}"] ] = _G["clearColorRegister"..(i)]
end


-- Ctrl + 按键
local SK_CTRL_ = {
	[ VK["{UP}"		] ] = moveMouseUp100, -- 按住 Ctrl 键再按 ↑
	[ VK["{DOWN}"	] ] = moveMouseDown100,
	[ VK["{LEFT}"	] ] = moveMouseLeft100,
	[ VK["{RIGHT}"	] ] = moveMouseRight100,
}

-- Alt + 按键
local SK_ALT_ = {
	[ VK["{D}"		] ] = function() -- Alt + D 是一个快捷键注册演示
		local cfg = customFormatsTable()[currentFormatIndex()]
		local r = dialogPickArgs{
			title = "一个弹窗",
			caption = {"参数", "值"},
			args = {
				{"参数一", "100"},
				{"参数二", "200"},
				{"当前选择的自定义格式的标题", cfg[1]},
			},
		}
		if r then
			for i,v in ipairs(r) do
				print(i,v)
			end
		end
	end,
	[ VK["{UP}"		] ] = moveMouseUp100,
	[ VK["{DOWN}"	] ] = moveMouseDown100,
	[ VK["{LEFT}"	] ] = moveMouseLeft100,
	[ VK["{RIGHT}"	] ] = moveMouseRight100,
}


-- Ctrl + Shift + 按键
local SK_CTRL_SHIFT_ = {

}


-- Ctrl + Alt + 按键
local SK_CTRL_ALT_ = {

}


-- Alt + Shift + 按键
local SK_ALT_SHIFT_ = {

}


-- Ctrl + Alt + Shift + 按键
local SK_CTRL_ALT_SHIFT_ = {

}


------------------------------------------------------------------------------
return {
	SK_PRESS_,
	SHIFT = SK_SHIFT_,
	CTRL = SK_CTRL_,
	ALT = SK_ALT_,
	CTRL_SHIFT = SK_CTRL_SHIFT_,
	CTRL_ALT = SK_CTRL_ALT_,
	ALT_SHIFT = SK_ALT_SHIFT_,
	CTRL_ALT_SHIFT = SK_CTRL_ALT_SHIFT_,
}
]=]

return require("scripts.lua.tscpbase").loadSettings(
	default_keymap,
	"scripts.config.colorpicker.keymap",
	"keymap",
	"table"
)
