﻿
--[[

格式说明：

{
	下拉选项标题,
	{
		customKeyMap = 自定义快捷键映射表,
		singlePosFormatRule = 单点取色生成格式函数,
		multiPosFormatRule = 多点取色生成格式函数,
		currentPosInfo = 鼠标所指当前点的格式生成函数（面板上那个随着鼠标移动时刻在变化的内容）,
		makeScriptRule = { -- 自定义脚本规则
			生成第 1 个文本框内容的函数,
			生成第 2 个文本框内容的函数,
			生成第 3 个文本框内容的函数,
			testRule = { -- [+ 1.7.7]
				第 1 个文本框的内容的测试函数,
				第 2 个文本框的内容的测试函数,
				第 3 个文本框的内容的测试函数,
			},
		},
	},
}

customKeyMap 说明：
	可参考 scripts/config/colorpicker/keymap.lua 的返回值


singlePosFormatRule、multiPosFormatRule 参数说明：
	p：		当前点信息，包括 x、y、c、r、g、b、num
	a：		坐标缓冲位 A 的信息，包括 x、y
	s：		坐标缓冲位 S 的信息，包括 x、y
	x：		坐标缓冲位 X 的信息，包括 x、y
	c：		坐标缓冲位 C 的信息，包括 x、y
	set:	扩展设置列表


makeScriptRule 参数说明：
	poslist: {
		p,
		p,
		p,
		...
		a = {x, y},
		s = {x, y},
		x = {x, y},
		c = {x, y},
	}

	set: 扩展设置列表

如需自定义格式，可以复制当前文件的考备份重命名然后做修改
修改完成后，可以在文件 scripts/config/colorpicker/cf_enabled.lua 应用添加自定义格式

--]]

return
{"旧版兼容格式",
-- 当前文件只是个例子，如果你喜欢旧版的格式规则，可以通过这个例子重新定义
-- 旧版格式规则参考说明请往下翻
	{
		remoteCmd = {
			["/test"] = function(arg, poslist, set)
				print("这只是测试一下远程指令接收", arg)
			end
		},
		settingsRule = {
			title = "自定义格式 [旧版兼容格式] 的参数设置",
			caption = {"参数名", "参数值"},
			args = {
				{"格式1前缀", 		"{#LF#"},
				{"格式1中缀", 		"#T#{ #X#, #Y#, #C#},#LF#"},
				{"格式1分隔符", 	""},
				{"格式1后缀", 		"}"},

				{"格式2前缀", 		"if ("},
				{"格式2中缀", 		"isColor( #X#, #Y#, #C#, 85)"},
				{"格式2分隔符", 	"#SP#and#SP#"},
				{"格式2后缀", 		") then"},
			},
		},
		singlePosFormatRule	= make_old_singlePosFormatRule("{ #X#, #Y#, #C#}"),
		multiPosFormatRule	= make_old_multiPosFormatRule("{ #X#, #Y#, #C#},#LF#"),
		currentPosInfo		= make_old_currentPosInfo("{ #X#, #Y#, #C#}"),
		makeScriptRule		= {
			(function(poslist, set)
				return make_old_makeScriptRule(
					set["格式1前缀"],
					set["格式1中缀"],
					set["格式1分隔符"],
					set["格式1后缀"]
				)(poslist)
			end),
			(function(poslist, set)
				return make_old_makeScriptRule(
					set["格式2前缀"],
					set["格式2中缀"],
					set["格式2分隔符"],
					set["格式2后缀"]
				)(poslist)
			end),
			make_findMultiColorInRegionFuzzy,
			testRule = { -- [+ 1.7.7]
				(function(s)
					return multiColorCodeDefine..[[
					if multiColor(]]..s..[[, 80) then
						nLog("相似度80以上")
					else
						nLog("相似度80以下")
					end
					]]
				end),
				(function(s)
					return isColorCodeDefine..s..[[
						nLog("匹配")
					else
						nLog("不匹配")
					end
					]]
				end),
				(function(s)
					return s..[[
						nLog("多点找色结果："..tostring(x).." ,"..tostring(y))
					]]
				end),
			},
		},
	},
}

--[[
-----------------------------------------------------
旧版的格式规则


自定义取色格式转义标签（全部标签都为 大！写！字！母! ）

	#X#
		代表 X 坐标

	#Y#
		代表 Y 坐标

	#C#
		代表颜色值（6位16进制）

	#R#
		代表颜色中的红色值

	#G#
		代表颜色中的绿色值

	#B#
		代表颜色中的蓝色值

	#HR#
		代表颜色中的红色值（2位16进制）

	#HG#
		代表颜色中的绿色值（2位16进制）

	#HB#
		代表颜色中的蓝色值（2位16进制）


	注意：以上的转义标签只能用于内容部分，不能用于前缀、中缀和后缀之中


	#SX#
		代表设置的起始点（左上）的 X 坐标

	#SY#
		代表设置的起始点（左上）的 Y 坐标

	#EX#
		代表设置的终点（右下）的 X 坐标

	#EY#
		代表设置的终点（右下）的 Y 坐标

	#CR#
		代表回车（\r）

	#LF#
		代表换行（\n）

	#T#
		代表制表符（\t）

	#SP#
		代表空格（在首尾空格被自动剔除的情况下可以使用）

	#0*#
		这不是一个标签，这个扩展用法是关闭部分标签的空格补齐(在部分标签第一个字母前插入一个数字零)
		支持扩展以下标签：
			#X#、#Y#、#R#、#G#、#B#、#SX#、#SY#、#EX#、#EY#
		例如：
			#0X#、#0Y#、#0R#、#0G#、#0B#、#0SX#、#0SY#、#0EX#、#0EY#

	#FMC#
		代表输出 findMultiColorInRegionFuzzy 的前两个参数（此标签仅能用于前缀、中缀、后缀中）
		输出示例：
			0x39383a, "1|-7|0xf6f6f6,3|7|0xf9fafa,0|22|0xf9fafa,-11|2|0xfbfbfc,-36|-29|0xf48315,-18|-31|0xffd528,21|-32|0x4faaf3,37|-32|0x0e6ab8,26|14|0x414042"

	一些示例（如果不知道什么意思请千万别乱复制使用）：
		#X#, #Y#, #C#
		{ #X#, #Y#, #C#},
		pos.new( #X#, #Y#, #C#),
		#X#, #Y#, #R#, #G#, #B#
		{#X#, #Y#, #R#, #G#, #B#},
		(#X#, #Y#, #R#, #G#, #B#)
		(#Y#, #X#, #B#, #G#, #R#)
		(#Y#, #X#, 0x#HB##HG##HR#)

	一些说明：
		坐标值为空格补齐4位
		颜色值为0x开头及0补齐6位
		RGB值为空格补齐3位
		HRGB值为0补齐2位
		任何字段如果首尾需要空格请使用#SP#

-----------------------------------------------------
--]]
