/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.sql.REF;
import oracle.sql.STRUCT;

@ProxyFor(value={OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableStatement
extends TxnReplayableBase
implements JDBCReplayable,
OracleStatement.BindChecksumListener {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;

    protected TxnReplayableStatement() {
        this.thisProxyNameInLog = "STMT" + this.thisProxyNameInLog;
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected void preForExecuteQuery(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {}
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected void preForExecute(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {}
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preForExecuteUpdate(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {}
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="sendBatch", args={}), @Signature(name="executeBatch", args={})})
    protected void preForBatches(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING: 
            case REPLAYING_LASTCALL: {
                try {
                    OracleStatement oracleStatement = (OracleStatement)this.getDelegate();
                    oracleStatement.registerBindChecksumListener(this);
                }
                catch (SQLException sQLException) {}
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="getARRAY", args={int.class}), @Signature(name="getBfile", args={int.class}), @Signature(name="getBFILE", args={int.class}), @Signature(name="getBLOB", args={int.class}), @Signature(name="getCLOB", args={int.class}), @Signature(name="getOPAQUE", args={int.class}), @Signature(name="getREF", args={int.class}), @Signature(name="getSTRUCT", args={int.class}), @Signature(name="setARRAY", args={String.class, ARRAY.class}), @Signature(name="setBfile", args={String.class, BFILE.class}), @Signature(name="setBFILE", args={String.class, BFILE.class}), @Signature(name="setBLOB", args={String.class, BLOB.class}), @Signature(name="setCLOB", args={String.class, CLOB.class}), @Signature(name="setOPAQUE", args={String.class, OPAQUE.class}), @Signature(name="setREF", args={String.class, REF.class}), @Signature(name="setSTRUCT", args={String.class, STRUCT.class}), @Signature(name="setARRAY", args={int.class, ARRAY.class}), @Signature(name="setBfile", args={int.class, BFILE.class}), @Signature(name="setBFILE", args={int.class, BFILE.class}), @Signature(name="setBLOB", args={int.class, BLOB.class}), @Signature(name="setCLOB", args={int.class, CLOB.class}), @Signature(name="setOPAQUE", args={int.class, OPAQUE.class}), @Signature(name="setREF", args={int.class, REF.class}), @Signature(name="setSTRUCT", args={int.class, STRUCT.class}), @Signature(name="setARRAYAtName", args={String.class, ARRAY.class}), @Signature(name="setBfileAtName", args={String.class, BFILE.class}), @Signature(name="setBFILEAtName", args={String.class, BFILE.class}), @Signature(name="setBLOBAtName", args={String.class, BLOB.class}), @Signature(name="setCLOBAtName", args={String.class, CLOB.class}), @Signature(name="setOPAQUEAtName", args={String.class, OPAQUE.class}), @Signature(name="setREFAtName", args={String.class, REF.class}), @Signature(name="setSTRUCTAtName", args={String.class, STRUCT.class})})
    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setAsciiStream", args={String.class, InputStream.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setUnicodeStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setUnicodeStreamAtName", args={String.class, InputStream.class, int.class})})
    protected void preForSetStreams(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setObject", args={String.class, Object.class}), @Signature(name="setObject", args={String.class, Object.class, int.class}), @Signature(name="setObject", args={String.class, Object.class, int.class, int.class}), @Signature(name="setObject", args={int.class, Object.class}), @Signature(name="setObject", args={int.class, Object.class, int.class}), @Signature(name="setObject", args={int.class, Object.class, int.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class, int.class})})
    protected void preForSetObjects(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (objectArray[1] instanceof InputStream || objectArray[1] instanceof Reader) {
            if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
            }
        } else {
            this.preForAll(method, object, objectArray);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="getResultSet", args={})})
    protected ResultSet postForGetResultSet(Method method, ResultSet resultSet) {
        this.postForAll(method, resultSet);
        if (!this.failoverMngr.isSessionStateConsistencyDynamic()) {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry = this.tailSameProxy;
                    while (callHistoryEntry != this.headSameProxy) {
                        if ("execute".equals(callHistoryEntry.method.getName()) && callHistoryEntry.result instanceof Integer) {
                            ((TxnReplayableResultSet)((Object)resultSet)).creatorCallEntry = callHistoryEntry;
                        }
                        callHistoryEntry = callHistoryEntry.prevEntrySameProxy;
                    }
                    break;
                }
            }
        }
        return resultSet;
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected ResultSet postForExecuteQuery(Method method, ResultSet resultSet) {
        this.postForAll(method, resultSet);
        if (!this.failoverMngr.isSessionStateConsistencyDynamic()) {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    ((TxnReplayableResultSet)((Object)resultSet)).creatorCallEntry = this.tailSameProxy;
                    break;
                }
            }
        }
        return resultSet;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onErrorVoidForClose(Method method, SQLException sQLException) throws SQLException {
        if (sQLException instanceof SQLRecoverableException) {
            return;
        }
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public boolean shouldContinue(long l2) {
        boolean bl = true;
        TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry = this.tailSameProxy;
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.currentBindChecksum = l2;
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                if (callHistoryEntry.checksum == 0L || callHistoryEntry.checksum == l2) break;
                this.failoverMngr.disableReplayInternal(callHistoryEntry.method, 388, "Replay failed because of checksum mismatch", null);
                bl = false;
            }
        }
        callHistoryEntry = null;
        return bl;
    }
}

