/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.EventListener;
import java.util.concurrent.Executor;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.PDBChangeEventListener;
import oracle.jdbc.internal.XSEventListener;

class NTFEventListener {
    private final AQNotificationListener aqlistener;
    private final DatabaseChangeListener dcnlistener;
    private final XSEventListener xslistener;
    private final LogicalTransactionIdEventListener ltxidlistener;
    private final JMSNotificationListener jmslistener;
    private final PDBChangeEventListener pdbChangeListener;
    private Executor executor = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    NTFEventListener(PDBChangeEventListener pDBChangeEventListener) throws SQLException {
        if (pDBChangeEventListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.jmslistener = null;
        this.dcnlistener = null;
        this.aqlistener = null;
        this.xslistener = null;
        this.ltxidlistener = null;
        this.pdbChangeListener = pDBChangeEventListener;
    }

    NTFEventListener(DatabaseChangeListener databaseChangeListener) throws SQLException {
        if (databaseChangeListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.jmslistener = null;
        this.dcnlistener = databaseChangeListener;
        this.aqlistener = null;
        this.xslistener = null;
        this.ltxidlistener = null;
        this.pdbChangeListener = null;
    }

    NTFEventListener(JMSNotificationListener jMSNotificationListener) throws SQLException {
        if (jMSNotificationListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.jmslistener = jMSNotificationListener;
        this.aqlistener = null;
        this.dcnlistener = null;
        this.xslistener = null;
        this.ltxidlistener = null;
        this.pdbChangeListener = null;
    }

    NTFEventListener(AQNotificationListener aQNotificationListener) throws SQLException {
        if (aQNotificationListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.jmslistener = null;
        this.aqlistener = aQNotificationListener;
        this.dcnlistener = null;
        this.xslistener = null;
        this.ltxidlistener = null;
        this.pdbChangeListener = null;
    }

    NTFEventListener(XSEventListener xSEventListener) throws SQLException {
        if (xSEventListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.jmslistener = null;
        this.aqlistener = null;
        this.dcnlistener = null;
        this.xslistener = xSEventListener;
        this.ltxidlistener = null;
        this.pdbChangeListener = null;
    }

    NTFEventListener(LogicalTransactionIdEventListener logicalTransactionIdEventListener) throws SQLException {
        if (logicalTransactionIdEventListener == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.jmslistener = null;
        this.aqlistener = null;
        this.dcnlistener = null;
        this.xslistener = null;
        this.ltxidlistener = logicalTransactionIdEventListener;
        this.pdbChangeListener = null;
    }

    void setExecutor(Executor executor) {
        this.executor = executor;
    }

    Executor getExecutor() {
        return this.executor;
    }

    EventListener getListener() {
        EventListener eventListener = this.dcnlistener;
        if (eventListener == null) {
            eventListener = this.aqlistener;
        }
        if (eventListener == null) {
            eventListener = this.jmslistener;
        }
        if (eventListener == null) {
            eventListener = this.pdbChangeListener;
        }
        return eventListener;
    }

    PDBChangeEventListener getPDBChangeEventListener() {
        return this.pdbChangeListener;
    }

    JMSNotificationListener getJMSListener() {
        return this.jmslistener;
    }

    AQNotificationListener getAQListener() {
        return this.aqlistener;
    }

    DatabaseChangeListener getDCNListener() {
        return this.dcnlistener;
    }

    XSEventListener getXSEventListener() {
        return this.xslistener;
    }

    LogicalTransactionIdEventListener getLogicalTransactionIdEventListener() {
        return this.ltxidlistener;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

