/*
 * Decompiled with CFR 0.152.
 */
package barcode;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class BarcodeUtil {
    public File generateFiles(String msg, String path) {
        File file = new File(path);
        try {
            BarcodeUtil.generates(msg, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public byte[] generates(String msg) throws IOException {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        BarcodeUtil.generates(msg, ous);
        ous.close();
        return ous.toByteArray();
    }

    public static void generates(String msg, OutputStream ous) {
        if (StringUtils.isEmpty((String)msg) || ous == null) {
            return;
        }
        Code128Bean bean = new Code128Bean();
        int dpi = 300;
        double moduleWidth = UnitConv.in2mm((double)0.006666666828095913);
        bean.setModuleWidth(moduleWidth);
        bean.setHeight(11.833333333333334);
        bean.doQuietZone(true);
        bean.setQuietZone(2.0);
        bean.setVerticalQuietZone(3.5);
        String format = "image/png";
        try {
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format, 300, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
            ous.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

