/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru.polynomial.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import org.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.Resultant;
import org.bouncycastle.util.Arrays;

public class IntegerPolynomialTest
extends TestCase {
    public void testMult() {
        int[] nArray = new int[11];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[4] = -1;
        nArray[6] = 1;
        nArray[9] = 1;
        nArray[10] = -1;
        IntegerPolynomial a = new IntegerPolynomial(nArray);
        IntegerPolynomial b = new IntegerPolynomial(new int[]{14, 11, 26, 24, 14, 16, 30, 7, 25, 6, 19});
        IntegerPolynomial c = a.mult(b, 32);
        this.assertEqualsMod(new int[]{3, -7, -10, -11, 10, 7, 6, 7, 5, -3, -7}, c.coeffs, 32);
        a = new IntegerPolynomial(new int[]{15, 27, 18, 16, 12, 13, 16, 2, 28, 22, 26});
        int[] nArray2 = new int[11];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[5] = 1;
        nArray2[8] = -1;
        nArray2[10] = -1;
        b = new IntegerPolynomial(nArray2);
        c = a.mult(b, 32);
        this.assertEqualsMod(new int[]{8, 25, 22, 20, 12, 24, 15, 19, 12, 19, 16}, c.coeffs, 32);
        int[] nArray3 = new int[11];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[4] = -1;
        nArray3[5] = -1;
        nArray3[8] = -1;
        nArray3[10] = 1;
        a = new IntegerPolynomial(nArray3);
        int[] nArray4 = new int[11];
        nArray4[0] = 704;
        b = new IntegerPolynomial(nArray4);
        c = a.mult(b);
        int[] nArray5 = new int[11];
        nArray5[0] = 1;
        nArray5[2] = -1;
        nArray5[3] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[7] = 1;
        nArray5[8] = -1;
        nArray5[9] = 1;
        nArray5[10] = -1;
        a = new IntegerPolynomial(nArray5);
        int[] nArray6 = new int[11];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArray6[5] = -1;
        nArray6[6] = -1;
        nArray6[7] = 1;
        nArray6[8] = 1;
        nArray6[9] = -1;
        nArray6[10] = 1;
        b = new IntegerPolynomial(nArray6);
        c = a.mult(b);
        c.modPositive(20);
        IntegerPolynomial d = a.mult(b, 20);
        d.modPositive(20);
        IntegerPolynomialTest.assertTrue((boolean)Arrays.areEqual(c.coeffs, d.coeffs));
    }

    void assertEqualsMod(int[] arr1, int[] arr2, int m) {
        IntegerPolynomialTest.assertEquals((int)arr1.length, (int)arr2.length);
        int i = 0;
        while (i < arr1.length) {
            IntegerPolynomialTest.assertEquals((int)((arr1[i] + m) % m), (int)((arr2[i] + m) % m));
            ++i;
        }
    }

    public void testInvertFq() {
        SecureRandom random = new SecureRandom();
        int[] nArray = new int[11];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[4] = -1;
        nArray[6] = 1;
        nArray[9] = 1;
        nArray[10] = -1;
        IntegerPolynomial a = new IntegerPolynomial(nArray);
        IntegerPolynomial b = a.invertFq(32);
        this.assertEqualsMod(new int[]{5, 9, 6, 16, 4, 15, 16, 22, 20, 18, 30}, b.coeffs, 32);
        this.verifyInverse(a, b, 32);
        int numInvertible = 0;
        while (numInvertible < 3) {
            a = DenseTernaryPolynomial.generateRandom(853, random);
            b = a.invertFq(2048);
            if (b == null) continue;
            ++numInvertible;
            this.verifyInverse(a, b, 2048);
        }
        int[] nArray2 = new int[11];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[6] = -1;
        nArray2[8] = -1;
        nArray2[10] = 1;
        a = new IntegerPolynomial(nArray2);
        b = a.invertFq(32);
        IntegerPolynomialTest.assertNull((Object)b);
    }

    public void testInvertF3() {
        int[] nArray = new int[11];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[4] = -1;
        nArray[6] = 1;
        nArray[9] = 1;
        nArray[10] = -1;
        IntegerPolynomial a = new IntegerPolynomial(nArray);
        IntegerPolynomial b = a.invertF3();
        int[] nArray2 = new int[11];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        nArray2[5] = 1;
        nArray2[7] = 2;
        nArray2[8] = 1;
        nArray2[9] = 2;
        this.assertEqualsMod(nArray2, b.coeffs, 3);
        this.verifyInverse(a, b, 3);
        int[] nArray3 = new int[11];
        nArray3[1] = 1;
        nArray3[2] = -1;
        nArray3[3] = 1;
        nArray3[8] = -1;
        a = new IntegerPolynomial(nArray3);
        b = a.invertF3();
        IntegerPolynomialTest.assertNull((Object)b);
    }

    private void verifyInverse(IntegerPolynomial a, IntegerPolynomial b, int modulus) {
        IntegerPolynomial c = a.mult(b, modulus);
        int i = 1;
        while (i < c.coeffs.length) {
            int n = i++;
            c.coeffs[n] = c.coeffs[n] % modulus;
        }
        c.ensurePositive(modulus);
        IntegerPolynomialTest.assertTrue((boolean)c.equalsOne());
    }

    public void testFromToBinary() {
        byte[] byArray = new byte[2062];
        byArray[0] = -44;
        byArray[1] = -33;
        byArray[2] = 30;
        byArray[3] = -109;
        byArray[4] = 101;
        byArray[5] = -28;
        byArray[6] = -6;
        byArray[7] = -105;
        byArray[8] = -45;
        byArray[9] = 113;
        byArray[10] = -72;
        byArray[11] = 99;
        byArray[12] = 101;
        byArray[13] = 15;
        byArray[14] = 9;
        byArray[15] = 49;
        byArray[16] = -80;
        byArray[17] = -76;
        byArray[18] = 58;
        byArray[19] = 42;
        byArray[20] = -57;
        byArray[21] = -113;
        byArray[22] = -89;
        byArray[23] = -14;
        byArray[24] = -125;
        byArray[25] = 24;
        byArray[26] = 125;
        byArray[27] = -16;
        byArray[28] = 37;
        byArray[29] = -58;
        byArray[30] = 10;
        byArray[31] = -49;
        byArray[32] = -77;
        byArray[33] = -31;
        byArray[34] = 120;
        byArray[35] = 103;
        byArray[36] = -29;
        byArray[37] = 105;
        byArray[38] = -56;
        byArray[39] = -126;
        byArray[40] = -92;
        byArray[41] = 36;
        byArray[42] = 125;
        byArray[43] = 127;
        byArray[44] = -90;
        byArray[45] = 38;
        byArray[46] = 9;
        byArray[47] = 4;
        byArray[48] = 104;
        byArray[49] = 10;
        byArray[50] = -78;
        byArray[51] = -106;
        byArray[52] = -88;
        byArray[53] = -1;
        byArray[54] = -1;
        byArray[55] = -43;
        byArray[56] = -19;
        byArray[57] = 90;
        byArray[58] = 41;
        byArray[60] = -43;
        byArray[61] = 102;
        byArray[62] = 118;
        byArray[63] = -72;
        byArray[64] = -122;
        byArray[65] = 19;
        byArray[66] = -76;
        byArray[67] = 57;
        byArray[68] = -59;
        byArray[69] = -2;
        byArray[70] = 35;
        byArray[71] = 47;
        byArray[72] = 83;
        byArray[73] = 114;
        byArray[74] = 86;
        byArray[75] = -115;
        byArray[76] = -125;
        byArray[77] = 58;
        byArray[78] = 75;
        byArray[79] = 115;
        byArray[80] = -29;
        byArray[81] = -6;
        byArray[82] = 108;
        byArray[83] = 6;
        byArray[84] = -77;
        byArray[85] = -51;
        byArray[86] = 127;
        byArray[87] = -8;
        byArray[88] = -8;
        byArray[89] = -58;
        byArray[90] = -30;
        byArray[91] = -126;
        byArray[92] = 110;
        byArray[93] = -5;
        byArray[94] = -35;
        byArray[95] = -41;
        byArray[96] = -37;
        byArray[97] = 69;
        byArray[98] = 22;
        byArray[99] = -48;
        byArray[100] = 26;
        byArray[101] = 4;
        byArray[102] = -120;
        byArray[103] = -19;
        byArray[104] = -32;
        byArray[105] = -81;
        byArray[106] = -77;
        byArray[107] = 124;
        byArray[108] = -7;
        byArray[109] = -2;
        byArray[110] = -46;
        byArray[111] = -96;
        byArray[112] = 38;
        byArray[113] = -35;
        byArray[114] = 88;
        byArray[115] = 4;
        byArray[116] = -5;
        byArray[117] = 16;
        byArray[118] = 101;
        byArray[119] = 29;
        byArray[120] = 7;
        byArray[121] = 2;
        byArray[122] = 88;
        byArray[123] = 35;
        byArray[124] = -64;
        byArray[125] = 31;
        byArray[126] = -66;
        byArray[127] = -70;
        byArray[128] = 120;
        byArray[129] = -97;
        byArray[130] = 76;
        byArray[131] = -74;
        byArray[132] = -97;
        byArray[133] = -61;
        byArray[134] = 52;
        byArray[135] = -56;
        byArray[136] = 87;
        byArray[137] = -35;
        byArray[138] = 5;
        byArray[139] = 95;
        byArray[140] = -93;
        byArray[141] = -30;
        byArray[142] = 10;
        byArray[143] = 38;
        byArray[144] = 17;
        byArray[145] = -102;
        byArray[146] = -25;
        byArray[147] = 86;
        byArray[148] = 7;
        byArray[149] = -43;
        byArray[150] = 44;
        byArray[151] = -52;
        byArray[152] = -108;
        byArray[153] = 33;
        byArray[154] = -18;
        byArray[155] = -110;
        byArray[156] = -9;
        byArray[157] = -115;
        byArray[158] = 66;
        byArray[159] = -71;
        byArray[160] = 66;
        byArray[161] = 1;
        byArray[162] = -90;
        byArray[163] = -72;
        byArray[164] = 90;
        byArray[165] = -88;
        byArray[166] = -38;
        byArray[167] = 75;
        byArray[168] = 47;
        byArray[169] = -124;
        byArray[170] = -120;
        byArray[171] = -15;
        byArray[172] = -49;
        byArray[173] = -8;
        byArray[174] = 85;
        byArray[175] = 5;
        byArray[176] = 17;
        byArray[177] = -88;
        byArray[178] = 76;
        byArray[179] = 99;
        byArray[180] = -4;
        byArray[181] = 83;
        byArray[182] = 16;
        byArray[183] = -91;
        byArray[184] = 82;
        byArray[185] = 116;
        byArray[186] = 112;
        byArray[187] = -83;
        byArray[188] = 56;
        byArray[189] = -45;
        byArray[190] = -26;
        byArray[191] = 125;
        byArray[192] = 13;
        byArray[193] = -75;
        byArray[194] = -115;
        byArray[195] = 92;
        byArray[196] = -12;
        byArray[197] = -59;
        byArray[198] = 3;
        byArray[199] = -12;
        byArray[200] = 14;
        byArray[201] = -6;
        byArray[202] = 43;
        byArray[203] = -17;
        byArray[204] = 121;
        byArray[205] = 122;
        byArray[206] = 22;
        byArray[207] = 92;
        byArray[208] = -74;
        byArray[209] = 99;
        byArray[210] = -59;
        byArray[211] = -103;
        byArray[212] = 113;
        byArray[213] = 8;
        byArray[214] = -103;
        byArray[215] = 114;
        byArray[216] = 99;
        byArray[217] = -48;
        byArray[218] = 92;
        byArray[219] = -88;
        byArray[220] = 77;
        byArray[221] = 81;
        byArray[222] = 5;
        byArray[223] = 31;
        byArray[224] = -4;
        byArray[225] = -69;
        byArray[226] = -24;
        byArray[227] = 23;
        byArray[228] = 94;
        byArray[229] = 126;
        byArray[230] = 71;
        byArray[231] = 93;
        byArray[232] = 20;
        byArray[233] = 77;
        byArray[234] = 82;
        byArray[235] = -54;
        byArray[236] = -14;
        byArray[237] = 86;
        byArray[238] = 45;
        byArray[239] = -81;
        byArray[241] = 52;
        byArray[242] = -63;
        byArray[243] = -66;
        byArray[244] = 48;
        byArray[245] = 104;
        byArray[246] = -54;
        byArray[247] = 15;
        byArray[248] = -73;
        byArray[249] = -2;
        byArray[250] = -52;
        byArray[251] = 115;
        byArray[252] = 76;
        byArray[253] = 28;
        byArray[254] = -5;
        byArray[255] = -94;
        byArray[256] = -63;
        byArray[257] = 117;
        byArray[258] = -69;
        byArray[260] = 61;
        byArray[261] = 22;
        byArray[262] = -1;
        byArray[263] = 71;
        byArray[264] = -115;
        byArray[265] = 9;
        byArray[266] = -73;
        byArray[267] = -100;
        byArray[268] = -128;
        byArray[269] = -31;
        byArray[270] = 106;
        byArray[271] = -74;
        byArray[272] = -61;
        byArray[273] = -37;
        byArray[274] = 98;
        byArray[275] = -6;
        byArray[276] = 11;
        byArray[277] = -5;
        byArray[278] = 6;
        byArray[279] = -18;
        byArray[280] = -53;
        byArray[281] = -6;
        byArray[282] = 11;
        byArray[283] = -49;
        byArray[284] = 62;
        byArray[285] = 23;
        byArray[286] = 6;
        byArray[287] = -128;
        byArray[288] = 38;
        byArray[289] = -91;
        byArray[290] = 89;
        byArray[291] = -34;
        byArray[292] = 18;
        byArray[293] = -38;
        byArray[294] = -110;
        byArray[295] = -101;
        byArray[296] = 43;
        byArray[297] = 36;
        byArray[298] = 62;
        byArray[299] = 101;
        byArray[300] = 112;
        byArray[301] = 59;
        byArray[302] = -91;
        byArray[303] = 78;
        byArray[304] = -81;
        byArray[305] = 61;
        byArray[306] = 126;
        byArray[307] = -21;
        byArray[308] = -42;
        byArray[309] = -110;
        byArray[310] = -38;
        byArray[311] = -27;
        byArray[312] = 69;
        byArray[313] = 57;
        byArray[314] = 9;
        byArray[315] = 24;
        byArray[316] = -50;
        byArray[317] = -118;
        byArray[318] = 31;
        byArray[319] = -17;
        byArray[320] = 42;
        byArray[321] = 87;
        byArray[322] = -54;
        byArray[323] = 122;
        byArray[324] = -16;
        byArray[325] = 42;
        byArray[326] = -47;
        byArray[327] = -19;
        byArray[328] = -80;
        byArray[329] = 16;
        byArray[330] = 54;
        byArray[331] = -97;
        byArray[332] = -89;
        byArray[333] = 81;
        byArray[334] = -22;
        byArray[335] = -35;
        byArray[336] = 45;
        byArray[337] = 54;
        byArray[338] = -46;
        byArray[339] = 22;
        byArray[340] = -122;
        byArray[341] = -95;
        byArray[342] = -17;
        byArray[343] = 7;
        byArray[344] = -127;
        byArray[345] = 105;
        byArray[346] = -100;
        byArray[347] = -56;
        byArray[348] = -98;
        byArray[349] = -105;
        byArray[350] = 101;
        byArray[351] = -81;
        byArray[352] = 104;
        byArray[353] = 121;
        byArray[354] = -7;
        byArray[355] = 33;
        byArray[356] = 126;
        byArray[357] = 110;
        byArray[358] = -125;
        byArray[359] = -85;
        byArray[360] = 111;
        byArray[361] = -52;
        byArray[362] = 123;
        byArray[363] = -98;
        byArray[364] = 41;
        byArray[365] = -42;
        byArray[366] = 88;
        byArray[367] = -68;
        byArray[368] = -17;
        byArray[369] = 39;
        byArray[370] = -19;
        byArray[371] = -96;
        byArray[372] = -10;
        byArray[373] = -117;
        byArray[374] = 13;
        byArray[375] = -88;
        byArray[376] = -75;
        byArray[377] = -101;
        byArray[378] = -16;
        byArray[379] = -7;
        byArray[380] = 73;
        byArray[381] = 23;
        byArray[382] = -12;
        byArray[383] = 41;
        byArray[384] = -116;
        byArray[385] = -105;
        byArray[386] = -64;
        byArray[387] = -4;
        byArray[388] = 103;
        byArray[389] = 49;
        byArray[390] = -15;
        byArray[391] = -49;
        byArray[392] = 60;
        byArray[393] = 88;
        byArray[394] = -25;
        byArray[395] = -21;
        byArray[396] = 42;
        byArray[397] = 26;
        byArray[398] = 95;
        byArray[399] = -90;
        byArray[400] = -83;
        byArray[401] = -69;
        byArray[402] = 64;
        byArray[403] = -2;
        byArray[404] = 50;
        byArray[405] = -116;
        byArray[406] = -64;
        byArray[407] = 26;
        byArray[408] = -29;
        byArray[409] = -93;
        byArray[410] = -120;
        byArray[411] = -70;
        byArray[412] = 32;
        byArray[413] = -38;
        byArray[414] = 39;
        byArray[415] = -126;
        byArray[416] = -19;
        byArray[417] = 103;
        byArray[418] = 127;
        byArray[419] = 65;
        byArray[420] = 54;
        byArray[421] = 110;
        byArray[422] = 94;
        byArray[423] = 126;
        byArray[424] = -82;
        byArray[425] = -80;
        byArray[426] = -18;
        byArray[427] = 43;
        byArray[428] = 45;
        byArray[429] = 56;
        byArray[430] = -118;
        byArray[431] = 109;
        byArray[432] = 36;
        byArray[433] = -8;
        byArray[434] = 10;
        byArray[435] = 113;
        byArray[436] = 69;
        byArray[437] = 53;
        byArray[438] = -122;
        byArray[439] = -127;
        byArray[440] = 92;
        byArray[441] = -127;
        byArray[442] = -73;
        byArray[443] = 70;
        byArray[444] = -19;
        byArray[445] = -105;
        byArray[446] = -80;
        byArray[447] = -15;
        byArray[448] = -5;
        byArray[449] = 99;
        byArray[450] = -109;
        byArray[451] = -27;
        byArray[452] = 119;
        byArray[453] = -76;
        byArray[454] = -57;
        byArray[455] = -48;
        byArray[456] = 42;
        byArray[457] = -35;
        byArray[458] = 23;
        byArray[459] = 39;
        byArray[460] = -126;
        byArray[461] = 44;
        byArray[462] = -107;
        byArray[463] = -100;
        byArray[464] = -125;
        byArray[465] = 117;
        byArray[466] = -50;
        byArray[467] = 115;
        byArray[468] = -79;
        byArray[469] = -16;
        byArray[470] = 104;
        byArray[471] = 8;
        byArray[472] = -102;
        byArray[473] = 83;
        byArray[474] = -73;
        byArray[475] = 21;
        byArray[476] = -85;
        byArray[477] = 113;
        byArray[478] = -87;
        byArray[479] = -54;
        byArray[480] = 93;
        byArray[481] = 63;
        byArray[482] = -108;
        byArray[483] = -64;
        byArray[484] = 109;
        byArray[485] = -74;
        byArray[486] = 15;
        byArray[487] = 14;
        byArray[488] = -119;
        byArray[489] = -6;
        byArray[490] = -68;
        byArray[491] = 45;
        byArray[492] = 37;
        byArray[493] = -15;
        byArray[494] = -97;
        byArray[495] = -95;
        byArray[496] = -55;
        byArray[497] = 89;
        byArray[498] = 25;
        byArray[499] = -63;
        byArray[500] = -92;
        byArray[501] = -80;
        byArray[502] = -27;
        byArray[503] = -8;
        byArray[504] = 55;
        byArray[505] = 50;
        byArray[506] = 96;
        byArray[507] = -91;
        byArray[508] = 40;
        byArray[509] = -74;
        byArray[510] = 110;
        byArray[511] = -96;
        byArray[512] = 94;
        byArray[513] = 6;
        byArray[514] = 85;
        byArray[515] = 92;
        byArray[517] = 34;
        byArray[518] = -122;
        byArray[519] = 5;
        byArray[520] = -126;
        byArray[521] = 123;
        byArray[522] = 37;
        byArray[523] = -90;
        byArray[524] = -94;
        byArray[525] = 60;
        byArray[526] = 14;
        byArray[527] = 36;
        byArray[528] = 49;
        byArray[529] = -98;
        byArray[530] = -23;
        byArray[531] = 57;
        byArray[532] = 75;
        byArray[533] = 63;
        byArray[534] = 106;
        byArray[535] = -7;
        byArray[536] = -36;
        byArray[537] = -89;
        byArray[538] = 84;
        byArray[539] = 71;
        byArray[540] = 60;
        byArray[541] = -21;
        byArray[542] = 104;
        byArray[543] = -47;
        byArray[544] = 90;
        byArray[545] = -52;
        byArray[546] = -66;
        byArray[547] = 88;
        byArray[548] = -91;
        byArray[549] = -81;
        byArray[550] = -3;
        byArray[551] = 116;
        byArray[552] = 23;
        byArray[553] = 62;
        byArray[554] = -47;
        byArray[555] = -84;
        byArray[556] = -118;
        byArray[557] = 65;
        byArray[558] = 31;
        byArray[559] = 7;
        byArray[560] = -103;
        byArray[561] = 37;
        byArray[562] = -29;
        byArray[563] = 115;
        byArray[564] = -114;
        byArray[565] = 73;
        byArray[566] = 12;
        byArray[567] = -121;
        byArray[568] = 96;
        byArray[569] = -91;
        byArray[570] = -7;
        byArray[571] = 56;
        byArray[572] = 10;
        byArray[573] = -72;
        byArray[574] = 27;
        byArray[575] = -45;
        byArray[576] = 122;
        byArray[577] = -27;
        byArray[578] = -38;
        byArray[579] = 74;
        byArray[580] = 64;
        byArray[581] = 30;
        byArray[582] = -60;
        byArray[583] = 64;
        byArray[584] = -21;
        byArray[585] = 48;
        byArray[586] = 101;
        byArray[587] = 113;
        byArray[588] = 126;
        byArray[589] = -60;
        byArray[590] = -103;
        byArray[591] = 71;
        byArray[592] = 100;
        byArray[593] = -117;
        byArray[594] = 124;
        byArray[595] = -125;
        byArray[596] = 116;
        byArray[597] = 78;
        byArray[598] = 114;
        byArray[599] = -74;
        byArray[600] = 42;
        byArray[601] = -81;
        byArray[602] = -54;
        byArray[603] = 34;
        byArray[604] = 33;
        byArray[605] = -10;
        byArray[606] = 19;
        byArray[607] = 23;
        byArray[608] = 24;
        byArray[609] = 40;
        byArray[611] = -8;
        byArray[612] = 78;
        byArray[613] = 100;
        byArray[614] = 73;
        byArray[615] = -88;
        byArray[616] = -95;
        byArray[617] = -62;
        byArray[618] = -115;
        byArray[619] = -18;
        byArray[620] = 47;
        byArray[621] = 10;
        byArray[622] = -14;
        byArray[623] = -39;
        byArray[624] = 82;
        byArray[625] = 27;
        byArray[626] = -9;
        byArray[627] = -115;
        byArray[628] = -70;
        byArray[629] = 92;
        byArray[630] = -6;
        byArray[631] = 39;
        byArray[632] = 45;
        byArray[633] = -71;
        byArray[634] = -109;
        byArray[635] = -41;
        byArray[636] = 94;
        byArray[637] = -88;
        byArray[638] = -63;
        byArray[639] = 19;
        byArray[640] = -58;
        byArray[641] = -37;
        byArray[642] = -31;
        byArray[643] = 1;
        byArray[644] = 127;
        byArray[645] = -42;
        byArray[646] = 125;
        byArray[647] = -120;
        byArray[648] = -57;
        byArray[649] = 120;
        byArray[650] = -86;
        byArray[651] = -6;
        byArray[652] = 17;
        byArray[653] = -27;
        byArray[654] = -37;
        byArray[655] = 47;
        byArray[656] = 55;
        byArray[657] = -22;
        byArray[658] = -11;
        byArray[659] = -31;
        byArray[660] = 38;
        byArray[661] = -1;
        byArray[662] = 29;
        byArray[663] = 56;
        byArray[664] = -34;
        byArray[665] = -104;
        byArray[666] = -66;
        byArray[667] = -62;
        byArray[668] = 72;
        byArray[669] = -11;
        byArray[670] = -30;
        byArray[671] = -30;
        byArray[672] = 61;
        byArray[673] = -31;
        byArray[674] = 10;
        byArray[675] = -63;
        byArray[676] = 116;
        byArray[677] = -84;
        byArray[678] = 118;
        byArray[679] = -127;
        byArray[680] = 6;
        byArray[681] = 17;
        byArray[682] = -36;
        byArray[683] = 91;
        byArray[684] = 123;
        byArray[685] = 77;
        byArray[686] = 35;
        byArray[687] = 22;
        byArray[688] = 110;
        byArray[689] = 114;
        byArray[690] = 107;
        byArray[691] = -3;
        byArray[692] = 52;
        byArray[693] = 11;
        byArray[694] = 86;
        byArray[695] = 68;
        byArray[696] = -56;
        byArray[698] = 119;
        byArray[699] = -43;
        byArray[700] = -73;
        byArray[701] = 112;
        byArray[702] = 89;
        byArray[703] = -4;
        byArray[704] = -122;
        byArray[705] = -71;
        byArray[706] = -26;
        byArray[707] = 103;
        byArray[708] = -118;
        byArray[709] = -61;
        byArray[710] = -112;
        byArray[711] = -108;
        byArray[712] = -44;
        byArray[713] = -25;
        byArray[714] = -22;
        byArray[715] = 4;
        byArray[716] = 24;
        byArray[717] = 53;
        byArray[718] = -5;
        byArray[719] = -71;
        byArray[720] = 9;
        byArray[721] = -41;
        byArray[722] = 84;
        byArray[723] = -28;
        byArray[724] = 22;
        byArray[725] = 99;
        byArray[726] = 39;
        byArray[727] = -26;
        byArray[728] = -2;
        byArray[729] = -51;
        byArray[730] = 68;
        byArray[731] = 63;
        byArray[732] = -15;
        byArray[733] = 99;
        byArray[734] = 66;
        byArray[735] = -78;
        byArray[736] = 46;
        byArray[737] = -89;
        byArray[738] = 21;
        byArray[739] = -38;
        byArray[740] = -114;
        byArray[741] = -51;
        byArray[742] = 100;
        byArray[743] = -59;
        byArray[744] = 84;
        byArray[745] = -76;
        byArray[746] = -105;
        byArray[747] = 51;
        byArray[748] = 28;
        byArray[749] = 19;
        byArray[750] = 74;
        byArray[751] = 42;
        byArray[752] = 91;
        byArray[753] = -73;
        byArray[754] = 12;
        byArray[755] = -89;
        byArray[756] = -128;
        byArray[757] = 34;
        byArray[758] = 38;
        byArray[759] = -100;
        byArray[760] = 121;
        byArray[761] = -78;
        byArray[762] = 114;
        byArray[763] = -28;
        byArray[764] = 127;
        byArray[765] = -29;
        byArray[766] = 50;
        byArray[767] = 105;
        byArray[768] = -6;
        byArray[769] = 36;
        byArray[770] = 98;
        byArray[771] = -35;
        byArray[772] = 79;
        byArray[773] = -58;
        byArray[774] = 5;
        byArray[775] = -13;
        byArray[776] = -86;
        byArray[777] = -101;
        byArray[778] = -108;
        byArray[779] = -99;
        byArray[780] = -70;
        byArray[781] = 25;
        byArray[782] = 103;
        byArray[783] = 63;
        byArray[784] = 57;
        byArray[785] = 79;
        byArray[786] = -12;
        byArray[787] = -63;
        byArray[788] = 125;
        byArray[789] = -54;
        byArray[790] = 61;
        byArray[791] = 15;
        byArray[792] = 6;
        byArray[793] = -79;
        byArray[794] = 90;
        byArray[795] = 76;
        byArray[796] = 103;
        byArray[797] = -45;
        byArray[798] = 7;
        byArray[799] = 39;
        byArray[800] = 93;
        byArray[801] = 107;
        byArray[802] = 58;
        byArray[803] = 76;
        byArray[804] = 80;
        byArray[805] = 56;
        byArray[806] = -108;
        byArray[807] = 55;
        byArray[808] = -22;
        byArray[809] = 36;
        byArray[810] = 125;
        byArray[811] = -91;
        byArray[812] = -65;
        byArray[813] = 11;
        byArray[814] = 69;
        byArray[815] = 10;
        byArray[816] = -19;
        byArray[817] = -14;
        byArray[818] = -4;
        byArray[819] = -26;
        byArray[820] = -36;
        byArray[821] = 114;
        byArray[822] = 124;
        byArray[823] = 63;
        byArray[824] = -31;
        byArray[825] = 88;
        byArray[826] = 92;
        byArray[827] = 108;
        byArray[828] = 33;
        byArray[829] = -52;
        byArray[830] = -22;
        byArray[831] = 80;
        byArray[832] = -65;
        byArray[833] = 57;
        byArray[834] = 126;
        byArray[835] = 43;
        byArray[836] = -13;
        byArray[837] = 122;
        byArray[838] = -8;
        byArray[839] = 68;
        byArray[840] = 72;
        byArray[841] = 92;
        byArray[842] = -50;
        byArray[843] = 100;
        byArray[844] = -91;
        byArray[845] = 1;
        byArray[846] = -81;
        byArray[847] = 75;
        byArray[848] = 95;
        byArray[849] = -11;
        byArray[850] = -99;
        byArray[851] = 38;
        byArray[852] = 121;
        byArray[853] = -20;
        byArray[854] = -70;
        byArray[855] = 82;
        byArray[856] = -125;
        byArray[857] = -94;
        byArray[858] = -18;
        byArray[859] = 16;
        byArray[860] = 59;
        byArray[861] = 89;
        byArray[862] = 18;
        byArray[863] = -96;
        byArray[864] = 91;
        byArray[865] = -97;
        byArray[866] = 62;
        byArray[867] = -96;
        byArray[868] = 127;
        byArray[869] = 45;
        byArray[870] = 70;
        byArray[871] = 16;
        byArray[872] = 84;
        byArray[873] = -43;
        byArray[874] = -75;
        byArray[875] = -118;
        byArray[876] = 81;
        byArray[877] = 58;
        byArray[878] = 84;
        byArray[879] = -115;
        byArray[880] = -120;
        byArray[881] = -3;
        byArray[882] = 41;
        byArray[883] = -103;
        byArray[884] = -70;
        byArray[885] = 123;
        byArray[886] = 26;
        byArray[887] = 101;
        byArray[888] = 33;
        byArray[889] = 58;
        byArray[890] = 13;
        byArray[891] = -11;
        byArray[892] = -73;
        byArray[893] = -84;
        byArray[894] = -47;
        byArray[895] = -7;
        byArray[896] = 81;
        byArray[897] = -63;
        byArray[898] = 60;
        byArray[899] = -45;
        byArray[900] = 30;
        byArray[901] = 100;
        byArray[902] = -51;
        byArray[903] = -15;
        byArray[904] = 73;
        byArray[905] = 58;
        byArray[906] = -119;
        byArray[907] = -3;
        byArray[908] = 62;
        byArray[909] = -63;
        byArray[910] = -17;
        byArray[911] = -69;
        byArray[912] = -44;
        byArray[913] = 60;
        byArray[914] = -54;
        byArray[915] = -115;
        byArray[916] = -59;
        byArray[917] = 23;
        byArray[918] = -59;
        byArray[919] = 98;
        byArray[920] = -89;
        byArray[921] = -72;
        byArray[922] = 20;
        byArray[923] = -96;
        byArray[924] = 27;
        byArray[925] = 53;
        byArray[926] = -89;
        byArray[927] = 59;
        byArray[928] = -85;
        byArray[929] = -29;
        byArray[930] = 120;
        byArray[931] = 23;
        byArray[932] = 62;
        byArray[933] = 8;
        byArray[934] = -86;
        byArray[935] = 113;
        byArray[936] = 87;
        byArray[937] = -15;
        byArray[938] = 102;
        byArray[939] = 106;
        byArray[940] = -104;
        byArray[941] = 57;
        byArray[942] = -57;
        byArray[943] = 37;
        byArray[944] = 110;
        byArray[945] = 118;
        byArray[946] = 109;
        byArray[947] = 25;
        byArray[948] = 64;
        byArray[949] = 26;
        byArray[950] = -20;
        byArray[951] = -86;
        byArray[952] = -2;
        byArray[953] = 60;
        byArray[954] = -70;
        byArray[955] = -33;
        byArray[956] = 67;
        byArray[957] = 13;
        byArray[958] = -28;
        byArray[959] = -29;
        byArray[960] = -63;
        byArray[961] = -37;
        byArray[962] = 67;
        byArray[963] = 99;
        byArray[964] = 84;
        byArray[965] = 121;
        byArray[966] = -126;
        byArray[967] = -38;
        byArray[968] = 45;
        byArray[969] = 24;
        byArray[970] = 122;
        byArray[971] = 51;
        byArray[972] = 11;
        byArray[973] = -19;
        byArray[974] = -80;
        byArray[975] = 26;
        byArray[976] = -106;
        byArray[977] = -95;
        byArray[978] = 82;
        byArray[979] = 69;
        byArray[980] = -2;
        byArray[981] = -75;
        byArray[982] = 62;
        byArray[983] = 106;
        byArray[984] = -120;
        byArray[985] = 87;
        byArray[986] = -107;
        byArray[987] = 87;
        byArray[988] = 17;
        byArray[989] = 102;
        byArray[990] = -52;
        byArray[991] = -16;
        byArray[992] = 22;
        byArray[993] = 12;
        byArray[994] = -86;
        byArray[995] = -48;
        byArray[996] = -95;
        byArray[997] = -61;
        byArray[998] = 109;
        byArray[999] = 64;
        byArray[1000] = -29;
        byArray[1001] = 111;
        byArray[1002] = 40;
        byArray[1003] = -90;
        byArray[1004] = -35;
        byArray[1005] = 49;
        byArray[1006] = 88;
        byArray[1007] = -15;
        byArray[1008] = 122;
        byArray[1009] = 127;
        byArray[1010] = 87;
        byArray[1011] = 113;
        byArray[1012] = 116;
        byArray[1013] = 93;
        byArray[1014] = 100;
        byArray[1015] = 28;
        byArray[1016] = -70;
        byArray[1017] = -87;
        byArray[1018] = -40;
        byArray[1019] = -1;
        byArray[1020] = -126;
        byArray[1021] = -114;
        byArray[1022] = 7;
        byArray[1023] = 79;
        byArray[1024] = 16;
        byArray[1025] = 2;
        byArray[1026] = -47;
        byArray[1027] = -98;
        byArray[1028] = -102;
        byArray[1029] = 49;
        byArray[1030] = 58;
        byArray[1031] = 61;
        byArray[1032] = -32;
        byArray[1033] = 44;
        byArray[1034] = 18;
        byArray[1035] = -26;
        byArray[1036] = 37;
        byArray[1037] = 27;
        byArray[1038] = -123;
        byArray[1039] = -76;
        byArray[1040] = 56;
        byArray[1041] = 91;
        byArray[1042] = 51;
        byArray[1043] = -21;
        byArray[1044] = -48;
        byArray[1045] = -122;
        byArray[1046] = -33;
        byArray[1047] = 40;
        byArray[1048] = -8;
        byArray[1049] = -62;
        byArray[1050] = -56;
        byArray[1051] = -126;
        byArray[1052] = 91;
        byArray[1053] = -51;
        byArray[1054] = 76;
        byArray[1055] = -29;
        byArray[1056] = 127;
        byArray[1057] = -22;
        byArray[1058] = -18;
        byArray[1059] = -110;
        byArray[1060] = 27;
        byArray[1061] = 13;
        byArray[1062] = -111;
        byArray[1063] = 81;
        byArray[1064] = 51;
        byArray[1065] = -104;
        byArray[1066] = 70;
        byArray[1067] = 98;
        byArray[1068] = 12;
        byArray[1069] = 120;
        byArray[1070] = -7;
        byArray[1071] = 15;
        byArray[1072] = 104;
        byArray[1073] = -43;
        byArray[1074] = -104;
        byArray[1075] = 124;
        byArray[1076] = 46;
        byArray[1077] = 116;
        byArray[1078] = 7;
        byArray[1079] = -26;
        byArray[1080] = 21;
        byArray[1081] = 33;
        byArray[1082] = 105;
        byArray[1083] = 17;
        byArray[1084] = -99;
        byArray[1085] = -42;
        byArray[1086] = -106;
        byArray[1087] = 8;
        byArray[1088] = -85;
        byArray[1089] = 39;
        byArray[1090] = 8;
        byArray[1091] = 79;
        byArray[1092] = -54;
        byArray[1093] = -81;
        byArray[1094] = 109;
        byArray[1095] = 40;
        byArray[1096] = 25;
        byArray[1097] = 29;
        byArray[1098] = -18;
        byArray[1099] = -90;
        byArray[1100] = 22;
        byArray[1101] = 85;
        byArray[1102] = -12;
        byArray[1103] = -16;
        byArray[1104] = 61;
        byArray[1105] = 49;
        byArray[1106] = -31;
        byArray[1107] = 127;
        byArray[1108] = 64;
        byArray[1109] = 5;
        byArray[1110] = 25;
        byArray[1111] = 39;
        byArray[1112] = -65;
        byArray[1113] = -42;
        byArray[1114] = 13;
        byArray[1115] = -97;
        byArray[1116] = -92;
        byArray[1117] = 36;
        byArray[1118] = -126;
        byArray[1119] = -18;
        byArray[1120] = -4;
        byArray[1121] = -22;
        byArray[1122] = -14;
        byArray[1123] = 109;
        byArray[1124] = -93;
        byArray[1125] = -76;
        byArray[1126] = -5;
        byArray[1127] = 13;
        byArray[1128] = 74;
        byArray[1129] = 44;
        byArray[1130] = 103;
        byArray[1131] = 79;
        byArray[1132] = 110;
        byArray[1133] = 85;
        byArray[1134] = 58;
        byArray[1135] = 39;
        byArray[1136] = -24;
        byArray[1137] = 119;
        byArray[1138] = 120;
        byArray[1139] = 122;
        byArray[1140] = 120;
        byArray[1141] = 43;
        byArray[1142] = 110;
        byArray[1143] = 67;
        byArray[1144] = 21;
        byArray[1145] = 47;
        byArray[1146] = 39;
        byArray[1147] = -48;
        byArray[1148] = 7;
        byArray[1149] = 91;
        byArray[1150] = -51;
        byArray[1151] = 126;
        byArray[1152] = 100;
        byArray[1153] = -38;
        byArray[1154] = -124;
        byArray[1156] = -97;
        byArray[1157] = 99;
        byArray[1158] = -123;
        byArray[1159] = 118;
        byArray[1160] = -27;
        byArray[1161] = 8;
        byArray[1162] = 102;
        byArray[1163] = -106;
        byArray[1164] = -23;
        byArray[1165] = -53;
        byArray[1166] = -4;
        byArray[1167] = -56;
        byArray[1168] = -9;
        byArray[1169] = -126;
        byArray[1170] = -85;
        byArray[1171] = 93;
        byArray[1172] = -4;
        byArray[1173] = -5;
        byArray[1174] = 4;
        byArray[1175] = 49;
        byArray[1176] = 29;
        byArray[1177] = 2;
        byArray[1178] = 63;
        byArray[1179] = 78;
        byArray[1180] = -32;
        byArray[1181] = -106;
        byArray[1182] = 118;
        byArray[1183] = 111;
        byArray[1184] = 52;
        byArray[1185] = 54;
        byArray[1186] = 74;
        byArray[1187] = 53;
        byArray[1188] = 106;
        byArray[1189] = 39;
        byArray[1190] = -95;
        byArray[1191] = -38;
        byArray[1192] = -18;
        byArray[1193] = 118;
        byArray[1194] = -5;
        byArray[1195] = 94;
        byArray[1196] = -83;
        byArray[1197] = -97;
        byArray[1198] = -27;
        byArray[1199] = 62;
        byArray[1200] = -56;
        byArray[1201] = -90;
        byArray[1202] = -36;
        byArray[1203] = 43;
        byArray[1204] = 43;
        byArray[1205] = -113;
        byArray[1206] = 119;
        byArray[1207] = -89;
        byArray[1208] = 44;
        byArray[1209] = -108;
        byArray[1210] = -46;
        byArray[1211] = 66;
        byArray[1212] = 28;
        byArray[1213] = 66;
        byArray[1214] = -38;
        byArray[1215] = 3;
        byArray[1216] = -62;
        byArray[1217] = -83;
        byArray[1218] = -35;
        byArray[1219] = -127;
        byArray[1220] = -2;
        byArray[1221] = 51;
        byArray[1222] = 104;
        byArray[1223] = 105;
        byArray[1224] = 40;
        byArray[1225] = 76;
        byArray[1226] = -10;
        byArray[1227] = -124;
        byArray[1228] = -95;
        byArray[1229] = 52;
        byArray[1230] = 11;
        byArray[1231] = 101;
        byArray[1232] = -32;
        byArray[1233] = -122;
        byArray[1234] = -73;
        byArray[1235] = -17;
        byArray[1236] = 37;
        byArray[1237] = -126;
        byArray[1238] = 68;
        byArray[1239] = -126;
        byArray[1240] = 55;
        byArray[1241] = 112;
        byArray[1242] = -126;
        byArray[1243] = 38;
        byArray[1244] = 99;
        byArray[1245] = -63;
        byArray[1246] = 123;
        byArray[1247] = -74;
        byArray[1248] = -31;
        byArray[1249] = 58;
        byArray[1250] = 8;
        byArray[1251] = 93;
        byArray[1252] = -68;
        byArray[1253] = 111;
        byArray[1254] = -22;
        byArray[1255] = -24;
        byArray[1256] = -23;
        byArray[1257] = 9;
        byArray[1258] = -87;
        byArray[1259] = -25;
        byArray[1260] = -115;
        byArray[1261] = 81;
        byArray[1262] = -116;
        byArray[1263] = -91;
        byArray[1264] = 60;
        byArray[1265] = 96;
        byArray[1266] = -102;
        byArray[1267] = -1;
        byArray[1268] = -7;
        byArray[1269] = 73;
        byArray[1270] = 99;
        byArray[1271] = 46;
        byArray[1272] = -78;
        byArray[1273] = 62;
        byArray[1274] = 48;
        byArray[1275] = -116;
        byArray[1276] = -52;
        byArray[1277] = -44;
        byArray[1278] = -5;
        byArray[1279] = 82;
        byArray[1280] = -45;
        byArray[1281] = 5;
        byArray[1282] = -55;
        byArray[1283] = -101;
        byArray[1284] = 101;
        byArray[1285] = 65;
        byArray[1286] = -109;
        byArray[1287] = -108;
        byArray[1288] = 26;
        byArray[1289] = 98;
        byArray[1290] = -55;
        byArray[1291] = 11;
        byArray[1292] = -86;
        byArray[1293] = 57;
        byArray[1294] = 30;
        byArray[1295] = 92;
        byArray[1296] = -58;
        byArray[1297] = 20;
        byArray[1298] = 82;
        byArray[1299] = 65;
        byArray[1300] = 103;
        byArray[1301] = 27;
        byArray[1302] = -64;
        byArray[1303] = 76;
        byArray[1304] = 123;
        byArray[1305] = -56;
        byArray[1306] = -16;
        byArray[1307] = -111;
        byArray[1308] = -83;
        byArray[1309] = 125;
        byArray[1310] = 65;
        byArray[1311] = 111;
        byArray[1312] = 9;
        byArray[1313] = 123;
        byArray[1314] = 14;
        byArray[1315] = 119;
        byArray[1316] = 126;
        byArray[1317] = -80;
        byArray[1318] = 79;
        byArray[1319] = 94;
        byArray[1320] = -19;
        byArray[1321] = 66;
        byArray[1322] = -25;
        byArray[1323] = 35;
        byArray[1324] = 112;
        byArray[1325] = -64;
        byArray[1326] = 10;
        byArray[1327] = -66;
        byArray[1328] = -86;
        byArray[1329] = 51;
        byArray[1330] = 56;
        byArray[1331] = -78;
        byArray[1332] = 103;
        byArray[1333] = 92;
        byArray[1334] = -116;
        byArray[1335] = 8;
        byArray[1336] = 75;
        byArray[1337] = 41;
        byArray[1338] = -49;
        byArray[1339] = -79;
        byArray[1340] = -53;
        byArray[1341] = 125;
        byArray[1342] = -32;
        byArray[1343] = -76;
        byArray[1344] = -27;
        byArray[1345] = 59;
        byArray[1346] = -8;
        byArray[1347] = -4;
        byArray[1348] = -94;
        byArray[1349] = -104;
        byArray[1350] = -15;
        byArray[1351] = 79;
        byArray[1352] = -7;
        byArray[1353] = -124;
        byArray[1354] = 32;
        byArray[1355] = -87;
        byArray[1356] = -104;
        byArray[1357] = 85;
        byArray[1358] = -118;
        byArray[1359] = -36;
        byArray[1360] = 125;
        byArray[1361] = 65;
        byArray[1362] = 111;
        byArray[1363] = -105;
        byArray[1364] = 5;
        byArray[1365] = -105;
        byArray[1366] = 40;
        byArray[1367] = -50;
        byArray[1368] = 2;
        byArray[1369] = 118;
        byArray[1370] = 123;
        byArray[1371] = -54;
        byArray[1372] = 59;
        byArray[1373] = -22;
        byArray[1374] = 94;
        byArray[1375] = 20;
        byArray[1376] = 99;
        byArray[1377] = -87;
        byArray[1378] = -27;
        byArray[1379] = 28;
        byArray[1380] = -30;
        byArray[1381] = -109;
        byArray[1382] = 72;
        byArray[1383] = -19;
        byArray[1384] = 92;
        byArray[1385] = 60;
        byArray[1386] = 19;
        byArray[1387] = 115;
        byArray[1388] = 47;
        byArray[1389] = 96;
        byArray[1390] = -96;
        byArray[1391] = 10;
        byArray[1392] = -74;
        byArray[1393] = 60;
        byArray[1394] = 96;
        byArray[1395] = -86;
        byArray[1396] = 101;
        byArray[1397] = 101;
        byArray[1398] = 68;
        byArray[1399] = -44;
        byArray[1400] = -72;
        byArray[1401] = 9;
        byArray[1402] = -36;
        byArray[1403] = 126;
        byArray[1404] = 96;
        byArray[1405] = -45;
        byArray[1406] = -12;
        byArray[1407] = 9;
        byArray[1408] = 14;
        byArray[1409] = -15;
        byArray[1410] = 79;
        byArray[1411] = -79;
        byArray[1412] = -48;
        byArray[1413] = 8;
        byArray[1414] = -107;
        byArray[1415] = -81;
        byArray[1416] = 47;
        byArray[1417] = 35;
        byArray[1418] = -36;
        byArray[1419] = -107;
        byArray[1420] = -120;
        byArray[1421] = -36;
        byArray[1422] = -124;
        byArray[1423] = 37;
        byArray[1424] = 103;
        byArray[1425] = -60;
        byArray[1426] = -35;
        byArray[1427] = -74;
        byArray[1428] = 100;
        byArray[1429] = -38;
        byArray[1430] = -88;
        byArray[1431] = -99;
        byArray[1432] = -99;
        byArray[1433] = -94;
        byArray[1434] = -107;
        byArray[1435] = 79;
        byArray[1436] = 115;
        byArray[1437] = 108;
        byArray[1438] = 54;
        byArray[1439] = 119;
        byArray[1440] = 73;
        byArray[1441] = 84;
        byArray[1442] = 110;
        byArray[1443] = -74;
        byArray[1444] = 92;
        byArray[1445] = 57;
        byArray[1446] = 108;
        byArray[1447] = 80;
        byArray[1448] = 47;
        byArray[1449] = -36;
        byArray[1450] = -119;
        byArray[1451] = -115;
        byArray[1452] = 58;
        byArray[1453] = -62;
        byArray[1454] = -4;
        byArray[1455] = -97;
        byArray[1456] = 43;
        byArray[1457] = -98;
        byArray[1458] = 5;
        byArray[1459] = 112;
        byArray[1460] = 47;
        byArray[1461] = 59;
        byArray[1462] = -89;
        byArray[1463] = 82;
        byArray[1464] = -69;
        byArray[1465] = -103;
        byArray[1466] = 39;
        byArray[1467] = -29;
        byArray[1468] = 75;
        byArray[1469] = -9;
        byArray[1470] = -94;
        byArray[1471] = -72;
        byArray[1472] = 99;
        byArray[1473] = -64;
        byArray[1474] = 22;
        byArray[1475] = -10;
        byArray[1476] = 21;
        byArray[1477] = 89;
        byArray[1478] = 101;
        byArray[1479] = 21;
        byArray[1480] = 94;
        byArray[1481] = -30;
        byArray[1482] = -17;
        byArray[1483] = 73;
        byArray[1484] = -36;
        byArray[1485] = -68;
        byArray[1486] = -89;
        byArray[1487] = -91;
        byArray[1488] = -94;
        byArray[1489] = 99;
        byArray[1490] = -106;
        byArray[1491] = 119;
        byArray[1492] = -116;
        byArray[1493] = 123;
        byArray[1494] = -19;
        byArray[1495] = 54;
        byArray[1496] = -99;
        byArray[1497] = 64;
        byArray[1498] = -119;
        byArray[1499] = 82;
        byArray[1500] = 120;
        byArray[1501] = -106;
        byArray[1502] = -99;
        byArray[1503] = 80;
        byArray[1504] = 69;
        byArray[1505] = 29;
        byArray[1506] = -48;
        byArray[1507] = 77;
        byArray[1508] = 28;
        byArray[1509] = 13;
        byArray[1510] = 92;
        byArray[1511] = -107;
        byArray[1512] = -77;
        byArray[1513] = 94;
        byArray[1514] = -116;
        byArray[1515] = 108;
        byArray[1516] = 89;
        byArray[1517] = -115;
        byArray[1518] = 96;
        byArray[1519] = -41;
        byArray[1520] = 25;
        byArray[1521] = 99;
        byArray[1522] = -65;
        byArray[1523] = 118;
        byArray[1524] = -5;
        byArray[1525] = -16;
        byArray[1526] = 48;
        byArray[1527] = -122;
        byArray[1528] = 5;
        byArray[1529] = 50;
        byArray[1530] = -123;
        byArray[1531] = -115;
        byArray[1532] = 13;
        byArray[1533] = 24;
        byArray[1534] = 7;
        byArray[1535] = 15;
        byArray[1536] = -103;
        byArray[1537] = -62;
        byArray[1538] = -71;
        byArray[1539] = 92;
        byArray[1540] = -82;
        byArray[1541] = -5;
        byArray[1542] = -70;
        byArray[1543] = 49;
        byArray[1544] = -6;
        byArray[1545] = -51;
        byArray[1546] = -17;
        byArray[1547] = -47;
        byArray[1548] = 12;
        byArray[1549] = 46;
        byArray[1550] = -86;
        byArray[1551] = 30;
        byArray[1552] = 93;
        byArray[1553] = 84;
        byArray[1554] = -101;
        byArray[1555] = 43;
        byArray[1556] = -92;
        byArray[1557] = -87;
        byArray[1558] = -118;
        byArray[1559] = -110;
        byArray[1560] = -32;
        byArray[1561] = 52;
        byArray[1562] = 115;
        byArray[1563] = -4;
        byArray[1564] = 36;
        byArray[1565] = -2;
        byArray[1566] = -79;
        byArray[1567] = -69;
        byArray[1568] = -46;
        byArray[1569] = -110;
        byArray[1570] = 70;
        byArray[1571] = -82;
        byArray[1572] = 6;
        byArray[1573] = 21;
        byArray[1574] = -27;
        byArray[1575] = -11;
        byArray[1576] = 94;
        byArray[1577] = 42;
        byArray[1578] = -81;
        byArray[1579] = -96;
        byArray[1580] = 116;
        byArray[1581] = -102;
        byArray[1582] = -38;
        byArray[1583] = 36;
        byArray[1584] = 32;
        byArray[1585] = 91;
        byArray[1586] = 28;
        byArray[1587] = 80;
        byArray[1588] = -45;
        byArray[1589] = 116;
        byArray[1590] = -94;
        byArray[1591] = -33;
        byArray[1592] = -5;
        byArray[1593] = -102;
        byArray[1594] = 64;
        byArray[1595] = -96;
        byArray[1596] = 27;
        byArray[1597] = -2;
        byArray[1598] = 100;
        byArray[1599] = -126;
        byArray[1600] = 59;
        byArray[1601] = -71;
        byArray[1602] = 33;
        byArray[1603] = -36;
        byArray[1604] = -124;
        byArray[1605] = 123;
        byArray[1606] = 99;
        byArray[1607] = -76;
        byArray[1608] = 108;
        byArray[1609] = 127;
        byArray[1610] = -11;
        byArray[1611] = -24;
        byArray[1612] = -19;
        byArray[1613] = 84;
        byArray[1614] = -6;
        byArray[1615] = 19;
        byArray[1616] = 105;
        byArray[1617] = -19;
        byArray[1618] = -18;
        byArray[1619] = 120;
        byArray[1620] = -14;
        byArray[1621] = 23;
        byArray[1622] = 39;
        byArray[1623] = 54;
        byArray[1624] = 87;
        byArray[1625] = 105;
        byArray[1626] = 58;
        byArray[1627] = -95;
        byArray[1628] = -15;
        byArray[1629] = 127;
        byArray[1630] = -65;
        byArray[1631] = 114;
        byArray[1632] = 49;
        byArray[1633] = 4;
        byArray[1634] = -66;
        byArray[1635] = 32;
        byArray[1636] = -7;
        byArray[1637] = 84;
        byArray[1638] = 43;
        byArray[1639] = -103;
        byArray[1640] = 76;
        byArray[1641] = 11;
        byArray[1642] = 36;
        byArray[1643] = -68;
        byArray[1644] = -3;
        byArray[1645] = -98;
        byArray[1646] = -5;
        byArray[1647] = -43;
        byArray[1648] = 35;
        byArray[1649] = -48;
        byArray[1650] = 20;
        byArray[1651] = -40;
        byArray[1652] = -33;
        byArray[1653] = -123;
        byArray[1654] = 1;
        byArray[1655] = -54;
        byArray[1656] = -44;
        byArray[1657] = 99;
        byArray[1658] = -68;
        byArray[1659] = 8;
        byArray[1660] = -100;
        byArray[1661] = 97;
        byArray[1662] = -49;
        byArray[1663] = -10;
        byArray[1664] = 110;
        byArray[1665] = 49;
        byArray[1666] = 84;
        byArray[1667] = 46;
        byArray[1668] = -85;
        byArray[1669] = 98;
        byArray[1670] = -103;
        byArray[1671] = -58;
        byArray[1672] = -4;
        byArray[1673] = 104;
        byArray[1674] = -100;
        byArray[1675] = -40;
        byArray[1676] = -79;
        byArray[1677] = 67;
        byArray[1678] = -20;
        byArray[1679] = -95;
        byArray[1680] = 85;
        byArray[1681] = 51;
        byArray[1682] = 73;
        byArray[1683] = 10;
        byArray[1684] = -25;
        byArray[1685] = 102;
        byArray[1686] = 68;
        byArray[1687] = -97;
        byArray[1688] = -83;
        byArray[1689] = -39;
        byArray[1690] = 35;
        byArray[1691] = 2;
        byArray[1692] = -111;
        byArray[1693] = 71;
        byArray[1694] = 62;
        byArray[1695] = -89;
        byArray[1696] = 20;
        byArray[1697] = 25;
        byArray[1698] = -126;
        byArray[1699] = 17;
        byArray[1700] = -81;
        byArray[1701] = -29;
        byArray[1702] = 39;
        byArray[1703] = -27;
        byArray[1704] = -55;
        byArray[1705] = 55;
        byArray[1706] = -122;
        byArray[1707] = 97;
        byArray[1708] = 23;
        byArray[1709] = -99;
        byArray[1710] = 55;
        byArray[1711] = 86;
        byArray[1712] = 33;
        byArray[1713] = -9;
        byArray[1714] = 8;
        byArray[1715] = 55;
        byArray[1716] = -40;
        byArray[1717] = -84;
        byArray[1718] = 39;
        byArray[1719] = 38;
        byArray[1720] = 37;
        byArray[1721] = -29;
        byArray[1722] = 87;
        byArray[1723] = 113;
        byArray[1724] = -118;
        byArray[1725] = -26;
        byArray[1726] = 123;
        byArray[1727] = -95;
        byArray[1728] = 24;
        byArray[1729] = -126;
        byArray[1730] = 119;
        byArray[1731] = -94;
        byArray[1732] = 17;
        byArray[1733] = 83;
        byArray[1734] = -43;
        byArray[1735] = 10;
        byArray[1736] = 63;
        byArray[1737] = -98;
        byArray[1738] = 72;
        byArray[1739] = 8;
        byArray[1740] = 16;
        byArray[1741] = -95;
        byArray[1742] = -96;
        byArray[1743] = 119;
        byArray[1744] = -91;
        byArray[1745] = 6;
        byArray[1746] = 71;
        byArray[1747] = -60;
        byArray[1748] = 1;
        byArray[1749] = -77;
        byArray[1750] = 4;
        byArray[1751] = 53;
        byArray[1752] = -121;
        byArray[1753] = 55;
        byArray[1754] = 7;
        byArray[1755] = 36;
        byArray[1756] = -86;
        byArray[1757] = -49;
        byArray[1758] = -118;
        byArray[1759] = -121;
        byArray[1760] = 56;
        byArray[1761] = 84;
        byArray[1762] = -49;
        byArray[1763] = -57;
        byArray[1764] = -99;
        byArray[1765] = 3;
        byArray[1766] = -68;
        byArray[1767] = 37;
        byArray[1768] = -108;
        byArray[1769] = -72;
        byArray[1770] = 114;
        byArray[1771] = -74;
        byArray[1772] = 120;
        byArray[1773] = 3;
        byArray[1774] = 121;
        byArray[1775] = -28;
        byArray[1776] = -106;
        byArray[1777] = 54;
        byArray[1778] = -20;
        byArray[1779] = 63;
        byArray[1780] = -121;
        byArray[1781] = -85;
        byArray[1782] = -59;
        byArray[1783] = -111;
        byArray[1784] = 32;
        byArray[1785] = 13;
        byArray[1786] = -69;
        byArray[1787] = 122;
        byArray[1788] = 90;
        byArray[1789] = 5;
        byArray[1790] = 40;
        byArray[1791] = 88;
        byArray[1792] = 15;
        byArray[1793] = -90;
        byArray[1794] = 125;
        byArray[1795] = -28;
        byArray[1796] = 89;
        byArray[1797] = 95;
        byArray[1798] = 73;
        byArray[1799] = 96;
        byArray[1800] = 60;
        byArray[1801] = -60;
        byArray[1802] = -51;
        byArray[1803] = 102;
        byArray[1804] = 7;
        byArray[1805] = 57;
        byArray[1806] = 91;
        byArray[1807] = 59;
        byArray[1808] = 15;
        byArray[1809] = 92;
        byArray[1810] = -76;
        byArray[1811] = -34;
        byArray[1812] = -23;
        byArray[1813] = -77;
        byArray[1814] = 90;
        byArray[1815] = 45;
        byArray[1816] = 91;
        byArray[1817] = 77;
        byArray[1818] = -63;
        byArray[1819] = 94;
        byArray[1820] = -127;
        byArray[1821] = 74;
        byArray[1822] = -97;
        byArray[1823] = -44;
        byArray[1824] = 50;
        byArray[1825] = -87;
        byArray[1826] = -94;
        byArray[1827] = -25;
        byArray[1828] = -71;
        byArray[1829] = 112;
        byArray[1830] = 127;
        byArray[1831] = -117;
        byArray[1832] = 6;
        byArray[1833] = 32;
        byArray[1834] = -113;
        byArray[1835] = 54;
        byArray[1836] = 83;
        byArray[1837] = -31;
        byArray[1838] = 111;
        byArray[1839] = -73;
        byArray[1840] = 53;
        byArray[1841] = 34;
        byArray[1842] = -32;
        byArray[1843] = -98;
        byArray[1844] = 125;
        byArray[1845] = -39;
        byArray[1846] = 63;
        byArray[1847] = 15;
        byArray[1848] = 72;
        byArray[1849] = -69;
        byArray[1850] = 87;
        byArray[1851] = -118;
        byArray[1852] = 108;
        byArray[1853] = 17;
        byArray[1854] = 84;
        byArray[1855] = 15;
        byArray[1856] = 61;
        byArray[1857] = -47;
        byArray[1858] = 54;
        byArray[1859] = -24;
        byArray[1860] = -79;
        byArray[1861] = 91;
        byArray[1862] = 28;
        byArray[1863] = -28;
        byArray[1864] = 66;
        byArray[1865] = 53;
        byArray[1866] = 22;
        byArray[1867] = 9;
        byArray[1868] = -28;
        byArray[1869] = -12;
        byArray[1870] = 38;
        byArray[1871] = 64;
        byArray[1872] = 75;
        byArray[1873] = -122;
        byArray[1874] = 96;
        byArray[1875] = -59;
        byArray[1876] = -45;
        byArray[1877] = 4;
        byArray[1878] = -19;
        byArray[1879] = 47;
        byArray[1880] = -30;
        byArray[1881] = 75;
        byArray[1882] = -94;
        byArray[1883] = 62;
        byArray[1884] = -64;
        byArray[1885] = 76;
        byArray[1886] = -49;
        byArray[1887] = 19;
        byArray[1888] = -66;
        byArray[1889] = -34;
        byArray[1890] = 3;
        byArray[1891] = 84;
        byArray[1892] = -2;
        byArray[1893] = -54;
        byArray[1894] = 13;
        byArray[1895] = -84;
        byArray[1896] = 86;
        byArray[1897] = -117;
        byArray[1898] = 94;
        byArray[1899] = -27;
        byArray[1900] = 89;
        byArray[1901] = 16;
        byArray[1902] = 96;
        byArray[1903] = 52;
        byArray[1904] = -77;
        byArray[1905] = -36;
        byArray[1906] = -116;
        byArray[1907] = 27;
        byArray[1908] = -52;
        byArray[1909] = -33;
        byArray[1910] = -50;
        byArray[1911] = 14;
        byArray[1912] = -59;
        byArray[1913] = 77;
        byArray[1914] = 93;
        byArray[1915] = -109;
        byArray[1916] = 8;
        byArray[1917] = -89;
        byArray[1918] = 81;
        byArray[1919] = -114;
        byArray[1920] = -29;
        byArray[1921] = -94;
        byArray[1922] = 73;
        byArray[1923] = -119;
        byArray[1924] = -56;
        byArray[1925] = -19;
        byArray[1926] = 88;
        byArray[1927] = -17;
        byArray[1928] = -33;
        byArray[1929] = 125;
        byArray[1930] = -18;
        byArray[1931] = -68;
        byArray[1932] = 113;
        byArray[1933] = 40;
        byArray[1934] = -128;
        byArray[1935] = -112;
        byArray[1936] = -119;
        byArray[1937] = -106;
        byArray[1938] = -106;
        byArray[1939] = -30;
        byArray[1940] = 23;
        byArray[1941] = -77;
        byArray[1942] = 49;
        byArray[1943] = 3;
        byArray[1944] = 98;
        byArray[1945] = -101;
        byArray[1946] = 99;
        byArray[1947] = -107;
        byArray[1948] = -121;
        byArray[1949] = -12;
        byArray[1950] = -112;
        byArray[1951] = 24;
        byArray[1952] = -74;
        byArray[1953] = -74;
        byArray[1954] = 79;
        byArray[1955] = -17;
        byArray[1956] = 96;
        byArray[1957] = 65;
        byArray[1958] = -52;
        byArray[1959] = 86;
        byArray[1960] = -63;
        byArray[1961] = 45;
        byArray[1962] = 84;
        byArray[1963] = 119;
        byArray[1964] = -42;
        byArray[1965] = 61;
        byArray[1966] = -91;
        byArray[1967] = 29;
        byArray[1968] = -87;
        byArray[1969] = 65;
        byArray[1970] = -85;
        byArray[1971] = 99;
        byArray[1972] = -14;
        byArray[1973] = 71;
        byArray[1974] = 33;
        byArray[1975] = -41;
        byArray[1976] = -48;
        byArray[1977] = -2;
        byArray[1978] = -121;
        byArray[1979] = 78;
        byArray[1980] = -38;
        byArray[1981] = 41;
        byArray[1982] = -7;
        byArray[1983] = -37;
        byArray[1984] = 48;
        byArray[1985] = 122;
        byArray[1986] = 61;
        byArray[1987] = -124;
        byArray[1988] = 42;
        byArray[1989] = -22;
        byArray[1990] = 24;
        byArray[1991] = 2;
        byArray[1992] = -49;
        byArray[1993] = 74;
        byArray[1994] = -81;
        byArray[1995] = -88;
        byArray[1996] = -89;
        byArray[1997] = -107;
        byArray[1998] = 109;
        byArray[1999] = 53;
        byArray[2000] = -68;
        byArray[2001] = 90;
        byArray[2002] = -117;
        byArray[2003] = 123;
        byArray[2004] = -109;
        byArray[2005] = -28;
        byArray[2006] = 12;
        byArray[2007] = 80;
        byArray[2008] = 120;
        byArray[2009] = 26;
        byArray[2010] = -104;
        byArray[2011] = 73;
        byArray[2012] = 70;
        byArray[2013] = -36;
        byArray[2014] = 34;
        byArray[2015] = -80;
        byArray[2016] = -104;
        byArray[2017] = 23;
        byArray[2018] = 16;
        byArray[2019] = 14;
        byArray[2020] = -96;
        byArray[2021] = -5;
        byArray[2022] = 27;
        byArray[2023] = 71;
        byArray[2024] = 25;
        byArray[2025] = -8;
        byArray[2026] = -125;
        byArray[2027] = 58;
        byArray[2028] = 88;
        byArray[2029] = -52;
        byArray[2030] = -97;
        byArray[2031] = -97;
        byArray[2032] = -93;
        byArray[2033] = 11;
        byArray[2034] = -44;
        byArray[2035] = 116;
        byArray[2036] = 42;
        byArray[2037] = -102;
        byArray[2038] = -100;
        byArray[2039] = -31;
        byArray[2040] = -86;
        byArray[2041] = 71;
        byArray[2042] = 84;
        byArray[2043] = 70;
        byArray[2044] = 27;
        byArray[2045] = 117;
        byArray[2046] = -67;
        byArray[2047] = 92;
        byArray[2048] = -84;
        byArray[2049] = -13;
        byArray[2050] = 54;
        byArray[2051] = -102;
        byArray[2052] = 34;
        byArray[2053] = 5;
        byArray[2054] = 19;
        byArray[2055] = -76;
        byArray[2056] = 71;
        byArray[2057] = 89;
        byArray[2058] = 22;
        byArray[2059] = -49;
        byArray[2060] = -34;
        byArray[2061] = -29;
        byte[] a = byArray;
        IntegerPolynomial poly = IntegerPolynomial.fromBinary(a, 1499, 2048);
        byte[] b = poly.toBinary(2048);
        IntegerPolynomialTest.assertTrue((boolean)Arrays.areEqual(this.copyOf(a, 2047), this.copyOf(b, 2047)));
        IntegerPolynomialTest.assertEquals((int)((a[a.length - 1] & 1) >> 6), (int)((b[b.length - 1] & 1) >> 6));
    }

    public void testFromToBinary3Sves() {
        byte[] byArray = new byte[282];
        byArray[0] = -112;
        byArray[1] = -78;
        byArray[2] = 19;
        byArray[3] = 15;
        byArray[4] = 99;
        byArray[5] = -65;
        byArray[6] = -56;
        byArray[7] = -90;
        byArray[8] = 44;
        byArray[9] = -93;
        byArray[10] = -109;
        byArray[11] = 104;
        byArray[12] = 40;
        byArray[13] = 90;
        byArray[14] = -84;
        byArray[15] = -21;
        byArray[16] = -124;
        byArray[17] = 51;
        byArray[18] = -33;
        byArray[19] = 4;
        byArray[20] = -51;
        byArray[21] = -106;
        byArray[22] = 33;
        byArray[23] = 86;
        byArray[24] = -76;
        byArray[25] = 42;
        byArray[26] = 41;
        byArray[27] = -17;
        byArray[28] = 47;
        byArray[29] = 79;
        byArray[30] = 81;
        byArray[31] = -29;
        byArray[32] = 15;
        byArray[33] = 116;
        byArray[34] = 101;
        byArray[35] = 120;
        byArray[36] = 116;
        byArray[37] = 32;
        byArray[38] = 116;
        byArray[39] = 111;
        byArray[40] = 32;
        byArray[41] = 101;
        byArray[42] = 110;
        byArray[43] = 99;
        byArray[44] = 114;
        byArray[45] = 121;
        byArray[46] = 112;
        byArray[47] = 116;
        byte[] a = byArray;
        IntegerPolynomial poly = IntegerPolynomial.fromBinary3Sves(a, 1499);
        byte[] b = poly.toBinary3Sves();
        IntegerPolynomialTest.assertTrue((boolean)Arrays.areEqual(a, b));
    }

    public void testFromToBinary3Tight() {
        int[] nArray = new int[1499];
        nArray[7] = 1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[19] = -1;
        nArray[24] = -1;
        nArray[33] = -1;
        nArray[37] = 1;
        nArray[54] = -1;
        nArray[67] = 1;
        nArray[99] = -1;
        nArray[105] = -1;
        nArray[106] = 1;
        nArray[124] = -1;
        nArray[130] = 1;
        nArray[132] = 1;
        nArray[144] = 1;
        nArray[157] = 1;
        nArray[159] = -1;
        nArray[169] = -1;
        nArray[178] = 1;
        nArray[179] = -1;
        nArray[182] = -1;
        nArray[194] = 1;
        nArray[201] = 1;
        nArray[203] = -1;
        nArray[216] = -1;
        nArray[218] = 1;
        nArray[245] = -1;
        nArray[255] = -1;
        nArray[279] = -1;
        nArray[293] = 1;
        nArray[294] = 1;
        nArray[302] = -1;
        nArray[312] = 1;
        nArray[340] = 1;
        nArray[348] = 1;
        nArray[366] = -1;
        nArray[368] = 1;
        nArray[372] = -1;
        nArray[376] = 1;
        nArray[401] = 1;
        nArray[438] = -1;
        nArray[448] = -1;
        nArray[452] = 1;
        nArray[457] = 1;
        nArray[471] = -1;
        nArray[472] = 1;
        nArray[477] = -1;
        nArray[492] = -1;
        nArray[494] = 1;
        nArray[496] = 1;
        nArray[498] = 1;
        nArray[500] = -1;
        nArray[503] = 1;
        nArray[505] = 1;
        nArray[514] = 1;
        nArray[519] = 1;
        nArray[530] = 1;
        nArray[580] = -1;
        nArray[614] = -1;
        nArray[628] = 1;
        nArray[632] = 1;
        nArray[644] = 1;
        nArray[647] = 1;
        nArray[669] = -1;
        nArray[671] = 1;
        nArray[697] = 1;
        nArray[698] = 1;
        nArray[707] = -1;
        nArray[708] = -1;
        nArray[710] = 1;
        nArray[716] = 1;
        nArray[717] = 1;
        nArray[731] = 1;
        nArray[739] = -1;
        nArray[748] = 1;
        nArray[749] = 1;
        nArray[751] = -1;
        nArray[755] = 1;
        nArray[784] = -1;
        nArray[790] = -1;
        nArray[800] = -1;
        nArray[822] = 1;
        nArray[832] = -1;
        nArray[842] = 1;
        nArray[862] = -1;
        nArray[863] = 1;
        nArray[864] = -1;
        nArray[874] = 1;
        nArray[876] = 1;
        nArray[885] = 1;
        nArray[895] = 1;
        nArray[896] = -1;
        nArray[913] = 1;
        nArray[942] = -1;
        nArray[964] = 1;
        nArray[969] = 1;
        nArray[978] = -1;
        nArray[980] = 1;
        nArray[981] = -1;
        nArray[995] = -1;
        nArray[997] = -1;
        nArray[998] = -1;
        nArray[1000] = -1;
        nArray[1019] = 1;
        nArray[1021] = -1;
        nArray[1029] = 1;
        nArray[1031] = 1;
        nArray[1048] = -1;
        nArray[1068] = 1;
        nArray[1070] = -1;
        nArray[1076] = -1;
        nArray[1087] = 1;
        nArray[1102] = -1;
        nArray[1139] = -1;
        nArray[1146] = -1;
        nArray[1161] = -1;
        nArray[1168] = -1;
        nArray[1185] = -1;
        nArray[1189] = -1;
        nArray[1190] = 1;
        nArray[1200] = -1;
        nArray[1210] = 1;
        nArray[1217] = -1;
        nArray[1220] = 1;
        nArray[1231] = -1;
        nArray[1233] = 1;
        nArray[1239] = -1;
        nArray[1273] = -1;
        nArray[1274] = -1;
        nArray[1283] = -1;
        nArray[1288] = -1;
        nArray[1312] = 1;
        nArray[1316] = 1;
        nArray[1320] = -1;
        nArray[1334] = -1;
        nArray[1345] = -1;
        nArray[1349] = 1;
        nArray[1364] = -1;
        nArray[1367] = 1;
        nArray[1370] = 1;
        nArray[1378] = 1;
        nArray[1391] = -1;
        nArray[1395] = -1;
        nArray[1399] = 1;
        nArray[1409] = -1;
        nArray[1411] = 1;
        nArray[1437] = 1;
        nArray[1443] = 1;
        nArray[1446] = 1;
        nArray[1452] = -1;
        nArray[1465] = 1;
        nArray[1471] = -1;
        nArray[1476] = 1;
        nArray[1481] = -1;
        nArray[1487] = 1;
        nArray[1490] = -1;
        int[] c = nArray;
        IntegerPolynomial poly1 = new IntegerPolynomial(c);
        IntegerPolynomial poly2 = IntegerPolynomial.fromBinary3Tight(poly1.toBinary3Tight(), c.length);
        IntegerPolynomialTest.assertTrue((boolean)Arrays.areEqual(poly1.coeffs, poly2.coeffs));
        int[] nArray2 = new int[1499];
        nArray2[15] = -1;
        nArray2[23] = -1;
        nArray2[29] = -1;
        nArray2[30] = -1;
        nArray2[49] = 1;
        nArray2[76] = 1;
        nArray2[96] = -1;
        nArray2[106] = 1;
        nArray2[114] = 1;
        nArray2[115] = -1;
        nArray2[116] = -1;
        nArray2[120] = 1;
        nArray2[122] = -1;
        nArray2[129] = 1;
        nArray2[153] = -1;
        nArray2[167] = 1;
        nArray2[174] = 1;
        nArray2[183] = -1;
        nArray2[207] = 1;
        nArray2[213] = 1;
        nArray2[217] = -1;
        nArray2[253] = -1;
        nArray2[255] = -1;
        nArray2[264] = 1;
        nArray2[267] = -1;
        nArray2[268] = 1;
        nArray2[272] = 1;
        nArray2[276] = 1;
        nArray2[277] = 1;
        nArray2[295] = -1;
        nArray2[298] = 1;
        nArray2[322] = 1;
        nArray2[323] = 1;
        nArray2[325] = 1;
        nArray2[330] = -1;
        nArray2[336] = 1;
        nArray2[337] = -1;
        nArray2[357] = 1;
        nArray2[376] = -1;
        nArray2[377] = -1;
        nArray2[379] = 1;
        nArray2[394] = -1;
        nArray2[401] = -1;
        nArray2[414] = -1;
        nArray2[432] = -1;
        nArray2[433] = -1;
        nArray2[440] = -1;
        nArray2[446] = 1;
        nArray2[448] = 1;
        nArray2[452] = 1;
        nArray2[463] = -1;
        nArray2[468] = 1;
        nArray2[476] = 1;
        nArray2[508] = -1;
        nArray2[513] = 1;
        nArray2[519] = -1;
        nArray2[529] = -1;
        nArray2[551] = -1;
        nArray2[553] = -1;
        nArray2[556] = 1;
        nArray2[561] = 1;
        nArray2[565] = 1;
        nArray2[582] = -1;
        nArray2[593] = 1;
        nArray2[608] = 1;
        nArray2[609] = 1;
        nArray2[630] = -1;
        nArray2[645] = 1;
        nArray2[658] = 1;
        nArray2[661] = 1;
        nArray2[671] = -1;
        nArray2[685] = 1;
        nArray2[692] = 1;
        nArray2[693] = -1;
        nArray2[698] = 1;
        nArray2[709] = -1;
        nArray2[726] = 1;
        nArray2[736] = -1;
        nArray2[741] = -1;
        nArray2[748] = -1;
        nArray2[756] = -1;
        nArray2[757] = -1;
        nArray2[770] = -1;
        nArray2[776] = 1;
        nArray2[782] = -1;
        nArray2[802] = 1;
        nArray2[825] = -1;
        nArray2[839] = 1;
        nArray2[841] = -1;
        nArray2[846] = -1;
        nArray2[854] = -1;
        nArray2[867] = 1;
        nArray2[874] = 1;
        nArray2[880] = -1;
        nArray2[890] = 1;
        nArray2[900] = -1;
        nArray2[921] = -1;
        nArray2[926] = 1;
        nArray2[928] = -1;
        nArray2[932] = 1;
        nArray2[945] = -1;
        nArray2[959] = -1;
        nArray2[966] = 1;
        nArray2[967] = 1;
        nArray2[975] = -1;
        nArray2[984] = 1;
        nArray2[986] = 1;
        nArray2[999] = -1;
        nArray2[1018] = -1;
        nArray2[1019] = -1;
        nArray2[1031] = 1;
        nArray2[1073] = -1;
        nArray2[1075] = -1;
        nArray2[1089] = 1;
        nArray2[1090] = -1;
        nArray2[1102] = 1;
        nArray2[1116] = -1;
        nArray2[1124] = 1;
        nArray2[1142] = -1;
        nArray2[1146] = -1;
        nArray2[1148] = 1;
        nArray2[1167] = -1;
        nArray2[1169] = 1;
        nArray2[1170] = 1;
        nArray2[1174] = 1;
        nArray2[1184] = 1;
        nArray2[1187] = -1;
        nArray2[1235] = 1;
        nArray2[1236] = -1;
        nArray2[1240] = -1;
        nArray2[1254] = -1;
        nArray2[1256] = -1;
        nArray2[1259] = 1;
        nArray2[1273] = -1;
        nArray2[1289] = 1;
        nArray2[1303] = 1;
        nArray2[1317] = -1;
        nArray2[1319] = -1;
        nArray2[1320] = 1;
        nArray2[1325] = 1;
        nArray2[1330] = 1;
        nArray2[1341] = -1;
        nArray2[1344] = -1;
        nArray2[1357] = 1;
        nArray2[1369] = 1;
        nArray2[1377] = 1;
        nArray2[1386] = 1;
        nArray2[1396] = -1;
        nArray2[1397] = 1;
        nArray2[1398] = 1;
        nArray2[1422] = -1;
        nArray2[1437] = -1;
        nArray2[1455] = 1;
        nArray2[1462] = -1;
        nArray2[1479] = 1;
        nArray2[1483] = 1;
        nArray2[1497] = 1;
        IntegerPolynomial poly3 = new IntegerPolynomial(nArray2);
        byte[] arr = poly3.toBinary3Tight();
        IntegerPolynomial poly4 = IntegerPolynomial.fromBinary3Tight(arr, 1499);
        IntegerPolynomialTest.assertTrue((boolean)Arrays.areEqual(poly3.coeffs, poly4.coeffs));
        int[] nArray3 = new int[7];
        nArray3[3] = 1;
        nArray3[4] = -1;
        nArray3[5] = -1;
        nArray3[6] = -1;
        IntegerPolynomial poly5 = new IntegerPolynomial(nArray3);
        arr = poly5.toBinary3Tight();
        IntegerPolynomial poly6 = IntegerPolynomial.fromBinary3Tight(arr, 7);
        IntegerPolynomialTest.assertTrue((boolean)Arrays.areEqual(poly5.coeffs, poly6.coeffs));
        SecureRandom random = new SecureRandom();
        int i = 0;
        while (i < 100) {
            DenseTernaryPolynomial poly7 = DenseTernaryPolynomial.generateRandom(157, random);
            arr = poly7.toBinary3Tight();
            IntegerPolynomial poly8 = IntegerPolynomial.fromBinary3Tight(arr, 157);
            IntegerPolynomialTest.assertTrue((boolean)Arrays.areEqual(poly7.coeffs, poly8.coeffs));
            ++i;
        }
    }

    public void testResultant() {
        SecureRandom random = new SecureRandom();
        NTRUSigningKeyGenerationParameters params = NTRUSigningKeyGenerationParameters.APR2011_439;
        IntegerPolynomial a = DenseTernaryPolynomial.generateRandom(params.N, params.d, params.d, random);
        this.verifyResultant(a, a.resultant());
        int[] nArray = new int[349];
        nArray[8] = -1;
        nArray[10] = 1;
        nArray[16] = 1;
        nArray[17] = -1;
        nArray[20] = -1;
        nArray[24] = 1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[31] = -1;
        nArray[32] = 1;
        nArray[33] = -1;
        nArray[35] = -1;
        nArray[37] = -1;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[43] = 1;
        nArray[44] = 1;
        nArray[45] = -1;
        nArray[46] = -1;
        nArray[47] = -1;
        nArray[49] = -1;
        nArray[50] = -1;
        nArray[53] = 1;
        nArray[59] = -1;
        nArray[62] = 1;
        nArray[65] = 1;
        nArray[66] = 1;
        nArray[67] = -1;
        nArray[69] = 1;
        nArray[70] = -1;
        nArray[72] = 1;
        nArray[74] = 1;
        nArray[76] = -1;
        nArray[77] = -1;
        nArray[79] = 1;
        nArray[81] = -1;
        nArray[82] = 1;
        nArray[83] = 1;
        nArray[84] = 1;
        nArray[85] = 1;
        nArray[88] = -1;
        nArray[89] = -1;
        nArray[90] = 1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[96] = -1;
        nArray[100] = 1;
        nArray[102] = 1;
        nArray[104] = 1;
        nArray[114] = 1;
        nArray[117] = 1;
        nArray[118] = -1;
        nArray[123] = -1;
        nArray[127] = 1;
        nArray[129] = 1;
        nArray[131] = 1;
        nArray[132] = -1;
        nArray[135] = 1;
        nArray[136] = 1;
        nArray[137] = 1;
        nArray[141] = -1;
        nArray[146] = 1;
        nArray[148] = 1;
        nArray[150] = -1;
        nArray[151] = -1;
        nArray[153] = -1;
        nArray[154] = -1;
        nArray[155] = -1;
        nArray[157] = -1;
        nArray[158] = -1;
        nArray[162] = 1;
        nArray[163] = 1;
        nArray[167] = 1;
        nArray[170] = 1;
        nArray[171] = -1;
        nArray[173] = 1;
        nArray[175] = -1;
        nArray[182] = -1;
        nArray[183] = -1;
        nArray[185] = -1;
        nArray[186] = -1;
        nArray[187] = 1;
        nArray[188] = 1;
        nArray[191] = -1;
        nArray[192] = 1;
        nArray[196] = -1;
        nArray[197] = 1;
        nArray[198] = -1;
        nArray[200] = -1;
        nArray[204] = -1;
        nArray[210] = -1;
        nArray[211] = 1;
        nArray[212] = 1;
        nArray[215] = -1;
        nArray[216] = 1;
        nArray[219] = 1;
        nArray[223] = 1;
        nArray[225] = 1;
        nArray[232] = 1;
        nArray[233] = -1;
        nArray[235] = 1;
        nArray[237] = -1;
        nArray[238] = -1;
        nArray[244] = 1;
        nArray[245] = -1;
        nArray[249] = 1;
        nArray[250] = -1;
        nArray[251] = 1;
        nArray[252] = -1;
        nArray[253] = -1;
        nArray[254] = 1;
        nArray[255] = -1;
        nArray[257] = 1;
        nArray[261] = 1;
        nArray[264] = 1;
        nArray[265] = -1;
        nArray[273] = -1;
        nArray[275] = 1;
        nArray[277] = -1;
        nArray[279] = 1;
        nArray[280] = -1;
        nArray[283] = 1;
        nArray[284] = 1;
        nArray[287] = 1;
        nArray[288] = 1;
        nArray[290] = -1;
        nArray[292] = -1;
        nArray[293] = 1;
        nArray[294] = -1;
        nArray[295] = -1;
        nArray[300] = 1;
        nArray[305] = 1;
        nArray[308] = 1;
        nArray[309] = -1;
        nArray[312] = 1;
        nArray[313] = -1;
        nArray[314] = 1;
        nArray[317] = 1;
        nArray[322] = 1;
        nArray[331] = -1;
        nArray[332] = 1;
        nArray[334] = -1;
        nArray[335] = -1;
        nArray[338] = -1;
        nArray[340] = 1;
        nArray[341] = 1;
        nArray[342] = -1;
        nArray[343] = 1;
        nArray[344] = -1;
        nArray[348] = 1;
        a = new IntegerPolynomial(nArray);
        this.verifyResultant(a, a.resultant());
    }

    private void verifyResultant(IntegerPolynomial a, Resultant r2) {
        BigIntPolynomial b = new BigIntPolynomial(a).mult(r2.rho);
        BigInteger[] bCoeffs = b.getCoeffs();
        int j = 1;
        while (j < bCoeffs.length - 1) {
            IntegerPolynomialTest.assertEquals((Object)BigInteger.ZERO, (Object)bCoeffs[j]);
            ++j;
        }
        if (r2.res.equals(BigInteger.ZERO)) {
            IntegerPolynomialTest.assertEquals((Object)BigInteger.ZERO, (Object)bCoeffs[0].subtract(bCoeffs[bCoeffs.length - 1]));
        } else {
            IntegerPolynomialTest.assertEquals((Object)BigInteger.ZERO, (Object)bCoeffs[0].subtract(bCoeffs[bCoeffs.length - 1]).mod(r2.res));
        }
        IntegerPolynomialTest.assertEquals((Object)bCoeffs[0].subtract(r2.res), (Object)bCoeffs[bCoeffs.length - 1].negate());
    }

    public void testResultantMod() {
        int p = 46337;
        int[] nArray = new int[349];
        nArray[8] = -1;
        nArray[10] = 1;
        nArray[16] = 1;
        nArray[17] = -1;
        nArray[20] = -1;
        nArray[24] = 1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[31] = -1;
        nArray[32] = 1;
        nArray[33] = -1;
        nArray[35] = -1;
        nArray[37] = -1;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[43] = 1;
        nArray[44] = 1;
        nArray[45] = -1;
        nArray[46] = -1;
        nArray[47] = -1;
        nArray[49] = -1;
        nArray[50] = -1;
        nArray[53] = 1;
        nArray[59] = -1;
        nArray[62] = 1;
        nArray[65] = 1;
        nArray[66] = 1;
        nArray[67] = -1;
        nArray[69] = 1;
        nArray[70] = -1;
        nArray[72] = 1;
        nArray[74] = 1;
        nArray[76] = -1;
        nArray[77] = -1;
        nArray[79] = 1;
        nArray[81] = -1;
        nArray[82] = 1;
        nArray[83] = 1;
        nArray[84] = 1;
        nArray[85] = 1;
        nArray[88] = -1;
        nArray[89] = -1;
        nArray[90] = 1;
        nArray[93] = -1;
        nArray[94] = -1;
        nArray[96] = -1;
        nArray[100] = 1;
        nArray[102] = 1;
        nArray[104] = 1;
        nArray[114] = 1;
        nArray[117] = 1;
        nArray[118] = -1;
        nArray[123] = -1;
        nArray[127] = 1;
        nArray[129] = 1;
        nArray[131] = 1;
        nArray[132] = -1;
        nArray[135] = 1;
        nArray[136] = 1;
        nArray[137] = 1;
        nArray[141] = -1;
        nArray[146] = 1;
        nArray[148] = 1;
        nArray[150] = -1;
        nArray[151] = -1;
        nArray[153] = -1;
        nArray[154] = -1;
        nArray[155] = -1;
        nArray[157] = -1;
        nArray[158] = -1;
        nArray[162] = 1;
        nArray[163] = 1;
        nArray[167] = 1;
        nArray[170] = 1;
        nArray[171] = -1;
        nArray[173] = 1;
        nArray[175] = -1;
        nArray[182] = -1;
        nArray[183] = -1;
        nArray[185] = -1;
        nArray[186] = -1;
        nArray[187] = 1;
        nArray[188] = 1;
        nArray[191] = -1;
        nArray[192] = 1;
        nArray[196] = -1;
        nArray[197] = 1;
        nArray[198] = -1;
        nArray[200] = -1;
        nArray[204] = -1;
        nArray[210] = -1;
        nArray[211] = 1;
        nArray[212] = 1;
        nArray[215] = -1;
        nArray[216] = 1;
        nArray[219] = 1;
        nArray[223] = 1;
        nArray[225] = 1;
        nArray[232] = 1;
        nArray[233] = -1;
        nArray[235] = 1;
        nArray[237] = -1;
        nArray[238] = -1;
        nArray[244] = 1;
        nArray[245] = -1;
        nArray[249] = 1;
        nArray[250] = -1;
        nArray[251] = 1;
        nArray[252] = -1;
        nArray[253] = -1;
        nArray[254] = 1;
        nArray[255] = -1;
        nArray[257] = 1;
        nArray[261] = 1;
        nArray[264] = 1;
        nArray[265] = -1;
        nArray[273] = -1;
        nArray[275] = 1;
        nArray[277] = -1;
        nArray[279] = 1;
        nArray[280] = -1;
        nArray[283] = 1;
        nArray[284] = 1;
        nArray[287] = 1;
        nArray[288] = 1;
        nArray[290] = -1;
        nArray[292] = -1;
        nArray[293] = 1;
        nArray[294] = -1;
        nArray[295] = -1;
        nArray[300] = 1;
        nArray[305] = 1;
        nArray[308] = 1;
        nArray[309] = -1;
        nArray[312] = 1;
        nArray[313] = -1;
        nArray[314] = 1;
        nArray[317] = 1;
        nArray[322] = 1;
        nArray[331] = -1;
        nArray[332] = 1;
        nArray[334] = -1;
        nArray[335] = -1;
        nArray[338] = -1;
        nArray[340] = 1;
        nArray[341] = 1;
        nArray[342] = -1;
        nArray[343] = 1;
        nArray[344] = -1;
        nArray[348] = 1;
        IntegerPolynomial a = new IntegerPolynomial(nArray);
        this.verifyResultant(a, a.resultant(p), p);
        SecureRandom random = new SecureRandom();
        int i = 0;
        while (i < 10) {
            a = DenseTernaryPolynomial.generateRandom(853, random);
            this.verifyResultant(a, a.resultant(p), p);
            ++i;
        }
    }

    private void verifyResultant(IntegerPolynomial a, Resultant r2, int p) {
        BigIntPolynomial b = new BigIntPolynomial(a).mult(r2.rho);
        b.mod(BigInteger.valueOf(p));
        BigInteger[] bCoeffs = b.getCoeffs();
        int j = 1;
        while (j < bCoeffs.length - 1) {
            IntegerPolynomialTest.assertEquals((Object)BigInteger.ZERO, (Object)bCoeffs[j]);
            ++j;
        }
        if (r2.res.equals(BigInteger.ZERO)) {
            IntegerPolynomialTest.assertEquals((Object)BigInteger.ZERO, (Object)bCoeffs[0].subtract(bCoeffs[bCoeffs.length - 1]));
        } else {
            IntegerPolynomialTest.assertEquals((Object)BigInteger.ZERO, (Object)bCoeffs[0].subtract(bCoeffs[bCoeffs.length - 1]).subtract(r2.res).mod(BigInteger.valueOf(p)));
        }
        IntegerPolynomialTest.assertEquals((Object)BigInteger.ZERO, (Object)bCoeffs[0].subtract(r2.res).subtract(bCoeffs[bCoeffs.length - 1].negate()).mod(BigInteger.valueOf(p)));
    }

    private byte[] copyOf(byte[] src, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(src, 0, tmp, 0, tmp.length);
        return tmp;
    }
}

