/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.test;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.KeyAgreement;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.util.Arrays;

public class NewHopeTest
extends TestCase {
    public void setUp() {
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastlePQCProvider());
        }
    }

    public void testKeyExchange() throws Exception {
        SecureRandom aliceRand = new SecureRandom();
        SecureRandom bobRand = new SecureRandom();
        int i = 0;
        while (i < 1000) {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("NH", "BCPQC");
            kpGen.initialize(1024, aliceRand);
            KeyPair aliceKp = kpGen.generateKeyPair();
            KeyAgreement bobAgree = KeyAgreement.getInstance("NH", "BCPQC");
            bobAgree.init(null, bobRand);
            Key bobSend = bobAgree.doPhase(aliceKp.getPublic(), true);
            KeyAgreement aliceAgree = KeyAgreement.getInstance("NH", "BCPQC");
            aliceAgree.init(aliceKp.getPrivate());
            aliceAgree.doPhase(bobSend, true);
            Assert.assertTrue((String)"value mismatch", (boolean)Arrays.areEqual(aliceAgree.generateSecret(), bobAgree.generateSecret()));
            ++i;
        }
    }
}

