/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.pqc.crypto.xmss.XMSSOid;

public final class DefaultXMSSOid
implements XMSSOid {
    private static final Map<String, DefaultXMSSOid> oidLookupTable;
    private final int oid;
    private final String stringRepresentation;

    static {
        HashMap<String, DefaultXMSSOid> map = new HashMap<String, DefaultXMSSOid>();
        map.put(DefaultXMSSOid.createKey("SHA-256", 32, 16, 67, 10), new DefaultXMSSOid(0x1000001, "XMSS_SHA2-256_W16_H10"));
        map.put(DefaultXMSSOid.createKey("SHA-256", 32, 16, 67, 16), new DefaultXMSSOid(0x2000002, "XMSS_SHA2-256_W16_H16"));
        map.put(DefaultXMSSOid.createKey("SHA-256", 32, 16, 67, 20), new DefaultXMSSOid(0x3000003, "XMSS_SHA2-256_W16_H20"));
        map.put(DefaultXMSSOid.createKey("SHA-512", 64, 16, 131, 10), new DefaultXMSSOid(0x4000004, "XMSS_SHA2-512_W16_H10"));
        map.put(DefaultXMSSOid.createKey("SHA-512", 64, 16, 131, 16), new DefaultXMSSOid(0x5000005, "XMSS_SHA2-512_W16_H16"));
        map.put(DefaultXMSSOid.createKey("SHA-512", 64, 16, 131, 20), new DefaultXMSSOid(0x6000006, "XMSS_SHA2-512_W16_H20"));
        map.put(DefaultXMSSOid.createKey("SHAKE128", 32, 16, 67, 10), new DefaultXMSSOid(0x7000007, "XMSS_SHAKE128_W16_H10"));
        map.put(DefaultXMSSOid.createKey("SHAKE128", 32, 16, 67, 16), new DefaultXMSSOid(0x8000008, "XMSS_SHAKE128_W16_H16"));
        map.put(DefaultXMSSOid.createKey("SHAKE128", 32, 16, 67, 20), new DefaultXMSSOid(0x9000009, "XMSS_SHAKE128_W16_H20"));
        map.put(DefaultXMSSOid.createKey("SHAKE256", 64, 16, 131, 10), new DefaultXMSSOid(0xA00000A, "XMSS_SHAKE256_W16_H10"));
        map.put(DefaultXMSSOid.createKey("SHAKE256", 64, 16, 131, 16), new DefaultXMSSOid(0xB00000B, "XMSS_SHAKE256_W16_H16"));
        map.put(DefaultXMSSOid.createKey("SHAKE256", 64, 16, 131, 20), new DefaultXMSSOid(0xC00000C, "XMSS_SHAKE256_W16_H20"));
        oidLookupTable = Collections.unmodifiableMap(map);
    }

    private DefaultXMSSOid(int oid, String stringRepresentation) {
        this.oid = oid;
        this.stringRepresentation = stringRepresentation;
    }

    public static DefaultXMSSOid lookup(String algorithmName, int digestSize, int winternitzParameter, int len, int height) {
        if (algorithmName == null) {
            throw new NullPointerException("algorithmName == null");
        }
        return oidLookupTable.get(DefaultXMSSOid.createKey(algorithmName, digestSize, winternitzParameter, len, height));
    }

    private static String createKey(String algorithmName, int digestSize, int winternitzParameter, int len, int height) {
        if (algorithmName == null) {
            throw new NullPointerException("algorithmName == null");
        }
        return String.valueOf(algorithmName) + "-" + digestSize + "-" + winternitzParameter + "-" + len + "-" + height;
    }

    @Override
    public int getOid() {
        return this.oid;
    }

    @Override
    public String toString() {
        return this.stringRepresentation;
    }
}

