/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class FIPSDESTest
implements Test {
    static String[] fips1Tests = new String[]{"DES/ECB/NoPadding", "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53", "DES/CBC/NoPadding", "e5c7cdde872bf27c43e934008c389c0f683788499a7c05f6", "DES/CFB/NoPadding", "f3096249c7f46e51a69e839b1a92f78403467133898ea622"};
    static String[] fips2Tests = new String[]{"DES/CFB8/NoPadding", "f31fda07011462ee187f", "DES/OFB8/NoPadding", "f34a2850c9c64985d684"};
    static byte[] input1 = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
    static byte[] input2 = Hex.decode("4e6f7720697320746865");

    @Override
    public String getName() {
        return "FIPSDESTest";
    }

    private boolean equalArray(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i != a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public TestResult test(String algorithm, byte[] input, byte[] output) {
        Cipher out;
        Cipher in;
        SecretKeySpec key;
        IvParameterSpec spec = new IvParameterSpec(Hex.decode("1234567890abcdef"));
        try {
            key = new SecretKeySpec(Hex.decode("0123456789abcdef"), "DES");
            in = Cipher.getInstance(algorithm, "BC");
            out = Cipher.getInstance(algorithm, "BC");
            if (algorithm.startsWith("DES/ECB")) {
                out.init(1, key);
            } else {
                out.init(1, (Key)key, spec);
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + algorithm + " failed initialisation - " + e.toString(), e);
        }
        try {
            if (algorithm.startsWith("DES/ECB")) {
                in.init(2, key);
            } else {
                in.init(2, (Key)key, spec);
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + algorithm + " failed initialisation - " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            int i = 0;
            while (i != input.length / 2) {
                cOut.write(input[i]);
                ++i;
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + algorithm + " failed encryption - " + e.toString());
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.equalArray(bytes, output)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + algorithm + " failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            int i = 0;
            while (i != input.length / 2) {
                bytes[i] = (byte)dIn.read();
                ++i;
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + algorithm + " failed encryption - " + e.toString());
        }
        if (!this.equalArray(bytes, input)) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": " + algorithm + " failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": " + algorithm + " Okay");
    }

    @Override
    public TestResult perform() {
        TestResult result;
        int i = 0;
        while (i != fips1Tests.length) {
            result = this.test(fips1Tests[i], input1, Hex.decode(fips1Tests[i + 1]));
            if (!result.isSuccessful()) {
                return result;
            }
            i += 2;
        }
        i = 0;
        while (i != fips2Tests.length) {
            result = this.test(fips2Tests[i], input2, Hex.decode(fips2Tests[i + 1]));
            if (!result.isSuccessful()) {
                return result;
            }
            i += 2;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    public static void main(String[] args) throws KeyException, InvalidAlgorithmParameterException {
        Security.addProvider(new BouncyCastleProvider());
        FIPSDESTest test = new FIPSDESTest();
        TestResult result = test.perform();
        System.out.println(result.toString());
    }
}

