/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsClient;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.test.TlsTestConfig;
import org.bouncycastle.crypto.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;

class TlsTestClientImpl
extends DefaultTlsClient {
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;

    TlsTestClientImpl(TlsTestConfig config) {
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    @Override
    public ProtocolVersion getClientVersion() {
        if (this.config.clientOfferVersion != null) {
            return this.config.clientOfferVersion;
        }
        return super.getClientVersion();
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        if (this.config.clientMinimumVersion != null) {
            return this.config.clientMinimumVersion;
        }
        return super.getMinimumVersion();
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = super.getClientExtensions();
        if (clientExtensions != null && !this.config.clientSendSignatureAlgorithms) {
            clientExtensions.remove(TlsUtils.EXT_signature_algorithms);
            this.supportedSignatureAlgorithms = null;
        }
        return clientExtensions;
    }

    @Override
    public boolean isFallback() {
        return this.config.clientFallback;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
                boolean isEmpty = serverCertificate == null || serverCertificate.isEmpty();
                org.bouncycastle.asn1.x509.Certificate[] chain = serverCertificate.getCertificateList();
                if (isEmpty || !chain[0].equals(TlsTestUtils.loadCertificateResource("x509-server.pem")) && !chain[0].equals(TlsTestUtils.loadCertificateResource("x509-server-dsa.pem")) && !chain[0].equals(TlsTestUtils.loadCertificateResource("x509-server-ecdsa.pem"))) {
                    throw new TlsFatalAlert(42);
                }
            }

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                if (TlsTestClientImpl.this.config.serverCertReq == 0) {
                    throw new IllegalStateException();
                }
                if (TlsTestClientImpl.this.config.clientAuth == 0) {
                    return null;
                }
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (certificateTypes == null || !Arrays.contains(certificateTypes, (short)1)) {
                    return null;
                }
                Vector<SignatureAndHashAlgorithm> supportedSigAlgs = certificateRequest.getSupportedSignatureAlgorithms();
                if (supportedSigAlgs != null && TlsTestClientImpl.this.config.clientAuthSigAlg != null) {
                    supportedSigAlgs = new Vector<SignatureAndHashAlgorithm>(1);
                    supportedSigAlgs.addElement(TlsTestClientImpl.this.config.clientAuthSigAlg);
                }
                final TlsSignerCredentials signerCredentials = TlsTestUtils.loadSignerCredentials(TlsTestClientImpl.this.context, supportedSigAlgs, (short)1, "x509-client.pem", "x509-client-key.pem");
                if (TlsTestClientImpl.this.config.clientAuth == 1) {
                    return signerCredentials;
                }
                return new TlsSignerCredentials(){

                    @Override
                    public byte[] generateCertificateSignature(byte[] hash) throws IOException {
                        byte[] sig = signerCredentials.generateCertificateSignature(hash);
                        if ((this).TlsTestClientImpl.this.config.clientAuth == 3) {
                            sig = TlsTestClientImpl.this.corruptBit(sig);
                        }
                        return sig;
                    }

                    @Override
                    public Certificate getCertificate() {
                        Certificate cert = signerCredentials.getCertificate();
                        if ((this).TlsTestClientImpl.this.config.clientAuth == 2) {
                            cert = TlsTestClientImpl.this.corruptCertificate(cert);
                        }
                        return cert;
                    }

                    @Override
                    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
                        return signerCredentials.getSignatureAndHashAlgorithm();
                    }
                };
            }
        };
    }

    protected Certificate corruptCertificate(Certificate cert) {
        org.bouncycastle.asn1.x509.Certificate[] certList = cert.getCertificateList();
        certList[0] = this.corruptCertificateSignature(certList[0]);
        return new Certificate(certList);
    }

    protected org.bouncycastle.asn1.x509.Certificate corruptCertificateSignature(org.bouncycastle.asn1.x509.Certificate cert) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(cert.getTBSCertificate());
        v.add(cert.getSignatureAlgorithm());
        v.add(this.corruptSignature(cert.getSignature()));
        return org.bouncycastle.asn1.x509.Certificate.getInstance(new DERSequence(v));
    }

    protected DERBitString corruptSignature(DERBitString bs) {
        return new DERBitString(this.corruptBit(bs.getOctets()));
    }

    protected byte[] corruptBit(byte[] bs) {
        bs = Arrays.clone(bs);
        int bit = this.context.getSecureRandom().nextInt(bs.length << 3);
        int n = bit >>> 3;
        bs[n] = (byte)(bs[n] ^ 1 << (bit & 7));
        return bs;
    }
}

