/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import org.bouncycastle.crypto.tls.TlsServerProtocol;
import org.bouncycastle.crypto.tls.test.MockTlsServer;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.io.TeeOutputStream;

public class TlsServerTest {
    private static final SecureRandom secureRandom = new SecureRandom();

    public static void main(String[] args) throws Exception {
        InetAddress address = InetAddress.getLocalHost();
        int port = 5556;
        ServerSocket ss = new ServerSocket(port, 16, address);
        try {
            while (true) {
                Socket s = ss.accept();
                System.out.println("--------------------------------------------------------------------------------");
                System.out.println("Accepted " + s);
                ServerThread t = new ServerThread(s);
                t.start();
            }
        }
        catch (Throwable throwable) {
            ss.close();
            throw throwable;
        }
    }

    static class ServerThread
    extends Thread {
        private final Socket s;

        ServerThread(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                try {
                    MockTlsServer server = new MockTlsServer();
                    TlsServerProtocol serverProtocol = new TlsServerProtocol(this.s.getInputStream(), this.s.getOutputStream(), secureRandom);
                    serverProtocol.accept(server);
                    TeeOutputStream log = new TeeOutputStream(serverProtocol.getOutputStream(), System.out);
                    Streams.pipeAll(serverProtocol.getInputStream(), log);
                    serverProtocol.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                try {
                    this.s.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

