/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.math.ec.WNafUtil;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (RSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        AsymmetricCipherKeyPair result = null;
        boolean done = false;
        while (!done) {
            BigInteger qSub1;
            BigInteger pSub1;
            BigInteger lcm;
            BigInteger d;
            BigInteger phi;
            BigInteger n;
            BigInteger q;
            int strength = this.param.getStrength();
            int pbitlength = (strength + 1) / 2;
            int qbitlength = strength - pbitlength;
            int mindiffbits = strength / 3;
            int minWeight = strength >> 2;
            BigInteger e = this.param.getPublicExponent();
            BigInteger p = this.chooseRandomPrime(pbitlength, e);
            while (true) {
                BigInteger diff;
                if ((diff = (q = this.chooseRandomPrime(qbitlength, e)).subtract(p).abs()).bitLength() < mindiffbits) {
                    continue;
                }
                n = p.multiply(q);
                if (n.bitLength() != strength) {
                    p = p.max(q);
                    continue;
                }
                if (WNafUtil.getNafWeight(n) >= minWeight) break;
                p = this.chooseRandomPrime(pbitlength, e);
            }
            if (p.compareTo(q) < 0) {
                phi = p;
                p = q;
                q = phi;
            }
            if ((d = e.modInverse(lcm = (phi = (pSub1 = p.subtract(ONE)).multiply(qSub1 = q.subtract(ONE))).divide(pSub1.gcd(qSub1)))).bitLength() <= qbitlength || !d.equals(e.modInverse(phi))) continue;
            done = true;
            BigInteger dP = d.remainder(pSub1);
            BigInteger dQ = d.remainder(qSub1);
            BigInteger qInv = q.modInverse(p);
            result = new AsymmetricCipherKeyPair(new RSAKeyParameters(false, n, e), new RSAPrivateCrtKeyParameters(n, e, d, p, q, dP, dQ, qInv));
        }
        return result;
    }

    protected BigInteger chooseRandomPrime(int bitlength, BigInteger e) {
        BigInteger p;
        while ((p = new BigInteger(bitlength, 1, this.param.getRandom())).mod(e).equals(ONE) || !p.isProbablePrime(this.param.getCertainty()) || !e.gcd(p.subtract(ONE)).equals(ONE)) {
        }
        return p;
    }
}

