﻿/// 该窗体用来支持一次输入多张卡号（最多五张）
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace 用户模式
{
    public partial class InputKeyForm : Form
    {
        public InputKeyForm()
        {
            InitializeComponent();
        }

        LoginForm loginForm = null;
        string loginKeys = string.Empty;

        public InputKeyForm(LoginForm parentForm, string oldKeys)
            : this()
        {
            loginKeys = oldKeys;
            loginForm = parentForm;
        }

        /// <summary>
        /// 清空卡号
        /// </summary>
        private void button1_Click(object sender, EventArgs e)
        {
            this.textBox1.Text = string.Empty;
            this.textBox2.Text = string.Empty;
            this.textBox3.Text = string.Empty;
            this.textBox4.Text = string.Empty;
            this.textBox5.Text = string.Empty;
        }

        /// <summary>
        /// 输入卡号
        /// </summary>
        private void button2_Click(object sender, EventArgs e)
        {
            string cKey = string.Empty, ncKey = string.Empty, nJoin = string.Empty, errInfo = string.Empty;
            string tempStr = string.Empty;
            for (int i = 0; i < 5; i++)
            {
                TextBox tb = this.Controls.Find("textBox" + (i + 1).ToString(), true).FirstOrDefault() as TextBox;
                if (tb == null) 
                {
                    continue;
                }
                tempStr = tb.Text;
                if (tempStr.Length == 32)
                {
                    if (ncKey.Contains(tempStr))
                    {
                        errInfo += "第" + (i + 1).ToString() + "行卡号重复";
                    }
                    else
                    {
                        ncKey += nJoin + tempStr;
                        nJoin = "|";
                    }
                }
                else 
                {
                    if (!string.IsNullOrEmpty(tempStr)) 
                    {
                        errInfo += "第" + (i + 1).ToString() + "行卡号输入错误";
                    }
                }
            }

            if (string.IsNullOrEmpty(errInfo))
            {
                loginForm.tbRecharge2.Text = ncKey;
                this.Close();
            }
            else 
            {
                MessageBox.Show(errInfo);
            }
        }

        private void InputKeyForm_Load(object sender, EventArgs e)
        {
            string newKeys = string.Empty, splitStr = string.Empty;
            string[] oldArr = loginKeys.Split('|');

            for (int i = 0; i < oldArr.Length; i++)
            {
                if (i > 4) 
                {
                    break;
                }
                if (oldArr[i].Length == 32) 
                {
                    TextBox tb = this.Controls.Find("textBox" + (i + 1).ToString(), true).FirstOrDefault() as TextBox;
                    if (tb == null) 
                    {
                        continue;
                    }
                    tb.Text = oldArr[i];
                    newKeys += splitStr + oldArr[i];
                    splitStr = "|";
                }
            }
            loginForm.tbRecharge2.Text = newKeys;
        }
    }
}
