﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace Util
{
    public class KssModule
    {
        private const string FILEDLL = @"kssPlugin.dll";

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern void ks_setLicense(string LicenseKey);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern void ks_setExtVal(int v_language, string v_pccode, string v_ininame, int v_contime, int v_is2svr,
            string v_rsaMod, string v_rsaPubKey, string v_ext8, string v_ext9, string v_callbackfun);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern void ks_setSoftVal(int v_softcode, string v_softkey);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern void ks_setUserVal(int v_clientid, string v_username, string v_password, string v_bdinfo);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_IdCheck(string v_signA, int v_iscon);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_exit();

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_GetData(int v_index);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_GetMsg(string v_index);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern void ks_setUpVal(int v_softHwnd, int v_softVersion, int v_checkupdata);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_unbind(int v_softcode, int v_clientid, string v_UsernameOrKey, string v_password);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_viewinfo(int v_softcode, string v_UsernameOrKey); 
        
        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_advapi(string v_expression);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern void ks_advapifree(string v_expression);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int IPC_Start(int v_sockPort, int v_clientNum);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_edit(int v_softcode, string v_username, string v_superpassword, 
            string v_newloginpassword, string v_bdinfo);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_reguser(int v_softcode, string v_username, string v_userpassword,
            string v_superpassword, string v_keynum, string v_bdinfo, string v_parentusername);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string ks_prepaid(int v_softcode, string v_username, string v_keynum);


        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int IPC_Connect(int v_sockPort);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string IPC_advapi(string v_expression);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string IPC_IdCheck(string v_signA, int v_iscon);

        [DllImport(FILEDLL,
            CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern string IPC_GetData(int v_index);



        [DllImport("kernel32.dll")]
        private static extern int WritePrivateProfileString(string section, string key, string val, string filePath);

        [DllImport("kernel32.dll")]
        private static extern int GetPrivateProfileString(string lpApplicationName, string lpKeyName, string lpDefault, 
            StringBuilder lpReturnedString, int nSize, string lpFileName);


        ///写ini文件 节点名 键名 键值
        public static void w_ini(string iarea, string iKeyName, string iKeyValue)
        {
            WritePrivateProfileString(iarea, iKeyName, iKeyValue, Parameters.v_inipath);
        }

        ///读ini文件  节点名 键名
        public static string r_ini(string iarea, string iKeyName)
        {
            StringBuilder stringChanged = new StringBuilder(string.Empty, 1024);
            //stringChanged = string(1024, 0);
            GetPrivateProfileString(iarea, iKeyName, "", stringChanged, 1024, Parameters.v_inipath);
            return stringChanged.ToString();
        }

        public static bool IsErrNo(string code)
        {
            return code.Length == 6 && code.StartsWith("eno");
        }

        public static string advapi(string v_text, InvokeMode mode = InvokeMode.Common)
        {
            string result = string.Empty;
            if (mode.ToString().ToLower() == "ipc")
            {
                result = IPC_advapi(v_text);
            }
            else 
            {
                result = ks_advapi(v_text);
            }
            if(IsErrNo(result))
            {
                return ks_GetMsg(result);
            }
            if(result.StartsWith("err"))
            {
                return result;
            }
            return result;
        }

        /// <summary>
        ///  登陆之后的基础验证函数，可经常调用。提示：并不是每次调用该函数都会连接服务器的，
        ///  ks_IdCheck会自动根据服务器上的验证频率参数判断什么时候该连什么时候不该连
        /// </summary>
        public static void chkPass(int ctype, InvokeMode mode = InvokeMode.Common)
        {
            string v_msgstr = string.Empty;
            int i_rnd = 0;
            
            Random random = new Random();
            i_rnd = random.Next(0, 50);
            v_msgstr = mode.ToString().ToLower() == "ipc" ? IPC_IdCheck(Parameters.signData.Substring(i_rnd * 8, 8), ctype) : ks_IdCheck(Parameters.signData.Substring(i_rnd * 8 + 1, 8), ctype);

            if(IsErrNo(v_msgstr))
            {
                MessageBox.Show(ks_GetMsg(v_msgstr), "系统提示");                
            }
            
            if(v_msgstr != Parameters.signData.Substring(i_rnd * 8 + 400, 8))
            {
                KssModule.w_ini("signdata", "err", v_msgstr + "," + Parameters.signData.Substring(i_rnd * 8 + 400, 8));
            }
        }

        /// <summary>
        /// 扣点函数，调用advapi接口实现扣点功能。成功返回剩余的点数。失败返回-1
        /// </summary>

        public static int kpoints(int v_points, string v_errinfo, InvokeMode mode = InvokeMode.Common)
        {
            string result = string.Empty;
            int c = 0;
            result = advapi("v_points," + v_points.ToString(), mode);
            c = c_int(result);
            if(c == 0)  /// ' 返回值不是整数或为0就说明扣点失败
            {    
                if(IsErrNo(result))
                {
                    v_errinfo = ks_GetMsg(result);
                }
                {
                    v_errinfo = result;
                }
                return -1;
            }
            v_errinfo = "扣点成功";
            return c;
        }

        /// <summary>
        /// 转成整数，转换失败返回0
        /// </summary>
        public static int c_int(string v_str)
        {
            int result = 0;
            int.TryParse(v_str, out result);
            return result;
        }

    }
}
