// Language: HTML
// This script demonstrates very simple HTML highlighting
// No Doctype, CSS or JavaScript support
// Well commented and very easy to understand
// Comments *must* start at the beginning of the line

// States - these define parser states
State=snormal
State=sstring1
State=sstring2
State=scomment
State=stagname
State=shtmltag
State=shtmlvalue

// Tokens - these define different coloring styles
Token=tnone
Token=turl
Token=twhitespace
Token=tstring
Token=tcomment {HTML Comment}
Token=tident
Token=tresword
Token=tsymbol
Token=tentity
Token=tunknown
// tnone, turl, twhitespace are required tokens
// {name} allows to assign pretty display name for custom tokens
// most standard tokens are assigned pretty names automatically

// Delimiters
Delimiters=;.,:'"{}[]()<>?!@#$%^&*-+=|\/

// The parser generally consists of lines in the following format:
// CurrentState SomeExpression NewState Token
// after the Token, optional SaveState or LoadState directive can be used
// SaveState or LoadState directives allow to remember/activate some previous state
// you can remember only one state!
// see example below
// snormal  <?   sphp     tphpbracket   SaveState
// sstring  <?   sphp     tphpbracket   SaveState
// sphp     ?>   snormal  tphpbracket   LoadState

// Common
snormal <                          stagname    tsymbol
stagname [a-z_A-Z][a-z_A-Z0-9]*    shtmltag    tunknown
shtmltag [^\>^\'^\"^#32^\=]*       shtmltag    tident
stagname /                         stagname    tsymbol
shtmltag /                         shtmltag    tsymbol
shtmltag =                         shtmlvalue  tsymbol
shtmlvalue [^\>^#32^\=]*           shtmltag    tstring
shtmlvalue >                       snormal     tsymbol
stagname >                         snormal     tsymbol
shtmltag >                         snormal     tsymbol

// White space
snormal #32*                      snormal   twhitespace
shtmltag #32*                     shtmltag  tsymbol

// Strings
shtmltag   \'                     sstring1   tstring
shtmlvalue \'                     sstring1   tstring
sstring1   [^\']*                 sstring1   tstring
sstring1   \'                     shtmltag   tstring
sstring1   \'\'                   sstring1   tstring
sstring1   \\                     sstring1   tstring

shtmlvalue  \"                    sstring2   tstring
shtmltag    \"                    sstring2   tstring
sstring2   [^\"]*                 sstring2   tstring
sstring2   \"                     shtmltag   tstring
sstring2   \"\"                   sstring2   tstring
sstring2   \\                     sstring2   tstring

// Comments
snormal   <\!--               scomment  tcomment
scomment [^\-]*               scomment  tcomment
scomment [\-]*[^>]            scomment  tcomment
scomment  [\-]*>              snormal   tcomment

// Reswords - tag names
// lines containing @@@ are special container brackets - do not touch them
//@@@HTM
stagname  'a'           shtmltag  tresword
stagname  'abbr'        shtmltag  tresword
stagname  'acronym'     shtmltag  tresword
stagname  'address'     shtmltag  tresword
stagname  'applet'      shtmltag  tresword
stagname  'area'        shtmltag  tresword
stagname  'article'     shtmltag  tresword
stagname  'aside'       shtmltag  tresword
stagname  'audio'       shtmltag  tresword
stagname  'b'           shtmltag  tresword
stagname  'base'        shtmltag  tresword
stagname  'basefont'    shtmltag  tresword
stagname  'bdi'         shtmltag  tresword
stagname  'bdo'         shtmltag  tresword
stagname  'big'         shtmltag  tresword
stagname  'blockquote'  shtmltag  tresword
stagname  'body'        shtmltag  tresword
stagname  'br'          shtmltag  tresword
stagname  'button'      shtmltag  tresword
stagname  'canvas'      shtmltag  tresword
stagname  'caption'     shtmltag  tresword
stagname  'center'      shtmltag  tresword
stagname  'cite'        shtmltag  tresword
stagname  'code'        shtmltag  tresword
stagname  'col'         shtmltag  tresword
stagname  'colgroup'    shtmltag  tresword
stagname  'command'     shtmltag  tresword
stagname  'data'        shtmltag  tresword
stagname  'datalist'    shtmltag  tresword
stagname  'dd'          shtmltag  tresword
stagname  'del'         shtmltag  tresword
stagname  'details'     shtmltag  tresword
stagname  'dfn'         shtmltag  tresword
stagname  'dialog'      shtmltag  tresword
stagname  'dir'         shtmltag  tresword
stagname  'div'         shtmltag  tresword
stagname  'dl'          shtmltag  tresword
stagname  'dt'          shtmltag  tresword
stagname  'em'          shtmltag  tresword
stagname  'embed'       shtmltag  tresword
stagname  'fieldset'    shtmltag  tresword
stagname  'figcaption'  shtmltag  tresword
stagname  'figure'      shtmltag  tresword
stagname  'footer'      shtmltag  tresword
stagname  'font'        shtmltag  tresword
stagname  'form'        shtmltag  tresword
stagname  'frame'       shtmltag  tresword
stagname  'frameset'    shtmltag  tresword
stagname  'h1'          shtmltag  tresword
stagname  'h2'          shtmltag  tresword
stagname  'h3'          shtmltag  tresword
stagname  'h4'          shtmltag  tresword
stagname  'h5'          shtmltag  tresword
stagname  'h6'          shtmltag  tresword
stagname  'head'        shtmltag  tresword
stagname  'header'      shtmltag  tresword
stagname  'hgroup'      shtmltag  tresword
stagname  'hr'          shtmltag  tresword
stagname  'html'        shtmltag  tresword
stagname  'i'           shtmltag  tresword
stagname  'iframe'      shtmltag  tresword
stagname  'img'         shtmltag  tresword
stagname  'input'       shtmltag  tresword
stagname  'ins'         shtmltag  tresword
stagname  'isindex'     shtmltag  tresword
stagname  'kbd'         shtmltag  tresword
stagname  'keygen'      shtmltag  tresword
stagname  'label'       shtmltag  tresword
stagname  'legend'      shtmltag  tresword
stagname  'li'          shtmltag  tresword
stagname  'link'        shtmltag  tresword
stagname  'main'        shtmltag  tresword
stagname  'map'         shtmltag  tresword
stagname  'mark'        shtmltag  tresword
stagname  'menu'        shtmltag  tresword
stagname  'meta'        shtmltag  tresword
stagname  'meter'       shtmltag  tresword
stagname  'nav'         shtmltag  tresword
stagname  'noframes'    shtmltag  tresword
stagname  'noscript'    shtmltag  tresword
stagname  'object'      shtmltag  tresword
stagname  'ol'          shtmltag  tresword
stagname  'optgroup'    shtmltag  tresword
stagname  'option'      shtmltag  tresword
stagname  'output'      shtmltag  tresword
stagname  'p'           shtmltag  tresword
stagname  'param'       shtmltag  tresword
stagname  'pre'         shtmltag  tresword
stagname  'progress'    shtmltag  tresword
stagname  'q'           shtmltag  tresword
stagname  'rp'          shtmltag  tresword
stagname  'rt'          shtmltag  tresword
stagname  'ruby'        shtmltag  tresword
stagname  's'           shtmltag  tresword
stagname  'samp'        shtmltag  tresword
stagname  'script'      shtmltag  tresword
stagname  'section'     shtmltag  tresword
stagname  'select'      shtmltag  tresword
stagname  'small'       shtmltag  tresword
stagname  'source'      shtmltag  tresword
stagname  'span'        shtmltag  tresword
stagname  'strike'      shtmltag  tresword
stagname  'strong'      shtmltag  tresword
stagname  'style'       shtmltag  tresword
stagname  'sub'         shtmltag  tresword
stagname  'summary'     shtmltag  tresword
stagname  'sup'         shtmltag  tresword
stagname  'table'       shtmltag  tresword
stagname  'tbody'       shtmltag  tresword
stagname  'td'          shtmltag  tresword
stagname  'template'    shtmltag  tresword
stagname  'textarea'    shtmltag  tresword
stagname  'tfoot'       shtmltag  tresword
stagname  'th'          shtmltag  tresword
stagname  'thead'       shtmltag  tresword
stagname  'time'        shtmltag  tresword
stagname  'title'       shtmltag  tresword
stagname  'tr'          shtmltag  tresword
stagname  'track'       shtmltag  tresword
stagname  'tt'          shtmltag  tresword
stagname  'u'           shtmltag  tresword
stagname  'ul'          shtmltag  tresword
stagname  'var'         shtmltag  tresword
stagname  'video'       shtmltag  tresword
stagname  'wbr'         shtmltag  tresword
//HTM@@@

// Reswords - entities
snormal  &lsquo;    snormal  tentity
snormal  &rsquo;    snormal  tentity
snormal  &sbquo;    snormal  tentity
snormal  &ldquo;    snormal  tentity
snormal  &rdquo;    snormal  tentity
snormal  &bdquo;    snormal  tentity
snormal  &dagger;   snormal  tentity
snormal  &Dagger;   snormal  tentity
snormal  &permil;   snormal  tentity
snormal  &lsaquo;   snormal  tentity
snormal  &rsaquo;   snormal  tentity
snormal  &spades;   snormal  tentity
snormal  &clubs;    snormal  tentity
snormal  &hearts;   snormal  tentity
snormal  &diams;    snormal  tentity
snormal  &oline;    snormal  tentity
snormal  &larr;     snormal  tentity
snormal  &uarr;     snormal  tentity
snormal  &rarr;     snormal  tentity
snormal  &darr;     snormal  tentity
snormal  &trade;    snormal  tentity
snormal  &quot;     snormal  tentity
snormal  &amp;      snormal  tentity
snormal  &frasl;    snormal  tentity
snormal  &lt;       snormal  tentity
snormal  &ndash;    snormal  tentity
snormal  &mdash;    snormal  tentity
snormal  &nbsp;     snormal  tentity
snormal  &iexcl;    snormal  tentity
snormal  &cent;     snormal  tentity
snormal  &pound;    snormal  tentity
snormal  &curren;   snormal  tentity
snormal  &yen;      snormal  tentity
snormal  &brvbar;   snormal  tentity
snormal  &brkbar;   snormal  tentity
snormal  &sect;     snormal  tentity
snormal  &uml;      snormal  tentity
snormal  &die;      snormal  tentity
snormal  &copy;     snormal  tentity
snormal  &ordf;     snormal  tentity
snormal  &laquo;    snormal  tentity
snormal  &not;      snormal  tentity
snormal  &shy;      snormal  tentity
snormal  &reg;      snormal  tentity
snormal  &macr;     snormal  tentity
snormal  &hibar;    snormal  tentity
snormal  &deg;      snormal  tentity
snormal  &plusmn;   snormal  tentity
snormal  &sup2;     snormal  tentity
snormal  &sup3;     snormal  tentity
snormal  &acute;    snormal  tentity
snormal  &micro;    snormal  tentity
snormal  &para;     snormal  tentity
snormal  &middot;   snormal  tentity
snormal  &cedil;    snormal  tentity
snormal  &sup1;     snormal  tentity
snormal  &ordm;     snormal  tentity
snormal  &raquo;    snormal  tentity
snormal  &frac14;   snormal  tentity
snormal  &frac12;   snormal  tentity
snormal  &frac34;   snormal  tentity
snormal  &iquest;   snormal  tentity
snormal  &Agrave;   snormal  tentity
snormal  &Aacute;   snormal  tentity
snormal  &Acirc;    snormal  tentity
snormal  &Atilde;   snormal  tentity
snormal  &Auml;     snormal  tentity
snormal  &Aring;    snormal  tentity
snormal  &AElig;    snormal  tentity
snormal  &Ccedil;   snormal  tentity
snormal  &Egrave;   snormal  tentity
snormal  &Eacute;   snormal  tentity
snormal  &Ecirc;    snormal  tentity
snormal  &Euml;     snormal  tentity
snormal  &Igrave;   snormal  tentity
snormal  &Iacute;   snormal  tentity
snormal  &Icirc;    snormal  tentity
snormal  &Iuml;     snormal  tentity
snormal  &ETH;      snormal  tentity
snormal  &Ntilde;   snormal  tentity
snormal  &Ograve;   snormal  tentity
snormal  &Oacute;   snormal  tentity
snormal  &Ocirc;    snormal  tentity
snormal  &Otilde;   snormal  tentity
snormal  &Ouml;     snormal  tentity
snormal  &times;    snormal  tentity
snormal  &Oslash;   snormal  tentity
snormal  &Ugrave;   snormal  tentity
snormal  &Uacute;   snormal  tentity
snormal  &Ucirc;    snormal  tentity
snormal  &Uuml;     snormal  tentity
snormal  &Yacute;   snormal  tentity
snormal  &THORN;    snormal  tentity
snormal  &szlig;    snormal  tentity
snormal  &agrave;   snormal  tentity
snormal  &aacute;   snormal  tentity
snormal  &acirc;    snormal  tentity
snormal  &atilde;   snormal  tentity
snormal  &auml;     snormal  tentity
snormal  &aring;    snormal  tentity
snormal  &aelig;    snormal  tentity
snormal  &ccedil;   snormal  tentity
snormal  &egrave;   snormal  tentity
snormal  &eacute;   snormal  tentity
snormal  &ecirc;    snormal  tentity
snormal  &euml;     snormal  tentity
snormal  &igrave;   snormal  tentity
snormal  &iacute;   snormal  tentity
snormal  &icirc;    snormal  tentity
snormal  &iuml;     snormal  tentity
snormal  &eth;      snormal  tentity
snormal  &ntilde;   snormal  tentity
snormal  &ograve;   snormal  tentity
snormal  &oacute;   snormal  tentity
snormal  &ocirc;    snormal  tentity
snormal  &otilde;   snormal  tentity
snormal  &ouml;     snormal  tentity
snormal  &divide;   snormal  tentity
snormal  &oslash;   snormal  tentity
snormal  &ugrave;   snormal  tentity
snormal  &uacute;   snormal  tentity
snormal  &ucirc;    snormal  tentity
snormal  &uuml;     snormal  tentity
snormal  &yacute;   snormal  tentity
snormal  &thorn;    snormal  tentity
snormal  &yuml;     snormal  tentity
snormal  &gt;       snormal  tentity
snormal  &euro;     snormal  tentity
snormal  &hellip;     snormal  tentity
snormal  &\#[0-9]*;  snormal  tentity
