/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResScalarValue;

public class ResAttrDecoder {
    private ResPackage mCurrentPackage;

    public String decode(int type, int value, String rawValue, int attrResId) throws AndrolibException {
        ResScalarValue resValue = this.mCurrentPackage.getValueFactory().factory(type, value, rawValue);
        String decoded = null;
        if (attrResId > 0) {
            try {
                ResAttr attr = (ResAttr)this.getCurrentPackage().getResTable().getResSpec(attrResId).getDefaultResource().getValue();
                decoded = attr.convertToResXmlFormat(resValue);
            }
            catch (UndefinedResObject | ClassCastException exception) {
                // empty catch block
            }
        }
        return decoded != null ? decoded : resValue.encodeAsResXmlAttr();
    }

    public String decodeManifestAttr(int attrResId) throws AndrolibException {
        ResResSpec resResSpec;
        if (attrResId != 0 && (resResSpec = this.getCurrentPackage().getResTable().getResSpec(attrResId)) != null) {
            return resResSpec.getName();
        }
        return null;
    }

    public ResPackage getCurrentPackage() throws AndrolibException {
        if (this.mCurrentPackage == null) {
            throw new AndrolibException("Current package not set");
        }
        return this.mCurrentPackage;
    }

    public void setCurrentPackage(ResPackage currentPackage) {
        this.mCurrentPackage = currentPackage;
    }
}

