/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.apache.commons.lang3.StringUtils;

public class SignalEventReceivedRequest {
    private String signalName;
    private List<RestVariable> variables;
    private String tenantId;
    private boolean async = false;

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @ApiModelProperty(value="ID of the tenant that the signal event should be processed in")
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, defaultImpl=RestVariable.class)
    @ApiModelProperty(value="Array of variables (in the general variables format) to use as payload to pass along with the signal. Cannot be used in case async is set to true, this will result in an error.")
    public List<RestVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<RestVariable> variables) {
        this.variables = variables;
    }

    @JsonIgnore
    public boolean isCustomTenantSet() {
        return this.tenantId != null && !StringUtils.isEmpty((CharSequence)this.tenantId);
    }

    @ApiModelProperty(value="Name of the signal")
    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    @ApiModelProperty(value="If true, handling of the signal will happen asynchronously. Return code will be 202 - Accepted to indicate the request is accepted but not yet executed. If false,\n                    handling the signal will be done immediately and result (200 - OK) will only return after this completed successfully. Defaults to false if omitted.")
    public boolean isAsync() {
        return this.async;
    }
}

