/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.engine.variable;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.engine.variable.RestVariableConverter;

public class DoubleRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "double";
    }

    @Override
    public Class<?> getVariableType() {
        return Double.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert doubles");
            }
            return ((Number)result.getValue()).doubleValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Double)) {
                throw new ActivitiIllegalArgumentException("Converter can only convert doubles");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

