/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.management.jmx.mbeans;

import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.management.jmx.annotations.ManagedAttribute;
import org.activiti.management.jmx.annotations.ManagedOperation;
import org.activiti.management.jmx.annotations.ManagedResource;

@ManagedResource(description="Job executor MBean")
public class JobExecutorMBean {
    AsyncExecutor jobExecutor;

    public JobExecutorMBean(ProcessEngineConfiguration processEngineConfig) {
        this.jobExecutor = processEngineConfig.getAsyncExecutor();
    }

    @ManagedAttribute(description="check if the job executor is activated")
    public boolean isJobExecutorActivated() {
        return this.jobExecutor != null && this.jobExecutor.isActive();
    }

    @ManagedOperation(description="set job executor activate")
    public void setJobExecutorActivate(Boolean active) {
        if (active.booleanValue()) {
            this.jobExecutor.start();
        } else {
            this.jobExecutor.shutdown();
        }
    }
}

