/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.activiti.form.engine.Clock;
import org.activiti.form.engine.impl.util.TimeZoneUtil;

public class DefaultClockImpl
implements Clock {
    private static volatile Calendar CURRENT_TIME;

    @Override
    public void setCurrentTime(Date currentTime) {
        GregorianCalendar time = null;
        if (currentTime != null) {
            time = new GregorianCalendar();
            time.setTime(currentTime);
        }
        this.setCurrentCalendar(time);
    }

    @Override
    public void setCurrentCalendar(Calendar currentTime) {
        CURRENT_TIME = currentTime;
    }

    @Override
    public void reset() {
        CURRENT_TIME = null;
    }

    @Override
    public Date getCurrentTime() {
        return CURRENT_TIME == null ? new Date() : CURRENT_TIME.getTime();
    }

    @Override
    public Calendar getCurrentCalendar() {
        return CURRENT_TIME == null ? new GregorianCalendar() : (Calendar)CURRENT_TIME.clone();
    }

    @Override
    public Calendar getCurrentCalendar(TimeZone timeZone) {
        return TimeZoneUtil.convertToTimeZone(this.getCurrentCalendar(), timeZone);
    }

    @Override
    public TimeZone getCurrentTimeZone() {
        return this.getCurrentCalendar().getTimeZone();
    }
}

