/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.activiti.form.engine.impl.persistence.entity.ResourceRef;
import org.activiti.form.engine.impl.persistence.entity.SubmittedFormEntity;

public class SubmittedFormEntityImpl
implements SubmittedFormEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String formId;
    protected String taskId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected Date submittedDate;
    protected String submittedBy;
    protected String formValuesId;
    protected ResourceRef resourceRef;
    protected String tenantId = "";

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        if (this.resourceRef != null && this.resourceRef.getId() != null) {
            persistentState.put("formValuesId", this.resourceRef.getId());
        }
        return persistentState;
    }

    public String getFormId() {
        return this.formId;
    }

    @Override
    public void setFormId(String formId) {
        this.formId = formId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    @Override
    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    @Override
    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public String getFormValuesId() {
        return this.formValuesId;
    }

    @Override
    public void setFormValuesId(String formValuesId) {
        this.formValuesId = formValuesId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public byte[] getFormValueBytes() {
        this.ensureResourceRefInitialized();
        return this.resourceRef.getBytes();
    }

    @Override
    public void setFormValueBytes(byte[] bytes) {
        this.ensureResourceRefInitialized();
        this.resourceRef.setValue("form-" + this.formId, bytes);
    }

    public ResourceRef getResourceRef() {
        return this.resourceRef;
    }

    protected void ensureResourceRefInitialized() {
        if (this.resourceRef == null) {
            this.resourceRef = new ResourceRef();
        }
    }

    public String toString() {
        return "SubmittedFormEntity[" + this.id + "]";
    }
}

