/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.form.api.Form;
import org.activiti.form.api.FormDeployment;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.impl.FormDeploymentQueryImpl;
import org.activiti.form.engine.impl.Page;
import org.activiti.form.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.form.engine.impl.persistence.entity.data.DataManager;
import org.activiti.form.engine.impl.persistence.entity.data.FormDeploymentDataManager;

public class FormDeploymentEntityManagerImpl
extends AbstractEntityManager<FormDeploymentEntity>
implements FormDeploymentEntityManager {
    protected FormDeploymentDataManager deploymentDataManager;

    public FormDeploymentEntityManagerImpl(FormEngineConfiguration formEngineConfiguration, FormDeploymentDataManager deploymentDataManager) {
        super(formEngineConfiguration);
        this.deploymentDataManager = deploymentDataManager;
    }

    @Override
    protected DataManager<FormDeploymentEntity> getDataManager() {
        return this.deploymentDataManager;
    }

    @Override
    public void insert(FormDeploymentEntity deployment) {
        super.insert(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.deleteDecisionTablesForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    protected void deleteDecisionTablesForDeployment(String deploymentId) {
        this.getFormEntityManager().deleteFormsByDeploymentId(deploymentId);
    }

    protected FormEntity findLatestForm(Form form) {
        FormEntity latestForm = null;
        latestForm = form.getTenantId() != null && !"".equals(form.getTenantId()) ? this.getFormEntityManager().findLatestFormByKeyAndTenantId(form.getKey(), form.getTenantId()) : this.getFormEntityManager().findLatestFormByKey(form.getKey());
        return latestForm;
    }

    @Override
    public FormDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return this.deploymentDataManager.findLatestDeploymentByName(deploymentName);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(FormDeploymentQueryImpl deploymentQuery) {
        return this.deploymentDataManager.findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<FormDeployment> findDeploymentsByQueryCriteria(FormDeploymentQueryImpl deploymentQuery, Page page) {
        return this.deploymentDataManager.findDeploymentsByQueryCriteria(deploymentQuery, page);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.deploymentDataManager.getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<FormDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.deploymentDataManager.findDeploymentsByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.deploymentDataManager.findDeploymentCountByNativeQuery(parameterMap);
    }

    public FormDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(FormDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }
}

