/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.deployer;

import java.util.List;
import java.util.Map;
import org.activiti.form.engine.impl.parser.FormParse;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.form.model.FormDefinition;

public class ParsedDeployment {
    protected FormDeploymentEntity deploymentEntity;
    protected List<FormEntity> forms;
    protected Map<FormEntity, FormParse> mapFormsToParses;
    protected Map<FormEntity, ResourceEntity> mapFormsToResources;

    public ParsedDeployment(FormDeploymentEntity entity, List<FormEntity> forms, Map<FormEntity, FormParse> mapFormsToParses, Map<FormEntity, ResourceEntity> mapFormsToResources) {
        this.deploymentEntity = entity;
        this.forms = forms;
        this.mapFormsToParses = mapFormsToParses;
        this.mapFormsToResources = mapFormsToResources;
    }

    public FormDeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public List<FormEntity> getAllForms() {
        return this.forms;
    }

    public ResourceEntity getResourceForForm(FormEntity form) {
        return this.mapFormsToResources.get(form);
    }

    public FormParse getFormParseForForm(FormEntity form) {
        return this.mapFormsToParses.get(form);
    }

    public FormDefinition getFormDefinitionForForm(FormEntity form) {
        FormParse parse = this.getFormParseForForm(form);
        return parse == null ? null : parse.getFormDefinition();
    }
}

