/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.editor.form.converter.FormJsonConverter;
import org.activiti.form.api.SubmittedForm;
import org.activiti.form.api.SubmittedFormQuery;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.ActivitiFormObjectNotFoundException;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.FormExpression;
import org.activiti.form.engine.impl.interceptor.Command;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormEntity;
import org.activiti.form.model.ExpressionFormField;
import org.activiti.form.model.FormDefinition;
import org.activiti.form.model.FormField;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRuntimeFormDefinitionCmd
implements Command<FormDefinition>,
Serializable {
    private static Logger logger = LoggerFactory.getLogger(GetRuntimeFormDefinitionCmd.class);
    private static final long serialVersionUID = 1L;
    protected String formDefinitionKey;
    protected String parentDeploymentId;
    protected String formId;
    protected String processInstanceId;
    protected String tenantId;
    protected Map<String, Object> variables;

    public GetRuntimeFormDefinitionCmd(String formDefinitionKey, String formId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formId, null, variables);
        this.processInstanceId = processInstanceId;
    }

    public GetRuntimeFormDefinitionCmd(String formDefinitionKey, String parentDeploymentId, String formId, String processInstanceId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formId, null, variables);
        this.parentDeploymentId = parentDeploymentId;
        this.processInstanceId = processInstanceId;
    }

    public GetRuntimeFormDefinitionCmd(String formDefinitionKey, String parentDeploymentId, String formId, String processInstanceId, String tenantId, Map<String, Object> variables) {
        this.initializeValues(formDefinitionKey, formId, null, variables);
        this.parentDeploymentId = parentDeploymentId;
        this.processInstanceId = processInstanceId;
        this.tenantId = tenantId;
    }

    @Override
    public FormDefinition execute(CommandContext commandContext) {
        FormCacheEntry formCacheEntry = this.resolveForm(commandContext);
        FormDefinition formDefinition = this.resolveFormDefinition(formCacheEntry, commandContext);
        this.fillFormFieldValues(formDefinition, commandContext);
        return formDefinition;
    }

    protected void initializeValues(String formDefinitionKey, String formId, String tenantId, Map<String, Object> variables) {
        this.formDefinitionKey = formDefinitionKey;
        this.formId = formId;
        this.tenantId = tenantId;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
    }

    protected void fillFormFieldValues(FormDefinition formDefinition, CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = commandContext.getFormEngineConfiguration();
        List allFields = formDefinition.listAllFields();
        if (allFields != null) {
            Map<String, JsonNode> submittedFormFieldMap = this.fillPreviousFormValues(formEngineConfiguration);
            this.fillVariablesWithFormValues(submittedFormFieldMap, allFields);
            for (FormField field : allFields) {
                if (field instanceof ExpressionFormField) {
                    ExpressionFormField expressionField = (ExpressionFormField)field;
                    FormExpression formExpression = formEngineConfiguration.getExpressionManager().createExpression(expressionField.getExpression());
                    try {
                        field.setValue(formExpression.getValue(this.variables));
                    }
                    catch (Exception e) {
                        logger.error("Error getting value for expression " + expressionField.getExpression() + " " + e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                field.setValue(this.variables.get(field.getId()));
            }
        }
    }

    protected FormCacheEntry resolveForm(CommandContext commandContext) {
        DeploymentManager deploymentManager = commandContext.getFormEngineConfiguration().getDeploymentManager();
        FormEntity formEntity = null;
        if (this.formId != null) {
            formEntity = deploymentManager.findDeployedFormById(this.formId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for id = '" + this.formId + "'", FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formEntity = deploymentManager.findDeployedLatestFormByKey(this.formDefinitionKey);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "'", FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyAndParentDeploymentId(this.formDefinitionKey, this.parentDeploymentId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formEntity = deploymentManager.findDeployedLatestFormByKeyParentDeploymentIdAndTenantId(this.formDefinitionKey, this.parentDeploymentId, this.tenantId);
            if (formEntity == null) {
                throw new ActivitiFormObjectNotFoundException("No form found for key '" + this.formDefinitionKey + "' for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormEntity.class);
            }
        } else {
            throw new ActivitiFormObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormCacheEntry formCacheEntry = deploymentManager.resolveForm(formEntity);
        return formCacheEntry;
    }

    protected Map<String, JsonNode> fillPreviousFormValues(FormEngineConfiguration formEngineConfiguration) {
        HashMap<String, JsonNode> submittedFormMap = new HashMap<String, JsonNode>();
        if (this.processInstanceId != null) {
            List submittedForms = ((SubmittedFormQuery)formEngineConfiguration.getFormService().createSubmittedFormQuery().processInstanceId(this.processInstanceId).orderBySubmittedDate().desc()).list();
            for (SubmittedForm otherForm : submittedForms) {
                try {
                    JsonNode submittedNode = formEngineConfiguration.getObjectMapper().readTree(otherForm.getFormValueBytes());
                    if (submittedNode == null || submittedNode.get("values") != null) continue;
                    JsonNode valuesNode = submittedNode.get("values");
                    Iterator fieldIdIterator = valuesNode.fieldNames();
                    while (fieldIdIterator.hasNext()) {
                        String fieldId = (String)fieldIdIterator.next();
                        if (submittedFormMap.containsKey(fieldId)) continue;
                        JsonNode valueNode = valuesNode.get(fieldId);
                        submittedFormMap.put(fieldId, valueNode);
                    }
                }
                catch (Exception e) {
                    throw new ActivitiFormException("Error parsing submitted form " + otherForm.getId());
                }
            }
        }
        return submittedFormMap;
    }

    public void fillVariablesWithFormValues(Map<String, JsonNode> submittedFormFieldMap, List<FormField> allFields) {
        for (FormField field : allFields) {
            JsonNode fieldValueNode = submittedFormFieldMap.get(field.getId());
            if (fieldValueNode == null || fieldValueNode.isNull()) continue;
            String fieldType = field.getType();
            String fieldValue = fieldValueNode.asText();
            if ("date".equals(fieldType)) {
                try {
                    if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                    LocalDate dateValue = LocalDate.parse((String)fieldValue);
                    this.variables.put(field.getId(), dateValue);
                }
                catch (Exception e) {
                    logger.error("Error parsing form date value for process instance " + this.processInstanceId + " with value " + fieldValue, (Throwable)e);
                }
                continue;
            }
            this.variables.put(field.getId(), fieldValue);
        }
    }

    protected FormDefinition resolveFormDefinition(FormCacheEntry formCacheEntry, CommandContext commandContext) {
        FormEntity formEntity = formCacheEntry.getFormEntity();
        FormJsonConverter formJsonConverter = commandContext.getFormEngineConfiguration().getFormJsonConverter();
        FormDefinition formDefinition = formJsonConverter.convertToForm(formCacheEntry.getFormJson(), formEntity.getId(), formEntity.getVersion());
        formDefinition.setId(formEntity.getId());
        formDefinition.setName(formEntity.getName());
        formDefinition.setKey(formEntity.getKey());
        return formDefinition;
    }
}

