/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.activiti.form.api.FormDeployment;
import org.activiti.form.api.FormDeploymentQuery;
import org.activiti.form.engine.ActivitiFormIllegalArgumentException;
import org.activiti.form.engine.impl.AbstractQuery;
import org.activiti.form.engine.impl.DeploymentQueryProperty;
import org.activiti.form.engine.impl.Page;
import org.activiti.form.engine.impl.interceptor.CommandContext;
import org.activiti.form.engine.impl.interceptor.CommandExecutor;

public class FormDeploymentQueryImpl
extends AbstractQuery<FormDeploymentQuery, FormDeployment>
implements FormDeploymentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String name;
    protected String nameLike;
    protected String category;
    protected String categoryNotEquals;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String parentDeploymentId;
    protected String parentDeploymentIdLike;
    protected String formDefinitionKey;
    protected String formDefinitionKeyLike;

    public FormDeploymentQueryImpl() {
    }

    public FormDeploymentQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public FormDeploymentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public FormDeploymentQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new ActivitiFormIllegalArgumentException("Deployment id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    public FormDeploymentQueryImpl deploymentName(String deploymentName) {
        if (deploymentName == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentName is null");
        }
        this.name = deploymentName;
        return this;
    }

    public FormDeploymentQueryImpl deploymentNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentNameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    public FormDeploymentQueryImpl deploymentCategory(String deploymentCategory) {
        if (deploymentCategory == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentCategory is null");
        }
        this.category = deploymentCategory;
        return this;
    }

    public FormDeploymentQueryImpl deploymentCategoryNotEquals(String deploymentCategoryNotEquals) {
        if (deploymentCategoryNotEquals == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentCategoryExclude is null");
        }
        this.categoryNotEquals = deploymentCategoryNotEquals;
        return this;
    }

    public FormDeploymentQueryImpl parentDeploymentId(String parentDeploymentId) {
        if (parentDeploymentId == null) {
            throw new ActivitiFormIllegalArgumentException("parentDeploymentId is null");
        }
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public FormDeploymentQueryImpl parentDeploymentIdLike(String parentDeploymentIdLike) {
        if (parentDeploymentIdLike == null) {
            throw new ActivitiFormIllegalArgumentException("parentDeploymentIdLike is null");
        }
        this.parentDeploymentIdLike = parentDeploymentIdLike;
        return this;
    }

    public FormDeploymentQueryImpl deploymentWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public FormDeploymentQueryImpl deploymentTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentTenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public FormDeploymentQueryImpl deploymentTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiFormIllegalArgumentException("deploymentTenantIdLike is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public FormDeploymentQueryImpl formDefinitionKey(String key) {
        if (key == null) {
            throw new ActivitiFormIllegalArgumentException("key is null");
        }
        this.formDefinitionKey = key;
        return this;
    }

    public FormDeploymentQueryImpl formDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new ActivitiFormIllegalArgumentException("keyLike is null");
        }
        this.formDefinitionKeyLike = keyLike;
        return this;
    }

    public FormDeploymentQuery orderByDeploymentId() {
        return (FormDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_ID);
    }

    public FormDeploymentQuery orderByDeploymentTime() {
        return (FormDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOY_TIME);
    }

    public FormDeploymentQuery orderByDeploymentName() {
        return (FormDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_NAME);
    }

    public FormDeploymentQuery orderByTenantId() {
        return (FormDeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getDeploymentEntityManager().findDeploymentCountByQueryCriteria(this);
    }

    @Override
    public List<FormDeployment> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getDeploymentEntityManager().findDeploymentsByQueryCriteria(this, page);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getFormDefinitionKey() {
        return this.formDefinitionKey;
    }

    public String getFormDefinitionKeyLike() {
        return this.formDefinitionKeyLike;
    }
}

