/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.FormEngine;
import org.activiti.form.engine.FormEngineConfiguration;
import org.activiti.form.engine.FormEngineInfo;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormEngines {
    private static Logger log = LoggerFactory.getLogger(FormEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, FormEngine> formEngines;
    protected static Map<String, FormEngineInfo> formEngineInfosByName;
    protected static Map<String, FormEngineInfo> formEngineInfosByResourceUrl;
    protected static List<FormEngineInfo> formEngineInfos;

    public static synchronized void init() {
        if (!FormEngines.isInitialized()) {
            if (formEngines == null) {
                formEngines = new HashMap<String, FormEngine>();
            }
            ClassLoader classLoader = FormEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("activiti.form.cfg.xml");
            }
            catch (IOException e) {
                throw new ActivitiFormException("problem retrieving activiti.form.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                log.info("Initializing form engine using configuration '{}'", (Object)resource.toString());
                FormEngines.initFormEngineFromResource(resource);
            }
            FormEngines.setInitialized(true);
        } else {
            log.info("Form engines already initialized");
        }
    }

    public static void registerDmnEngine(FormEngine formEngine) {
        formEngines.put(formEngine.getName(), formEngine);
    }

    public static void unregister(FormEngine formEngine) {
        formEngines.remove(formEngine.getName());
    }

    private static FormEngineInfo initFormEngineFromResource(URL resourceUrl) {
        FormEngineInfo formEngineInfo = formEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (formEngineInfo != null) {
            formEngineInfos.remove(formEngineInfo);
            if (formEngineInfo.getException() == null) {
                String formEngineName = formEngineInfo.getName();
                formEngines.remove(formEngineName);
                formEngineInfosByName.remove(formEngineName);
            }
            formEngineInfosByResourceUrl.remove(formEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            log.info("initializing dmn engine for resource {}", (Object)resourceUrl);
            FormEngine formEngine = FormEngines.buildFormEngine(resourceUrl);
            String formEngineName = formEngine.getName();
            log.info("initialised form engine {}", (Object)formEngineName);
            formEngineInfo = new FormEngineInfo(formEngineName, resourceUrlString, null);
            formEngines.put(formEngineName, formEngine);
            formEngineInfosByName.put(formEngineName, formEngineInfo);
        }
        catch (Throwable e) {
            log.error("Exception while initializing form engine: {}", (Object)e.getMessage(), (Object)e);
            formEngineInfo = new FormEngineInfo(null, resourceUrlString, FormEngines.getExceptionString(e));
        }
        formEngineInfosByResourceUrl.put(resourceUrlString, formEngineInfo);
        formEngineInfos.add(formEngineInfo);
        return formEngineInfo;
    }

    private static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    protected static FormEngine buildFormEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            FormEngineConfiguration formEngineConfiguration = FormEngineConfiguration.createFormEngineConfigurationFromInputStream(inputStream);
            FormEngine formEngine = formEngineConfiguration.buildFormEngine();
            return formEngine;
        }
        catch (IOException e) {
            throw new ActivitiFormException("couldn't open resource stream: " + e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static List<FormEngineInfo> getFormEngineInfos() {
        return formEngineInfos;
    }

    public static FormEngineInfo getFormEngineInfo(String formEngineName) {
        return formEngineInfosByName.get(formEngineName);
    }

    public static FormEngine getDefaultFormEngine() {
        return FormEngines.getFormEngine(NAME_DEFAULT);
    }

    public static FormEngine getFormEngine(String formEngineName) {
        if (!FormEngines.isInitialized()) {
            FormEngines.init();
        }
        return formEngines.get(formEngineName);
    }

    public static FormEngineInfo retry(String resourceUrl) {
        log.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return FormEngines.initFormEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new ActivitiFormException("invalid url: " + resourceUrl, e);
        }
    }

    public static Map<String, FormEngine> getFormEngines() {
        return formEngines;
    }

    public static synchronized void destroy() {
        if (FormEngines.isInitialized()) {
            HashMap<String, FormEngine> engines = new HashMap<String, FormEngine>(formEngines);
            formEngines = new HashMap<String, FormEngine>();
            for (String formEngineName : engines.keySet()) {
                FormEngine formEngine = (FormEngine)engines.get(formEngineName);
                try {
                    formEngine.close();
                }
                catch (Exception e) {
                    log.error("exception while closing {}", (Object)(formEngineName == null ? "the default form engine" : "form engine " + formEngineName), (Object)e);
                }
            }
            formEngineInfosByName.clear();
            formEngineInfosByResourceUrl.clear();
            formEngineInfos.clear();
            FormEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        FormEngines.isInitialized = isInitialized;
    }

    static {
        formEngines = new HashMap<String, FormEngine>();
        formEngineInfosByName = new HashMap<String, FormEngineInfo>();
        formEngineInfosByResourceUrl = new HashMap<String, FormEngineInfo>();
        formEngineInfos = new ArrayList<FormEngineInfo>();
    }
}

