/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.form.engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.activiti.editor.form.converter.FormJsonConverter;
import org.activiti.form.api.FormRepositoryService;
import org.activiti.form.api.FormService;
import org.activiti.form.engine.ActivitiFormException;
import org.activiti.form.engine.Clock;
import org.activiti.form.engine.FormEngine;
import org.activiti.form.engine.impl.FormEngineImpl;
import org.activiti.form.engine.impl.FormRepositoryServiceImpl;
import org.activiti.form.engine.impl.FormServiceImpl;
import org.activiti.form.engine.impl.ServiceImpl;
import org.activiti.form.engine.impl.cfg.CommandExecutorImpl;
import org.activiti.form.engine.impl.cfg.IdGenerator;
import org.activiti.form.engine.impl.cfg.StandaloneFormEngineConfiguration;
import org.activiti.form.engine.impl.cfg.StandaloneInMemFormEngineConfiguration;
import org.activiti.form.engine.impl.cfg.TransactionContextFactory;
import org.activiti.form.engine.impl.cfg.standalone.StandaloneMybatisTransactionContextFactory;
import org.activiti.form.engine.impl.db.DbSqlSessionFactory;
import org.activiti.form.engine.impl.deployer.CachingAndArtifactsManager;
import org.activiti.form.engine.impl.deployer.FormDeployer;
import org.activiti.form.engine.impl.deployer.FormDeploymentHelper;
import org.activiti.form.engine.impl.deployer.ParsedDeploymentBuilderFactory;
import org.activiti.form.engine.impl.el.ExpressionManager;
import org.activiti.form.engine.impl.interceptor.CommandConfig;
import org.activiti.form.engine.impl.interceptor.CommandContextFactory;
import org.activiti.form.engine.impl.interceptor.CommandContextInterceptor;
import org.activiti.form.engine.impl.interceptor.CommandExecutor;
import org.activiti.form.engine.impl.interceptor.CommandInterceptor;
import org.activiti.form.engine.impl.interceptor.CommandInvoker;
import org.activiti.form.engine.impl.interceptor.LogInterceptor;
import org.activiti.form.engine.impl.interceptor.SessionFactory;
import org.activiti.form.engine.impl.parser.FormParseFactory;
import org.activiti.form.engine.impl.persistence.StrongUuidGenerator;
import org.activiti.form.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.activiti.form.engine.impl.persistence.deploy.Deployer;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.form.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.form.engine.impl.persistence.deploy.FormCacheEntry;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import org.activiti.form.engine.impl.persistence.entity.FormDeploymentEntityManagerImpl;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManager;
import org.activiti.form.engine.impl.persistence.entity.FormEntityManagerImpl;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntityManager;
import org.activiti.form.engine.impl.persistence.entity.ResourceEntityManagerImpl;
import org.activiti.form.engine.impl.persistence.entity.SubmittedFormEntityManager;
import org.activiti.form.engine.impl.persistence.entity.SubmittedFormEntityManagerImpl;
import org.activiti.form.engine.impl.persistence.entity.data.FormDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.FormDeploymentDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.ResourceDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.SubmittedFormDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.impl.MybatisFormDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.impl.MybatisFormDeploymentDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.impl.MybatisResourceDataManager;
import org.activiti.form.engine.impl.persistence.entity.data.impl.MybatisSubmittedFormDataManager;
import org.activiti.form.engine.impl.util.DefaultClockImpl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.defaults.DefaultSqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class FormEngineConfiguration {
    protected static final Logger logger = LoggerFactory.getLogger(FormEngineConfiguration.class);
    public static final String NO_TENANT_ID = "";
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/activiti/form/db/mapping/mappings.xml";
    public static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_FO_";
    public static final String DB_SCHEMA_UPDATE_FALSE = "false";
    public static final String DB_SCHEMA_UPDATE_DROP_CREATE = "create-drop";
    public static final String DB_SCHEMA_UPDATE_TRUE = "true";
    protected String formEngineName = "default";
    protected String databaseType;
    protected String jdbcDriver = "org.h2.Driver";
    protected String jdbcUrl = "jdbc:h2:tcp://localhost/~/activitiform";
    protected String jdbcUsername = "sa";
    protected String jdbcPassword = "";
    protected String dataSourceJndiName;
    protected int jdbcMaxActiveConnections;
    protected int jdbcMaxIdleConnections;
    protected int jdbcMaxCheckoutTime;
    protected int jdbcMaxWaitTime;
    protected boolean jdbcPingEnabled;
    protected String jdbcPingQuery;
    protected int jdbcPingConnectionNotUsedFor;
    protected int jdbcDefaultTransactionIsolationLevel;
    protected DataSource dataSource;
    protected String databaseSchemaUpdate = "true";
    protected String xmlEncoding = "UTF-8";
    protected BeanFactory beanFactory;
    protected CommandConfig defaultCommandConfig;
    protected CommandConfig schemaCommandConfig;
    protected CommandInterceptor commandInvoker;
    protected List<CommandInterceptor> customPreCommandInterceptors;
    protected List<CommandInterceptor> customPostCommandInterceptors;
    protected List<CommandInterceptor> commandInterceptors;
    protected CommandExecutor commandExecutor;
    protected FormRepositoryService repositoryService = new FormRepositoryServiceImpl();
    protected FormService formService = new FormServiceImpl();
    protected FormDeploymentDataManager deploymentDataManager;
    protected FormDataManager formDataManager;
    protected ResourceDataManager resourceDataManager;
    protected SubmittedFormDataManager submittedFormDataManager;
    protected FormDeploymentEntityManager deploymentEntityManager;
    protected FormEntityManager formEntityManager;
    protected ResourceEntityManager resourceEntityManager;
    protected SubmittedFormEntityManager submittedFormEntityManager;
    protected CommandContextFactory commandContextFactory;
    protected TransactionContextFactory transactionContextFactory;
    protected ExpressionManager expressionManager;
    protected FormJsonConverter formJsonConverter = new FormJsonConverter();
    protected SqlSessionFactory sqlSessionFactory;
    protected TransactionFactory transactionFactory;
    protected Set<Class<?>> customMybatisMappers;
    protected Set<String> customMybatisXMLMappers;
    protected List<SessionFactory> customSessionFactories;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected boolean transactionsExternallyManaged;
    protected boolean usingRelationalDatabase = true;
    protected String databaseTablePrefix = "";
    protected String databaseCatalog = "";
    protected String databaseSchema;
    protected boolean tablePrefixIsSchema;
    protected static Properties databaseTypeMappings = FormEngineConfiguration.getDefaultDatabaseTypeMappings();
    public static final String DATABASE_TYPE_H2 = "h2";
    public static final String DATABASE_TYPE_HSQL = "hsql";
    public static final String DATABASE_TYPE_MYSQL = "mysql";
    public static final String DATABASE_TYPE_ORACLE = "oracle";
    public static final String DATABASE_TYPE_POSTGRES = "postgres";
    public static final String DATABASE_TYPE_MSSQL = "mssql";
    public static final String DATABASE_TYPE_DB2 = "db2";
    protected FormDeployer formDeployer;
    protected FormParseFactory formParseFactory;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected FormDeploymentHelper formDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected List<Deployer> customPreDeployers;
    protected List<Deployer> customPostDeployers;
    protected List<Deployer> deployers;
    protected DeploymentManager deploymentManager;
    protected int formCacheLimit = -1;
    protected DeploymentCache<FormCacheEntry> formCache;
    protected IdGenerator idGenerator;
    protected Clock clock;

    public static Properties getDefaultDatabaseTypeMappings() {
        Properties databaseTypeMappings = new Properties();
        databaseTypeMappings.setProperty("H2", DATABASE_TYPE_H2);
        databaseTypeMappings.setProperty("HSQL Database Engine", DATABASE_TYPE_HSQL);
        databaseTypeMappings.setProperty("MySQL", DATABASE_TYPE_MYSQL);
        databaseTypeMappings.setProperty("Oracle", DATABASE_TYPE_ORACLE);
        databaseTypeMappings.setProperty("PostgreSQL", DATABASE_TYPE_POSTGRES);
        databaseTypeMappings.setProperty("Microsoft SQL Server", DATABASE_TYPE_MSSQL);
        databaseTypeMappings.setProperty(DATABASE_TYPE_DB2, DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDP", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX390", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXX8664", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXZ64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXPPC64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/400 SQL", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/6000", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB iSeries", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/AIX64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HPUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HP64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/PTX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB AS400", DATABASE_TYPE_DB2);
        return databaseTypeMappings;
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromResourceDefault() {
        return FormEngineConfiguration.createFormEngineConfigurationFromResource("activiti.form.cfg.xml", "formEngineConfiguration");
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromResource(String resource) {
        return FormEngineConfiguration.createFormEngineConfigurationFromResource(resource, "formEngineConfiguration");
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromResource(String resource, String beanName) {
        return FormEngineConfiguration.parseFormEngineConfigurationFromResource(resource, beanName);
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromInputStream(InputStream inputStream) {
        return FormEngineConfiguration.createFormEngineConfigurationFromInputStream(inputStream, "formEngineConfiguration");
    }

    public static FormEngineConfiguration createFormEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        return FormEngineConfiguration.parseFormEngineConfigurationFromInputStream(inputStream, beanName);
    }

    public static FormEngineConfiguration createStandaloneFormEngineConfiguration() {
        return new StandaloneFormEngineConfiguration();
    }

    public static FormEngineConfiguration createStandaloneInMemFormEngineConfiguration() {
        return new StandaloneInMemFormEngineConfiguration();
    }

    public static FormEngineConfiguration parseFormEngineConfiguration(Resource springResource, String beanName) {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader xmlBeanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        xmlBeanDefinitionReader.setValidationMode(3);
        xmlBeanDefinitionReader.loadBeanDefinitions(springResource);
        FormEngineConfiguration formEngineConfiguration = (FormEngineConfiguration)beanFactory.getBean(beanName);
        formEngineConfiguration.setBeanFactory((BeanFactory)beanFactory);
        return formEngineConfiguration;
    }

    public static FormEngineConfiguration parseFormEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        InputStreamResource springResource = new InputStreamResource(inputStream);
        return FormEngineConfiguration.parseFormEngineConfiguration((Resource)springResource, beanName);
    }

    public static FormEngineConfiguration parseFormEngineConfigurationFromResource(String resource, String beanName) {
        ClassPathResource springResource = new ClassPathResource(resource);
        return FormEngineConfiguration.parseFormEngineConfiguration((Resource)springResource, beanName);
    }

    public FormEngine buildFormEngine() {
        this.init();
        return new FormEngineImpl(this);
    }

    protected void init() {
        this.initExpressionManager();
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initIdGenerator();
        if (this.usingRelationalDatabase) {
            this.initDataSource();
            this.initDbSchema();
        }
        this.initTransactionFactory();
        this.initSqlSessionFactory();
        this.initSessionFactories();
        this.initServices();
        this.initDataManagers();
        this.initEntityManagers();
        this.initDeployers();
        this.initClock();
    }

    protected void initServices() {
        this.initService(this.repositoryService);
        this.initService(this.formService);
    }

    protected void initService(Object service) {
        if (service instanceof ServiceImpl) {
            ((ServiceImpl)service).setCommandExecutor(this.commandExecutor);
        }
    }

    public void initExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = new ExpressionManager();
        }
    }

    public void initDataManagers() {
        if (this.deploymentDataManager == null) {
            this.deploymentDataManager = new MybatisFormDeploymentDataManager(this);
        }
        if (this.formDataManager == null) {
            this.formDataManager = new MybatisFormDataManager(this);
        }
        if (this.resourceDataManager == null) {
            this.resourceDataManager = new MybatisResourceDataManager(this);
        }
        if (this.submittedFormDataManager == null) {
            this.submittedFormDataManager = new MybatisSubmittedFormDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.deploymentEntityManager == null) {
            this.deploymentEntityManager = new FormDeploymentEntityManagerImpl(this, this.deploymentDataManager);
        }
        if (this.formEntityManager == null) {
            this.formEntityManager = new FormEntityManagerImpl(this, this.formDataManager);
        }
        if (this.resourceEntityManager == null) {
            this.resourceEntityManager = new ResourceEntityManagerImpl(this, this.resourceDataManager);
        }
        if (this.submittedFormEntityManager == null) {
            this.submittedFormEntityManager = new SubmittedFormEntityManagerImpl(this, this.submittedFormDataManager);
        }
    }

    protected void initDataSource() {
        if (this.dataSource == null) {
            if (this.dataSourceJndiName != null) {
                try {
                    this.dataSource = (DataSource)new InitialContext().lookup(this.dataSourceJndiName);
                }
                catch (Exception e) {
                    throw new ActivitiFormException("couldn't lookup datasource from " + this.dataSourceJndiName + ": " + e.getMessage(), e);
                }
            } else if (this.jdbcUrl != null) {
                if (this.jdbcDriver == null || this.jdbcUsername == null) {
                    throw new ActivitiFormException("DataSource or JDBC properties have to be specified in a process engine configuration");
                }
                logger.debug("initializing datasource to db: {}", (Object)this.jdbcUrl);
                if (logger.isInfoEnabled()) {
                    logger.info("Configuring Datasource with following properties (omitted password for security)");
                    logger.info("datasource driver: " + this.jdbcDriver);
                    logger.info("datasource url : " + this.jdbcUrl);
                    logger.info("datasource user name : " + this.jdbcUsername);
                }
                PooledDataSource pooledDataSource = new PooledDataSource(this.getClass().getClassLoader(), this.jdbcDriver, this.jdbcUrl, this.jdbcUsername, this.jdbcPassword);
                if (this.jdbcMaxActiveConnections > 0) {
                    pooledDataSource.setPoolMaximumActiveConnections(this.jdbcMaxActiveConnections);
                }
                if (this.jdbcMaxIdleConnections > 0) {
                    pooledDataSource.setPoolMaximumIdleConnections(this.jdbcMaxIdleConnections);
                }
                if (this.jdbcMaxCheckoutTime > 0) {
                    pooledDataSource.setPoolMaximumCheckoutTime(this.jdbcMaxCheckoutTime);
                }
                if (this.jdbcMaxWaitTime > 0) {
                    pooledDataSource.setPoolTimeToWait(this.jdbcMaxWaitTime);
                }
                if (this.jdbcPingEnabled) {
                    pooledDataSource.setPoolPingEnabled(true);
                    if (this.jdbcPingQuery != null) {
                        pooledDataSource.setPoolPingQuery(this.jdbcPingQuery);
                    }
                    pooledDataSource.setPoolPingConnectionsNotUsedFor(this.jdbcPingConnectionNotUsedFor);
                }
                if (this.jdbcDefaultTransactionIsolationLevel > 0) {
                    pooledDataSource.setDefaultTransactionIsolationLevel(Integer.valueOf(this.jdbcDefaultTransactionIsolationLevel));
                }
                this.dataSource = pooledDataSource;
            }
            if (this.dataSource instanceof PooledDataSource) {
                ((PooledDataSource)this.dataSource).forceCloseAll();
            }
        }
        if (this.databaseType == null) {
            this.initDatabaseType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDatabaseType() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            logger.debug("database product name: '{}'", (Object)databaseProductName);
            this.databaseType = databaseTypeMappings.getProperty(databaseProductName);
            if (this.databaseType == null) {
                throw new ActivitiFormException("couldn't deduct database type from database product name '" + databaseProductName + "'");
            }
            logger.debug("using database type: {}", (Object)this.databaseType);
        }
        catch (SQLException e) {
            logger.error("Exception while initializing Database connection", (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                logger.error("Exception while closing the Database connection", (Throwable)e);
            }
        }
    }

    public void initDbSchema() {
        try {
            JdbcConnection connection = new JdbcConnection(this.dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)this.databaseSchema)) {
                database.setDefaultSchemaName(this.databaseSchema);
                database.setLiquibaseSchemaName(this.databaseSchema);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.databaseCatalog)) {
                database.setDefaultCatalogName(this.databaseCatalog);
                database.setLiquibaseCatalogName(this.databaseCatalog);
            }
            Liquibase liquibase = new Liquibase("org/activiti/form/db/liquibase/activiti-form-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            if (DB_SCHEMA_UPDATE_DROP_CREATE.equals(this.databaseSchemaUpdate)) {
                logger.debug("Dropping and creating schema FORM");
                liquibase.dropAll();
                liquibase.update("form");
            } else if (DB_SCHEMA_UPDATE_TRUE.equals(this.databaseSchemaUpdate)) {
                logger.debug("Updating schema FORM");
                liquibase.update("form");
            } else if (DB_SCHEMA_UPDATE_FALSE.equals(this.databaseSchemaUpdate)) {
                logger.debug("Validating schema FORM");
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new ActivitiFormException("Error initialising form data schema", e);
        }
    }

    public void initSessionFactories() {
        if (this.sessionFactories == null) {
            this.sessionFactories = new HashMap();
            if (this.usingRelationalDatabase) {
                this.initDbSqlSessionFactory();
            }
        }
        if (this.customSessionFactories != null) {
            for (SessionFactory sessionFactory : this.customSessionFactories) {
                this.addSessionFactory(sessionFactory);
            }
        }
    }

    public void initDbSqlSessionFactory() {
        if (this.dbSqlSessionFactory == null) {
            this.dbSqlSessionFactory = this.createDbSqlSessionFactory();
        }
        this.dbSqlSessionFactory.setDatabaseType(this.databaseType);
        this.dbSqlSessionFactory.setSqlSessionFactory(this.sqlSessionFactory);
        this.dbSqlSessionFactory.setIdGenerator(this.idGenerator);
        this.dbSqlSessionFactory.setDatabaseTablePrefix(this.databaseTablePrefix);
        this.dbSqlSessionFactory.setTablePrefixIsSchema(this.tablePrefixIsSchema);
        this.dbSqlSessionFactory.setDatabaseCatalog(this.databaseCatalog);
        this.dbSqlSessionFactory.setDatabaseSchema(this.databaseSchema);
        this.addSessionFactory(this.dbSqlSessionFactory);
    }

    public DbSqlSessionFactory createDbSqlSessionFactory() {
        return new DbSqlSessionFactory();
    }

    public void addSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactories.put(sessionFactory.getSessionType(), sessionFactory);
    }

    public void initCommandExecutors() {
        this.initDefaultCommandConfig();
        this.initSchemaCommandConfig();
        this.initCommandInvoker();
        this.initCommandInterceptors();
        this.initCommandExecutor();
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig();
        }
    }

    public void initSchemaCommandConfig() {
        if (this.schemaCommandConfig == null) {
            this.schemaCommandConfig = new CommandConfig().transactionNotSupported();
        }
    }

    public void initCommandInvoker() {
        if (this.commandInvoker == null) {
            this.commandInvoker = new CommandInvoker();
        }
    }

    public void initCommandInterceptors() {
        if (this.commandInterceptors == null) {
            this.commandInterceptors = new ArrayList<CommandInterceptor>();
            if (this.customPreCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPreCommandInterceptors);
            }
            this.commandInterceptors.addAll(this.getDefaultCommandInterceptors());
            if (this.customPostCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPostCommandInterceptors);
            }
            this.commandInterceptors.add(this.commandInvoker);
        }
    }

    public Collection<? extends CommandInterceptor> getDefaultCommandInterceptors() {
        ArrayList<CommandInterceptor> interceptors = new ArrayList<CommandInterceptor>();
        interceptors.add(new LogInterceptor());
        CommandInterceptor transactionInterceptor = this.createTransactionInterceptor();
        if (transactionInterceptor != null) {
            interceptors.add(transactionInterceptor);
        }
        interceptors.add(new CommandContextInterceptor(this.commandContextFactory, this));
        return interceptors;
    }

    public void initCommandExecutor() {
        if (this.commandExecutor == null) {
            CommandInterceptor first = this.initInterceptorChain(this.commandInterceptors);
            this.commandExecutor = new CommandExecutorImpl(this.getDefaultCommandConfig(), first);
        }
    }

    public CommandInterceptor initInterceptorChain(List<CommandInterceptor> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new ActivitiFormException("invalid command interceptor chain configuration: " + chain);
        }
        for (int i = 0; i < chain.size() - 1; ++i) {
            chain.get(i).setNext(chain.get(i + 1));
        }
        return chain.get(0);
    }

    public CommandInterceptor createTransactionInterceptor() {
        return null;
    }

    protected void initDeployers() {
        if (this.formParseFactory == null) {
            this.formParseFactory = new FormParseFactory();
        }
        if (this.formDeployer == null) {
            this.deployers = new ArrayList<Deployer>();
            if (this.customPreDeployers != null) {
                this.deployers.addAll(this.customPreDeployers);
            }
            this.deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                this.deployers.addAll(this.customPostDeployers);
            }
        }
        if (this.formCache == null) {
            this.formCache = this.formCacheLimit <= 0 ? new DefaultDeploymentCache<FormCacheEntry>() : new DefaultDeploymentCache<FormCacheEntry>(this.formCacheLimit);
        }
        this.deploymentManager = new DeploymentManager(this.formCache, this);
        this.deploymentManager.setDeployers(this.deployers);
        this.deploymentManager.setDeploymentEntityManager(this.deploymentEntityManager);
        this.deploymentManager.setFormEntityManager(this.formEntityManager);
    }

    public Collection<? extends Deployer> getDefaultDeployers() {
        ArrayList<FormDeployer> defaultDeployers = new ArrayList<FormDeployer>();
        if (this.formDeployer == null) {
            this.formDeployer = new FormDeployer();
        }
        this.initDmnDeployerDependencies();
        this.formDeployer.setIdGenerator(this.idGenerator);
        this.formDeployer.setParsedDeploymentBuilderFactory(this.parsedDeploymentBuilderFactory);
        this.formDeployer.setFormDeploymentHelper(this.formDeploymentHelper);
        this.formDeployer.setCachingAndArtifactsManager(this.cachingAndArtifactsManager);
        defaultDeployers.add(this.formDeployer);
        return defaultDeployers;
    }

    public void initDmnDeployerDependencies() {
        if (this.parsedDeploymentBuilderFactory == null) {
            this.parsedDeploymentBuilderFactory = new ParsedDeploymentBuilderFactory();
        }
        if (this.parsedDeploymentBuilderFactory.getFormParseFactory() == null) {
            this.parsedDeploymentBuilderFactory.setFormParseFactory(this.formParseFactory);
        }
        if (this.formDeploymentHelper == null) {
            this.formDeploymentHelper = new FormDeploymentHelper();
        }
        if (this.cachingAndArtifactsManager == null) {
            this.cachingAndArtifactsManager = new CachingAndArtifactsManager();
        }
    }

    public void initIdGenerator() {
        if (this.idGenerator == null) {
            this.idGenerator = new StrongUuidGenerator();
        }
    }

    public void initCommandContextFactory() {
        if (this.commandContextFactory == null) {
            this.commandContextFactory = new CommandContextFactory();
        }
        this.commandContextFactory.setDmnEngineConfiguration(this);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new StandaloneMybatisTransactionContextFactory();
        }
    }

    public void initClock() {
        if (this.clock == null) {
            this.clock = new DefaultClockImpl();
        }
    }

    public void initTransactionFactory() {
        if (this.transactionFactory == null) {
            this.transactionFactory = this.transactionsExternallyManaged ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
        }
    }

    public void initSqlSessionFactory() {
        if (this.sqlSessionFactory == null) {
            InputStream inputStream = null;
            try {
                inputStream = this.getMyBatisXmlConfigurationStream();
                Environment environment = new Environment("default", this.transactionFactory, this.dataSource);
                InputStreamReader reader = new InputStreamReader(inputStream);
                Properties properties = new Properties();
                properties.put("prefix", this.databaseTablePrefix);
                properties.put("limitBefore", NO_TENANT_ID);
                properties.put("limitAfter", NO_TENANT_ID);
                properties.put("limitBetween", NO_TENANT_ID);
                properties.put("limitOuterJoinBetween", NO_TENANT_ID);
                properties.put("limitBeforeNativeQuery", NO_TENANT_ID);
                properties.put("orderBy", "order by ${orderByColumns}");
                properties.put("blobType", "BLOB");
                properties.put("boolValue", "TRUE");
                if (this.databaseType != null) {
                    properties.load(this.getResourceAsStream("org/activiti/form/db/properties/" + this.databaseType + ".properties"));
                }
                Configuration configuration = this.initMybatisConfiguration(environment, reader, properties);
                this.sqlSessionFactory = new DefaultSqlSessionFactory(configuration);
            }
            catch (Exception e) {
                throw new ActivitiFormException("Error while building ibatis SqlSessionFactory: " + e.getMessage(), e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    public Configuration initMybatisConfiguration(Environment environment, Reader reader, Properties properties) {
        XMLConfigBuilder parser = new XMLConfigBuilder(reader, NO_TENANT_ID, properties);
        Configuration configuration = parser.getConfiguration();
        if (this.databaseType != null) {
            configuration.setDatabaseId(this.databaseType);
        }
        configuration.setEnvironment(environment);
        this.initCustomMybatisMappers(configuration);
        configuration = this.parseMybatisConfiguration(configuration, parser);
        return configuration;
    }

    public void initCustomMybatisMappers(Configuration configuration) {
        if (this.getCustomMybatisMappers() != null) {
            for (Class<?> clazz : this.getCustomMybatisMappers()) {
                configuration.addMapper(clazz);
            }
        }
    }

    public Configuration parseMybatisConfiguration(Configuration configuration, XMLConfigBuilder parser) {
        return this.parseCustomMybatisXMLMappers(parser.parse());
    }

    public Configuration parseCustomMybatisXMLMappers(Configuration configuration) {
        if (this.getCustomMybatisXMLMappers() != null) {
            for (String resource : this.getCustomMybatisXMLMappers()) {
                XMLMapperBuilder mapperParser = new XMLMapperBuilder(this.getResourceAsStream(resource), configuration, resource, configuration.getSqlFragments());
                mapperParser.parse();
            }
        }
        return configuration;
    }

    protected InputStream getResourceAsStream(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    public InputStream getMyBatisXmlConfigurationStream() {
        return this.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    public String getFormEngineName() {
        return this.formEngineName;
    }

    public FormEngineConfiguration setFormEngineName(String formEngineName) {
        this.formEngineName = formEngineName;
        return this;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public FormEngineConfiguration setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public FormEngineConfiguration setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public FormEngineConfiguration setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public FormEngineConfiguration setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public FormEngineConfiguration setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
        return this;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public FormEngineConfiguration setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
        return this;
    }

    public int getJdbcMaxActiveConnections() {
        return this.jdbcMaxActiveConnections;
    }

    public FormEngineConfiguration setJdbcMaxActiveConnections(int jdbcMaxActiveConnections) {
        this.jdbcMaxActiveConnections = jdbcMaxActiveConnections;
        return this;
    }

    public int getJdbcMaxIdleConnections() {
        return this.jdbcMaxIdleConnections;
    }

    public FormEngineConfiguration setJdbcMaxIdleConnections(int jdbcMaxIdleConnections) {
        this.jdbcMaxIdleConnections = jdbcMaxIdleConnections;
        return this;
    }

    public int getJdbcMaxCheckoutTime() {
        return this.jdbcMaxCheckoutTime;
    }

    public FormEngineConfiguration setJdbcMaxCheckoutTime(int jdbcMaxCheckoutTime) {
        this.jdbcMaxCheckoutTime = jdbcMaxCheckoutTime;
        return this;
    }

    public int getJdbcMaxWaitTime() {
        return this.jdbcMaxWaitTime;
    }

    public FormEngineConfiguration setJdbcMaxWaitTime(int jdbcMaxWaitTime) {
        this.jdbcMaxWaitTime = jdbcMaxWaitTime;
        return this;
    }

    public boolean isJdbcPingEnabled() {
        return this.jdbcPingEnabled;
    }

    public FormEngineConfiguration setJdbcPingEnabled(boolean jdbcPingEnabled) {
        this.jdbcPingEnabled = jdbcPingEnabled;
        return this;
    }

    public int getJdbcPingConnectionNotUsedFor() {
        return this.jdbcPingConnectionNotUsedFor;
    }

    public FormEngineConfiguration setJdbcPingConnectionNotUsedFor(int jdbcPingConnectionNotUsedFor) {
        this.jdbcPingConnectionNotUsedFor = jdbcPingConnectionNotUsedFor;
        return this;
    }

    public int getJdbcDefaultTransactionIsolationLevel() {
        return this.jdbcDefaultTransactionIsolationLevel;
    }

    public FormEngineConfiguration setJdbcDefaultTransactionIsolationLevel(int jdbcDefaultTransactionIsolationLevel) {
        this.jdbcDefaultTransactionIsolationLevel = jdbcDefaultTransactionIsolationLevel;
        return this;
    }

    public String getJdbcPingQuery() {
        return this.jdbcPingQuery;
    }

    public FormEngineConfiguration setJdbcPingQuery(String jdbcPingQuery) {
        this.jdbcPingQuery = jdbcPingQuery;
        return this;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public FormEngineConfiguration setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
        return this;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public FormEngineConfiguration setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
        return this;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public FormEngineConfiguration setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    public CommandConfig getDefaultCommandConfig() {
        return this.defaultCommandConfig;
    }

    public FormEngineConfiguration setDefaultCommandConfig(CommandConfig defaultCommandConfig) {
        this.defaultCommandConfig = defaultCommandConfig;
        return this;
    }

    public CommandInterceptor getCommandInvoker() {
        return this.commandInvoker;
    }

    public FormEngineConfiguration setCommandInvoker(CommandInterceptor commandInvoker) {
        this.commandInvoker = commandInvoker;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptors() {
        return this.customPreCommandInterceptors;
    }

    public FormEngineConfiguration setCustomPreCommandInterceptors(List<CommandInterceptor> customPreCommandInterceptors) {
        this.customPreCommandInterceptors = customPreCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptors() {
        return this.customPostCommandInterceptors;
    }

    public FormEngineConfiguration setCustomPostCommandInterceptors(List<CommandInterceptor> customPostCommandInterceptors) {
        this.customPostCommandInterceptors = customPostCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptors() {
        return this.commandInterceptors;
    }

    public FormEngineConfiguration setCommandInterceptors(List<CommandInterceptor> commandInterceptors) {
        this.commandInterceptors = commandInterceptors;
        return this;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public FormEngineConfiguration setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public FormRepositoryService getFormRepositoryService() {
        return this.repositoryService;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public FormEngineConfiguration getFormEngineConfiguration() {
        return this;
    }

    public FormDeployer getFormDeployer() {
        return this.formDeployer;
    }

    public FormEngineConfiguration setFormDeployer(FormDeployer formDeployer) {
        this.formDeployer = formDeployer;
        return this;
    }

    public FormParseFactory getFormParseFactory() {
        return this.formParseFactory;
    }

    public FormEngineConfiguration setFormParseFactory(FormParseFactory formParseFactory) {
        this.formParseFactory = formParseFactory;
        return this;
    }

    public int getFormCacheLimit() {
        return this.formCacheLimit;
    }

    public FormEngineConfiguration setFormCacheLimit(int formCacheLimit) {
        this.formCacheLimit = formCacheLimit;
        return this;
    }

    public DeploymentCache<FormCacheEntry> getFormCache() {
        return this.formCache;
    }

    public FormEngineConfiguration setFormCache(DeploymentCache<FormCacheEntry> formCache) {
        this.formCache = formCache;
        return this;
    }

    public FormDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public FormEngineConfiguration setDeploymentDataManager(FormDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
        return this;
    }

    public FormDataManager getFormDataManager() {
        return this.formDataManager;
    }

    public FormEngineConfiguration setFormDataManager(FormDataManager formDataManager) {
        this.formDataManager = formDataManager;
        return this;
    }

    public ResourceDataManager getResourceDataManager() {
        return this.resourceDataManager;
    }

    public FormEngineConfiguration setResourceDataManager(ResourceDataManager resourceDataManager) {
        this.resourceDataManager = resourceDataManager;
        return this;
    }

    public SubmittedFormDataManager getSubmittedFormDataManager() {
        return this.submittedFormDataManager;
    }

    public FormEngineConfiguration setSubmittedFormDataManager(SubmittedFormDataManager submittedFormDataManager) {
        this.submittedFormDataManager = submittedFormDataManager;
        return this;
    }

    public FormDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public FormEngineConfiguration setDeploymentEntityManager(FormDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
        return this;
    }

    public FormEntityManager getFormEntityManager() {
        return this.formEntityManager;
    }

    public FormEngineConfiguration setFormEntityManager(FormEntityManager formEntityManager) {
        this.formEntityManager = formEntityManager;
        return this;
    }

    public ResourceEntityManager getResourceEntityManager() {
        return this.resourceEntityManager;
    }

    public FormEngineConfiguration setResourceEntityManager(ResourceEntityManager resourceEntityManager) {
        this.resourceEntityManager = resourceEntityManager;
        return this;
    }

    public SubmittedFormEntityManager getSubmittedFormEntityManager() {
        return this.submittedFormEntityManager;
    }

    public FormEngineConfiguration setSubmittedFormEntityManager(SubmittedFormEntityManager submittedFormEntityManager) {
        this.submittedFormEntityManager = submittedFormEntityManager;
        return this;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public FormEngineConfiguration setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
        return this;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public FormEngineConfiguration setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public FormEngineConfiguration setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
        return this;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public FormEngineConfiguration setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public FormJsonConverter getFormJsonConverter() {
        return this.formJsonConverter;
    }

    public FormEngineConfiguration setFormJsonConverter(FormJsonConverter formJsonConverter) {
        this.formJsonConverter = formJsonConverter;
        return this;
    }

    public Set<Class<?>> getCustomMybatisMappers() {
        return this.customMybatisMappers;
    }

    public FormEngineConfiguration setCustomMybatisMappers(Set<Class<?>> customMybatisMappers) {
        this.customMybatisMappers = customMybatisMappers;
        return this;
    }

    public Set<String> getCustomMybatisXMLMappers() {
        return this.customMybatisXMLMappers;
    }

    public FormEngineConfiguration setCustomMybatisXMLMappers(Set<String> customMybatisXMLMappers) {
        this.customMybatisXMLMappers = customMybatisXMLMappers;
        return this;
    }

    public List<SessionFactory> getCustomSessionFactories() {
        return this.customSessionFactories;
    }

    public FormEngineConfiguration setCustomSessionFactories(List<SessionFactory> customSessionFactories) {
        this.customSessionFactories = customSessionFactories;
        return this;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public FormEngineConfiguration setDbSqlSessionFactory(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        return this;
    }

    public boolean isUsingRelationalDatabase() {
        return this.usingRelationalDatabase;
    }

    public FormEngineConfiguration setUsingRelationalDatabase(boolean usingRelationalDatabase) {
        this.usingRelationalDatabase = usingRelationalDatabase;
        return this;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public FormEngineConfiguration setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
        return this;
    }

    public String getDatabaseCatalog() {
        return this.databaseCatalog;
    }

    public FormEngineConfiguration setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
        return this;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public FormEngineConfiguration setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    public boolean isTablePrefixIsSchema() {
        return this.tablePrefixIsSchema;
    }

    public FormEngineConfiguration setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
        return this;
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public FormEngineConfiguration setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
        return this;
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public FormEngineConfiguration setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
        return this;
    }

    public FormEngineConfiguration setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        this.databaseSchemaUpdate = databaseSchemaUpdate;
        return this;
    }

    public Clock getClock() {
        return this.clock;
    }

    public FormEngineConfiguration setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public FormEngineConfiguration setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }
}

