/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.dmn.converter.child.BaseChildElementParser;
import org.activiti.dmn.model.DecisionRule;
import org.activiti.dmn.model.DecisionTable;
import org.activiti.dmn.model.DmnElement;
import org.activiti.dmn.model.InputClause;
import org.activiti.dmn.model.RuleInputClauseContainer;
import org.activiti.dmn.model.UnaryTests;

public class InputEntryParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "inputEntry";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, DecisionTable decisionTable) throws Exception {
        if (!(parentElement instanceof DecisionRule)) {
            return;
        }
        DecisionRule rule = (DecisionRule)parentElement;
        UnaryTests inputEntry = new UnaryTests();
        inputEntry.setId(xtr.getAttributeValue(null, "id"));
        boolean readyWithInputEntry = false;
        try {
            while (!readyWithInputEntry && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    inputEntry.setText(xtr.getElementText());
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithInputEntry = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing input entry", (Throwable)e);
        }
        InputClause inputClause = null;
        if (decisionTable.getInputs() != null && decisionTable.getInputs().get(rule.getInputEntries().size()) != null) {
            inputClause = (InputClause)decisionTable.getInputs().get(rule.getInputEntries().size());
        }
        if (inputClause == null) {
            LOGGER.warn("Error determine output clause for position: " + decisionTable.getInputs());
        }
        RuleInputClauseContainer ruleInputClauseContainer = new RuleInputClauseContainer();
        ruleInputClauseContainer.setInputClause(inputClause);
        ruleInputClauseContainer.setInputEntry(inputEntry);
        rule.addInputEntry(ruleInputClauseContainer);
    }
}

