/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.osgi.blueprint;

import java.util.ArrayList;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.VariableScopeElResolver;
import org.activiti.engine.impl.scripting.BeansResolverFactory;
import org.activiti.engine.impl.scripting.ScriptBindingsFactory;
import org.activiti.engine.impl.scripting.ScriptingEngines;
import org.activiti.engine.impl.scripting.VariableScopeResolverFactory;
import org.activiti.osgi.OsgiScriptingEngines;
import org.activiti.osgi.blueprint.BlueprintContextELResolver;
import org.activiti.osgi.blueprint.BlueprintELResolver;
import org.activiti.osgi.blueprint.ProcessEngineFactory;

public class ProcessEngineFactoryWithELResolver
extends ProcessEngineFactory {
    private BlueprintELResolver blueprintELResolver;
    private BlueprintContextELResolver blueprintContextELResolver;

    @Override
    public void init() throws Exception {
        ProcessEngineConfigurationImpl configImpl = (ProcessEngineConfigurationImpl)this.getProcessEngineConfiguration();
        configImpl.setExpressionManager((ExpressionManager)new BlueprintExpressionManager());
        ArrayList<Object> resolverFactories = configImpl.getResolverFactories();
        if (resolverFactories == null) {
            resolverFactories = new ArrayList<Object>();
            resolverFactories.add(new VariableScopeResolverFactory());
            resolverFactories.add(new BeansResolverFactory());
        }
        configImpl.setScriptingEngines((ScriptingEngines)new OsgiScriptingEngines(new ScriptBindingsFactory(configImpl, resolverFactories)));
        super.init();
    }

    public void setBlueprintELResolver(BlueprintELResolver blueprintELResolver) {
        this.blueprintELResolver = blueprintELResolver;
    }

    public void setBlueprintContextELResolver(BlueprintContextELResolver blueprintContextELResolver) {
        this.blueprintContextELResolver = blueprintContextELResolver;
    }

    public class BlueprintExpressionManager
    extends ExpressionManager {
        protected ELResolver createElResolver(VariableScope variableScope) {
            CompositeELResolver compositeElResolver = new CompositeELResolver();
            compositeElResolver.add((ELResolver)new VariableScopeElResolver(variableScope));
            if (ProcessEngineFactoryWithELResolver.this.blueprintContextELResolver != null) {
                compositeElResolver.add((ELResolver)ProcessEngineFactoryWithELResolver.this.blueprintContextELResolver);
            }
            compositeElResolver.add((ELResolver)ProcessEngineFactoryWithELResolver.this.blueprintELResolver);
            compositeElResolver.add((ELResolver)new BeanELResolver());
            compositeElResolver.add((ELResolver)new ArrayELResolver());
            compositeElResolver.add((ELResolver)new ListELResolver());
            compositeElResolver.add((ELResolver)new MapELResolver());
            return compositeElResolver;
        }
    }
}

