/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.osgi.blueprint;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class ClassLoaderWrapper
extends ClassLoader {
    private ClassLoader[] parents;

    public ClassLoaderWrapper(ClassLoader ... parents) {
        this.parents = parents;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cachedClass = this.findLoadedClass(name);
        if (cachedClass != null) {
            if (resolve) {
                this.resolveClass(cachedClass);
            }
            return cachedClass;
        }
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader parent = this.parents[i];
            try {
                Class<?> clazz = parent.loadClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader parent = this.parents[i];
            URL url = parent.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration findResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader parent = this.parents[i];
            ArrayList<URL> parentResources = Collections.list(parent.getResources(name));
            resources.addAll(parentResources);
        }
        return Collections.enumeration(resources);
    }
}

