/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.camel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.camel.ActivitiEndpoint;
import org.activiti.camel.ExchangeUtils;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.commons.lang3.StringUtils;

public abstract class CamelBehavior
extends AbstractBpmnActivityBehavior
implements ActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected Expression camelContext;
    protected CamelContext camelContextObj;
    protected List<MapExceptionEntry> mapExceptions;
    protected TargetType toTargetType = null;

    protected abstract void setPropertTargetVariable(ActivitiEndpoint var1);

    protected void updateTargetVariables(ActivitiEndpoint endpoint) {
        this.toTargetType = null;
        if (endpoint.isCopyVariablesToBodyAsMap()) {
            this.toTargetType = TargetType.BODY_AS_MAP;
        } else if (endpoint.isCopyCamelBodyToBody()) {
            this.toTargetType = TargetType.BODY;
        } else if (endpoint.isCopyVariablesToProperties()) {
            this.toTargetType = TargetType.PROPERTIES;
        }
        if (this.toTargetType == null) {
            this.setPropertTargetVariable(endpoint);
        }
    }

    protected void copyVariables(Map<String, Object> variables, Exchange exchange, ActivitiEndpoint endpoint) {
        switch (this.toTargetType) {
            case BODY_AS_MAP: {
                this.copyVariablesToBodyAsMap(variables, exchange);
                break;
            }
            case BODY: {
                this.copyVariablesToBody(variables, exchange);
                break;
            }
            case PROPERTIES: {
                this.copyVariablesToProperties(variables, exchange);
            }
        }
    }

    public void execute(DelegateExecution execution) {
        this.setAppropriateCamelContext(execution);
        ActivitiEndpoint endpoint = this.createEndpoint(execution);
        Exchange exchange = this.createExchange(execution, endpoint);
        try {
            endpoint.process(exchange);
        }
        catch (Exception e) {
            throw new ActivitiException("Exception while processing exchange", (Throwable)e);
        }
        execution.setVariables(ExchangeUtils.prepareVariables(exchange, endpoint));
        boolean isActiviti5Execution = false;
        if (Context.getCommandContext() != null && Activiti5Util.isActiviti5ProcessDefinitionId((CommandContext)Context.getCommandContext(), (String)execution.getProcessDefinitionId()) || Context.getCommandContext() == null && Activiti5Util.getActiviti5CompatibilityHandler() != null) {
            isActiviti5Execution = true;
        }
        if (!this.handleCamelException(exchange, execution, isActiviti5Execution)) {
            if (isActiviti5Execution) {
                Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                activiti5CompatibilityHandler.leaveExecution(execution);
                return;
            }
            this.leave(execution);
        }
    }

    protected ActivitiEndpoint createEndpoint(DelegateExecution execution) {
        String uri = "activiti://" + this.getProcessDefinitionKey(execution) + ":" + execution.getCurrentActivityId();
        return this.getEndpoint(uri);
    }

    protected ActivitiEndpoint getEndpoint(String key) {
        for (Endpoint e : this.camelContextObj.getEndpoints()) {
            if (!e.getEndpointKey().equals(key) || !(e instanceof ActivitiEndpoint)) continue;
            return (ActivitiEndpoint)e;
        }
        throw new ActivitiException("Activiti endpoint not defined for " + key);
    }

    protected Exchange createExchange(DelegateExecution activityExecution, ActivitiEndpoint endpoint) {
        Exchange ex = endpoint.createExchange();
        ex.setProperty("PROCESS_ID_PROPERTY", (Object)activityExecution.getProcessInstanceId());
        ex.setProperty("EXECUTION_ID_PROPERTY", (Object)activityExecution.getId());
        Map variables = activityExecution.getVariables();
        this.updateTargetVariables(endpoint);
        this.copyVariables(variables, ex, endpoint);
        return ex;
    }

    protected boolean handleCamelException(Exchange exchange, DelegateExecution execution, boolean isActiviti5Execution) {
        boolean notHandledByCamel;
        Exception camelException = exchange.getException();
        boolean bl = notHandledByCamel = exchange.isFailed() && camelException != null;
        if (notHandledByCamel) {
            if (camelException instanceof BpmnError) {
                if (isActiviti5Execution) {
                    Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                    activiti5CompatibilityHandler.propagateError((BpmnError)camelException, execution);
                    return true;
                }
                ErrorPropagation.propagateError((BpmnError)((BpmnError)camelException), (DelegateExecution)execution);
                return true;
            }
            if (isActiviti5Execution) {
                Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                if (activiti5CompatibilityHandler.mapException(camelException, execution, this.mapExceptions)) {
                    return true;
                }
                throw new ActivitiException("Unhandled exception on camel route", (Throwable)camelException);
            }
            if (ErrorPropagation.mapException((Exception)camelException, (ExecutionEntity)((ExecutionEntity)execution), this.mapExceptions)) {
                return true;
            }
            throw new ActivitiException("Unhandled exception on camel route", (Throwable)camelException);
        }
        return false;
    }

    protected void copyVariablesToProperties(Map<String, Object> variables, Exchange exchange) {
        for (Map.Entry<String, Object> var : variables.entrySet()) {
            exchange.setProperty(var.getKey(), var.getValue());
        }
    }

    protected void copyVariablesToBodyAsMap(Map<String, Object> variables, Exchange exchange) {
        exchange.getIn().setBody(new HashMap<String, Object>(variables));
    }

    protected void copyVariablesToBody(Map<String, Object> variables, Exchange exchange) {
        Object camelBody = variables.get("camelBody");
        if (camelBody != null) {
            exchange.getIn().setBody(camelBody);
        }
    }

    protected String getProcessDefinitionKey(DelegateExecution execution) {
        Process process = ProcessDefinitionUtil.getProcess((String)execution.getProcessDefinitionId());
        return process.getId();
    }

    protected boolean isASync(DelegateExecution execution) {
        boolean async = false;
        if (execution.getCurrentFlowElement() instanceof Activity) {
            async = ((Activity)execution.getCurrentFlowElement()).isAsynchronous();
        }
        return async;
    }

    protected void setAppropriateCamelContext(DelegateExecution execution) {
        String camelContextValue = this.getStringFromField(this.camelContext, execution);
        if (!StringUtils.isEmpty((CharSequence)camelContextValue) || this.camelContextObj == null) {
            ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
            if (Context.getCommandContext() != null && Activiti5Util.isActiviti5ProcessDefinitionId((CommandContext)Context.getCommandContext(), (String)execution.getProcessDefinitionId()) || Context.getCommandContext() == null && Activiti5Util.getActiviti5CompatibilityHandler() != null) {
                Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                this.camelContextObj = (CamelContext)activiti5CompatibilityHandler.getCamelContextObject(camelContextValue);
            } else {
                try {
                    Object ctx;
                    SpringProcessEngineConfiguration springConfiguration = (SpringProcessEngineConfiguration)engineConfiguration;
                    if (StringUtils.isEmpty((CharSequence)camelContextValue) && this.camelContextObj == null) {
                        camelContextValue = springConfiguration.getDefaultCamelContext();
                    }
                    if ((ctx = springConfiguration.getApplicationContext().getBean(camelContextValue)) == null || !(ctx instanceof CamelContext)) {
                        throw new ActivitiException("Could not find CamelContext named " + camelContextValue + ".");
                    }
                    this.camelContextObj = (CamelContext)ctx;
                }
                catch (Exception e) {
                    throw new ActivitiException("Expecting a SpringProcessEngineConfiguration for the Activiti Camel module.", (Throwable)e);
                }
            }
        }
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableScope)execution)) != null) {
            return value.toString();
        }
        return null;
    }

    public void setCamelContext(Expression camelContext) {
        this.camelContext = camelContext;
    }

    public static enum TargetType {
        BODY_AS_MAP,
        BODY,
        PROPERTIES;

    }
}

