/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.executor.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.activiti.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(JobMessageListener.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                String jobId = textMessage.getText();
                ExecuteAsyncRunnable executeAsyncRunnable = new ExecuteAsyncRunnable(jobId, this.processEngineConfiguration);
                executeAsyncRunnable.run();
            }
        }
        catch (Exception e) {
            logger.error("Exception when handling message from job queue", (Throwable)e);
        }
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }
}

