/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.dmn.service.api;

import java.util.ArrayList;
import java.util.List;
import org.activiti.dmn.api.DmnDecisionTable;
import org.activiti.dmn.api.DmnDeployment;
import org.activiti.dmn.api.RuleEngineExecutionResult;
import org.activiti.rest.dmn.service.api.DmnRestUrlBuilder;
import org.activiti.rest.dmn.service.api.DmnRestUrls;
import org.activiti.rest.dmn.service.api.decision.ExecuteDecisionResponse;
import org.activiti.rest.dmn.service.api.repository.DecisionTableResponse;
import org.activiti.rest.dmn.service.api.repository.DmnDeploymentResponse;

public class DmnRestResponseFactory {
    public DecisionTableResponse createDecisionTableResponse(DmnDecisionTable decisionTable) {
        return this.createDecisionTableResponse(decisionTable, this.createUrlBuilder());
    }

    public DecisionTableResponse createDecisionTableResponse(DmnDecisionTable decisionTable, DmnRestUrlBuilder urlBuilder) {
        DecisionTableResponse response = new DecisionTableResponse(decisionTable);
        response.setUrl(urlBuilder.buildUrl(DmnRestUrls.URL_DECISION_TABLE, decisionTable.getId()));
        return response;
    }

    public List<DecisionTableResponse> createDecisionTableResponseList(List<DmnDecisionTable> decisionTables) {
        DmnRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DecisionTableResponse> responseList = new ArrayList<DecisionTableResponse>();
        for (DmnDecisionTable instance : decisionTables) {
            responseList.add(this.createDecisionTableResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public List<DmnDeploymentResponse> createDmnDeploymentResponseList(List<DmnDeployment> deployments) {
        DmnRestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DmnDeploymentResponse> responseList = new ArrayList<DmnDeploymentResponse>();
        for (DmnDeployment instance : deployments) {
            responseList.add(this.createDmnDeploymentResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public DmnDeploymentResponse createDmnDeploymentResponse(DmnDeployment deployment) {
        return this.createDmnDeploymentResponse(deployment, this.createUrlBuilder());
    }

    public DmnDeploymentResponse createDmnDeploymentResponse(DmnDeployment deployment, DmnRestUrlBuilder urlBuilder) {
        return new DmnDeploymentResponse(deployment, urlBuilder.buildUrl(DmnRestUrls.URL_DEPLOYMENT, deployment.getId()));
    }

    public ExecuteDecisionResponse createExecuteDecisionResponse(RuleEngineExecutionResult executionResult) {
        return this.createExecuteDecisionResponse(executionResult, this.createUrlBuilder());
    }

    public ExecuteDecisionResponse createExecuteDecisionResponse(RuleEngineExecutionResult executionResult, DmnRestUrlBuilder urlBuilder) {
        ExecuteDecisionResponse response = new ExecuteDecisionResponse(executionResult);
        response.setUrl(urlBuilder.buildUrl(DmnRestUrls.URL_DECISION_EXECUTOR, new Object[0]));
        return response;
    }

    protected DmnRestUrlBuilder createUrlBuilder() {
        return DmnRestUrlBuilder.fromCurrentRequest();
    }
}

