/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.dmn.exception;

import org.activiti.dmn.engine.ActivitiDmnIllegalArgumentException;
import org.activiti.dmn.engine.ActivitiDmnObjectNotFoundException;
import org.activiti.rest.dmn.exception.ActivitiDmnConflictException;
import org.activiti.rest.dmn.exception.ActivitiDmnContentNotSupportedException;
import org.activiti.rest.dmn.exception.ActivitiDmnForbiddenException;
import org.activiti.rest.dmn.exception.ErrorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ExceptionHandlerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    @ExceptionHandler(value={ActivitiDmnContentNotSupportedException.class})
    @ResponseBody
    public ErrorInfo handleNotSupported(ActivitiDmnContentNotSupportedException e) {
        return new ErrorInfo("Content is not supported", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={ActivitiDmnConflictException.class})
    @ResponseBody
    public ErrorInfo handleConflict(ActivitiDmnConflictException e) {
        return new ErrorInfo("Conflict", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ActivitiDmnObjectNotFoundException.class})
    @ResponseBody
    public ErrorInfo handleNotFound(ActivitiDmnObjectNotFoundException e) {
        return new ErrorInfo("Not found", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={ActivitiDmnForbiddenException.class})
    @ResponseBody
    public ErrorInfo handleForbidden(ActivitiDmnForbiddenException e) {
        return new ErrorInfo("Forbidden", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ActivitiDmnIllegalArgumentException.class})
    @ResponseBody
    public ErrorInfo handleIllegal(ActivitiDmnIllegalArgumentException e) {
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseBody
    public ErrorInfo handleBadMessageConversion(HttpMessageConversionException e) {
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorInfo handleOtherException(Exception e) {
        LOGGER.error("Unhandled exception", (Throwable)e);
        return new ErrorInfo("Internal server error", e);
    }
}

