/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.repository.ProcessDefinition;

public class Activiti5Util {
    public static boolean isActiviti5ProcessDefinitionId(CommandContext commandContext, String processDefinitionId) {
        if (processDefinitionId == null) {
            return false;
        }
        try {
            ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
            if (processDefinition == null) {
                return false;
            }
            return Activiti5Util.isActiviti5ProcessDefinition(commandContext, processDefinition);
        }
        catch (ActivitiObjectNotFoundException e) {
            return false;
        }
    }

    public static boolean isActiviti5ProcessDefinitionId(ProcessEngineConfigurationImpl processEngineConfiguration, final String processDefinitionId) {
        if (processDefinitionId == null) {
            return false;
        }
        if (!processEngineConfiguration.isActiviti5CompatibilityEnabled()) {
            return false;
        }
        ProcessDefinitionCacheEntry cacheEntry = processEngineConfiguration.getProcessDefinitionCache().get(processDefinitionId);
        if (cacheEntry != null) {
            ProcessDefinition processDefinition = cacheEntry.getProcessDefinition();
            return "activiti-5".equals(processDefinition.getEngineVersion());
        }
        return processEngineConfiguration.getCommandExecutor().execute(new Command<Boolean>(){

            @Override
            public Boolean execute(CommandContext commandContext) {
                return Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, processDefinitionId);
            }
        });
    }

    public static boolean isActiviti5ProcessDefinition(CommandContext commandContext, ProcessDefinition processDefinition) {
        if (!commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled()) {
            return false;
        }
        if (processDefinition.getEngineVersion() != null) {
            if ("activiti-5".equals(processDefinition.getEngineVersion())) {
                if (commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled()) {
                    return true;
                }
            } else {
                throw new ActivitiException("Invalid 'engine' for process definition " + processDefinition.getId() + " : " + processDefinition.getEngineVersion());
            }
        }
        return false;
    }

    public static Activiti5CompatibilityHandler getActiviti5CompatibilityHandler() {
        Activiti5CompatibilityHandler activiti5CompatibilityHandler = Context.getActiviti5CompatibilityHandler();
        if (activiti5CompatibilityHandler == null) {
            activiti5CompatibilityHandler = Context.getFallbackActiviti5CompatibilityHandler();
        }
        if (activiti5CompatibilityHandler == null) {
            throw new ActivitiException("Found Activiti 5 process definition, but no compatibility handler on the classpath");
        }
        return activiti5CompatibilityHandler;
    }
}

