/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;

public class GetUserPictureCmd
implements Command<Picture>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public GetUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Picture execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new ActivitiIllegalArgumentException("userId is null");
        }
        User user = (User)commandContext.getUserEntityManager().findById(this.userId);
        if (user == null) {
            throw new ActivitiObjectNotFoundException("user " + this.userId + " doesn't exist", User.class);
        }
        return commandContext.getUserEntityManager().getUserPicture(this.userId);
    }
}

