/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.runtime.Execution;

public class GetExecutionVariableInstancesCmd
implements Command<Map<String, VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected Collection<String> variableNames;
    protected boolean isLocal;

    public GetExecutionVariableInstancesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        this.executionId = executionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Map<String, VariableInstance> execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        Map<String, VariableInstance> variables = null;
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            variables = activiti5CompatibilityHandler.getExecutionVariableInstances(this.executionId, this.variableNames, this.isLocal);
        } else {
            variables = this.variableNames == null || this.variableNames.isEmpty() ? (this.isLocal ? execution.getVariableInstancesLocal() : execution.getVariableInstances()) : (this.isLocal ? execution.getVariableInstancesLocal(this.variableNames, false) : execution.getVariableInstances(this.variableNames, false));
        }
        return variables;
    }
}

