/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDmnTestCase
extends TestCase {
    protected static final String EMPTY_LINE = "\n";
    protected static Logger log = LoggerFactory.getLogger(AbstractDmnTestCase.class);
    protected boolean isEmptyLinesEnabled = true;

    public void assertTextPresent(String expected, String actual) {
        if (actual == null || !actual.contains(expected)) {
            throw new AssertionFailedError("expected presence of [" + expected + "], but was [" + actual + "]");
        }
    }

    public void assertTextPresentIgnoreCase(String expected, String actual) {
        this.assertTextPresent(expected.toLowerCase(), actual.toLowerCase());
    }

    protected void runTest() throws Throwable {
        if (log.isDebugEnabled()) {
            if (this.isEmptyLinesEnabled) {
                log.debug(EMPTY_LINE);
            }
            log.debug("#### START {}.{} ###########################################################", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getName());
        }
        try {
            super.runTest();
        }
        catch (AssertionFailedError e) {
            log.error(EMPTY_LINE);
            log.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            throw e;
        }
        catch (Throwable e) {
            log.error(EMPTY_LINE);
            log.error("EXCEPTION: {}", (Object)e, (Object)e);
            throw e;
        }
        finally {
            log.debug("#### END {}.{} #############################################################", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.getName());
        }
    }
}

