/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl.audit;

import java.util.Map;
import org.activiti.dmn.api.DecisionExecutionAuditContainer;
import org.activiti.dmn.model.Decision;
import org.activiti.dmn.model.DecisionTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionExecutionAuditUtil {
    private static final Logger logger = LoggerFactory.getLogger(DecisionExecutionAuditUtil.class);

    public static DecisionExecutionAuditContainer initializeRuleExecutionAudit(Decision decision, Map<String, Object> inputVariables) {
        if (decision == null || decision.getId() == null) {
            logger.error("decision does not contain key");
            throw new IllegalArgumentException("decision does not contain key");
        }
        DecisionTable decisionTable = (DecisionTable)decision.getExpression();
        if (decisionTable.getHitPolicy() == null) {
            logger.error("decision table does not contain a hit policy");
            throw new IllegalArgumentException("decision table does not contain a hit policy");
        }
        String decisionKey = decision.getId();
        String decisionName = decision.getName();
        return new DecisionExecutionAuditContainer(decisionKey, decisionName, decisionTable.getHitPolicy(), inputVariables);
    }
}

