/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.dmn.engine.impl;

import java.io.InputStream;
import java.util.List;
import org.activiti.dmn.api.DmnDecisionTable;
import org.activiti.dmn.api.DmnDecisionTableQuery;
import org.activiti.dmn.api.DmnDeployment;
import org.activiti.dmn.api.DmnDeploymentBuilder;
import org.activiti.dmn.api.DmnDeploymentQuery;
import org.activiti.dmn.api.DmnRepositoryService;
import org.activiti.dmn.api.NativeDecisionTableQuery;
import org.activiti.dmn.api.NativeDmnDeploymentQuery;
import org.activiti.dmn.engine.impl.DecisionTableQueryImpl;
import org.activiti.dmn.engine.impl.DmnDeploymentQueryImpl;
import org.activiti.dmn.engine.impl.NativeDecisionTableQueryImpl;
import org.activiti.dmn.engine.impl.NativeDmnDeploymentQueryImpl;
import org.activiti.dmn.engine.impl.ServiceImpl;
import org.activiti.dmn.engine.impl.cmd.DeleteDeploymentCmd;
import org.activiti.dmn.engine.impl.cmd.DeployCmd;
import org.activiti.dmn.engine.impl.cmd.GetDeploymentDecisionTableCmd;
import org.activiti.dmn.engine.impl.cmd.GetDeploymentDmnResourceCmd;
import org.activiti.dmn.engine.impl.cmd.GetDeploymentResourceCmd;
import org.activiti.dmn.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import org.activiti.dmn.engine.impl.cmd.GetDmnDefinitionCmd;
import org.activiti.dmn.engine.impl.cmd.SetDecisionTableCategoryCmd;
import org.activiti.dmn.engine.impl.cmd.SetDeploymentCategoryCmd;
import org.activiti.dmn.engine.impl.cmd.SetDeploymentTenantIdCmd;
import org.activiti.dmn.engine.impl.interceptor.Command;
import org.activiti.dmn.engine.impl.interceptor.CommandContext;
import org.activiti.dmn.engine.impl.repository.DmnDeploymentBuilderImpl;
import org.activiti.dmn.model.DmnDefinition;

public class DmnRepositoryServiceImpl
extends ServiceImpl
implements DmnRepositoryService {
    public DmnDeploymentBuilder createDeployment() {
        return this.commandExecutor.execute(new Command<DmnDeploymentBuilder>(){

            @Override
            public DmnDeploymentBuilder execute(CommandContext commandContext) {
                return new DmnDeploymentBuilderImpl();
            }
        });
    }

    public DmnDeployment deploy(DmnDeploymentBuilderImpl deploymentBuilder) {
        return this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute(new DeleteDeploymentCmd(deploymentId));
    }

    public DmnDecisionTableQuery createDecisionTableQuery() {
        return new DecisionTableQueryImpl(this.commandExecutor);
    }

    public NativeDecisionTableQuery createNativeDecisionTableQuery() {
        return new NativeDecisionTableQueryImpl(this.commandExecutor);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.commandExecutor.execute(new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return this.commandExecutor.execute(new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public void setDeploymentCategory(String deploymentId, String category) {
        this.commandExecutor.execute(new SetDeploymentCategoryCmd(deploymentId, category));
    }

    public void setDeploymentTenantId(String deploymentId, String newTenantId) {
        this.commandExecutor.execute(new SetDeploymentTenantIdCmd(deploymentId, newTenantId));
    }

    public DmnDeploymentQuery createDeploymentQuery() {
        return new DmnDeploymentQueryImpl(this.commandExecutor);
    }

    public NativeDmnDeploymentQuery createNativeDeploymentQuery() {
        return new NativeDmnDeploymentQueryImpl(this.commandExecutor);
    }

    public DmnDecisionTable getDecisionTable(String decisionTableId) {
        return this.commandExecutor.execute(new GetDeploymentDecisionTableCmd(decisionTableId));
    }

    public DmnDefinition getDmnDefinition(String decisionTableId) {
        return this.commandExecutor.execute(new GetDmnDefinitionCmd(decisionTableId));
    }

    public InputStream getDmnResource(String decisionTableId) {
        return this.commandExecutor.execute(new GetDeploymentDmnResourceCmd(decisionTableId));
    }

    public void setDecisionTableCategory(String decisionTableId, String category) {
        this.commandExecutor.execute(new SetDecisionTableCategoryCmd(decisionTableId, category));
    }
}

