/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.runtime;

import java.util.List;
import javax.inject.Inject;
import org.activiti.app.domain.runtime.Comment;
import org.activiti.app.repository.runtime.CommentRepository;
import org.activiti.engine.identity.User;
import org.activiti.engine.runtime.Clock;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommentService {
    @Inject
    private CommentRepository commentRepository;
    @Inject
    private Clock clock;

    public Long countCommentsForTask(String taskId) {
        return this.commentRepository.countByTaskId(taskId);
    }

    public Long countCommentsForProcessInstance(String processInstanceId) {
        return this.commentRepository.countByProcessInstanceId(processInstanceId);
    }

    public List<Comment> getCommentsForTask(String taskId, boolean latestFirst) {
        return this.commentRepository.findByTaskId(taskId, new Sort(latestFirst ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"created"}));
    }

    public List<Comment> getCommentsForProcessInstance(String processInstanceId, boolean latestFirst) {
        return this.commentRepository.findByProcessInstanceId(processInstanceId, new Sort(latestFirst ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{"created"}));
    }

    public Comment createComment(String message, User createdBy, String processInstanceId) {
        return this.createComment(message, createdBy, null, processInstanceId);
    }

    public Comment createComment(String message, User createdBy, String taskId, String processInstanceId) {
        Comment newComment = new Comment();
        newComment.setMessage(message);
        newComment.setCreatedBy(createdBy.getId());
        newComment.setCreated(this.clock.getCurrentTime());
        newComment.setTaskId(taskId);
        newComment.setProcessInstanceId(processInstanceId);
        this.commentRepository.save(newComment);
        return newComment;
    }

    public void deleteComment(Comment comment) {
        this.commentRepository.delete(comment);
    }

    @Transactional
    public void deleteAllCommentsForProcessInstance(String processInstanceId) {
        this.commentRepository.deleteAllByProcessInstanceId(processInstanceId);
    }
}

