/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.app.service.editor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.app.domain.editor.AbstractModel;
import org.activiti.app.domain.editor.Model;
import org.activiti.app.domain.editor.ModelHistory;
import org.activiti.app.model.common.ResultListDataRepresentation;
import org.activiti.app.model.editor.DecisionTableSaveRepresentation;
import org.activiti.app.model.editor.ModelKeyRepresentation;
import org.activiti.app.model.editor.ModelRepresentation;
import org.activiti.app.model.editor.decisiontable.DecisionTableDefinitionRepresentation;
import org.activiti.app.model.editor.decisiontable.DecisionTableRepresentation;
import org.activiti.app.security.SecurityUtils;
import org.activiti.app.service.api.ModelService;
import org.activiti.app.service.editor.BaseActivitiModelService;
import org.activiti.app.service.exception.BadRequestException;
import org.activiti.app.service.exception.InternalServerErrorException;
import org.activiti.app.util.XmlUtil;
import org.activiti.dmn.model.Decision;
import org.activiti.dmn.model.DmnDefinition;
import org.activiti.dmn.xml.converter.DmnXMLConverter;
import org.activiti.editor.dmn.converter.DmnJsonConverter;
import org.activiti.engine.identity.User;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ActivitiDecisionTableService
extends BaseActivitiModelService {
    private static final Logger logger = LoggerFactory.getLogger(ActivitiDecisionTableService.class);
    protected static final int MIN_FILTER_LENGTH = 1;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ObjectMapper objectMapper;
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();
    protected DmnXMLConverter dmnXmlConverter = new DmnXMLConverter();

    public List<DecisionTableRepresentation> getDecisionTables(String[] decisionTableIds) {
        ArrayList<DecisionTableRepresentation> decisionTableRepresentations = new ArrayList<DecisionTableRepresentation>();
        for (String decisionTableId : decisionTableIds) {
            Model model = this.getModel(decisionTableId, true, false);
            DecisionTableRepresentation decisionTableRepresentation = this.createDecisionTableRepresentation(model);
            decisionTableRepresentations.add(decisionTableRepresentation);
        }
        return decisionTableRepresentations;
    }

    public ResultListDataRepresentation getDecisionTables(String filter) {
        String validFilter = this.makeValidFilterText(filter);
        List<Model> models = null;
        models = validFilter != null ? this.modelRepository.findModelsByModelType(4, validFilter) : this.modelRepository.findModelsByModelType(4);
        ArrayList<DecisionTableRepresentation> reps = new ArrayList<DecisionTableRepresentation>();
        for (Model model : models) {
            reps.add(new DecisionTableRepresentation(model));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(reps);
        result.setTotal(Long.valueOf(models.size()));
        return result;
    }

    public void exportDecisionTable(HttpServletResponse response, String decisionTableId) {
        this.exportDecisionTable(response, this.getModel(decisionTableId, true, false));
    }

    public void exportHistoricDecisionTable(HttpServletResponse response, String modelHistoryId) {
        ModelHistory modelHistory = (ModelHistory)this.modelHistoryRepository.findOne((Serializable)((Object)modelHistoryId));
        this.getModel(modelHistory.getModelId(), true, false);
        this.exportDecisionTable(response, modelHistory);
    }

    public void exportDecisionTableHistory(HttpServletResponse response, String decisionTableId) {
        this.exportDecisionTable(response, this.getModel(decisionTableId, true, false));
    }

    protected void exportDecisionTable(HttpServletResponse response, AbstractModel decisionTableModel) {
        DecisionTableRepresentation decisionTableRepresentation = this.getDecisionTableRepresentation(decisionTableModel);
        try {
            int count;
            JsonNode editorJsonNode = this.objectMapper.readTree(decisionTableModel.getModelEditorJson());
            String fileName = URLEncoder.encode(decisionTableRepresentation.getName(), "UTF-8").replaceAll("\\+", "%20") + ".dmn";
            response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + fileName);
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/xml");
            DmnDefinition dmnDefinition = this.dmnJsonConverter.convertToDmn(editorJsonNode, decisionTableModel.getId(), decisionTableModel.getVersion(), decisionTableModel.getLastUpdated());
            byte[] xmlBytes = this.dmnXmlConverter.convertToXML(dmnDefinition);
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(xmlBytes));
            byte[] buffer = new byte[8096];
            while ((count = in.read(buffer)) != -1) {
                servletOutputStream.write(buffer, 0, count);
            }
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception e) {
            logger.error("Could not export decision table model", (Throwable)e);
            throw new InternalServerErrorException("Could not export decision table model");
        }
    }

    public ModelRepresentation importDecisionTable(HttpServletRequest request, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName != null && (fileName.endsWith(".dmn") || fileName.endsWith(".xml"))) {
            try {
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                InputStreamReader xmlIn = new InputStreamReader(file.getInputStream(), "UTF-8");
                XMLStreamReader xtr = xif.createXMLStreamReader(xmlIn);
                DmnDefinition dmnDefinition = this.dmnXmlConverter.convertToDmnModel(xtr);
                ObjectNode editorJsonNode = this.dmnJsonConverter.convertToJson(dmnDefinition);
                editorJsonNode.remove("id");
                ModelRepresentation modelRepresentation = new ModelRepresentation();
                modelRepresentation.setKey(((Decision)dmnDefinition.getDecisions().get(0)).getId());
                modelRepresentation.setName(dmnDefinition.getName());
                modelRepresentation.setDescription(dmnDefinition.getDescription());
                modelRepresentation.setModelType(4);
                Model model = this.modelService.createModel(modelRepresentation, editorJsonNode.toString(), SecurityUtils.getCurrentUserObject());
                return new ModelRepresentation(model);
            }
            catch (Exception e) {
                logger.error("Could not import decision table model", (Throwable)e);
                throw new InternalServerErrorException("Could not import decision table model");
            }
        }
        throw new BadRequestException("Invalid file name, only .dmn or .xml files are supported not " + fileName);
    }

    protected String makeValidFilterText(String filterText) {
        String trimmed;
        String validFilter = null;
        if (filterText != null && (trimmed = StringUtils.trim((String)filterText)).length() >= 1) {
            validFilter = "%" + trimmed.toLowerCase() + "%";
        }
        return validFilter;
    }

    public Model getDecisionTableModel(String decisionTableId) {
        return this.getModel(decisionTableId, true, false);
    }

    public DecisionTableRepresentation getDecisionTable(String decisionTableId) {
        return this.createDecisionTableRepresentation(this.getDecisionTableModel(decisionTableId));
    }

    public DecisionTableRepresentation getDecisionTableRepresentation(AbstractModel decisionTableModel) {
        return this.createDecisionTableRepresentation(decisionTableModel);
    }

    public DecisionTableRepresentation getHistoricDecisionTable(String modelHistoryId) {
        ModelHistory modelHistory = (ModelHistory)this.modelHistoryRepository.findOne((Serializable)((Object)modelHistoryId));
        this.getModel(modelHistory.getModelId(), true, false);
        return this.createDecisionTableRepresentation(modelHistory);
    }

    protected DecisionTableRepresentation createDecisionTableRepresentation(AbstractModel model) {
        DecisionTableDefinitionRepresentation decisionTableDefinitionRepresentation = null;
        try {
            decisionTableDefinitionRepresentation = (DecisionTableDefinitionRepresentation)this.objectMapper.readValue(model.getModelEditorJson(), DecisionTableDefinitionRepresentation.class);
        }
        catch (Exception e) {
            logger.error("Error deserializing decision table", (Throwable)e);
            throw new InternalServerErrorException("Could not deserialize decision table definition");
        }
        DecisionTableRepresentation result = new DecisionTableRepresentation(model);
        result.setDecisionTableDefinition(decisionTableDefinitionRepresentation);
        return result;
    }

    public DecisionTableRepresentation saveDecisionTable(String decisionTableId, DecisionTableSaveRepresentation saveRepresentation) {
        User user = SecurityUtils.getCurrentUserObject();
        Model model = this.getModel(decisionTableId, false, false);
        String decisionKey = saveRepresentation.getDecisionTableRepresentation().getKey();
        ModelKeyRepresentation modelKeyInfo = this.modelService.validateModelKey(model, model.getModelType(), decisionKey);
        if (modelKeyInfo.isKeyAlreadyExists()) {
            throw new BadRequestException("Provided model key already exists: " + decisionKey);
        }
        model.setName(saveRepresentation.getDecisionTableRepresentation().getName());
        model.setKey(decisionKey);
        model.setDescription(saveRepresentation.getDecisionTableRepresentation().getDescription());
        String editorJson = null;
        try {
            editorJson = this.objectMapper.writeValueAsString((Object)saveRepresentation.getDecisionTableRepresentation().getDecisionTableDefinition());
        }
        catch (Exception e) {
            logger.error("Error while processing decision table json", (Throwable)e);
            throw new InternalServerErrorException("Decision table could not be saved " + decisionTableId);
        }
        String filteredImageString = saveRepresentation.getDecisionTableImageBase64().replace("data:image/png;base64,", "");
        byte[] imageBytes = Base64.decodeBase64((String)filteredImageString);
        model = this.modelService.saveModel(model, editorJson, imageBytes, saveRepresentation.isNewVersion(), saveRepresentation.getComment(), user);
        DecisionTableRepresentation result = new DecisionTableRepresentation(model);
        result.setDecisionTableDefinition(saveRepresentation.getDecisionTableRepresentation().getDecisionTableDefinition());
        return result;
    }
}

