/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cdi.impl.event;

import java.util.HashSet;
import java.util.Set;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ManualTask;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.bpmn.model.Transaction;
import org.activiti.bpmn.model.UserTask;
import org.activiti.cdi.BusinessProcessEventType;
import org.activiti.cdi.impl.event.CdiExecutionListener;
import org.activiti.cdi.impl.event.CdiTaskListener;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.parse.BpmnParseHandler;

public class CdiEventSupportBpmnParseHandler
implements BpmnParseHandler {
    protected static final Set<Class<? extends BaseElement>> supportedTypes = new HashSet<Class<? extends BaseElement>>();

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        return supportedTypes;
    }

    public void parse(BpmnParse bpmnParse, BaseElement element) {
        if (element instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)element;
            CdiExecutionListener listener = new CdiExecutionListener(sequenceFlow.getId());
            this.addActivitiListenerToElement((FlowElement)sequenceFlow, "take", listener);
        } else {
            if (element instanceof UserTask) {
                UserTask userTask = (UserTask)element;
                this.addCreateListener(userTask);
                this.addAssignListener(userTask);
                this.addCompleteListener(userTask);
                this.addDeleteListener(userTask);
            }
            if (element instanceof FlowElement) {
                FlowElement flowElement = (FlowElement)element;
                this.addStartEventListener(flowElement);
                this.addEndEventListener(flowElement);
            }
        }
    }

    private void addCompleteListener(UserTask userTask) {
        this.addActivitiListenerToUserTask(userTask, "complete", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.COMPLETE_TASK));
    }

    private void addAssignListener(UserTask userTask) {
        this.addActivitiListenerToUserTask(userTask, "assignment", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.ASSIGN_TASK));
    }

    private void addCreateListener(UserTask userTask) {
        this.addActivitiListenerToUserTask(userTask, "create", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.CREATE_TASK));
    }

    protected void addDeleteListener(UserTask userTask) {
        this.addActivitiListenerToUserTask(userTask, "delete", new CdiTaskListener(userTask.getId(), BusinessProcessEventType.DELETE_TASK));
    }

    protected void addStartEventListener(FlowElement flowElement) {
        CdiExecutionListener listener = new CdiExecutionListener(flowElement.getId(), BusinessProcessEventType.START_ACTIVITY);
        this.addActivitiListenerToElement(flowElement, "start", listener);
    }

    protected void addEndEventListener(FlowElement flowElement) {
        CdiExecutionListener listener = new CdiExecutionListener(flowElement.getId(), BusinessProcessEventType.END_ACTIVITY);
        this.addActivitiListenerToElement(flowElement, "end", listener);
    }

    protected void addActivitiListenerToElement(FlowElement flowElement, String event, Object instance) {
        ActivitiListener listener = new ActivitiListener();
        listener.setEvent(event);
        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_INSTANCE);
        listener.setInstance(instance);
        flowElement.getExecutionListeners().add(listener);
    }

    protected void addActivitiListenerToUserTask(UserTask userTask, String event, Object instance) {
        ActivitiListener listener = new ActivitiListener();
        listener.setEvent(event);
        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_INSTANCE);
        listener.setInstance(instance);
        userTask.getTaskListeners().add(listener);
    }

    static {
        supportedTypes.add(StartEvent.class);
        supportedTypes.add(EndEvent.class);
        supportedTypes.add(ExclusiveGateway.class);
        supportedTypes.add(InclusiveGateway.class);
        supportedTypes.add(ParallelGateway.class);
        supportedTypes.add(ScriptTask.class);
        supportedTypes.add(ServiceTask.class);
        supportedTypes.add(BusinessRuleTask.class);
        supportedTypes.add(Task.class);
        supportedTypes.add(ManualTask.class);
        supportedTypes.add(UserTask.class);
        supportedTypes.add(EndEvent.class);
        supportedTypes.add(SubProcess.class);
        supportedTypes.add(EventSubProcess.class);
        supportedTypes.add(CallActivity.class);
        supportedTypes.add(SendTask.class);
        supportedTypes.add(ReceiveTask.class);
        supportedTypes.add(EventGateway.class);
        supportedTypes.add(Transaction.class);
        supportedTypes.add(ThrowEvent.class);
        supportedTypes.add(TimerEventDefinition.class);
        supportedTypes.add(ErrorEventDefinition.class);
        supportedTypes.add(SignalEventDefinition.class);
        supportedTypes.add(SequenceFlow.class);
    }
}

