/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;

public class AssociationJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        AssociationJsonConverter.fillJsonTypes(convertersToBpmnMap);
        AssociationJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("Association", AssociationJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(Association.class, AssociationJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "Association";
    }

    @Override
    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        Association association = (Association)baseElement;
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape(association.getId(), "Association", 172.0, 212.0, 128.0, 212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(association.getSourceRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(association.getSourceRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        List graphicInfoList = model.getFlowLocationGraphicInfo(association.getId());
        if (graphicInfoList.size() > 2) {
            for (int i = 1; i < graphicInfoList.size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)graphicInfoList.get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        GraphicInfo targetGraphicInfo = model.getGraphicInfo(association.getTargetRef());
        GraphicInfo flowGraphicInfo = (GraphicInfo)graphicInfoList.get(graphicInfoList.size() - 1);
        double diffTopY = Math.abs(flowGraphicInfo.getY() - targetGraphicInfo.getY());
        double diffRightX = Math.abs(flowGraphicInfo.getX() - (targetGraphicInfo.getX() + targetGraphicInfo.getWidth()));
        double diffBottomY = Math.abs(flowGraphicInfo.getY() - (targetGraphicInfo.getY() + targetGraphicInfo.getHeight()));
        dockNode = this.objectMapper.createObjectNode();
        if (diffTopY < 5.0) {
            dockNode.put("x", targetGraphicInfo.getWidth() / 2.0);
            dockNode.put("y", 0.0);
        } else if (diffRightX < 5.0) {
            dockNode.put("x", targetGraphicInfo.getWidth());
            dockNode.put("y", targetGraphicInfo.getHeight() / 2.0);
        } else if (diffBottomY < 5.0) {
            dockNode.put("x", targetGraphicInfo.getWidth() / 2.0);
            dockNode.put("y", targetGraphicInfo.getHeight());
        } else {
            dockNode.put("x", 0.0);
            dockNode.put("y", targetGraphicInfo.getHeight() / 2.0);
        }
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.set("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(association.getTargetRef()));
        flowNode.set("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.set("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode(association.getTargetRef()));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", association.getId());
        flowNode.set("properties", (JsonNode)propertiesNode);
        shapesArrayNode.add((JsonNode)flowNode);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        Association association = new Association();
        String sourceRef = BpmnJsonConverterUtil.lookForSourceRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes"));
        if (sourceRef != null) {
            association.setSourceRef(sourceRef);
            String targetId = elementNode.get("target").get("resourceId").asText();
            association.setTargetRef(BpmnJsonConverterUtil.getElementId(shapeMap.get(targetId)));
        }
        return association;
    }
}

